/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ClearPage;
import com.google.doclava.Comment;
import com.google.doclava.Doclava;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocFile {
    private static final Pattern LINE = Pattern.compile("(.*)[\r]?\n", 8);
    private static final Pattern PROP = Pattern.compile("([^=]+)=(.*)");

    public static String readFile(String filename) {
        try {
            int amt;
            File f = new File(filename);
            int length = (int)f.length();
            FileInputStream is = new FileInputStream(f);
            InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
            char[] buf = new char[length];
            int index = 0;
            while ((amt = reader.read(buf, index, length - index)) >= 1) {
                index += amt;
            }
            return new String(buf, 0, index);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void writePage(String docfile, String outfile) {
        Data hdf = Doclava.makeHDF();
        String filedata = DocFile.readFile(docfile);
        int start = -1;
        int lineno = 1;
        Matcher lines = LINE.matcher(filedata);
        String line = null;
        while (lines.find()) {
            line = lines.group(1);
            if (line.length() > 0) {
                if (line.equals("@jd:body")) {
                    start = lines.end();
                    break;
                }
                Matcher prop = PROP.matcher(line);
                if (!prop.matches()) break;
                String key = prop.group(1);
                String value = prop.group(2);
                hdf.setValue(key, value);
            }
            ++lineno;
        }
        if (start < 0) {
            System.err.println(docfile + ":" + lineno + ": error parsing docfile");
            if (line != null) {
                System.err.println(docfile + ":" + lineno + ":" + line);
            }
            System.exit(1);
        }
        String fromTemplate = hdf.getValue("template.which", "");
        String fromPage = hdf.getValue("page.onlyfortemplate", "");
        if (!"".equals(fromPage) && !fromTemplate.equals(fromPage)) {
            return;
        }
        String commentText = filedata.substring(start);
        Comment comment = new Comment(commentText, null, new SourcePositionInfo(docfile, lineno, 1));
        TagInfo.makeHDF(hdf, "root.descr", comment.tags());
        hdf.setValue("commentText", commentText);
        String fromWhichmodule = hdf.getValue("android.whichmodule", "");
        if (fromWhichmodule.equals("online-pdk")) {
            hdf.setValue("online-pdk", "true");
            ClearPage.write(hdf, "docpage.cs", outfile);
        } else if (outfile.indexOf("sdk/") != -1) {
            hdf.setValue("sdk", "true");
            if (outfile.indexOf("index.html") != -1 || outfile.indexOf("features.html") != -1) {
                ClearPage.write(hdf, "sdkpage.cs", outfile);
            } else {
                ClearPage.write(hdf, "docpage.cs", outfile);
            }
        } else if (outfile.indexOf("guide/") != -1) {
            hdf.setValue("guide", "true");
            ClearPage.write(hdf, "docpage.cs", outfile);
        } else if (outfile.indexOf("resources/") != -1) {
            hdf.setValue("resources", "true");
            ClearPage.write(hdf, "docpage.cs", outfile);
        } else {
            ClearPage.write(hdf, "nosidenavpage.cs", outfile);
        }
    }
}

