/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.util;

import com.google.common.base.Preconditions;
import com.google.streamhtmlparser.util.HtmlUtils;
import java.util.Arrays;

public class JavascriptTokenBuffer {
    private static final int BUFFER_SIZE = 18;
    private final char[] buffer;
    private int startIndex;
    private int endIndex;

    public JavascriptTokenBuffer() {
        this.buffer = new char[18];
        this.startIndex = 0;
        this.endIndex = 0;
    }

    public JavascriptTokenBuffer(JavascriptTokenBuffer aJavascriptTokenBuffer) {
        this.buffer = Arrays.copyOf(aJavascriptTokenBuffer.buffer, aJavascriptTokenBuffer.buffer.length);
        this.startIndex = aJavascriptTokenBuffer.startIndex;
        this.endIndex = aJavascriptTokenBuffer.endIndex;
    }

    public void appendString(String input) {
        if (input == null) {
            throw new NullPointerException("input == null is not allowed");
        }
        for (int i = 0; i < input.length(); ++i) {
            this.appendChar(input.charAt(i));
        }
    }

    public void appendChar(char input) {
        if (HtmlUtils.isJavascriptWhitespace(input) && HtmlUtils.isJavascriptWhitespace(this.getChar(-1))) {
            return;
        }
        this.buffer[this.endIndex] = input;
        this.endIndex = (this.endIndex + 1) % this.buffer.length;
        if (this.endIndex == this.startIndex) {
            this.startIndex = (this.endIndex + 1) % this.buffer.length;
        }
    }

    public char popChar() {
        if (this.startIndex == this.endIndex) {
            return '\u0000';
        }
        --this.endIndex;
        if (this.endIndex < 0) {
            this.endIndex += this.buffer.length;
        }
        return this.buffer[this.endIndex];
    }

    public char getChar(int position) {
        assert (position < 0);
        int absolutePosition = this.getAbsolutePosition(position);
        if (absolutePosition < 0) {
            return '\u0000';
        }
        return this.buffer[absolutePosition];
    }

    public boolean setChar(int position, char input) {
        assert (position < 0);
        int absolutePosition = this.getAbsolutePosition(position);
        if (absolutePosition < 0) {
            return false;
        }
        this.buffer[absolutePosition] = input;
        return true;
    }

    public String getLastIdentifier() {
        int end = -1;
        if (HtmlUtils.isJavascriptWhitespace(this.getChar(-1))) {
            --end;
        }
        int position = end;
        while (HtmlUtils.isJavascriptIdentifier(this.getChar(position))) {
            --position;
        }
        if (position + 1 >= end) {
            return null;
        }
        return this.slice(position + 1, end);
    }

    public String slice(int start, int end) {
        Preconditions.checkArgument(start <= end);
        Preconditions.checkArgument(start < 0);
        Preconditions.checkArgument(end < 0);
        StringBuffer output = new StringBuffer();
        for (int position = start; position <= end; ++position) {
            char c = this.getChar(position);
            if (c == '\u0000') continue;
            output.append(c);
        }
        return new String(output);
    }

    private int getAbsolutePosition(int position) {
        assert (position < 0);
        if (position <= -this.buffer.length) {
            return -1;
        }
        int len = this.endIndex - this.startIndex;
        if (len < 0) {
            len += this.buffer.length;
        }
        if (position < -len) {
            return -1;
        }
        int absolutePosition = (position + this.endIndex) % this.buffer.length;
        if (absolutePosition < 0) {
            absolutePosition += this.buffer.length;
        }
        return absolutePosition;
    }
}

