/*
 * Decompiled with CFR 0.152.
 */
package com.beust.kobalt.wrapper;

import com.beust.kobalt.wrapper.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Main {
    private static final boolean DEV = false;
    private static final int DEV_VERSION_INT = 662;
    private static final String DEV_VERSION = "0.662";
    private static final String DEV_ZIP = "/Users/beust/kotlin/kobalt/kobaltBuild/libs/kobalt-0.662.zip";
    private static final String KOBALT_PROPERTIES = "kobalt.properties";
    private static final String KOBALTW = "kobaltw";
    private static final String KOBALTW_BAT = "kobaltw.bat";
    private static final String KOBALT_WRAPPER_PROPERTIES = "kobalt-wrapper.properties";
    private static final String PROPERTY_VERSION = "kobalt.version";
    private static final String PROPERTY_DOWNLOAD_URL = "kobalt.downloadUrl";
    private static final String FILE_NAME = "kobalt";
    private static final String DISTRIBUTIONS_DIR = System.getProperty("user.home") + "/.kobalt/wrapper/dist";
    private static final File VERSION_TXT = new File(".kobalt", "wrapperVersion.txt");
    private final Properties wrapperProperties = new Properties();
    private static int logLevel = 1;
    private boolean noOverwrite = false;
    private static final String[] FILES = new String[]{"kobaltw", "kobaltw.bat", "kobalt/wrapper/kobalt-wrapper.jar"};
    private static String PROPERTY_NO_ANIMATIONS = "com.beust.kobalt.noAnimations";

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        int n = new Main().installAndLaunchMain(stringArray);
        System.exit(n);
    }

    private String getVersion() throws IOException {
        Properties properties = this.maybeCreateProperties();
        return properties.getProperty(PROPERTY_VERSION);
    }

    private int installAndLaunchMain(String[] stringArray) throws IOException, InterruptedException {
        int n;
        String string = this.getVersion();
        this.initWrapperFile(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            boolean bl3 = true;
            switch (stringArray[n]) {
                case "--version": {
                    System.out.println("Kobalt " + string + ", Wrapper " + this.getWrapperVersion());
                    bl2 = true;
                    break;
                }
                case "--noOverwrite": {
                    this.noOverwrite = true;
                    bl3 = false;
                    break;
                }
                case "--noLaunch": {
                    bl = true;
                    break;
                }
                case "--log": {
                    logLevel = Integer.parseInt(stringArray[n + 1]);
                    arrayList.add(stringArray[n]);
                    ++n;
                }
            }
            if (!bl3) continue;
            arrayList.add(stringArray[n]);
        }
        n = 0;
        if (!bl2) {
            Path path = this.installDistribution();
            if (!bl) {
                n = this.launchMain(path, arrayList);
            }
        }
        return n;
    }

    private void readProperties(Properties properties, InputStream inputStream) throws IOException {
        properties.load(inputStream);
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties maybeCreateProperties() throws IOException {
        Properties properties = new Properties();
        URL uRL = this.getClass().getClassLoader().getResource(KOBALT_PROPERTIES);
        if (uRL != null) {
            this.readProperties(properties, uRL.openConnection().getInputStream());
        } else {
            File file = new File("src/main/resources/kobalt.properties");
            if (file.exists()) {
                try (FileInputStream fileInputStream = null;){
                    fileInputStream = new FileInputStream(file);
                    this.readProperties(properties, fileInputStream);
                }
            } else {
                throw new IllegalArgumentException("Couldn't find kobalt.properties");
            }
        }
        return properties;
    }

    private File getWrapperDir() {
        return new File(FILE_NAME, "wrapper");
    }

    private static String downloadUrl(String string) {
        return "http://beust.com/kobalt/kobalt-" + string + ".zip";
    }

    private void initWrapperFile(String string) throws IOException {
        File file = new File(this.getWrapperDir(), KOBALT_WRAPPER_PROPERTIES);
        if (!file.exists()) {
            this.saveFile(file, "kobalt.version=" + string + "\n");
        }
        this.wrapperProperties.load(new FileReader(file));
    }

    private String getWrapperVersion() {
        return this.wrapperProperties.getProperty(PROPERTY_VERSION);
    }

    private String getWrapperDownloadUrl(String string) {
        String string2 = this.wrapperProperties.getProperty(PROPERTY_DOWNLOAD_URL);
        if (string2 == null) {
            string2 = Main.downloadUrl(string);
        }
        return string2;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    private Path installDistribution() throws IOException {
        String string = this.getVersion();
        String string2 = this.getWrapperVersion();
        String string3 = "kobalt-" + string2 + ".zip";
        Files.createDirectories(Paths.get(DISTRIBUTIONS_DIR, new String[0]), new FileAttribute[0]);
        Path path = Paths.get(DISTRIBUTIONS_DIR, string3);
        Main.log(2, "Wrapper version: " + string2);
        boolean bl = Float.parseFloat(string) * 1000.0f >= 650.0f;
        String string4 = DISTRIBUTIONS_DIR;
        Path path2 = Paths.get(string4, bl ? "kobalt-" + string2 : "", this.getWrapperDir().getPath() + "/" + FILE_NAME + "-" + string2 + ".jar");
        boolean bl2 = false;
        if (!Files.exists(path, new LinkOption[0]) || !Files.exists(path2, new LinkOption[0])) {
            this.download(path.toFile(), string2);
            bl2 = true;
        }
        if (!this.noOverwrite && bl2) {
            for (int i = 0; i < 2; ++i) {
                try {
                    this.extractZipFile(path, string4);
                    break;
                }
                catch (ZipException zipException) {
                    this.error("Couldn't open zip file " + path + ": " + zipException.getMessage());
                    this.error("The file is probably corrupt, downloading it again");
                    Files.delete(path);
                    this.download(path.toFile(), string2);
                    continue;
                }
            }
        }
        if (!this.noOverwrite) {
            if (VERSION_TXT.exists()) {
                try (FileReader fileReader = new FileReader(VERSION_TXT);
                     BufferedReader bufferedReader = new BufferedReader(fileReader);){
                    String string5 = bufferedReader.readLine();
                    if (!string2.equals(string5)) {
                        Main.log(2, "  Trying to install a different version " + string2 + " != " + string5 + ", overwriting the installed wrapper");
                        this.installWrapperFiles(string, string2);
                    }
                    Main.log(2, "  Trying to install the same version " + string2 + " == " + string5 + ", not overwriting the installed wrapper");
                }
            } else {
                Main.log(2, "  Couldn't find $VERSION_TEXT, overwriting the installed wrapper");
                this.installWrapperFiles(string, string2);
            }
        }
        return path2;
    }

    private void installWrapperFiles(String string, String string2) throws IOException {
        block31: {
            Object object;
            String string3 = DISTRIBUTIONS_DIR + File.separator + "kobalt-" + string2;
            for (String object2 : FILES) {
                object = Paths.get(object2, new String[0]);
                object.toFile().getAbsoluteFile().getParentFile().mkdirs();
                if (object2.endsWith(KOBALTW)) {
                    this.generateKobaltW(Paths.get(KOBALTW, new String[0]));
                    continue;
                }
                if (object2.endsWith(KOBALTW_BAT)) {
                    this.generateKobaltWBat(Paths.get(KOBALTW_BAT, new String[0]));
                    continue;
                }
                Path throwable = Paths.get(string3, object2);
                try {
                    if (this.isWindows() && object.toFile().exists()) {
                        Main.log(2, "  Windows detected, not overwriting " + object);
                        continue;
                    }
                    Main.log(2, "  Copying " + throwable + " to " + object);
                    Files.copy(throwable, (Path)object, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    Main.log(1, "  Couldn't copy " + throwable + " to " + object + ": " + iOException.getMessage());
                }
            }
            Main.log(2, "  Writing " + VERSION_TXT);
            File file = VERSION_TXT.getParentFile();
            file.mkdirs();
            if (file.exists()) {
                try (FileWriter fileWriter = new FileWriter(VERSION_TXT);){
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    object = null;
                    try {
                        bufferedWriter.write(string2);
                        break block31;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (bufferedWriter != null) {
                            if (object != null) {
                                try {
                                    bufferedWriter.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                bufferedWriter.close();
                            }
                        }
                    }
                }
            }
            Main.log(1, "Warning: could not create the directory " + file.getAbsolutePath() + ", can't write " + VERSION_TXT);
        }
    }

    private void generateKobaltW(Path path) throws IOException {
        Object object;
        String string;
        if (this.isWindows()) {
            string = "/usr/bin/env";
        } else {
            object = new File("/bin/env");
            if (!((File)object).canExecute()) {
                object = new File("/usr/bin/env");
            }
            string = ((File)object).getAbsolutePath();
        }
        object = "#!" + string + " sh\njava -jar \"`dirname \"$0\"`/kobalt/wrapper/kobalt-wrapper.jar\" $*\n";
        Main.log(2, "  Generating kobaltw with shebang.");
        Files.write(path, ((String)object).getBytes(), new OpenOption[0]);
        if (!new File(KOBALTW).setExecutable(true) && !this.isWindows()) {
            Main.log(1, "Couldn't make kobaltw executable");
        }
    }

    private void generateKobaltWBat(Path path) throws IOException {
        if (this.isWindows() && path.toFile().exists()) {
            Main.log(2, "  Windows detected, not overwriting " + path);
        } else {
            String string = "@echo off\r\nset DIRNAME=%~dp0\r\nif \"%DIRNAME%\" == \"\" set DIRNAME=.\r\njava -jar \"%DIRNAME%/kobalt/wrapper/kobalt-wrapper.jar\" %*\r\n";
            Main.log(2, "  Generating kobaltw.bat for Windows.");
            Files.write(path, string.getBytes(), new OpenOption[0]);
        }
    }

    private void extractZipFile(Path path, String string) throws IOException {
        Main.log(2, "Extracting " + path);
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                Path path2 = Paths.get(string, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    continue;
                }
                Main.log(2, "  Writing " + zipEntry.getName() + " to " + path2);
                try {
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    Files.copy(zipFile.getInputStream(zipEntry), path2, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (FileSystemException fileSystemException) {
                    Main.log(2, "Couldn't copy to " + path2);
                }
            }
        }
    }

    private void download(File file, String string) throws IOException {
        for (int i = 0; i < 3; ++i) {
            block3: {
                try {
                    this.downloadImpl(file, string);
                }
                catch (IOException iOException) {
                    this.error("Failed to download file " + file + " due to I/O issue: " + iOException.getMessage());
                    Files.deleteIfExists(file.toPath());
                    if (i != 2) break block3;
                    throw iOException;
                }
            }
            if (file.exists()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadImpl(File file, String string) throws IOException {
        block37: {
            String string2 = this.getWrapperDownloadUrl(string);
            Main.log(2, "Downloading " + string2);
            boolean bl = false;
            Proxy proxy = Config.getProxy();
            HttpURLConnection httpURLConnection = null;
            try {
                int n = 0;
                URL uRL = null;
                while (!bl) {
                    uRL = new URL(string2);
                    httpURLConnection = proxy != null ? (HttpURLConnection)uRL.openConnection(proxy) : (HttpURLConnection)uRL.openConnection();
                    n = httpURLConnection.getResponseCode();
                    if (n == 302 || n == 301) {
                        string2 = httpURLConnection.getHeaderField("Location");
                        continue;
                    }
                    bl = true;
                }
                if (n == 200) {
                    String string3 = "";
                    String string4 = httpURLConnection.getHeaderField("Content-Disposition");
                    String string5 = httpURLConnection.getContentType();
                    int n2 = httpURLConnection.getContentLength();
                    if (string4 != null) {
                        int n3 = string4.indexOf("filename=");
                        if (n3 > 0) {
                            string3 = string4.substring(n3 + 9, string4.length());
                        }
                    } else {
                        string3 = string2.substring(string2.lastIndexOf("/") + 1, string2.length());
                    }
                    Main.log(2, "Content-Type = " + string5);
                    Main.log(2, "Content-Disposition = " + string4);
                    Main.log(2, "Content-Length = " + n2);
                    Main.log(2, "fileName = " + string3);
                    try (InputStream inputStream = httpURLConnection.getInputStream();
                         FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        this.copyToStreamWithProgress(inputStream, fileOutputStream, n2, uRL.toString());
                    }
                    Main.log(1, "Downloaded " + string2);
                    break block37;
                }
                this.error("No file to download. Server replied HTTP code: " + n);
            }
            catch (IOException iOException) {
                Main.log(1, "Warning: couldn't download " + string2);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
    }

    private void copyToStreamWithProgress(InputStream inputStream, OutputStream outputStream, long l, String string) throws IOException {
        int n;
        boolean bl;
        long l2 = 0L;
        byte[] byArray = new byte[100000];
        boolean bl2 = bl = System.console() != null && System.getProperty(PROPERTY_NO_ANIMATIONS) == null;
        if (!bl) {
            Main.log2(1, "\rDownloading " + string);
        }
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l2 += (long)n;
            if (!bl || n <= 0) continue;
            if (l > 0L) {
                float f = l2 * 100L / l;
                Main.log2(1, "\rDownloading " + string + " " + f + "%");
                continue;
            }
            Main.log2(1, ".");
        }
        Main.log2(1, "\n");
    }

    private void saveFile(File file, String string) throws IOException {
        Files.createDirectories(file.getAbsoluteFile().toPath().getParent(), new FileAttribute[0]);
        Files.deleteIfExists(file.toPath());
        Main.log(2, "Wrote " + file);
        Files.write(Paths.get(file.toURI()), string.getBytes(), new OpenOption[0]);
    }

    static void log2(int n, String string) {
        Main.p(n, string, false);
    }

    static void log(int n, String string) {
        Main.p(n, "[Wrapper] " + string, true);
    }

    private static void p(int n, String string, boolean bl) {
        if (n <= logLevel) {
            if (bl) {
                System.out.println(string);
            } else {
                System.out.print(string);
            }
        }
    }

    private void error(String string) {
        System.out.println("[Wrapper error] *** " + string);
    }

    private int launchMain(Path path, List<String> list) throws IOException, InterruptedException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("java");
        arrayList.add("-Dfile.encoding=" + Charset.defaultCharset().name());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((String)object).matches("-D(.+?)=(.*)")) continue;
            arrayList.add((String)object);
            iterator.remove();
        }
        arrayList.add("-jar");
        arrayList.add(path.toFile().getAbsolutePath());
        Collections.addAll(arrayList, list.toArray(new String[list.size()]));
        object = new ProcessBuilder(arrayList);
        ((ProcessBuilder)object).inheritIO();
        Main.log(2, "Launching " + arrayList);
        Process process = ((ProcessBuilder)object).start();
        return process.waitFor();
    }
}

