/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.apple;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.apple.PropertyListSerialization;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import net.sf.antcontrib.cpptasks.gcc.GccCCompiler;
import net.sf.antcontrib.cpptasks.ide.DependencyDef;
import net.sf.antcontrib.cpptasks.ide.ProjectDef;
import net.sf.antcontrib.cpptasks.ide.ProjectWriter;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;

public final class XcodeProjectWriter
implements ProjectWriter {
    public void writeProject(File fileName, CCTask task, ProjectDef projectDef, List sources, Hashtable targets, TargetInfo linkTarget) throws IOException {
        String projectName;
        File xcodeDir = new File(fileName + ".xcodeproj");
        if (!projectDef.getOverwrite() && xcodeDir.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + xcodeDir.toString());
        }
        CommandLineCompilerConfiguration compilerConfig = this.getBaseCompilerConfiguration(targets);
        if (compilerConfig == null) {
            throw new BuildException("Unable to find compilation target using GNU C++ compiler");
        }
        CommandLineLinkerConfiguration linkerConfig = null;
        if (linkTarget.getConfiguration() instanceof CommandLineLinkerConfiguration) {
            linkerConfig = (CommandLineLinkerConfiguration)linkTarget.getConfiguration();
        }
        if ((projectName = projectDef.getName()) == null) {
            projectName = fileName.getName();
        }
        String basePath = fileName.getAbsoluteFile().getParent();
        xcodeDir.mkdir();
        File xcodeProj = new File(xcodeDir, "project.pbxproj");
        HashMap<String, Object> propertyList = new HashMap<String, Object>();
        propertyList.put("archiveVersion", "1");
        propertyList.put("classes", new HashMap());
        propertyList.put("objectVersion", "42");
        HashMap<String, Map> objects = new HashMap<String, Map>();
        String sourceTree = "<source>";
        List sourceGroupChildren = this.addSources(objects, "SOURCE_ROOT", basePath, targets);
        PBXObjectRef sourceGroup = XcodeProjectWriter.createPBXGroup("Source", "<source>", sourceGroupChildren);
        objects.put(sourceGroup.getID(), sourceGroup.getProperties());
        PBXObjectRef product = this.addProduct(objects, linkTarget);
        ArrayList<PBXObjectRef> productsList = new ArrayList<PBXObjectRef>();
        productsList.add(product);
        PBXObjectRef productsGroup = XcodeProjectWriter.createPBXGroup("Products", "<source>", productsList);
        objects.put(productsGroup.getID(), productsGroup.getProperties());
        PBXObjectRef documentationGroup = this.addDocumentationGroup(objects, "<source>");
        ArrayList<PBXObjectRef> groups = new ArrayList<PBXObjectRef>(3);
        groups.add(sourceGroup);
        groups.add(documentationGroup);
        groups.add(productsGroup);
        PBXObjectRef mainGroup = XcodeProjectWriter.createPBXGroup(projectName, "<source>", groups);
        StringBuffer comments = new StringBuffer();
        Iterator iter = projectDef.getComments().iterator();
        while (iter.hasNext()) {
            comments.append(iter.next());
        }
        if (comments.length() > 0) {
            mainGroup.getProperties().put("comments", comments.toString());
        }
        objects.put(mainGroup.getID(), mainGroup.getProperties());
        PBXObjectRef compilerConfigurations = this.addProjectConfigurationList(objects, basePath, projectDef.getDependencies(), compilerConfig, linkerConfig);
        String projectDirPath = "";
        ArrayList<PBXObjectRef> projectTargets = new ArrayList<PBXObjectRef>();
        String projectRoot = CUtil.toUnixPath(CUtil.getRelativePath(basePath, projectDef.getProject().getBaseDir()));
        PBXObjectRef project = XcodeProjectWriter.createPBXProject(compilerConfigurations, mainGroup, projectDirPath, projectRoot, projectTargets);
        objects.put(project.getID(), project.getProperties());
        ArrayList<PBXObjectRef> frameworkBuildFiles = new ArrayList<PBXObjectRef>();
        Iterator iter2 = projectDef.getDependencies().iterator();
        while (iter2.hasNext()) {
            DependencyDef dependency = (DependencyDef)iter2.next();
            PBXObjectRef buildFile = this.addDependency(objects, project, groups, basePath, dependency);
            if (buildFile == null) continue;
            frameworkBuildFiles.add(buildFile);
        }
        PBXObjectRef nativeTarget = this.addNativeTarget(objects, linkTarget, product, projectName, sourceGroupChildren, frameworkBuildFiles);
        projectTargets.add(nativeTarget);
        propertyList.put("objects", objects);
        propertyList.put("rootObject", project.getID());
        try {
            PropertyListSerialization.serialize(propertyList, projectDef.getComments(), xcodeProj);
        }
        catch (TransformerConfigurationException ex) {
            throw new IOException(ex.toString());
        }
        catch (SAXException ex) {
            if (ex.getException() instanceof IOException) {
                throw (IOException)ex.getException();
            }
            throw new IOException(ex.toString());
        }
    }

    private PBXObjectRef addDependency(Map objects, PBXObjectRef project, List mainGroupChildren, String baseDir, DependencyDef dependency) {
        File xcodeDir;
        if (dependency.getFile() != null && (xcodeDir = new File(String.valueOf(dependency.getFile().getAbsolutePath()) + ".xcodeproj")).exists()) {
            PBXObjectRef xcodePrj = XcodeProjectWriter.createPBXFileReference("SOURCE_ROOT", baseDir, xcodeDir);
            mainGroupChildren.add(xcodePrj);
            objects.put(xcodePrj.getID(), xcodePrj.getProperties());
            int proxyType = 2;
            PBXObjectRef proxy = XcodeProjectWriter.createPBXContainerItemProxy(xcodePrj, proxyType, dependency.getName());
            objects.put(proxy.getID(), proxy.getProperties());
            PBXObjectRef referenceProxy = XcodeProjectWriter.createPBXReferenceProxy(proxy, dependency);
            objects.put(referenceProxy.getID(), referenceProxy.getProperties());
            PBXObjectRef buildFile = XcodeProjectWriter.createPBXBuildFile(referenceProxy, Collections.EMPTY_MAP);
            objects.put(buildFile.getID(), buildFile.getProperties());
            ArrayList<PBXObjectRef> productsChildren = new ArrayList<PBXObjectRef>();
            productsChildren.add(referenceProxy);
            PBXObjectRef products = XcodeProjectWriter.createPBXGroup("Products", "<group>", productsChildren);
            objects.put(products.getID(), products.getProperties());
            HashMap<String, PBXObjectRef> projectReference = new HashMap<String, PBXObjectRef>();
            projectReference.put("ProductGroup", products);
            projectReference.put("ProjectRef", xcodePrj);
            ArrayList projectReferences = (ArrayList)project.getProperties().get("ProjectReferences");
            if (projectReferences == null) {
                projectReferences = new ArrayList();
                project.getProperties().put("ProjectReferences", projectReferences);
            }
            projectReferences.add(projectReference);
            return buildFile;
        }
        return null;
    }

    private PBXObjectRef addDocumentationGroup(Map objects, String sourceTree) {
        ArrayList productsList = new ArrayList();
        PBXObjectRef products = XcodeProjectWriter.createPBXGroup("Documentation", sourceTree, productsList);
        objects.put(products.getID(), products.getProperties());
        return products;
    }

    private PBXObjectRef addProduct(Map objects, TargetInfo linkTarget) {
        PBXObjectRef executable = XcodeProjectWriter.createPBXFileReference("BUILD_PRODUCTS_DIR", linkTarget.getOutput().getParent(), linkTarget.getOutput());
        Map executableProperties = executable.getProperties();
        String fileType = this.getFileType(linkTarget);
        executableProperties.put("explicitFileType", fileType);
        executableProperties.put("includeInIndex", "0");
        objects.put(executable.getID(), executableProperties);
        return executable;
    }

    private List addSources(Map objects, String sourceTree, String basePath, Hashtable targets) {
        ArrayList<PBXObjectRef> sourceGroupChildren = new ArrayList<PBXObjectRef>();
        ArrayList<File> sourceList = new ArrayList<File>(targets.size());
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            TargetInfo info = (TargetInfo)targetIter.next();
            File[] targetsources = info.getSources();
            int i = 0;
            while (i < targetsources.length) {
                sourceList.add(targetsources[i]);
                ++i;
            }
        }
        Object[] sortedSources = sourceList.toArray();
        Arrays.sort(sortedSources, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((File)o1).getName().compareTo(((File)o2).getName());
            }
        });
        int i = 0;
        while (i < sortedSources.length) {
            PBXObjectRef fileRef = XcodeProjectWriter.createPBXFileReference(sourceTree, basePath, (File)sortedSources[i]);
            sourceGroupChildren.add(fileRef);
            objects.put(fileRef.getID(), fileRef.getProperties());
            ++i;
        }
        return sourceGroupChildren;
    }

    private PBXObjectRef addNativeTargetConfigurationList(Map objects, String projectName) {
        ArrayList<PBXObjectRef> configurations = new ArrayList<PBXObjectRef>();
        HashMap<String, String> debugSettings = new HashMap<String, String>();
        debugSettings.put("COPY_PHASE_STRIP", "NO");
        debugSettings.put("GCC_DYNAMIC_NO_PIC", "NO");
        debugSettings.put("GCC_ENABLE_FIX_AND_CONTINUE", "YES");
        debugSettings.put("GCC_MODEL_TUNING", "G5");
        debugSettings.put("GCC_OPTIMIZATION_LEVEL", "0");
        debugSettings.put("INSTALL_PATH", "$(HOME)/bin");
        debugSettings.put("PRODUCT_NAME", projectName);
        debugSettings.put("ZERO_LINK", "YES");
        PBXObjectRef debugConfig = XcodeProjectWriter.createXCBuildConfiguration("Debug", debugSettings);
        objects.put(debugConfig.getID(), debugConfig.getProperties());
        configurations.add(debugConfig);
        HashMap<String, Object> releaseSettings = new HashMap<String, Object>();
        ArrayList<String> archs = new ArrayList<String>();
        archs.add("ppc");
        archs.add("i386");
        releaseSettings.put("ARCHS", archs);
        releaseSettings.put("GCC_GENERATE_DEBUGGING_SYMBOLS", "NO");
        releaseSettings.put("GCC_MODEL_TUNING", "G5");
        releaseSettings.put("INSTALL_PATH", "$(HOME)/bin");
        releaseSettings.put("PRODUCT_NAME", projectName);
        PBXObjectRef releaseConfig = XcodeProjectWriter.createXCBuildConfiguration("Release", releaseSettings);
        objects.put(releaseConfig.getID(), releaseConfig.getProperties());
        configurations.add(releaseConfig);
        PBXObjectRef configurationList = XcodeProjectWriter.createXCConfigurationList(configurations);
        objects.put(configurationList.getID(), configurationList.getProperties());
        return configurationList;
    }

    private PBXObjectRef addProjectConfigurationList(Map objects, String baseDir, List dependencies, CommandLineCompilerConfiguration compilerConfig, CommandLineLinkerConfiguration linkerConfig) {
        int i;
        ArrayList<PBXObjectRef> configurations = new ArrayList<PBXObjectRef>();
        HashMap<String, Object> debugSettings = new HashMap<String, Object>();
        debugSettings.put("GCC_WARN_ABOUT_RETURN_TYPE", "YES");
        debugSettings.put("GCC_WARN_UNUSED_VARIABLE", "YES");
        debugSettings.put("PREBINDING", "NO");
        debugSettings.put("SDKROOT", "/Developer/SDKs/MacOSX10.4u.sdk");
        PBXObjectRef debugConfig = XcodeProjectWriter.createXCBuildConfiguration("Debug", debugSettings);
        objects.put(debugConfig.getID(), debugConfig.getProperties());
        configurations.add(debugConfig);
        HashMap<String, Object> releaseSettings = new HashMap<String, Object>();
        releaseSettings.put("GCC_WARN_ABOUT_RETURN_TYPE", "YES");
        releaseSettings.put("GCC_WARN_UNUSED_VARIABLE", "YES");
        releaseSettings.put("PREBINDING", "NO");
        releaseSettings.put("SDKROOT", "/Developer/SDKs/MacOSX10.4u.sdk");
        PBXObjectRef releaseConfig = XcodeProjectWriter.createXCBuildConfiguration("Release", releaseSettings);
        objects.put(releaseConfig.getID(), releaseConfig.getProperties());
        configurations.add(releaseConfig);
        PBXObjectRef configurationList = XcodeProjectWriter.createXCConfigurationList(configurations);
        Map projectConfigurationListProperties = configurationList.getProperties();
        projectConfigurationListProperties.put("defaultConfigurationIsVisible", "0");
        projectConfigurationListProperties.put("defaultConfigurationName", "Debug");
        objects.put(configurationList.getID(), configurationList.getProperties());
        File[] includeDirs = compilerConfig.getIncludePath();
        if (includeDirs.length > 0) {
            ArrayList<String> includePaths = new ArrayList<String>();
            HashMap<String, String> includePathMap = new HashMap<String, String>();
            i = 0;
            while (i < includeDirs.length) {
                String absPath;
                if (!CUtil.isSystemPath(includeDirs[i]) && !includePathMap.containsKey(absPath = includeDirs[i].getAbsolutePath())) {
                    if (absPath.startsWith("/usr/")) {
                        includePaths.add(CUtil.toUnixPath(absPath));
                    } else {
                        String relPath = CUtil.toUnixPath(CUtil.getRelativePath(baseDir, includeDirs[i]));
                        includePaths.add(relPath);
                    }
                    includePathMap.put(absPath, absPath);
                }
                ++i;
            }
            includePaths.add("${inherited)");
            debugSettings.put("HEADER_SEARCH_PATHS", includePaths);
            releaseSettings.put("HEADER_SEARCH_PATHS", includePaths);
        }
        String[] preArgs = compilerConfig.getPreArguments();
        ArrayList<String> defines = new ArrayList<String>();
        i = 0;
        while (i < preArgs.length) {
            if (preArgs[i].startsWith("-D")) {
                defines.add(preArgs[i].substring(2));
            }
            ++i;
        }
        if (defines.size() > 0) {
            defines.add("$(inherited)");
            debugSettings.put("GCC_PREPROCESSOR_DEFINITIONS", defines);
            releaseSettings.put("GCC_PREPROCESSOR_DEFINITIONS", defines);
        }
        if (linkerConfig != null) {
            HashMap<String, String> librarySearchMap = new HashMap<String, String>();
            ArrayList<String> librarySearchPaths = new ArrayList<String>();
            ArrayList<String> otherLdFlags = new ArrayList<String>();
            String[] linkerArgs = linkerConfig.getEndArguments();
            int i2 = 0;
            while (i2 < linkerArgs.length) {
                if (linkerArgs[i2].startsWith("-L")) {
                    String libDir = linkerArgs[i2].substring(2);
                    if (!librarySearchMap.containsKey(libDir)) {
                        if (!libDir.equals("/usr/lib")) {
                            librarySearchPaths.add(CUtil.toUnixPath(CUtil.getRelativePath(baseDir, new File(libDir))));
                        }
                        librarySearchMap.put(libDir, libDir);
                    }
                } else if (linkerArgs[i2].startsWith("-l")) {
                    String libName = linkerArgs[i2].substring(2);
                    boolean found = false;
                    Iterator iter = dependencies.iterator();
                    while (iter.hasNext()) {
                        File dependencyFile;
                        DependencyDef dependency = (DependencyDef)iter.next();
                        if (!libName.startsWith(dependency.getName()) || (dependencyFile = dependency.getFile()) == null || !new File(String.valueOf(dependencyFile.getAbsolutePath()) + ".xcodeproj").exists()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        otherLdFlags.add(linkerArgs[i2]);
                    }
                }
                ++i2;
            }
            debugSettings.put("LIBRARY_SEARCH_PATHS", librarySearchPaths);
            debugSettings.put("OTHER_LDFLAGS", otherLdFlags);
            releaseSettings.put("LIBRARY_SEARCH_PATHS", librarySearchPaths);
            releaseSettings.put("OTHER_LDFLAGS", otherLdFlags);
        }
        return configurationList;
    }

    private PBXObjectRef addNativeTarget(Map objects, TargetInfo linkTarget, PBXObjectRef product, String projectName, List sourceGroupChildren, List frameworkBuildFiles) {
        PBXObjectRef buildConfigurations = this.addNativeTargetConfigurationList(objects, projectName);
        int buildActionMask = Integer.MAX_VALUE;
        ArrayList<PBXObjectRef> buildPhases = new ArrayList<PBXObjectRef>();
        HashMap settings = new HashMap();
        settings.put("ATTRIBUTES", new ArrayList());
        ArrayList<PBXObjectRef> buildFiles = new ArrayList<PBXObjectRef>();
        Iterator iter = sourceGroupChildren.iterator();
        while (iter.hasNext()) {
            PBXObjectRef sourceFile = (PBXObjectRef)iter.next();
            PBXObjectRef buildFile = XcodeProjectWriter.createPBXBuildFile(sourceFile, settings);
            buildFiles.add(buildFile);
            objects.put(buildFile.getID(), buildFile.getProperties());
        }
        PBXObjectRef sourcesBuildPhase = XcodeProjectWriter.createPBXSourcesBuildPhase(buildActionMask, buildFiles, false);
        objects.put(sourcesBuildPhase.getID(), sourcesBuildPhase.getProperties());
        buildPhases.add(sourcesBuildPhase);
        buildActionMask = 8;
        PBXObjectRef frameworksBuildPhase = XcodeProjectWriter.createPBXFrameworksBuildPhase(buildActionMask, frameworkBuildFiles, false);
        objects.put(frameworksBuildPhase.getID(), frameworksBuildPhase.getProperties());
        buildPhases.add(frameworksBuildPhase);
        PBXObjectRef copyFilesBuildPhase = XcodeProjectWriter.createPBXCopyFilesBuildPhase(8, "/usr/share/man/man1", "0", new ArrayList(), true);
        objects.put(copyFilesBuildPhase.getID(), copyFilesBuildPhase.getProperties());
        buildPhases.add(copyFilesBuildPhase);
        ArrayList buildRules = new ArrayList();
        ArrayList dependencies = new ArrayList();
        String productInstallPath = "$(HOME)/bin";
        String productType = this.getProductType(linkTarget);
        PBXObjectRef nativeTarget = XcodeProjectWriter.createPBXNativeTarget(projectName, buildConfigurations, buildPhases, buildRules, dependencies, productInstallPath, projectName, product, productType);
        objects.put(nativeTarget.getID(), nativeTarget.getProperties());
        return nativeTarget;
    }

    private int getProductTypeIndex(TargetInfo linkTarget) {
        String outPath = linkTarget.getOutput().getPath();
        String outExtension = null;
        int lastDot = outPath.lastIndexOf(46);
        if (lastDot != -1) {
            outExtension = outPath.substring(lastDot);
        }
        if (".a".equalsIgnoreCase(outExtension) || ".lib".equalsIgnoreCase(outExtension)) {
            return 1;
        }
        if (".dylib".equalsIgnoreCase(outExtension) || ".so".equalsIgnoreCase(outExtension) || ".dll".equalsIgnoreCase(outExtension)) {
            return 2;
        }
        return 0;
    }

    private String getProductType(TargetInfo linkTarget) {
        switch (this.getProductTypeIndex(linkTarget)) {
            case 1: {
                return "com.apple.product-type.library.static";
            }
            case 2: {
                return "com.apple.product-type.library.dynamic";
            }
        }
        return "com.apple.product-type.tool";
    }

    private String getFileType(TargetInfo linkTarget) {
        switch (this.getProductTypeIndex(linkTarget)) {
            case 1: {
                return "archive.ar";
            }
            case 2: {
                return "compiled.mach-o.dylib";
            }
        }
        return "compiled.mach-o.executable";
    }

    private static PBXObjectRef createPBXFileReference(String sourceTree, String baseDir, File file) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isa", "PBXFileReference");
        String relPath = CUtil.toUnixPath(CUtil.getRelativePath(baseDir, file));
        map.put("path", relPath);
        map.put("name", file.getName());
        map.put("sourceTree", sourceTree);
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXGroup(String name, String sourceTree, List children) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "PBXGroup");
        map.put("name", name);
        map.put("sourceTree", sourceTree);
        map.put("children", children);
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXProject(PBXObjectRef buildConfigurationList, PBXObjectRef mainGroup, String projectDirPath, String projectRoot, List targets) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "PBXProject");
        map.put("buildConfigurationList", buildConfigurationList.getID());
        map.put("hasScannedForEncodings", "0");
        map.put("mainGroup", mainGroup.getID());
        map.put("projectDirPath", projectDirPath);
        map.put("targets", targets);
        map.put("projectRoot", projectRoot);
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createXCConfigurationList(List buildConfigurations) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "XCConfigurationList");
        map.put("buildConfigurations", buildConfigurations);
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createXCBuildConfiguration(String name, Map buildSettings) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "XCBuildConfiguration");
        map.put("buildSettings", buildSettings);
        map.put("name", name);
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXNativeTarget(String name, PBXObjectRef buildConfigurationList, List buildPhases, List buildRules, List dependencies, String productInstallPath, String productName, PBXObjectRef productReference, String productType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "PBXNativeTarget");
        map.put("buildConfigurationList", buildConfigurationList);
        map.put("buildPhases", buildPhases);
        map.put("buildRules", buildRules);
        map.put("dependencies", dependencies);
        map.put("name", name);
        map.put("productInstallPath", productInstallPath);
        map.put("productName", productName);
        map.put("productReference", productReference);
        map.put("productType", productType);
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXSourcesBuildPhase(int buildActionMask, List files, boolean runOnly) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("buildActionMask", String.valueOf(buildActionMask));
        map.put("files", files);
        map.put("isa", "PBXSourcesBuildPhase");
        map.put("runOnlyForDeploymentPostprocessing", XcodeProjectWriter.toString(runOnly));
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXBuildFile(PBXObjectRef fileRef, Map settings) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileRef", fileRef);
        map.put("isa", "PBXBuildFile");
        if (settings != null) {
            map.put("settings", settings);
        }
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXFrameworksBuildPhase(int buildActionMask, List files, boolean runOnly) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "PBXFrameworksBuildPhase");
        map.put("buildActionMask", NumberFormat.getIntegerInstance(Locale.US).format(buildActionMask));
        map.put("files", files);
        map.put("runOnlyForDeploymentPostprocessing", XcodeProjectWriter.toString(runOnly));
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXCopyFilesBuildPhase(int buildActionMask, String dstPath, String dstSubfolderSpec, List files, boolean runOnly) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "PBXCopyFilesBuildPhase");
        map.put("buildActionMask", NumberFormat.getIntegerInstance(Locale.US).format(buildActionMask));
        map.put("dstPath", dstPath);
        map.put("dstSubfolderSpec", dstSubfolderSpec);
        map.put("files", files);
        map.put("runOnlyForDeploymentPostprocessing", XcodeProjectWriter.toString(runOnly));
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXContainerItemProxy(PBXObjectRef containerPortal, int proxyType, String remoteInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "PBXContainerItemProxy");
        map.put("containerPortal", containerPortal);
        map.put("proxyType", NumberFormat.getIntegerInstance(Locale.US).format(proxyType));
        map.put("remoteInfo", remoteInfo);
        return new PBXObjectRef(map);
    }

    private static PBXObjectRef createPBXReferenceProxy(PBXObjectRef remoteRef, DependencyDef dependency) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isa", "PBXReferenceProxy");
        String fileType = "compiled.mach-o.dylib";
        map.put("fileType", fileType);
        map.put("remoteRef", remoteRef);
        map.put("path", String.valueOf(dependency.getFile().getName()) + ".dylib");
        map.put("sourceTree", "BUILT_PRODUCTS_DIR");
        return new PBXObjectRef(map);
    }

    private static String toString(boolean b) {
        if (b) {
            return "1";
        }
        return "0";
    }

    private CommandLineCompilerConfiguration getBaseCompilerConfiguration(Hashtable targets) {
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            CommandLineCompilerConfiguration compilerConfig;
            TargetInfo targetInfo = (TargetInfo)targetIter.next();
            ProcessorConfiguration config = targetInfo.getConfiguration();
            if (!(config instanceof CommandLineCompilerConfiguration) || !((compilerConfig = (CommandLineCompilerConfiguration)config).getCompiler() instanceof GccCCompiler)) continue;
            return compilerConfig;
        }
        return null;
    }

    private static final class PBXObjectRef {
        private final String id;
        private final Map properties;
        private static int nextID = 0;

        public PBXObjectRef(Map props) {
            if (props == null) {
                throw new NullPointerException("props");
            }
            StringBuffer buf = new StringBuffer("000000000000000000000000");
            String idStr = Integer.toHexString(nextID++);
            buf.replace(buf.length() - idStr.length(), buf.length(), idStr);
            this.id = buf.toString();
            this.properties = props;
        }

        public String toString() {
            return this.id;
        }

        public String getID() {
            return this.id;
        }

        public Map getProperties() {
            return this.properties;
        }
    }
}

