/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.ClassInfo;
import com.google.doclava.FieldInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.SeeTagInfo;
import com.google.doclava.TagInfo;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proofread {
    static FileWriter out = null;
    static final Pattern WHITESPACE = Pattern.compile("\\r?\\n");
    static final String INDENT = "        ";
    static final String NEWLINE = "\n        ";

    public static void initProofread(String filename) {
        try {
            out = new FileWriter(filename);
            out.write("javadoc proofread file: " + filename + "\n");
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                out = null;
            }
            System.err.println("error opening file: " + filename);
        }
    }

    public static void finishProofread() {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void write(String s) {
        if (out == null) {
            return;
        }
        try {
            out.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeIndented(String s) {
        s = s.trim();
        Matcher m = WHITESPACE.matcher(s);
        s = m.replaceAll(NEWLINE);
        Proofread.write(INDENT);
        Proofread.write(s);
        Proofread.write("\n");
    }

    public static void writeFileHeader(String filename) {
        Proofread.write("\n\n=== ");
        Proofread.write(filename);
        Proofread.write(" ===\n");
    }

    public static void writeTagList(List<TagInfo> tags) {
        if (out == null) {
            return;
        }
        for (TagInfo t : tags) {
            String k = t.kind();
            if ("Text".equals(t.name())) {
                Proofread.writeIndented(t.text());
                continue;
            }
            if ("@more".equals(k)) {
                Proofread.writeIndented("");
                continue;
            }
            if ("@see".equals(k)) {
                SeeTagInfo see = (SeeTagInfo)t;
                String label = see.label();
                if (label == null) {
                    label = "";
                }
                Proofread.writeIndented("{" + see.name() + " ... " + label + "}");
                continue;
            }
            if ("@code".equals(k)) {
                Proofread.writeIndented(t.text());
                continue;
            }
            if ("@samplecode".equals(k)) {
                Proofread.writeIndented(t.text());
                continue;
            }
            Proofread.writeIndented("{" + (t.name() != null ? t.name() : "") + "/" + t.text() + "}");
        }
    }

    public static void writePackages(String filename, List<TagInfo> tags) {
        if (out == null) {
            return;
        }
        Proofread.writeFileHeader(filename);
        Proofread.writeTagList(tags);
    }

    public static void writePackage(String filename, List<TagInfo> tags) {
        if (out == null) {
            return;
        }
        Proofread.writeFileHeader(filename);
        Proofread.writeTagList(tags);
    }

    public static void writeClass(String filename, ClassInfo cl) {
        if (out == null) {
            return;
        }
        Proofread.writeFileHeader(filename);
        Proofread.writeTagList(cl.inlineTags());
        for (FieldInfo f : cl.enumConstants()) {
            Proofread.write("ENUM: " + f.name() + "\n");
            Proofread.writeTagList(f.inlineTags());
        }
        for (FieldInfo f : cl.getFields()) {
            Proofread.write("FIELD: " + f.name() + "\n");
            Proofread.writeTagList(f.inlineTags());
        }
        for (MethodInfo m : cl.getConstructors()) {
            Proofread.write("CONSTRUCTOR: " + m.name() + "\n");
            Proofread.writeTagList(m.inlineTags().tags());
        }
        for (MethodInfo m : cl.getMethods()) {
            Proofread.write("METHOD: " + m.name() + "\n");
            Proofread.writeTagList(m.inlineTags().tags());
        }
    }
}

