/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Copy
extends Task {
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector filesets = new Vector();
    protected boolean filtering = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    private boolean failonerror = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();
    protected Hashtable completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    private Vector filterChains = new Vector();
    private Vector filterSets = new Vector();
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private String encoding = null;

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTofile(File destFile) {
        this.destFile = destFile;
    }

    public void setTodir(File destDir) {
        this.destDir = destDir;
    }

    public FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.filterChains.addElement(filterChain);
        return filterChain;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public void setPreserveLastModified(String preserve) {
        this.setPreserveLastModified(Project.toBoolean(preserve));
    }

    public void setPreserveLastModified(boolean preserve) {
        this.preserveLastModified = preserve;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected Vector getFilterSets() {
        return this.filterSets;
    }

    protected Vector getFilterChains() {
        return this.filterChains;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void execute() throws BuildException {
        File savedFile = this.file;
        File savedDestFile = this.destFile;
        File savedDestDir = this.destDir;
        FileSet savedFileSet = null;
        if (this.file == null && this.destFile != null && this.filesets.size() == 1) {
            savedFileSet = (FileSet)this.filesets.elementAt(0);
        }
        this.validateAttributes();
        try {
            if (this.file != null) {
                if (this.file.exists()) {
                    if (this.destFile == null) {
                        this.destFile = new File(this.destDir, this.file.getName());
                    }
                    if (this.forceOverwrite || this.file.lastModified() > this.destFile.lastModified()) {
                        this.fileCopyMap.put(this.file.getAbsolutePath(), this.destFile.getAbsolutePath());
                    } else {
                        this.log(this.file + " omitted as " + this.destFile + " is up to date.", 3);
                    }
                } else {
                    String message = "Warning: Could not find file " + this.file.getAbsolutePath() + " to copy.";
                    if (!this.failonerror) {
                        this.log(message);
                    } else {
                        throw new BuildException(message);
                    }
                }
            }
            int i = 0;
            while (i < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                File fromDir = fs.getDir(this.project);
                String[] srcFiles = ds.getIncludedFiles();
                String[] srcDirs = ds.getIncludedDirectories();
                boolean isEverythingIncluded = ds.isEverythingIncluded();
                if (isEverythingIncluded && !this.flatten && this.mapperElement == null) {
                    this.completeDirMap.put(fromDir, this.destDir);
                }
                this.scan(fromDir, this.destDir, srcFiles, srcDirs);
                ++i;
            }
            this.doFileOperations();
            Object var13_13 = null;
            this.file = savedFile;
            this.destFile = savedDestFile;
            this.destDir = savedDestDir;
            if (savedFileSet != null) {
                this.filesets.insertElementAt(savedFileSet, 0);
            }
            this.fileCopyMap.clear();
            this.dirCopyMap.clear();
            this.completeDirMap.clear();
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.file = savedFile;
            this.destFile = savedDestFile;
            this.destDir = savedDestDir;
            if (savedFileSet != null) {
                this.filesets.insertElementAt(savedFileSet, 0);
            }
            this.fileCopyMap.clear();
            this.dirCopyMap.clear();
            this.completeDirMap.clear();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException("Only one of tofile and todir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException("One of tofile or todir must be set.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to copy directories.");
        }
        if (this.destFile != null && this.filesets.size() > 0) {
            if (this.filesets.size() > 1) {
                throw new BuildException("Cannot concatenate multiple files into a single file.");
            }
            FileSet fs = (FileSet)this.filesets.elementAt(0);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String[] srcFiles = ds.getIncludedFiles();
            if (srcFiles.length == 0) {
                throw new BuildException("Cannot perform operation from directory to file.");
            }
            if (srcFiles.length != 1) throw new BuildException("Cannot concatenate multiple files into a single file.");
            if (this.file != null) throw new BuildException("Cannot concatenate multiple files into a single file.");
            this.file = new File(ds.getBasedir(), srcFiles[0]);
            this.filesets.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = this.fileUtils.getParentFile(this.destFile);
    }

    protected void scan(File fromDir, File toDir, String[] files, String[] dirs) {
        FileNameMapper mapper = null;
        mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        this.buildMap(fromDir, toDir, files, mapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(fromDir, toDir, dirs, mapper, this.dirCopyMap);
        }
    }

    protected void buildMap(File fromDir, File toDir, String[] names, FileNameMapper mapper, Hashtable map) {
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < names.length) {
                if (mapper.mapFileName(names[i]) != null) {
                    v.addElement(names[i]);
                }
                ++i;
            }
            toCopy = new String[v.size()];
            v.copyInto(toCopy);
        } else {
            SourceFileScanner ds = new SourceFileScanner(this);
            toCopy = ds.restrict(names, fromDir, toDir, mapper);
        }
        int i = 0;
        while (i < toCopy.length) {
            File src = new File(fromDir, (String)toCopy[i]);
            File dest = new File(toDir, mapper.mapFileName((String)toCopy[i])[0]);
            map.put(src.getAbsolutePath(), dest.getAbsolutePath());
            ++i;
        }
    }

    protected void doFileOperations() {
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String toFile;
                String fromFile = (String)e.nextElement();
                if (fromFile.equals(toFile = (String)this.fileCopyMap.get(fromFile))) {
                    this.log("Skipping self-copy of " + fromFile, this.verbosity);
                    continue;
                }
                try {
                    this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                    FilterSetCollection executionFilters = new FilterSetCollection();
                    if (this.filtering) {
                        executionFilters.addFilterSet(this.project.getGlobalFilterSet());
                    }
                    Enumeration filterEnum = this.filterSets.elements();
                    while (filterEnum.hasMoreElements()) {
                        executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                    }
                    this.fileUtils.copyFile(fromFile, toFile, executionFilters, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.encoding, this.project);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.location);
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int count = 0;
            while (e.hasMoreElements()) {
                File d = new File((String)e.nextElement());
                if (d.exists()) continue;
                if (!d.mkdirs()) {
                    this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                this.log("Copied " + count + " empty director" + (count == 1 ? "y" : "ies") + " to " + this.destDir.getAbsolutePath());
            }
        }
    }
}

