/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.text.DecimalFormat;
import org.apache.xalan.xpath.XObject;
import org.xml.sax.SAXException;

public class XNumber
extends XObject {
    double m_val;

    public XNumber(double d) {
        this.m_val = d;
    }

    public int getType() {
        return 2;
    }

    private String getTypeString() {
        return "#NUMBER";
    }

    public double num() {
        return this.m_val;
    }

    public boolean bool() {
        return !Double.isNaN(this.m_val) && this.m_val != 0.0;
    }

    public String str() {
        if (Double.isNaN(this.m_val)) {
            return "NaN";
        }
        if (Double.isInfinite(this.m_val)) {
            if (this.m_val > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.####################");
        String string = decimalFormat.format(this.m_val);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public Object object() {
        return new Double(this.m_val);
    }

    public boolean equals(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        return this.m_val == xObject.num();
    }
}

