/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.utils.StringPool;

public final class DeferredAttrNSImpl
extends AttrNSImpl
implements DeferredNode {
    static final long serialVersionUID = 6074924934945957154L;
    protected transient int fNodeIndex;

    DeferredAttrNSImpl(DeferredDocumentImpl deferredDocumentImpl, int n) {
        super(deferredDocumentImpl, null);
        this.fNodeIndex = n;
        this.syncData = true;
        this.syncChildren = true;
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeData() {
        this.syncData = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        int n = deferredDocumentImpl.getNodeName(this.fNodeIndex);
        StringPool stringPool = deferredDocumentImpl.getStringPool();
        this.name = stringPool.toString(n);
        this.specified = deferredDocumentImpl.getNodeValue(this.fNodeIndex) == 1;
        this.prefix = stringPool.toString(stringPool.getPrefixForQName(n));
        this.namespaceURI = stringPool.toString(stringPool.getURIForQName(n));
        if (this.namespaceURI == null) {
            if (this.prefix != null) {
                if (this.prefix.equals("xmlns")) {
                    this.namespaceURI = "http://www.w3.org/2000/xmlns/";
                }
            } else if (this.name.equals("xmlns")) {
                this.namespaceURI = "http://www.w3.org/2000/xmlns/";
            }
        }
        this.localName = stringPool.toString(stringPool.getLocalPartForQName(n));
    }

    protected void synchronizeChildren() {
        this.syncChildren = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        NodeImpl nodeImpl = null;
        int n = deferredDocumentImpl.getFirstChild(this.fNodeIndex);
        while (n != -1) {
            NodeImpl nodeImpl2 = (NodeImpl)((Object)deferredDocumentImpl.getNodeObject(n));
            if (nodeImpl == null) {
                this.firstChild = nodeImpl2;
            } else {
                nodeImpl.nextSibling = nodeImpl2;
            }
            nodeImpl2.parentNode = this;
            nodeImpl2.previousSibling = nodeImpl;
            nodeImpl = nodeImpl2;
            n = deferredDocumentImpl.getNextSibling(n);
        }
        if (nodeImpl != null) {
            this.lastChild = nodeImpl;
        }
    }
}

