/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.domx;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.readers.MIME2Java;
import org.apache.xerces.validators.schema.XUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XGrammarWriter {
    protected static final OutputFormat DEFAULT_OUTPUT_FORMAT = OutputFormat.XML_SCHEMA;
    protected static final String[] CONTENT_MODEL_ELEMENT_NAMES = new String[]{"element", "group"};
    protected PrintWriter out;
    protected int indent;
    protected OutputFormat format;
    protected boolean verbose;
    protected String encoding;
    protected boolean canonical;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = new DOMParser();
        try {
            var1_1.setFeature("http://apache.org/xml/features/domx/grammar-access", true);
        }
        catch (Exception v0) {
            System.err.println("warning: unable to set feature.");
        }
        var2_2 = new XGrammarWriter();
        if (var0.length == 0) {
            XGrammarWriter.printUsage();
            return;
        }
        var3_3 = 0;
        while (var3_3 < var0.length) {
            var4_4 = var0[var3_3];
            if (!var4_4.startsWith("-")) ** GOTO lbl37
            if (var4_4.equals("-d") || var4_4.equals("--dtd")) {
                var2_2.setOutputFormat(OutputFormat.DTD);
            } else if (var4_4.equals("-x") || var4_4.equals("--schema")) {
                var2_2.setOutputFormat(OutputFormat.XML_SCHEMA);
            } else if (var4_4.equals("-v") || var4_4.equals("--verbose")) {
                var2_2.setVerbose(true);
            } else if (var4_4.equals("-q") || var4_4.equals("--quiet")) {
                var2_2.setVerbose(false);
            } else {
                if (var4_4.equals("-h") || var4_4.equals("--help")) {
                    XGrammarWriter.printUsage();
                    return;
                }
                if (var4_4.equals("--")) {
                    if (var3_3 < var0.length - 1) {
                        System.err.println("error: Missing argument to -- option.");
                        return;
                    }
                    var4_4 = var0[++var3_3];
                } else {
                    System.err.println("error: Unknown option (" + var4_4 + ").");
                }
lbl37:
                // 3 sources

                try {
                    var1_1.parse(var4_4);
                    var5_5 = var1_1.getDocument();
                    var2_2.printGrammar(var4_4, var5_5.getDoctype());
                }
                catch (Exception var5_6) {
                    System.err.println("error: Error parsing document (" + var4_4 + ").");
                    var5_6.printStackTrace(System.err);
                }
            }
            ++var3_3;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java org.apache.xerces.domx.XGrammarWriter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -d | --dtd      Output document grammar in DTD format.");
        System.err.println("  -x | --schema   Output document grammar in XML Schema format. (default)");
        System.err.println("  -v | --verbose  Verbose output prints default attributes.");
        System.err.println("  -q | --quiet    Quiet output prints specified attributes. (default)");
        System.err.println("  -h | --help     This help screen.");
        System.err.println();
        System.err.println("  -- filename     Specify input URI that starts with a hyphen (-).");
    }

    public XGrammarWriter() {
        this(System.out);
    }

    public XGrammarWriter(PrintWriter printWriter) {
        this.init();
        this.out = printWriter;
    }

    public XGrammarWriter(OutputStream outputStream) {
        this.init();
        try {
            this.out = new PrintWriter(new OutputStreamWriter(outputStream, this.encoding));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.encoding = null;
            this.out = new PrintWriter(outputStream);
            return;
        }
    }

    public XGrammarWriter(Writer writer, String string) {
        this(new PrintWriter(writer));
        this.encoding = string;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.format = outputFormat;
    }

    public OutputFormat getOutputFormat() {
        return this.format;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setCanonical(boolean bl) {
        this.canonical = bl;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public void printGrammar(String string, DocumentType documentType) {
        String string2;
        this.out.print("<?xml ");
        if (this.format.equals(OutputFormat.XML_SCHEMA)) {
            this.out.print("version=\"1.0\" ");
        }
        if ((string2 = MIME2Java.reverse(this.encoding)) == null) {
            string2 = "US-ASCII";
        }
        this.out.print("encoding=\"");
        this.out.print(string2);
        this.out.print('\"');
        this.out.print("?>");
        this.out.flush();
        this.out.println();
        this.out.print("<!-- Grammar referenced in document: \"");
        this.out.print(string);
        this.out.print("\" -->");
        this.out.flush();
        if (documentType == null) {
            return;
        }
        Element element = XUtil.getFirstChildElement((Node)documentType, "schema");
        if (this.format.equals(OutputFormat.DTD)) {
            this.out.println();
            Element element2 = XUtil.getFirstChildElement(element);
            while (element2 != null) {
                String string3 = element2.getNodeName();
                if (string3.equals("element")) {
                    this.printElementDecl(element2);
                } else if (string3.equals("textEntity")) {
                    this.printEntityDecl(element2);
                } else if (string3.equals("externalEntity")) {
                    this.printEntityDecl(element2);
                } else if (string3.equals("unparsedEntity")) {
                    this.printEntityDecl(element2);
                } else if (string3.equals("notation")) {
                    this.printNotationDecl(element2);
                } else if (string3.equals("comment")) {
                    this.printComment(element2);
                }
                element2 = XUtil.getNextSiblingElement(element2);
            }
            return;
        }
        if (this.format.equals(OutputFormat.XML_SCHEMA)) {
            this.out.println();
            this.out.print("<!DOCTYPE schema PUBLIC \"-//W3C//DTD XML Schema Version 1.0//EN\" \"http://www.w3.org/XML/Group/1999/09/23-xmlschema/structures/structures.dtd\">");
            this.printElement(element);
            this.out.println();
            this.out.flush();
            return;
        }
        throw new IllegalArgumentException("unknown output format (" + this.format + ")");
    }

    public void printComment(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            this.out.println();
            this.printIndent(this.indent);
            while (node != null) {
                if (node.getNodeType() == 3) {
                    this.out.print(node.getNodeValue());
                }
                node = node.getNextSibling();
            }
            this.out.flush();
        }
    }

    public void printElement(Element element) {
        boolean bl = this.isEmpty(element);
        if (bl) {
            this.out.println();
            this.printIndent(this.indent);
            this.printEmptyElement(element);
        } else {
            this.out.println();
            this.printIndent(this.indent);
            this.printOpenElement(element);
            Node node = element.getFirstChild();
            int n = -1;
            while (node != null) {
                n = node.getNodeType();
                if (n == 1) {
                    ++this.indent;
                    this.printElement((Element)node);
                    --this.indent;
                } else if (n == 3) {
                    this.printText((Text)node);
                }
                node = node.getNextSibling();
            }
            if (n != 3) {
                this.out.println();
                this.printIndent(this.indent);
            }
            this.printCloseElement(element);
        }
        this.out.flush();
    }

    public void printIndent(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.out.print("  ");
            ++n2;
        }
        this.out.flush();
    }

    public void printOpenElement(Element element) {
        this.printOpenElement(element, false);
    }

    public void printEmptyElement(Element element) {
        this.printOpenElement(element, true);
    }

    public void printCloseElement(Element element) {
        this.out.print("</");
        this.out.print(element.getNodeName());
        this.out.print('>');
        this.out.flush();
    }

    public void printAttribute(Attr attr) {
        String string = attr.getNodeName();
        String string2 = attr.getNodeValue();
        this.out.print(string);
        this.out.print('=');
        this.out.print('\"');
        this.out.print(this.normalize(string2));
        this.out.print('\"');
    }

    public void printText(Text text) {
        String string = text.getNodeValue();
        this.out.print(this.normalize(string));
    }

    public void printElementDecl(Element element) {
        String string = element.getAttribute("name");
        Element element2 = XUtil.getFirstChildElement((Node)element, "archetype");
        this.out.print("<!ELEMENT ");
        this.out.print(string);
        this.out.print(' ');
        this.printElementDeclContentModel(element2);
        this.out.print('>');
        this.out.println();
        this.out.flush();
        Element element3 = XUtil.getFirstChildElement((Node)element, "archetype");
        if (element3 != null) {
            Element element4 = XUtil.getFirstChildElement((Node)element3, "attribute");
            while (element4 != null) {
                this.printAttributeDecl(string, element4);
                element4 = XUtil.getNextSiblingElement((Node)element4, "attribute");
            }
        }
    }

    public void printElementDeclContentModel(Element element) {
        String string = element.getAttribute("content");
        if (string.equals("empty") || string.equals("any")) {
            this.out.print(string.toUpperCase());
        } else if (string.equals("elemOnly")) {
            this.printElementDeclContentModelChildren(element);
        } else if (string.equals("mixed") || string.equals("textOnly")) {
            this.printElementDeclContentModelMixed(element);
        }
        this.out.flush();
    }

    public void printElementDeclContentModelMixed(Element element) {
        Element element2 = XUtil.getFirstChildElement((Node)element, "element");
        boolean bl = element2 == null;
        this.out.print("(#PCDATA");
        if (!bl) {
            while (element2 != null) {
                String string = element2.getAttribute("ref");
                this.out.print('|');
                this.out.print(string);
                element2 = XUtil.getNextSiblingElement((Node)element2, "element");
            }
        }
        this.out.print(')');
        if (!bl) {
            this.out.print('*');
        }
    }

    public void printElementDeclContentModelChildren(Element element) {
        boolean bl;
        boolean bl2 = bl = !this.containsMoreThanOneChildOfType(element, new String[]{"element", "group"}) && XUtil.getFirstChildElement((Node)element, "element") != null;
        if (bl) {
            this.out.print('(');
        }
        Element element2 = XUtil.getFirstChildElement((Node)element, CONTENT_MODEL_ELEMENT_NAMES);
        while (element2 != null) {
            this.printElementDeclContentModelChildren0(element2);
            element2 = XUtil.getNextSiblingElement((Node)element2, CONTENT_MODEL_ELEMENT_NAMES);
            if (element2 == null) continue;
            this.out.print(',');
        }
        if (bl) {
            this.out.print(')');
        }
    }

    public void printAttributeDecl(String string, Element element) {
        Object object;
        String string2 = element.getAttribute("name");
        String string3 = element.getAttribute("type");
        Attr attr = element.getAttributeNode("default");
        this.out.print("<!ATTLIST ");
        this.out.print(string);
        this.out.print(' ');
        this.out.print(string2);
        this.out.print(' ');
        if (this.isBasicAttributeType(string3)) {
            object = XUtil.getFirstChildElement((Node)element, "enumeration");
            if (string3.equals("NMTOKEN") && object != null) {
                this.out.print('(');
                Element element2 = XUtil.getFirstChildElement((Node)object, "literal");
                while (element2 != null) {
                    element2.normalize();
                    Node node = this.getFirstChildOfType(element2, (short)3);
                    String string4 = node != null ? node.getNodeValue() : "";
                    this.out.print(string4);
                    element2 = XUtil.getNextSiblingElement((Node)element2, "literal");
                    if (element2 == null) continue;
                    this.out.print('|');
                }
                this.out.print(')');
            } else {
                this.out.print(string3);
            }
        } else {
            this.out.print("CDATA");
        }
        if (element.getAttribute("minOccurs").equals("1")) {
            this.out.print(" #REQUIRED");
        } else if (element.getAttribute("fixed").length() > 0) {
            object = element.getAttribute("fixed");
            this.out.print(" #FIXED ");
            this.out.print('\"');
            this.out.print(this.normalize((String)object));
            this.out.print('\"');
        } else if (attr == null) {
            this.out.print(" #IMPLIED");
        }
        if (attr != null) {
            object = attr.getNodeValue();
            this.out.print(' ');
            this.out.print('\"');
            this.out.print(this.normalize((String)object));
            this.out.print('\"');
        }
        this.out.print('>');
        this.out.println();
        this.out.flush();
    }

    public void printEntityDecl(Element element) {
        String string = element.getNodeName();
        String string2 = element.getAttribute("name");
        this.out.print("<!ENTITY ");
        this.out.print(string2);
        this.out.print(' ');
        if (string.equals("textEntity")) {
            element.normalize();
            Node node = this.getFirstChildOfType(element, (short)3);
            String string3 = node != null ? node.getNodeValue() : "";
            this.out.print('\"');
            this.out.print(this.normalize(string3));
            this.out.print('\"');
        } else {
            String string4 = element.getAttribute("public");
            String string5 = element.getAttribute("system");
            if (string4.length() > 0) {
                this.out.print("PUBLIC ");
                this.out.print('\"');
                this.out.print(string4);
                this.out.print('\"');
                this.out.print(' ');
                this.out.print('\"');
                this.out.print(string5);
                this.out.print('\"');
            } else if (string5.length() > 0) {
                this.out.print("SYSTEM ");
                this.out.print('\"');
                this.out.print(string5);
                this.out.print('\"');
            }
            if (string.equals("unparsedEntity")) {
                String string6 = element.getAttribute("notation");
                this.out.print(" NDATA ");
                this.out.print(string6);
            }
        }
        this.out.print('>');
        this.out.println();
        this.out.flush();
    }

    public void printNotationDecl(Element element) {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("public");
        String string3 = element.getAttribute("system");
        this.out.print("<!NOTATION ");
        this.out.print(string);
        this.out.print(' ');
        if (string2.length() > 0) {
            this.out.print("PUBLIC ");
            this.out.print('\"');
            this.out.print(string2);
            this.out.print('\"');
            if (string3.length() > 0) {
                this.out.print(' ');
                this.out.print('\"');
                this.out.print(string3);
                this.out.print('\"');
            }
        } else if (string3.length() > 0) {
            this.out.print("SYSTEM ");
            this.out.print('\"');
            this.out.print(string3);
            this.out.print('\"');
        }
        this.out.print('>');
        this.out.println();
        this.out.flush();
    }

    protected void printOpenElement(Element element, boolean bl) {
        this.out.print('<');
        this.out.print(element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            if (this.verbose || attr.getSpecified()) {
                this.out.print(' ');
                this.printAttribute(attr);
            }
            ++n2;
        }
        if (bl) {
            this.out.print('/');
        }
        this.out.print('>');
        this.out.flush();
    }

    protected boolean isEmpty(Element element) {
        if (!element.hasChildNodes()) {
            return true;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            short s = node.getNodeType();
            if (s == 1 || s == 3) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    protected boolean isBasicAttributeType(String string) {
        return string.equals("ENTITY") || string.equals("ENTITIES") || string.equals("ID") || string.equals("IDREF") || string.equals("IDREFS") || string.equals("NMTOKEN") || string.equals("NMTOKENS");
    }

    protected boolean isBasicOccurrenceCount(String string, String string2) {
        int n = this.parseInt(string, 1);
        int n2 = this.parseInt(string2, 1);
        return n == 0 && n2 == 1 || n == 1 && n2 == 1 || n == 0 && n2 == -1 || n == 1 && n2 == -1;
    }

    protected int parseInt(String string, int n) {
        if (string == null || string.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected boolean containsMoreThanOneChildOfType(Element element, String[] stringArray) {
        int n = 0;
        Element element2 = XUtil.getFirstChildElement((Node)element, stringArray);
        while (element2 != null) {
            ++n;
            element2 = XUtil.getNextSiblingElement((Node)element2, stringArray);
        }
        return n > 1;
    }

    protected Node getFirstChildOfType(Node node, short s) {
        if (node != null) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == s) {
                    return node2;
                }
                node2 = node2.getNextSibling();
            }
        }
        return null;
    }

    protected Node getNextSiblingOfType(Node node, short s) {
        if (node != null) {
            Node node2 = node.getNextSibling();
            while (node2 != null) {
                if (node2.getNodeType() == s) {
                    return node2;
                }
                node2 = node2.getNextSibling();
            }
        }
        return null;
    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void init() {
        this.indent = 0;
        this.verbose = false;
        this.format = OutputFormat.XML_SCHEMA;
        this.encoding = "UTF8";
        this.canonical = false;
    }

    private void printElementDeclContentModelChildren0(Element element) {
        String string = element.getNodeName();
        if (string.equals("element")) {
            String string2 = this.buildOccurrenceCountString(element.getAttribute("ref"), element.getAttribute("minOccurs"), element.getAttribute("maxOccurs"));
            this.out.print(string2);
            return;
        }
        char c = ',';
        String string3 = element.getAttribute("order");
        if (string3.equals("choice")) {
            c = '|';
        } else if (string3.equals("all")) {
            c = '&';
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintWriter printWriter2 = this.out;
        this.out = printWriter;
        this.out.print('(');
        Element element2 = XUtil.getFirstChildElement((Node)element, CONTENT_MODEL_ELEMENT_NAMES);
        while (element2 != null) {
            this.printElementDeclContentModelChildren0(element2);
            element2 = XUtil.getNextSiblingElement((Node)element2, CONTENT_MODEL_ELEMENT_NAMES);
            if (element2 == null) continue;
            this.out.print(c);
        }
        this.out.print(')');
        String string4 = stringWriter.toString();
        if (c == '&') {
            if (string4.startsWith("(") && string4.endsWith(")")) {
                string4 = string4.substring(1, string4.length() - 1);
            }
            string4 = this.expandAllModel(string4);
        }
        string4 = this.buildOccurrenceCountString(string4, element.getAttribute("minOccurs"), element.getAttribute("maxOccurs"));
        this.out = printWriter2;
        this.out.print(string4);
    }

    private String expandAllModel(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        int n = vector.size();
        if (n > 1) {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
            String string3 = "(" + this.buildAllModel(stringArray, 0) + ')';
            return string3;
        }
        return string;
    }

    private String buildAllModel(String[] stringArray, int n) {
        if (stringArray.length - n == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.createSeq(stringArray));
            this.swap(stringArray, n, n + 1);
            stringBuffer.append('|');
            stringBuffer.append(this.createSeq(stringArray));
            this.swap(stringArray, n, n + 1);
            return stringBuffer.toString();
        }
        String[] stringArray2 = new String[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < stringArray.length) {
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            this.shift(stringArray2, n, n2);
            stringBuffer.append(this.buildAllModel(stringArray2, n + 1));
            if (n2 < stringArray.length - 1) {
                stringBuffer.append('|');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String createSeq(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private void shift(String[] stringArray, int n, int n2) {
        String string = stringArray[n2];
        int n3 = n2;
        while (n3 > n) {
            stringArray[n3] = stringArray[n3 - 1];
            --n3;
        }
        stringArray[n] = string;
    }

    private void swap(String[] stringArray, int n, int n2) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
    }

    private String buildOccurrenceCountString(String string, String string2, String string3) {
        int n = this.parseInt(string2, 0);
        int n2 = this.parseInt(string3, 1);
        boolean bl = true;
        if (n2 == -1) {
            n2 = n;
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0 && n2 == 1 && bl) {
            stringBuffer.append(string);
            stringBuffer.append('?');
        } else if (n == 0 && n2 == 0 && !bl) {
            stringBuffer.append(string);
            stringBuffer.append('*');
        } else if (n == 1 && n2 == 1 && !bl) {
            stringBuffer.append(string);
            stringBuffer.append('+');
        } else if (n == 1 && n2 == 1 && bl) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('(');
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(string);
                if (n3 < n - 1) {
                    stringBuffer.append(',');
                }
                ++n3;
            }
            if (n2 > n) {
                int n4 = n;
                while (n4 < n2) {
                    stringBuffer.append(',');
                    stringBuffer.append(string);
                    stringBuffer.append('?');
                    ++n4;
                }
            }
            if (!bl) {
                stringBuffer.append(',');
                stringBuffer.append(string);
                stringBuffer.append('*');
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static final class OutputFormat {
        public static final OutputFormat DTD = new OutputFormat(0);
        public static final OutputFormat XML_SCHEMA = new OutputFormat(1);
        private int value;

        private OutputFormat(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((OutputFormat)object).getValue();
        }

        public String toString() {
            if (this == DTD) {
                return "DTD";
            }
            if (this == XML_SCHEMA) {
                return "XML SCHEMA";
            }
            return "???";
        }
    }
}

