/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.utils.StringPool;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public final class EntityPool {
    static final int CHUNK_SHIFT = 5;
    static final int CHUNK_SIZE = 32;
    static final int CHUNK_MASK = 31;
    static final int INITIAL_CHUNK_COUNT = 32;
    private StringPool fStringPool;
    private XMLErrorReporter fErrorReporter;
    private int fEntityCount;
    private int[][] fName = new int[32][];
    private int[][] fValue = new int[32][];
    private int[][] fLocation = new int[32][];
    private int[][] fPublicId = new int[32][];
    private int[][] fSystemId = new int[32][];
    private int[][] fNotationName = new int[32][];
    private byte[][] fDeclIsExternal = new byte[32][];
    private int fNotationListHead = -1;
    private boolean fCreateStandardEntities = false;
    private Vector fRequiredNotations;

    public EntityPool(StringPool stringPool, XMLErrorReporter xMLErrorReporter, boolean bl) {
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fCreateStandardEntities = bl;
        if (this.fCreateStandardEntities) {
            this.createInternalEntity("lt", "&#60;");
            this.createInternalEntity("gt", ">");
            this.createInternalEntity("amp", "&#38;");
            this.createInternalEntity("apos", "'");
            this.createInternalEntity("quot", "\"");
        }
    }

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fEntityCount = 0;
        this.fNotationListHead = -1;
        if (this.fRequiredNotations != null) {
            this.fRequiredNotations.removeAllElements();
        }
        if (this.fCreateStandardEntities) {
            this.createInternalEntity("lt", "&#60;");
            this.createInternalEntity("gt", ">");
            this.createInternalEntity("amp", "&#38;");
            this.createInternalEntity("apos", "'");
            this.createInternalEntity("quot", "\"");
        }
    }

    private void createInternalEntity(String string, String string2) {
        int n = this.fEntityCount >> 5;
        int n2 = this.fEntityCount & 0x1F;
        this.ensureCapacity(n);
        this.fName[n][n2] = this.fStringPool.addSymbol(string);
        this.fValue[n][n2] = this.fStringPool.addString(string2);
        this.fLocation[n][n2] = -1;
        this.fPublicId[n][n2] = -1;
        this.fSystemId[n][n2] = -1;
        this.fNotationName[n][n2] = -1;
        ++this.fEntityCount;
    }

    private boolean ensureCapacity(int n) {
        try {
            return this.fName[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fName, 0, nArray, 0, n);
            this.fName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fValue, 0, nArray, 0, n);
            this.fValue = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fLocation, 0, nArray, 0, n);
            this.fLocation = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fPublicId, 0, nArray, 0, n);
            this.fPublicId = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fSystemId, 0, nArray, 0, n);
            this.fSystemId = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNotationName, 0, nArray, 0, n);
            this.fNotationName = nArray;
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fDeclIsExternal, 0, byArray, 0, n);
            this.fDeclIsExternal = byArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fName[n] = new int[32];
        this.fValue[n] = new int[32];
        this.fLocation[n] = new int[32];
        this.fPublicId[n] = new int[32];
        this.fSystemId[n] = new int[32];
        this.fNotationName[n] = new int[32];
        this.fDeclIsExternal[n] = new byte[32];
        return true;
    }

    public int addEntityDecl(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = this.fEntityCount >> 5;
        int n8 = this.fEntityCount & 0x1F;
        this.ensureCapacity(n7);
        this.fName[n7][n8] = n;
        this.fValue[n7][n8] = n2;
        this.fLocation[n7][n8] = n3;
        this.fPublicId[n7][n8] = n4;
        this.fSystemId[n7][n8] = n5;
        this.fNotationName[n7][n8] = n6;
        this.fDeclIsExternal[n7][n8] = bl ? -128 : 0;
        int n9 = this.fEntityCount++;
        return n9;
    }

    public int addNotationDecl(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6 = this.fNotationListHead;
        while (n6 != -1) {
            n5 = n6 >> 5;
            n4 = n6 & 0x1F;
            if (this.fNotationName[n5][n4] == n) {
                return -1;
            }
            n6 = this.fValue[n5][n4];
        }
        n5 = this.fEntityCount >> 5;
        n4 = this.fEntityCount & 0x1F;
        this.ensureCapacity(n5);
        this.fName[n5][n4] = -1;
        this.fValue[n5][n4] = this.fNotationListHead;
        this.fPublicId[n5][n4] = n2;
        this.fSystemId[n5][n4] = n3;
        this.fNotationName[n5][n4] = n;
        this.fDeclIsExternal[n5][n4] = bl ? -128 : 0;
        this.fNotationListHead = this.fEntityCount++;
        return this.fNotationListHead;
    }

    public int lookupEntity(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.fEntityCount) {
            if (this.fName[n2][n3] == n) {
                return n4;
            }
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            ++n4;
        }
        return -1;
    }

    public boolean isExternalEntity(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fValue[n2][n3] == -1;
    }

    public boolean isUnparsedEntity(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fNotationName[n2][n3] != -1;
    }

    public boolean getEntityDeclIsExternal(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fDeclIsExternal[n2][n3] < 0;
    }

    public int getEntityName(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fName[n2][n3];
    }

    public int getEntityValue(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fValue[n2][n3];
    }

    public int getEntityLocation(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fLocation[n2][n3];
    }

    public int getPublicId(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fPublicId[n2][n3];
    }

    public int getSystemId(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fSystemId[n2][n3];
    }

    public int lookupNotation(int n) {
        int n2 = this.fNotationListHead;
        while (n2 != -1) {
            int n3 = n2 >> 5;
            int n4 = n2 & 0x1F;
            if (this.fNotationName[n3][n4] == n) {
                return n2;
            }
            n2 = this.fValue[n3][n4];
        }
        return -1;
    }

    public boolean getNotationDeclIsExternal(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fDeclIsExternal[n2][n3] < 0;
    }

    public int getNotationName(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fNotationName[n2][n3];
    }

    public void addRequiredNotation(int n, Locator locator, int n2, int n3, Object[] objectArray) {
        if (this.fRequiredNotations == null) {
            this.fRequiredNotations = new Vector();
        }
        int n4 = 0;
        while (n4 < this.fRequiredNotations.size()) {
            RequiredNotation requiredNotation = (RequiredNotation)this.fRequiredNotations.elementAt(n4);
            if (requiredNotation.fNotationName == n) {
                return;
            }
            ++n4;
        }
        this.fRequiredNotations.addElement(new RequiredNotation(n, locator, n2, n3, objectArray));
    }

    public void checkRequiredNotations() throws Exception {
        if (this.fRequiredNotations == null) {
            return;
        }
        int n = 0;
        while (n < this.fRequiredNotations.size()) {
            RequiredNotation requiredNotation = (RequiredNotation)this.fRequiredNotations.elementAt(n);
            if (this.lookupNotation(requiredNotation.fNotationName) == -1) {
                this.fErrorReporter.reportError(requiredNotation.fLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", requiredNotation.fMajorCode, requiredNotation.fMinorCode, requiredNotation.fArgs, 1);
            }
            ++n;
        }
    }

    class RequiredNotation {
        int fNotationName;
        LocatorImpl fLocator;
        int fMajorCode;
        int fMinorCode;
        Object[] fArgs;

        RequiredNotation(int n, Locator locator, int n2, int n3, Object[] objectArray) {
            EntityPool.this = EntityPool.this;
            this.fNotationName = n;
            this.fLocator = new LocatorImpl(locator);
            this.fMajorCode = n2;
            this.fMinorCode = n3;
            this.fArgs = objectArray;
        }
    }
}

