/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import org.apache.xerces.validators.dtd.CMException;
import org.apache.xerces.validators.dtd.InsertableElementsInfo;
import org.apache.xerces.validators.dtd.XMLContentModel;

public class MixedContentModel
implements XMLContentModel {
    private int fCount;
    private int[] fChildren;

    public MixedContentModel(int n, int[] nArray) throws CMException {
        this.fCount = n;
        this.fChildren = new int[this.fCount];
        System.arraycopy(nArray, 0, this.fChildren, 0, n);
    }

    public int validateContent(int n, int[] nArray) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 != -1) {
                int n4 = 0;
                while (n4 < this.fCount) {
                    if (n3 == this.fChildren[n4]) break;
                    ++n4;
                }
                if (n4 == this.fCount) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        int n = insertableElementsInfo.insertAt;
        while (n < insertableElementsInfo.childCount) {
            insertableElementsInfo.curChildren[n] = insertableElementsInfo.curChildren[n + 1];
            ++n;
        }
        --insertableElementsInfo.childCount;
        int n2 = this.validateContent(insertableElementsInfo.childCount, insertableElementsInfo.curChildren);
        if (n2 != -1 && n2 < insertableElementsInfo.insertAt) {
            return n2;
        }
        insertableElementsInfo.canHoldPCData = true;
        insertableElementsInfo.isValidEOC = true;
        insertableElementsInfo.resultsCount = this.fCount;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new int[insertableElementsInfo.resultsCount];
        }
        boolean bl2 = true;
        if (bl && n2 < insertableElementsInfo.childCount) {
            bl2 = false;
        }
        int n3 = 0;
        while (n3 < this.fCount) {
            insertableElementsInfo.possibleChildren[n3] = this.fChildren[n3];
            insertableElementsInfo.results[n3] = bl2;
            ++n3;
        }
        return -1;
    }
}

