/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.javascript;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.BSFFunctions;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class JavaScriptEngine
extends BSFEngineImpl {
    private Scriptable global;
    private Context cx;

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        try {
            this.cx = new Context();
            Context.enter();
            this.global = this.cx.initStandardObjects(null);
            this.global.put("bsf", this.global, (Object)new BSFFunctions(bSFManager, (BSFEngine)this));
        }
        finally {
            Object var5_4 = null;
            if (this.cx != null) {
                this.cx.exit();
            }
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.declareBean((BSFDeclaredBean)vector.elementAt(n2));
            ++n2;
        }
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        String string2 = object.toString();
        Object object2 = null;
        try {
            try {
                Context.enter();
                object2 = this.cx.evaluateString(this.global, string2, string, n, null);
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.cx.exit();
            throw throwable;
        }
        this.cx.exit();
        return object2;
    }

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        Object object2 = null;
        try {
            try {
                Context.enter();
                Object object3 = this.global.get(string, this.global);
                if (object3 == Scriptable.NOT_FOUND) {
                    throw new JavaScriptException((Object)("function " + string + " not found."));
                }
                object2 = ScriptRuntime.call((Context)this.cx, (Object)object3, (Object)this.global, (Object[])objectArray);
                if (object2 instanceof Wrapper) {
                    object2 = ((Wrapper)object2).unwrap();
                }
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.cx.exit();
            throw throwable;
        }
        this.cx.exit();
        return object2;
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.global.put(bSFDeclaredBean.name, this.global, bSFDeclaredBean.bean);
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.global.put(bSFDeclaredBean.name, this.global, null);
    }

    private void handleError(Throwable throwable) throws BSFException {
        if (throwable instanceof WrappedException) {
            throwable = (Throwable)((WrappedException)throwable).unwrap();
        }
        String string = null;
        Throwable throwable2 = null;
        if (throwable instanceof JavaScriptException) {
            string = throwable.getLocalizedMessage();
            Object object = ((JavaScriptException)throwable).getValue();
            if (object instanceof Throwable) {
                throwable2 = (Throwable)object;
            }
        } else if (throwable instanceof EvaluatorException || throwable instanceof SecurityException) {
            string = throwable.getLocalizedMessage();
        } else if (throwable instanceof RuntimeException) {
            string = "Internal Error: " + throwable.toString();
            throwable2 = throwable;
        } else if (throwable instanceof StackOverflowError) {
            string = "Stack Overflow";
        } else {
            throwable2 = throwable;
        }
        if (string == null) {
            string = throwable.toString();
        }
        if (throwable instanceof Error && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, "JavaScript Error: " + string, throwable2);
    }
}

