/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.FileVisitor;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.LinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import org.apache.tools.ant.BuildException;

public final class TargetMatcher
implements FileVisitor {
    private LinkerConfiguration linker;
    private Vector objectFiles;
    private File outputDir;
    private ProcessorConfiguration[] processors;
    private final File[] sourceFiles = new File[1];
    private Hashtable targets;
    private VersionInfo versionInfo;
    private CCTask task;

    public TargetMatcher(CCTask task, File outputDir, ProcessorConfiguration[] processors, LinkerConfiguration linker, Vector objectFiles, Hashtable targets, VersionInfo versionInfo) {
        this.task = task;
        this.outputDir = outputDir;
        this.processors = processors;
        this.targets = targets;
        this.linker = linker;
        this.objectFiles = objectFiles;
        this.versionInfo = versionInfo;
    }

    public void visit(File parentDir, String filename) throws BuildException {
        block8: {
            ProcessorConfiguration selectedCompiler;
            File fullPath;
            block7: {
                int linkerbid;
                fullPath = new File(parentDir, filename);
                selectedCompiler = null;
                int bid = 0;
                if (this.processors != null) {
                    int k = 0;
                    while (k < this.processors.length) {
                        int newBid = this.processors[k].bid(fullPath.toString());
                        if (newBid > bid) {
                            bid = newBid;
                            selectedCompiler = this.processors[k];
                        }
                        ++k;
                    }
                }
                if (bid > 0) break block7;
                if (this.linker == null || (linkerbid = this.linker.bid(filename)) <= 0) break block8;
                this.objectFiles.addElement(fullPath);
                if (linkerbid != 1) break block8;
                this.task.log("Unrecognized file type " + fullPath.toString() + " will be passed to linker");
                break block8;
            }
            String[] outputFileNames = selectedCompiler.getOutputFileNames(filename, this.versionInfo);
            this.sourceFiles[0] = fullPath;
            int i = 0;
            while (i < outputFileNames.length) {
                TargetInfo previousTarget = (TargetInfo)this.targets.get(outputFileNames[i]);
                if (previousTarget == null) {
                    this.targets.put(outputFileNames[i], new TargetInfo(selectedCompiler, this.sourceFiles, null, new File(this.outputDir, outputFileNames[i]), selectedCompiler.getRebuild()));
                } else if (!previousTarget.getSources()[0].equals(this.sourceFiles[0])) {
                    StringBuffer builder = new StringBuffer("Output filename conflict: ");
                    builder.append(outputFileNames[i]);
                    builder.append(" would be produced from ");
                    builder.append(previousTarget.getSources()[0].toString());
                    builder.append(" and ");
                    builder.append(filename);
                    throw new BuildException(builder.toString());
                }
                ++i;
            }
        }
    }
}

