/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import net.sf.clirr.core.internal.ExceptionUtil;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static ClassLoader createClassLoader(String[] cpEntries) {
        URL[] cpUrls = new URL[cpEntries.length];
        for (int i = 0; i < cpEntries.length; ++i) {
            String cpEntry = cpEntries[i];
            File entry = new File(cpEntry);
            try {
                URL url;
                cpUrls[i] = url = entry.toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                IllegalArgumentException illegalArgEx = new IllegalArgumentException("Cannot create classLoader from classpath entry " + entry);
                ExceptionUtil.initCause(illegalArgEx, ex);
                throw illegalArgEx;
            }
        }
        URLClassLoader classPathLoader = new URLClassLoader(cpUrls);
        return classPathLoader;
    }
}

