/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.JumpData;
import net.sourceforge.cobertura.coveragedata.SwitchData;
import net.sourceforge.cobertura.util.StringUtil;

public class LineData
implements Comparable,
CoverageData,
HasBeenInstrumented,
Serializable {
    private static final long serialVersionUID = 4L;
    private transient Lock lock;
    private long hits = 0L;
    private List jumps = null;
    private List switches;
    private final int lineNumber;
    private String methodDescriptor;
    private String methodName;

    LineData(int lineNumber) {
        this(lineNumber, null, null);
    }

    LineData(int lineNumber, String methodName, String methodDescriptor) {
        this.lineNumber = lineNumber;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.initLock();
    }

    private void initLock() {
        this.lock = new ReentrantLock();
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(LineData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.lineNumber - ((LineData)o).lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        LineData lineData = (LineData)obj;
        this.getBothLocks(lineData);
        try {
            boolean bl = this.hits == lineData.hits && (this.jumps == lineData.jumps || this.jumps != null && ((Object)this.jumps).equals(lineData.jumps)) && (this.switches == lineData.switches || this.switches != null && ((Object)this.switches).equals(lineData.switches)) && this.lineNumber == lineData.lineNumber && this.methodDescriptor.equals(lineData.methodDescriptor) && this.methodName.equals(lineData.methodName);
            return bl;
        }
        finally {
            this.lock.unlock();
            lineData.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBranchCoverageRate() {
        if (this.getNumberOfValidBranches() == 0) {
            return 1.0;
        }
        this.lock.lock();
        try {
            double d = (double)this.getNumberOfCoveredBranches() / (double)this.getNumberOfValidBranches();
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConditionCoverage() {
        StringBuffer ret = new StringBuffer();
        if (this.getNumberOfValidBranches() == 0) {
            ret.append(StringUtil.getPercentValue(1.0));
        } else {
            this.lock.lock();
            try {
                ret.append(StringUtil.getPercentValue(this.getBranchCoverageRate()));
                ret.append(" (").append(this.getNumberOfCoveredBranches()).append("/").append(this.getNumberOfValidBranches()).append(")");
            }
            finally {
                this.lock.unlock();
            }
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHits() {
        this.lock.lock();
        try {
            long l = this.hits;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCovered() {
        this.lock.lock();
        try {
            boolean bl = this.getHits() > 0L && (this.getNumberOfValidBranches() == 0 || 1.0 - this.getBranchCoverageRate() < 1.0E-4);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public double getLineCoverageRate() {
        return this.getHits() > 0L ? 1.0 : 0.0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMethodDescriptor() {
        this.lock.lock();
        try {
            String string = this.methodDescriptor;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMethodName() {
        this.lock.lock();
        try {
            String string = this.methodName;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNumberOfCoveredLines() {
        return this.getHits() > 0L ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfValidBranches() {
        int ret = 0;
        this.lock.lock();
        try {
            int i;
            if (this.jumps != null) {
                for (i = this.jumps.size() - 1; i >= 0; --i) {
                    ret += ((JumpData)this.jumps.get(i)).getNumberOfValidBranches();
                }
            }
            if (this.switches != null) {
                for (i = this.switches.size() - 1; i >= 0; --i) {
                    ret += ((SwitchData)this.switches.get(i)).getNumberOfValidBranches();
                }
            }
            int n = ret;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCoveredBranches() {
        int ret = 0;
        this.lock.lock();
        try {
            int i;
            if (this.jumps != null) {
                for (i = this.jumps.size() - 1; i >= 0; --i) {
                    ret += ((JumpData)this.jumps.get(i)).getNumberOfCoveredBranches();
                }
            }
            if (this.switches != null) {
                for (i = this.switches.size() - 1; i >= 0; --i) {
                    ret += ((SwitchData)this.switches.get(i)).getNumberOfCoveredBranches();
                }
            }
            int n = ret;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNumberOfValidLines() {
        return 1;
    }

    public int hashCode() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBranch() {
        this.lock.lock();
        try {
            boolean bl = this.jumps != null || this.switches != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(CoverageData coverageData) {
        LineData lineData = (LineData)coverageData;
        this.getBothLocks(lineData);
        try {
            int i;
            this.hits += lineData.hits;
            if (lineData.jumps != null) {
                if (this.jumps == null) {
                    this.jumps = lineData.jumps;
                } else {
                    for (i = Math.min(this.jumps.size(), lineData.jumps.size()) - 1; i >= 0; --i) {
                        ((JumpData)this.jumps.get(i)).merge((JumpData)lineData.jumps.get(i));
                    }
                    for (i = Math.min(this.jumps.size(), lineData.jumps.size()); i < lineData.jumps.size(); ++i) {
                        this.jumps.add(lineData.jumps.get(i));
                    }
                }
            }
            if (lineData.switches != null) {
                if (this.switches == null) {
                    this.switches = lineData.switches;
                } else {
                    for (i = Math.min(this.switches.size(), lineData.switches.size()) - 1; i >= 0; --i) {
                        ((SwitchData)this.switches.get(i)).merge((SwitchData)lineData.switches.get(i));
                    }
                    for (i = Math.min(this.switches.size(), lineData.switches.size()); i < lineData.switches.size(); ++i) {
                        this.switches.add(lineData.switches.get(i));
                    }
                }
            }
            if (lineData.methodName != null) {
                this.methodName = lineData.methodName;
            }
            if (lineData.methodDescriptor != null) {
                this.methodDescriptor = lineData.methodDescriptor;
            }
        }
        finally {
            this.lock.unlock();
            lineData.lock.unlock();
        }
    }

    void addJump(int jumpNumber) {
        this.getJumpData(jumpNumber);
    }

    void addSwitch(int switchNumber, int[] keys) {
        this.getSwitchData(switchNumber, new SwitchData(switchNumber, keys));
    }

    void addSwitch(int switchNumber, int min, int max) {
        this.getSwitchData(switchNumber, new SwitchData(switchNumber, min, max));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMethodNameAndDescriptor(String name, String descriptor) {
        this.lock.lock();
        try {
            this.methodName = name;
            this.methodDescriptor = descriptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void touch(int new_hits) {
        this.lock.lock();
        try {
            this.hits += (long)new_hits;
        }
        finally {
            this.lock.unlock();
        }
    }

    void touchJump(int jumpNumber, boolean branch, int hits) {
        this.getJumpData(jumpNumber).touchBranch(branch, hits);
    }

    void touchSwitch(int switchNumber, int branch, int hits) {
        this.getSwitchData(switchNumber, null).touchBranch(branch, hits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConditionSize() {
        this.lock.lock();
        try {
            int n = (this.jumps == null ? 0 : this.jumps.size()) + (this.switches == null ? 0 : this.switches.size());
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConditionData(int index) {
        Object branchData = null;
        this.lock.lock();
        try {
            int switchesSize;
            int jumpsSize = this.jumps == null ? 0 : this.jumps.size();
            int n = switchesSize = this.switches == null ? 0 : this.switches.size();
            if (index < jumpsSize) {
                branchData = this.jumps.get(index);
            } else if (index < jumpsSize + switchesSize) {
                branchData = this.switches.get(index - jumpsSize);
            }
            Object var5_5 = branchData;
            return var5_5;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getConditionCoverage(int index) {
        Object branchData = this.getConditionData(index);
        if (branchData == null) {
            return StringUtil.getPercentValue(1.0);
        }
        if (branchData instanceof JumpData) {
            JumpData jumpData = (JumpData)branchData;
            return StringUtil.getPercentValue(jumpData.getBranchCoverageRate());
        }
        SwitchData switchData = (SwitchData)branchData;
        return StringUtil.getPercentValue(switchData.getBranchCoverageRate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JumpData getJumpData(int jumpNumber) {
        this.lock.lock();
        try {
            if (this.jumps == null) {
                this.jumps = new ArrayList();
            }
            if (this.jumps.size() <= jumpNumber) {
                int i = this.jumps.size();
                while (i <= jumpNumber) {
                    this.jumps.add(new JumpData(i++));
                }
            }
            JumpData jumpData = (JumpData)this.jumps.get(jumpNumber);
            return jumpData;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SwitchData getSwitchData(int switchNumber, SwitchData data) {
        this.lock.lock();
        try {
            if (this.switches == null) {
                this.switches = new ArrayList();
            }
            if (this.switches.size() < switchNumber) {
                int i = this.switches.size();
                while (i < switchNumber) {
                    this.switches.add(new SwitchData(i++));
                }
            }
            if (this.switches.size() == switchNumber) {
                if (data != null) {
                    this.switches.add(data);
                } else {
                    this.switches.add(new SwitchData(switchNumber));
                }
            }
            SwitchData switchData = (SwitchData)this.switches.get(switchNumber);
            return switchData;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBothLocks(LineData other) {
        boolean myLock = false;
        boolean otherLock = false;
        while (!myLock || !otherLock) {
            try {
                myLock = this.lock.tryLock();
                otherLock = other.lock.tryLock();
            }
            finally {
                if (myLock && otherLock) continue;
                if (myLock) {
                    this.lock.unlock();
                }
                if (otherLock) {
                    other.lock.unlock();
                }
                Thread.yield();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initLock();
    }
}

