/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.bcel;

import net.sf.clirr.core.internal.bcel.BcelJavaType;
import net.sf.clirr.core.internal.bcel.BcelScopeHelper;
import net.sf.clirr.core.spi.Field;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Scope;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.JavaClass;

final class BcelField
implements Field {
    private final org.apache.bcel.classfile.Field field;
    private final JavaClass owningClass;

    BcelField(JavaClass owningClass, org.apache.bcel.classfile.Field field) {
        this.owningClass = owningClass;
        this.field = field;
    }

    public String getName() {
        return this.field.getName();
    }

    public JavaType getType() {
        return new BcelJavaType(this.field.getType(), this.owningClass.getRepository());
    }

    public boolean isFinal() {
        return this.field.isFinal();
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    public boolean isDeprecated() {
        Attribute[] attrs = this.field.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!(attrs[i] instanceof Deprecated)) continue;
            return true;
        }
        return false;
    }

    public Object getConstantValue() {
        return this.field.getConstantValue();
    }

    public Scope getDeclaredScope() {
        return BcelScopeHelper.getScope(this.field.getAccessFlags());
    }

    public Scope getEffectiveScope() {
        return this.getDeclaredScope();
    }

    public String toString() {
        return this.field.toString();
    }
}

