/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;

public final class CoIterator {
    private Object[] left;
    private Object[] right;
    private int leftIndex;
    private int rightIndex;
    private Object currLeft;
    private Object currRight;
    private Comparator comparator;

    public CoIterator(Comparator comparator, Collection left, Collection right) {
        this.comparator = comparator;
        this.left = left.toArray();
        this.right = right.toArray();
        Arrays.sort(this.left, comparator);
        Arrays.sort(this.right, comparator);
    }

    public CoIterator(Comparator comparator, Object[] left, Object[] right) {
        this.comparator = comparator;
        this.left = (Object[])left.clone();
        this.right = (Object[])right.clone();
        Arrays.sort(this.left, comparator);
        Arrays.sort(this.right, comparator);
    }

    public boolean hasNext() {
        return this.leftIndex < this.left.length || this.rightIndex < this.right.length;
    }

    public void next() {
        int order;
        boolean haveRight;
        boolean haveLeft = this.leftIndex < this.left.length;
        boolean bl = haveRight = this.rightIndex < this.right.length;
        if (!haveLeft && !haveRight) {
            this.currLeft = null;
            this.currRight = null;
            throw new NoSuchElementException();
        }
        if (haveLeft && !haveRight) {
            order = -1;
        } else if (!haveLeft && haveRight) {
            order = 1;
        } else if (this.comparator != null) {
            order = this.comparator.compare(this.left[this.leftIndex], this.right[this.rightIndex]);
        } else {
            Comparable c1 = (Comparable)this.left[this.leftIndex];
            order = c1.compareTo(this.right[this.rightIndex]);
        }
        if (order < 0) {
            this.currLeft = this.left[this.leftIndex];
            this.currRight = null;
            ++this.leftIndex;
        } else if (order > 0) {
            this.currLeft = null;
            this.currRight = this.right[this.rightIndex];
            ++this.rightIndex;
        } else {
            this.currLeft = this.left[this.leftIndex];
            this.currRight = this.right[this.rightIndex];
            ++this.leftIndex;
            ++this.rightIndex;
        }
    }

    public Object getLeft() {
        return this.currLeft;
    }

    public Object getRight() {
        return this.currRight;
    }
}

