/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.checks;

import net.sf.clirr.core.Message;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.AbstractDiffReporter;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.spi.JavaType;

public final class GenderChangeCheck
extends AbstractDiffReporter
implements ClassChangeCheck {
    private static final Message MSG_GENDER_CLASS_TO_INTERFACE = new Message(2000);
    private static final Message MSG_GENDER_INTERFACE_TO_CLASS = new Message(2001);

    public GenderChangeCheck(ApiDiffDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean check(JavaType baseLine, JavaType current) {
        if (!baseLine.isInterface() && current.isInterface()) {
            this.log(MSG_GENDER_CLASS_TO_INTERFACE, this.getSeverity(baseLine, Severity.ERROR), baseLine.getName(), null, null, null);
        } else if (baseLine.isInterface() && !current.isInterface()) {
            this.log(MSG_GENDER_INTERFACE_TO_CLASS, this.getSeverity(baseLine, Severity.ERROR), baseLine.getName(), null, null, null);
        }
        return true;
    }
}

