/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.SequenceFileRecordReader;

public class SequenceFileAsTextRecordReader
implements RecordReader<Text, Text> {
    private final SequenceFileRecordReader<WritableComparable, Writable> sequenceFileRecordReader;
    private WritableComparable innerKey;
    private Writable innerValue;

    public SequenceFileAsTextRecordReader(Configuration conf, FileSplit split) throws IOException {
        this.sequenceFileRecordReader = new SequenceFileRecordReader(conf, split);
        this.innerKey = this.sequenceFileRecordReader.createKey();
        this.innerValue = this.sequenceFileRecordReader.createValue();
    }

    @Override
    public Text createKey() {
        return new Text();
    }

    @Override
    public Text createValue() {
        return new Text();
    }

    @Override
    public synchronized boolean next(Text key, Text value) throws IOException {
        Text tKey = key;
        Text tValue = value;
        if (!this.sequenceFileRecordReader.next(this.innerKey, this.innerValue)) {
            return false;
        }
        tKey.set(this.innerKey.toString());
        tValue.set(this.innerValue.toString());
        return true;
    }

    @Override
    public float getProgress() throws IOException {
        return this.sequenceFileRecordReader.getProgress();
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.sequenceFileRecordReader.getPos();
    }

    @Override
    public synchronized void close() throws IOException {
        this.sequenceFileRecordReader.close();
    }
}

