/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;

@Deprecated
@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class MetricsUtil {
    public static final Log LOG = LogFactory.getLog(MetricsUtil.class);

    private MetricsUtil() {
    }

    public static MetricsContext getContext(String contextName) {
        return MetricsUtil.getContext(contextName, contextName);
    }

    public static MetricsContext getContext(String refName, String contextName) {
        MetricsContext metricsContext;
        try {
            metricsContext = ContextFactory.getFactory().getContext(refName, contextName);
            if (!metricsContext.isMonitoring()) {
                metricsContext.startMonitoring();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to create metrics context " + contextName), (Throwable)ex);
            metricsContext = ContextFactory.getNullContext(contextName);
        }
        return metricsContext;
    }

    public static MetricsRecord createRecord(MetricsContext context, String recordName) {
        MetricsRecord metricsRecord = context.createRecord(recordName);
        metricsRecord.setTag("hostName", MetricsUtil.getHostName());
        return metricsRecord;
    }

    private static String getHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOG.info((Object)"Unable to obtain hostName", (Throwable)ex);
            hostName = "unknown";
        }
        return hostName;
    }
}

