# Node.js 9 ChangeLog

<!--lint disable prohibited-strings-->
<!--lint disable maximum-line-length-->

<table>
<tr>
<th>Current</th>
</tr>
<tr>
<td>
<a href="#9.11.2">9.11.2</a><br/>
<a href="#9.11.1">9.11.1</a><br/>
<a href="#9.11.0">9.11.0</a><br/>
<a href="#9.10.1">9.10.1</a><br/>
<a href="#9.10.0">9.10.0</a><br/>
<a href="#9.9.0">9.9.0</a><br/>
<a href="#9.8.0">9.8.0</a><br/>
<a href="#9.7.1">9.7.1</a><br/>
<a href="#9.7.0">9.7.0</a><br/>
<a href="#9.6.1">9.6.1</a><br/>
<a href="#9.6.0">9.6.0</a><br/>
<a href="#9.5.0">9.5.0</a><br/>
<a href="#9.4.0">9.4.0</a><br/>
<a href="#9.3.0">9.3.0</a><br/>
<a href="#9.2.1">9.2.1</a><br/>
<a href="#9.2.0">9.2.0</a><br/>
<a href="#9.1.0">9.1.0</a><br/>
<a href="#9.0.0">9.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [12.x](CHANGELOG_V12.md)
  * [11.x](CHANGELOG_V11.md)
  * [10.x](CHANGELOG_V10.md)
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="9.11.2"></a>
## 2018-06-12, Version 9.11.2 (Current), @evanlucas

### Notable Changes

* **Fixes memory exhaustion DoS** (CVE-2018-7164): Fixes a bug introduced in 9.7.0 that increases the memory consumed when reading from the network into JavaScript using the net.Socket object directly as a stream.
* **buffer** (CVE-2018-7167): Fixes Denial of Service vulnerability where calling Buffer.fill() could hang
* **http2**
  * (CVE-2018-7161): Fixes Denial of Service vulnerability by updating the http2 implementation to not crash under certain circumstances during cleanup
  * (CVE-2018-1000168): Fixes Denial of Service vulnerability by upgrading nghttp2 to 1.32.0
* **tls** (CVE-2018-7162): Fixes Denial of Service vulnerability by updating the TLS implementation to not crash upon receiving

### Commits

* [[`65ed3213ca`](https://github.com/nodejs/node/commit/65ed3213ca)] - **deps**: update to nghttp2 1.32.0 (James M Snell) [nodejs-private/node-private#124](https://github.com/nodejs-private/node-private/pull/124)
* [[`f0af3b09bd`](https://github.com/nodejs/node/commit/f0af3b09bd)] - **doc**: buffer.fill() can zero-fill on invalid input (Сковорода Никита Андреевич) [nodejs-private/node-private#120](https://github.com/nodejs-private/node-private/pull/120)
* [[`828159fcd4`](https://github.com/nodejs/node/commit/828159fcd4)] - **http2**: fixup http2stream cleanup and other nits (James M Snell) [nodejs-private/node-private#122](https://github.com/nodejs-private/node-private/pull/122)
* [[`be103eba41`](https://github.com/nodejs/node/commit/be103eba41)] - **src**: re-add `Realloc()` shrink after reading stream data (Anna Henningsen) [nodejs-private/node-private#129](https://github.com/nodejs-private/node-private/pull/129)
* [[`555696df51`](https://github.com/nodejs/node/commit/555696df51)] - **src**: avoid hanging on Buffer#fill 0-length input (Сковорода Никита Андреевич) [nodejs-private/node-private#120](https://github.com/nodejs-private/node-private/pull/120)
* [[`7684ba63c4`](https://github.com/nodejs/node/commit/7684ba63c4)] - **test**: add tls write error regression test (Shigeki Ohtsu) [nodejs-private/node-private#130](https://github.com/nodejs-private/node-private/pull/130)
* [[`0ab90acaf3`](https://github.com/nodejs/node/commit/0ab90acaf3)] - **test**: add regression test for nghttp2 CVE-2018-1000168 (James M Snell) [nodejs-private/node-private#124](https://github.com/nodejs-private/node-private/pull/124)
* [[`84f23d2f12`](https://github.com/nodejs/node/commit/84f23d2f12)] - **tls**: fix SSL write error handling (Anna Henningsen) [nodejs-private/node-private#130](https://github.com/nodejs-private/node-private/pull/130)

<a id="9.11.1"></a>
## 2018-04-05, Version 9.11.1 (Current), @MylesBorins

### Notable Changes

No additional commits.

An infrastructure issue caused a non-functioning msi installer for x64 to be promoted.
The patch release is to ensure that all binaries and installers work as expected.

<a id="9.11.0"></a>
## 2018-04-04, Version 9.11.0 (Current), @MylesBorins prepared by @targos

### Notable Changes

* **deps**:
  - Updated ICU to 61.1 (Steven R. Loomis) [#19621](https://github.com/nodejs/node/pull/19621)
    Includes CLDR 33 (many new languages and data improvements).
* **fs**:
  - Emit 'ready' event for `ReadStream` and `WriteStream` (Sameer Srivastava) [#19408](https://github.com/nodejs/node/pull/19408)
* **n-api**:
  - Bump version of n-api supported (Michael Dawson) [#19497](https://github.com/nodejs/node/pull/19497)
* **net**:
  - Emit 'ready' event for `Socket` (Sameer Srivastava) [#19408](https://github.com/nodejs/node/pull/19408)
* **Added new collaborators**
  - [mafintosh](https://github.com/mafintosh) Mathias Buus

### Commits

* [[`0bd78dc391`](https://github.com/nodejs/node/commit/0bd78dc391)] - **buffer**: use v8::TypedArray::kMaxLength as buffer::kMaxLength (Joyee Cheung) [#19738](https://github.com/nodejs/node/pull/19738)
* [[`54b84f3c26`](https://github.com/nodejs/node/commit/54b84f3c26)] - **buffer**: remove "new" from deprecation message (Rich Trott) [#19687](https://github.com/nodejs/node/pull/19687)
* [[`0127712cf5`](https://github.com/nodejs/node/commit/0127712cf5)] - **build**: introduce make jstest (Joyee Cheung) [#19324](https://github.com/nodejs/node/pull/19324)
* [[`58f61dbf8e`](https://github.com/nodejs/node/commit/58f61dbf8e)] - **deps**: ICU 61.1 bump (Steven R. Loomis) [#19621](https://github.com/nodejs/node/pull/19621)
* [[`97a92c4973`](https://github.com/nodejs/node/commit/97a92c4973)] - **deps**: turn in std::string for ICU (Steven R. Loomis) [#19624](https://github.com/nodejs/node/pull/19624)
* [[`ae86adc086`](https://github.com/nodejs/node/commit/ae86adc086)] - **doc**: fix various nits (Vse Mozhet Byt) [#19743](https://github.com/nodejs/node/pull/19743)
* [[`041f6cd9c9`](https://github.com/nodejs/node/commit/041f6cd9c9)] - **doc**: improve Buffer.allocUnsafeSlow() and related (Rich Trott) [#19742](https://github.com/nodejs/node/pull/19742)
* [[`42671f24ba`](https://github.com/nodejs/node/commit/42671f24ba)] - **doc**: add mafintosh to collaborators (Mathias Buus) [#19773](https://github.com/nodejs/node/pull/19773)
* [[`c1b83fcbc2`](https://github.com/nodejs/node/commit/c1b83fcbc2)] - **doc**: update to adding listens on SIGUSR1 (willhayslett) [#19709](https://github.com/nodejs/node/pull/19709)
* [[`1aaad92101`](https://github.com/nodejs/node/commit/1aaad92101)] - **doc**: fix lint nits in COLLABORATOR\_GUIDE.md (Vse Mozhet Byt) [#19762](https://github.com/nodejs/node/pull/19762)
* [[`5149e18719`](https://github.com/nodejs/node/commit/5149e18719)] - **doc**: deprecation clarifications (James M Snell) [#19522](https://github.com/nodejs/node/pull/19522)
* [[`c5469bb7a8`](https://github.com/nodejs/node/commit/c5469bb7a8)] - **doc**: remove "if provided" for optional arguments (Rich Trott) [#19690](https://github.com/nodejs/node/pull/19690)
* [[`3a3ae0134d`](https://github.com/nodejs/node/commit/3a3ae0134d)] - **doc**: do not identify string as "JavaScript string" (Rich Trott) [#19689](https://github.com/nodejs/node/pull/19689)
* [[`d111037624`](https://github.com/nodejs/node/commit/d111037624)] - **doc**: favor utf16le over ucs2 in buffer.md (Rich Trott) [#19688](https://github.com/nodejs/node/pull/19688)
* [[`bb32bc8686`](https://github.com/nodejs/node/commit/bb32bc8686)] - **doc**: fix links in vm.md (Vse Mozhet Byt) [#19721](https://github.com/nodejs/node/pull/19721)
* [[`44361bd1c8`](https://github.com/nodejs/node/commit/44361bd1c8)] - **doc**: fix quotes mistypes in inline code blocks (Сковорода Никита Андреевич) [#19713](https://github.com/nodejs/node/pull/19713)
* [[`c8fa8f1f9d`](https://github.com/nodejs/node/commit/c8fa8f1f9d)] - **doc**: remove ES6/ECMAScript 2015 from buffer.md (Rich Trott) [#19685](https://github.com/nodejs/node/pull/19685)
* [[`9f20534889`](https://github.com/nodejs/node/commit/9f20534889)] - **doc**: shorten character encoding introduction (Rich Trott) [#19648](https://github.com/nodejs/node/pull/19648)
* [[`078616109c`](https://github.com/nodejs/node/commit/078616109c)] - **doc**: guard against md list parsing edge case (Vse Mozhet Byt) [#19647](https://github.com/nodejs/node/pull/19647)
* [[`2ea7f90728`](https://github.com/nodejs/node/commit/2ea7f90728)] - **doc**: fix grammar error in process.md (Kenji Okamoto) [#19641](https://github.com/nodejs/node/pull/19641)
* [[`7555deeb8c`](https://github.com/nodejs/node/commit/7555deeb8c)] - **doc**: improve zero-fill-buffers text (Rich Trott) [#19623](https://github.com/nodejs/node/pull/19623)
* [[`5e90fc6a85`](https://github.com/nodejs/node/commit/5e90fc6a85)] - **fs**: use fs.access in fs.exists (Bartosz Sosnowski) [#18618](https://github.com/nodejs/node/pull/18618)
* [[`8a8b43e1b1`](https://github.com/nodejs/node/commit/8a8b43e1b1)] - **(SEMVER-MINOR)** **fs,net**: emit 'ready' for fs streams and sockets (Sameer Srivastava) [#19408](https://github.com/nodejs/node/pull/19408)
* [[`e1f44a6366`](https://github.com/nodejs/node/commit/e1f44a6366)] - **http**: fix `request` when `setHost` is `true` (XadillaX) [#19502](https://github.com/nodejs/node/pull/19502)
* [[`dac5f67e64`](https://github.com/nodejs/node/commit/dac5f67e64)] - **http**: support server options on createServer (Wes Todd) [#19461](https://github.com/nodejs/node/pull/19461)
* [[`2bdf3ca235`](https://github.com/nodejs/node/commit/2bdf3ca235)] - **http2**: callback valid check before closing request (Trivikram) [#19061](https://github.com/nodejs/node/pull/19061)
* [[`7b850a7565`](https://github.com/nodejs/node/commit/7b850a7565)] - **http2**: destroy() stream, upon errnoException (Sarat Addepalli) [#19389](https://github.com/nodejs/node/pull/19389)
* [[`441175c29a`](https://github.com/nodejs/node/commit/441175c29a)] - **http2**: refer to stream errors by name (Anna Henningsen) [#18966](https://github.com/nodejs/node/pull/18966)
* [[`0bcad33c7a`](https://github.com/nodejs/node/commit/0bcad33c7a)] - **inspector**: report client-visible host and port (Eugene Ostroukhov) [#19664](https://github.com/nodejs/node/pull/19664)
* [[`8e440115ec`](https://github.com/nodejs/node/commit/8e440115ec)] - **lib**: add back lib/module.js redirection (Joyee Cheung) [#19177](https://github.com/nodejs/node/pull/19177)
* [[`45c477c2e6`](https://github.com/nodejs/node/commit/45c477c2e6)] - **lib**: restructure cjs and esm loaders (Joyee Cheung) [#19177](https://github.com/nodejs/node/pull/19177)
* [[`152a86c6aa`](https://github.com/nodejs/node/commit/152a86c6aa)] - **lib**: make isStackOverflowError() engine-agnostic (Mike Kaufman) [#19705](https://github.com/nodejs/node/pull/19705)
* [[`889a3b44b3`](https://github.com/nodejs/node/commit/889a3b44b3)] - **lib**: fix a typo in lib/timers "read through" (wangzengdi) [#19666](https://github.com/nodejs/node/pull/19666)
* [[`a45f3f8fd2`](https://github.com/nodejs/node/commit/a45f3f8fd2)] - **lib**: document nextTick queue internals (Anna Henningsen) [#19469](https://github.com/nodejs/node/pull/19469)
* [[`d3d1ee7279`](https://github.com/nodejs/node/commit/d3d1ee7279)] - **lib**: add internal check macros (Gus Caplan) [#18852](https://github.com/nodejs/node/pull/18852)
* [[`e0c7d783e0`](https://github.com/nodejs/node/commit/e0c7d783e0)] - **lint**: change require-buffer rule message (Gus Caplan) [#19701](https://github.com/nodejs/node/pull/19701)
* [[`859b719927`](https://github.com/nodejs/node/commit/859b719927)] - **module**: skip preserveSymlinks for main (Guy Bedford) [#19388](https://github.com/nodejs/node/pull/19388)
* [[`a0a58730e0`](https://github.com/nodejs/node/commit/a0a58730e0)] - **n-api**: back up env before finalize (Gabriel Schulhof) [#19718](https://github.com/nodejs/node/pull/19718)
* [[`b0a3a44ff6`](https://github.com/nodejs/node/commit/b0a3a44ff6)] - **n-api**: ensure in-module exceptions are propagated (Gabriel Schulhof) [#19537](https://github.com/nodejs/node/pull/19537)
* [[`94a10bad3a`](https://github.com/nodejs/node/commit/94a10bad3a)] - **(SEMVER-MINOR)** **n-api**: bump version of n-api supported (Michael Dawson) [#19497](https://github.com/nodejs/node/pull/19497)
* [[`ee4390a167`](https://github.com/nodejs/node/commit/ee4390a167)] - **repl**: fix tab completion of inspector module (Michaël Zasso) [#19505](https://github.com/nodejs/node/pull/19505)
* [[`ebdcf91dcc`](https://github.com/nodejs/node/commit/ebdcf91dcc)] - **src**: put bootstrappers in lib/internal/bootstrap/ (Joyee Cheung) [#19177](https://github.com/nodejs/node/pull/19177)
* [[`ff7a116ba3`](https://github.com/nodejs/node/commit/ff7a116ba3)] - **src**: move internal loaders out of bootstrap\_node.js (Joyee Cheung) [#19112](https://github.com/nodejs/node/pull/19112)
* [[`75d23ab2a0`](https://github.com/nodejs/node/commit/75d23ab2a0)] - **src**: fix warnings in aliased\_buffer (Kyle Farnung) [#19665](https://github.com/nodejs/node/pull/19665)
* [[`01e31906e8`](https://github.com/nodejs/node/commit/01e31906e8)] - **src**: general C++ cleanup in node\_url.cc (Anna Henningsen) [#19598](https://github.com/nodejs/node/pull/19598)
* [[`6c466811d3`](https://github.com/nodejs/node/commit/6c466811d3)] - **src**: name all builtin init functions Initialize (Daniel Bevenius) [#19550](https://github.com/nodejs/node/pull/19550)
* [[`1a38b9bd0f`](https://github.com/nodejs/node/commit/1a38b9bd0f)] - **src**: remove unused 'ares.h' include from env.h (Anna Henningsen) [#19557](https://github.com/nodejs/node/pull/19557)
* [[`cae9ff256b`](https://github.com/nodejs/node/commit/cae9ff256b)] - **src**: fix upcoming V8 deprecation warnings (Sarat Addepalli) [#19490](https://github.com/nodejs/node/pull/19490)
* [[`83ebaf08d9`](https://github.com/nodejs/node/commit/83ebaf08d9)] - **test**: remove NODE\_DEBUG in global module loading test (Joyee Cheung) [#19177](https://github.com/nodejs/node/pull/19177)
* [[`92e9ed09e9`](https://github.com/nodejs/node/commit/92e9ed09e9)] - **test**: test process.setuid for bad argument types (Divyanshu Singh) [#19703](https://github.com/nodejs/node/pull/19703)
* [[`4df3377856`](https://github.com/nodejs/node/commit/4df3377856)] - **test**: update test to comply with lint rule (Rich Trott) [#19784](https://github.com/nodejs/node/pull/19784)
* [[`f379167917`](https://github.com/nodejs/node/commit/f379167917)] - **test**: improve assert message (fatahn) [#19629](https://github.com/nodejs/node/pull/19629)
* [[`46569d644d`](https://github.com/nodejs/node/commit/46569d644d)] - **test**: remove third argument from call to assert.strictEqual() (Forrest Wolf) [#19659](https://github.com/nodejs/node/pull/19659)
* [[`e44b7779d6`](https://github.com/nodejs/node/commit/e44b7779d6)] - **test**: fix flaky test-cluster-send-handle-twice (Rich Trott) [#19700](https://github.com/nodejs/node/pull/19700)
* [[`90c85461ff`](https://github.com/nodejs/node/commit/90c85461ff)] - **test**: rename regression tests more expressively (Ujjwal Sharma) [#19668](https://github.com/nodejs/node/pull/19668)
* [[`ff7f28c4f2`](https://github.com/nodejs/node/commit/ff7f28c4f2)] - **test**: remove 3rd argument from assert.strictEqual (Arian Santrach) [#19707](https://github.com/nodejs/node/pull/19707)
* [[`0b27416516`](https://github.com/nodejs/node/commit/0b27416516)] - **test**: make test-http-expect-continue more strict (Rich Trott) [#19669](https://github.com/nodejs/node/pull/19669)
* [[`94b28aaf07`](https://github.com/nodejs/node/commit/94b28aaf07)] - **test**: use createReadStream instead of ReadStream (Daniel Bevenius) [#19636](https://github.com/nodejs/node/pull/19636)
* [[`7ae2ca4476`](https://github.com/nodejs/node/commit/7ae2ca4476)] - **test**: removed default message from assert.strictEqual (jaspal-yupana) [#19660](https://github.com/nodejs/node/pull/19660)
* [[`a89ba21ab4`](https://github.com/nodejs/node/commit/a89ba21ab4)] - **test**: refactor test-net-dns-error (Luigi Pinca) [#19640](https://github.com/nodejs/node/pull/19640)
* [[`677b613d24`](https://github.com/nodejs/node/commit/677b613d24)] - **test**: fix typo in test-tls-cnnic-whitelist (Daniel Bevenius) [#19662](https://github.com/nodejs/node/pull/19662)
* [[`806bc0d8f7`](https://github.com/nodejs/node/commit/806bc0d8f7)] - **test**: fix assert.throws error in test-http-parser (Rich Trott) [#19626](https://github.com/nodejs/node/pull/19626)
* [[`2f09ee78fb`](https://github.com/nodejs/node/commit/2f09ee78fb)] - **test**: refactor test-http-expect-continue (Rich Trott) [#19625](https://github.com/nodejs/node/pull/19625)
* [[`278e8af7a6`](https://github.com/nodejs/node/commit/278e8af7a6)] - **test**: rename tests with descriptive filenames (Ujjwal Sharma) [#19608](https://github.com/nodejs/node/pull/19608)
* [[`0daa063021`](https://github.com/nodejs/node/commit/0daa063021)] - **test**: amplify and optimize doctool/test-make-doc (Vse Mozhet Byt) [#19581](https://github.com/nodejs/node/pull/19581)
* [[`274eff5376`](https://github.com/nodejs/node/commit/274eff5376)] - **test**: update link according to NIST bibliography (Tobias Nießen) [#19593](https://github.com/nodejs/node/pull/19593)
* [[`21e69d1222`](https://github.com/nodejs/node/commit/21e69d1222)] - **test**: fix test-tty-get-color-depth (Bartosz Sosnowski) [#18478](https://github.com/nodejs/node/pull/18478)
* [[`4caf536b20`](https://github.com/nodejs/node/commit/4caf536b20)] - **test**: http2 stream.respond() error checks (Trivikram) [#18861](https://github.com/nodejs/node/pull/18861)
* [[`ca97be52a2`](https://github.com/nodejs/node/commit/ca97be52a2)] - **test**: fix wrong error classes passed in as type (Ruben Bridgewater) [#13686](https://github.com/nodejs/node/pull/13686)
* [[`44b12c158d`](https://github.com/nodejs/node/commit/44b12c158d)] - **test**: fix common.expectsError (Refael Ackermann) [#13686](https://github.com/nodejs/node/pull/13686)
* [[`cc68bc27f8`](https://github.com/nodejs/node/commit/cc68bc27f8)] - **test**: add more asserts to `test-internal-errors` (Refael Ackermann) [#13686](https://github.com/nodejs/node/pull/13686)
* [[`6bc49f03b9`](https://github.com/nodejs/node/commit/6bc49f03b9)] - **test**: http2 errors on req.close() (Trivikram) [#18854](https://github.com/nodejs/node/pull/18854)
* [[`53d7fbbbf5`](https://github.com/nodejs/node/commit/53d7fbbbf5)] - **tools**: don’t emit illegal utf-8 from icutrim/iculslocs (Steven R. Loomis) [#19756](https://github.com/nodejs/node/pull/19756)
* [[`b80d169e7c`](https://github.com/nodejs/node/commit/b80d169e7c)] - **tools**: apply editorconfig rules to tools also (Tobias Nießen) [#19521](https://github.com/nodejs/node/pull/19521)
* [[`239a036317`](https://github.com/nodejs/node/commit/239a036317)] - **tools**: remove src dir from JS editorconfig rule (Tobias Nießen) [#19521](https://github.com/nodejs/node/pull/19521)
* [[`7043e95fb7`](https://github.com/nodejs/node/commit/7043e95fb7)] - **tools**: dry utility function in tools/doc/json.js (Vse Mozhet Byt) [#19692](https://github.com/nodejs/node/pull/19692)
* [[`140611b2c6`](https://github.com/nodejs/node/commit/140611b2c6)] - **tools**: fix comment nits in tools/doc/\*.js files (Vse Mozhet Byt) [#19696](https://github.com/nodejs/node/pull/19696)
* [[`2c5d53f7cb`](https://github.com/nodejs/node/commit/2c5d53f7cb)] - **tools**: fix nits in tools/doc/type-parser.js (Vse Mozhet Byt) [#19612](https://github.com/nodejs/node/pull/19612)
* [[`fdc51a1331`](https://github.com/nodejs/node/commit/fdc51a1331)] - **url**: remove redundant function (Sergey Golovin) [#19076](https://github.com/nodejs/node/pull/19076)
* [[`99e3c77808`](https://github.com/nodejs/node/commit/99e3c77808)] - **url**: refactor "escapeParam" function to make it common (Sergey Golovin) [#19076](https://github.com/nodejs/node/pull/19076)

<a id="9.10.1"></a>
## 2018-03-29, Version 9.10.1 (Current), @MylesBorins

### Notable Changes

No additional commits.

Due to incorrect staging of the upgrade to the GCC 4.9.X compiler, the latest releases for PPC little
endian were built using GCC 4.9.X instead of GCC 4.8.X. This caused an ABI breakage on PPCLE based
environments. This has been fixed in our infrastructure and we are doing this release to ensure that
the hosted binaries are adhering to our platform support contract.

Note that Node.js versions 10.X and later will be built with version 4.9.X or later of the GCC compiler,
and it is possible that Node.js version 9.X may be built on the 4.9.X compiler at a later
time as the stated [minimum compiler requirement](https://github.com/nodejs/node/blob/v8.x/BUILDING.md)
for Node.js version 9.X is 4.9.4.

<a id="9.10.0"></a>
## 2018-03-28, Version 9.10.0 (Current), @MylesBorins prepared by @targos

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/march-2018-security-releases/ for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2018-7158
* CVE-2018-7159
* CVE-2018-7160

### Notable Changes

* **Upgrade to OpenSSL 1.0.2o**: Does not contain any security fixes that are known to impact Node.js.
* **Fix for inspector DNS rebinding vulnerability (CVE-2018-7160)**: A malicious website could use a DNS rebinding attack to trick a web browser to bypass same-origin-policy checks and allow HTTP connections to localhost or to hosts on the local network, potentially to an open inspector port as a debugger, therefore gaining full code execution access. The inspector now only allows connections that have a browser `Host` value of `localhost` or `localhost6`.
* **Fix for `'path'` module regular expression denial of service (CVE-2018-7158)**: A regular expression used for parsing POSIX paths could be used to cause a denial of service if an attacker were able to have a specially crafted path string passed through one of the impacted `'path'` module functions.
* **Reject spaces in HTTP `Content-Length` header values (CVE-2018-7159)**: The Node.js HTTP parser allowed for spaces inside `Content-Length` header values. Such values now lead to rejected connections in the same way as non-numeric values.
* **Update root certificates**: 5 additional root certificates have been added to the Node.js binary and 30 have been removed.

* **cluster**:
  - Add support for `NODE_OPTIONS="--inspect"` (Sameer Srivastava) [#19165](https://github.com/nodejs/node/pull/19165)
* **crypto**:
  - Expose the public key of a certificate (Hannes Magnusson) [#17690](https://github.com/nodejs/node/pull/17690)
* **n-api**:
  - Add `napi_fatal_exception` to trigger an `uncaughtException` in JavaScript (Mathias Buus) [#19337](https://github.com/nodejs/node/pull/19337)
* **path**:
  - Fix regression in `posix.normalize` (Michaël Zasso) [#19520](https://github.com/nodejs/node/pull/19520)
* **stream**:
  - Improve stream creation performance (Brian White) [#19401](https://github.com/nodejs/node/pull/19401)
* **Added new collaborators**
  - [BethGriggs](https://github.com/BethGriggs) Beth Griggs

### Commits

* [[`926214aefe`](https://github.com/nodejs/node/commit/926214aefe)] - **cluster**: add support for NODE\_OPTIONS="--inspect" (Sameer Srivastava) [#19165](https://github.com/nodejs/node/pull/19165)
* [[`6ead99aa73`](https://github.com/nodejs/node/commit/6ead99aa73)] - **console**: don't swallow call stack exceeded errors (Dan Kaplun) [#19423](https://github.com/nodejs/node/pull/19423)
* [[`02671dc12b`](https://github.com/nodejs/node/commit/02671dc12b)] - **crypto**: update root certificates (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)
* [[`fd8c79ddfc`](https://github.com/nodejs/node/commit/fd8c79ddfc)] - **(SEMVER-MINOR)** **crypto**: add docs & tests for cert.pubkey & cert.fingerprint256 (Hannes Magnusson) [#17690](https://github.com/nodejs/node/pull/17690)
* [[`23312675cb`](https://github.com/nodejs/node/commit/23312675cb)] - **(SEMVER-MINOR)** **crypto**: provide full cert details to checkServerIdentity (Hannes Magnusson) [#17690](https://github.com/nodejs/node/pull/17690)
* [[`26e2938a50`](https://github.com/nodejs/node/commit/26e2938a50)] - **(SEMVER-MINOR)** **crypto**: add cert.pubkey containing the raw pubkey of certificate (Hannes Magnusson) [#17690](https://github.com/nodejs/node/pull/17690)
* [[`f5d9324315`](https://github.com/nodejs/node/commit/f5d9324315)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`f5eb182b50`](https://github.com/nodejs/node/commit/f5eb182b50)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`ddcb3fc886`](https://github.com/nodejs/node/commit/ddcb3fc886)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`d908169bad`](https://github.com/nodejs/node/commit/d908169bad)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#19638](https://github.com/nodejs/node/pull/19638)
* [[`0cd883fe09`](https://github.com/nodejs/node/commit/0cd883fe09)] - **deps**: upgrade openssl sources to 1.0.2o (Shigeki Ohtsu) [#19638](https://github.com/nodejs/node/pull/19638)
* [[`c39167dc26`](https://github.com/nodejs/node/commit/c39167dc26)] - **deps**: reject interior blanks in Content-Length (Ben Noordhuis) [nodejs-private/http-parser-private#1](https://github.com/nodejs-private/http-parser-private/pull/1)
* [[`3bc15a69ae`](https://github.com/nodejs/node/commit/3bc15a69ae)] - **deps**: upgrade http-parser to v2.8.0 (Ben Noordhuis) [nodejs-private/http-parser-private#1](https://github.com/nodejs-private/http-parser-private/pull/1)
* [[`6591d9f761`](https://github.com/nodejs/node/commit/6591d9f761)] - **deps**: cherry-pick 0c35b72 from upstream V8 (Gus Caplan) [#18038](https://github.com/nodejs/node/pull/18038)
* [[`e533911696`](https://github.com/nodejs/node/commit/e533911696)] - **doc**: remove use of "random port" re dgram send (Thomas Hunter II) [#19620](https://github.com/nodejs/node/pull/19620)
* [[`3894981af2`](https://github.com/nodejs/node/commit/3894981af2)] - **doc**: improve assert legacy text (Rich Trott) [#19622](https://github.com/nodejs/node/pull/19622)
* [[`8191ada9ae`](https://github.com/nodejs/node/commit/8191ada9ae)] - **doc**: improve Buffer() text (Rich Trott) [#19567](https://github.com/nodejs/node/pull/19567)
* [[`2fadc9ef68`](https://github.com/nodejs/node/commit/2fadc9ef68)] - **doc**: fix run-on sentence in buffer.md (Rich Trott) [#19567](https://github.com/nodejs/node/pull/19567)
* [[`962c5816a2`](https://github.com/nodejs/node/commit/962c5816a2)] - **doc**: change v-notation for version in buffer.md (Rich Trott) [#19567](https://github.com/nodejs/node/pull/19567)
* [[`5a2f336994`](https://github.com/nodejs/node/commit/5a2f336994)] - **doc**: add missing fs.Stats.size section (Vse Mozhet Byt) [#19583](https://github.com/nodejs/node/pull/19583)
* [[`8653c42a41`](https://github.com/nodejs/node/commit/8653c42a41)] - **doc**: rename HTTP2 to HTTP/2 (Timothy Gu) [#19603](https://github.com/nodejs/node/pull/19603)
* [[`b70ac0ab2e`](https://github.com/nodejs/node/commit/b70ac0ab2e)] - **doc**: remove confusing note about child process stdio (Anna Henningsen) [#19552](https://github.com/nodejs/node/pull/19552)
* [[`5e3d971f79`](https://github.com/nodejs/node/commit/5e3d971f79)] - **doc**: add BethGriggs to collaborators (Beth Griggs) [#19610](https://github.com/nodejs/node/pull/19610)
* [[`5e9f9297b3`](https://github.com/nodejs/node/commit/5e9f9297b3)] - **doc**: document `make docopen` (Ayush Gupta) [#19321](https://github.com/nodejs/node/pull/19321)
* [[`4db7848e09`](https://github.com/nodejs/node/commit/4db7848e09)] - **doc**: remove example labels from buffer.md (Rich Trott) [#19582](https://github.com/nodejs/node/pull/19582)
* [[`f07e820e6d`](https://github.com/nodejs/node/commit/f07e820e6d)] - **doc**: add 'v' prefix to all versions in metadata (Tobias Nießen) [#19590](https://github.com/nodejs/node/pull/19590)
* [[`7e9b7a5683`](https://github.com/nodejs/node/commit/7e9b7a5683)] - **doc**: add missing metadata for fs.open (Tobias Nießen) [#19585](https://github.com/nodejs/node/pull/19585)
* [[`d47e5d022f`](https://github.com/nodejs/node/commit/d47e5d022f)] - **doc**: add link & simplify data event (net.Socket) (Christopher Hiller) [#19487](https://github.com/nodejs/node/pull/19487)
* [[`43f24c0406`](https://github.com/nodejs/node/commit/43f24c0406)] - **doc**: add directory structure in writing-tests.md (juggernaut451) [#18802](https://github.com/nodejs/node/pull/18802)
* [[`157fc28710`](https://github.com/nodejs/node/commit/157fc28710)] - **doc**: add added in versions to fs.Stats properties (jvelezpo) [#19266](https://github.com/nodejs/node/pull/19266)
* [[`fa17002215`](https://github.com/nodejs/node/commit/fa17002215)] - **doc**: add missing metadata for settings.windowsHide (Tobias Nießen) [#19578](https://github.com/nodejs/node/pull/19578)
* [[`4532a8913d`](https://github.com/nodejs/node/commit/4532a8913d)] - **doc**: add `require.main` to `require` properties (Vse Mozhet Byt) [#19573](https://github.com/nodejs/node/pull/19573)
* [[`1e8ece149a`](https://github.com/nodejs/node/commit/1e8ece149a)] - **doc**: add missing metadata for cluster.settings.cwd (Tobias Nießen) [#19569](https://github.com/nodejs/node/pull/19569)
* [[`933c58cd76`](https://github.com/nodejs/node/commit/933c58cd76)] - **doc**: add types for some `process` properties (Vse Mozhet Byt) [#19571](https://github.com/nodejs/node/pull/19571)
* [[`ae0e243028`](https://github.com/nodejs/node/commit/ae0e243028)] - **doc**: fix n-api example string (Steven R. Loomis) [#19205](https://github.com/nodejs/node/pull/19205)
* [[`7c9ba3db40`](https://github.com/nodejs/node/commit/7c9ba3db40)] - **doc**: correct introduced\_in metadata for buffer doc (Rich Trott) [#19545](https://github.com/nodejs/node/pull/19545)
* [[`1073f09cad`](https://github.com/nodejs/node/commit/1073f09cad)] - **doc**: minor improvements to buffer.md (Rich Trott) [#19547](https://github.com/nodejs/node/pull/19547)
* [[`9845fc3e4a`](https://github.com/nodejs/node/commit/9845fc3e4a)] - **doc**: Add a missing comma (jiangq) [#19555](https://github.com/nodejs/node/pull/19555)
* [[`d1c45e258c`](https://github.com/nodejs/node/commit/d1c45e258c)] - **doc**: update child\_process.md (Ari Leo Frankel) [#19075](https://github.com/nodejs/node/pull/19075)
* [[`8e3f59fbb5`](https://github.com/nodejs/node/commit/8e3f59fbb5)] - **doc**: clarify child\_process promise rejections (TomCoded) [#19541](https://github.com/nodejs/node/pull/19541)
* [[`e9f41eecc8`](https://github.com/nodejs/node/commit/e9f41eecc8)] - **doc**: move StackOverflow to unofficial section (josephleon) [#19416](https://github.com/nodejs/node/pull/19416)
* [[`3f49174969`](https://github.com/nodejs/node/commit/3f49174969)] - **doc**: move who-to-cc to COLABORATOR\_GUIDE.md (Rich Trott) [#19460](https://github.com/nodejs/node/pull/19460)
* [[`65c9a5278c`](https://github.com/nodejs/node/commit/65c9a5278c)] - **doc**: require passing CI for landing code (Rich Trott) [#19458](https://github.com/nodejs/node/pull/19458)
* [[`98d038a1f3`](https://github.com/nodejs/node/commit/98d038a1f3)] - **doc**: simplify COLLABORATOR\_GUIDE.md instructions (Rich Trott) [#19458](https://github.com/nodejs/node/pull/19458)
* [[`e5bcd8d981`](https://github.com/nodejs/node/commit/e5bcd8d981)] - **doc**: reduce CI options in COLLABORATOR\_GUIDE.md (Rich Trott) [#19458](https://github.com/nodejs/node/pull/19458)
* [[`26e97a124d`](https://github.com/nodejs/node/commit/26e97a124d)] - **doc**: add new documentation rule (estrada9166) [#18726](https://github.com/nodejs/node/pull/18726)
* [[`ed55386d74`](https://github.com/nodejs/node/commit/ed55386d74)] - **doc**: add fs declarations to stream doc js examples (Ivan Filenko) [#18804](https://github.com/nodejs/node/pull/18804)
* [[`9c672624b3`](https://github.com/nodejs/node/commit/9c672624b3)] - **doc**: remove \*\*Note:\*\* tags (James M Snell) [#18592](https://github.com/nodejs/node/pull/18592)
* [[`742b304ea3`](https://github.com/nodejs/node/commit/742b304ea3)] - **doc**: warn about using util.inspect/util.format (James M Snell) [#17791](https://github.com/nodejs/node/pull/17791)
* [[`d3833b0734`](https://github.com/nodejs/node/commit/d3833b0734)] - **doc**: update collaborator guide (Ruben Bridgewater) [#19116](https://github.com/nodejs/node/pull/19116)
* [[`c3886b50c9`](https://github.com/nodejs/node/commit/c3886b50c9)] - **doc**: add note about browsers and HTTP/2 (Steven) [#19476](https://github.com/nodejs/node/pull/19476)
* [[`cc7ba0bb9d`](https://github.com/nodejs/node/commit/cc7ba0bb9d)] - **doc**: fix/improve inspector profiler example (Ali Ijaz Sheikh) [#19379](https://github.com/nodejs/node/pull/19379)
* [[`9c9263e7cc`](https://github.com/nodejs/node/commit/9c9263e7cc)] - **doc**: add trivikr to collaborators (Trivikram) [#19384](https://github.com/nodejs/node/pull/19384)
* [[`5960cde4eb`](https://github.com/nodejs/node/commit/5960cde4eb)] - **doc**: fix changelog (Myles Borins) [#19515](https://github.com/nodejs/node/pull/19515)
* [[`b351e0eda6`](https://github.com/nodejs/node/commit/b351e0eda6)] - **http**: use more destructuring (Tobias Nießen) [#19481](https://github.com/nodejs/node/pull/19481)
* [[`49c0efd2a2`](https://github.com/nodejs/node/commit/49c0efd2a2)] - **http2**: remove some unnecessary next ticks (James M Snell) [#19451](https://github.com/nodejs/node/pull/19451)
* [[`583d5afa5e`](https://github.com/nodejs/node/commit/583d5afa5e)] - **inspector**: do not allow host names (Eugene Ostroukhov)
* [[`fc1a610a00`](https://github.com/nodejs/node/commit/fc1a610a00)] - **inspector**: check Host header for local connections (Eugene Ostroukhov)
* [[`419e88ea4a`](https://github.com/nodejs/node/commit/419e88ea4a)] - **lib,test**: lint fixes for linter upgrade (Rich Trott) [#19528](https://github.com/nodejs/node/pull/19528)
* [[`fd8523fe44`](https://github.com/nodejs/node/commit/fd8523fe44)] - **n-api**: re-write test\_make\_callback (Gabriel Schulhof) [#19448](https://github.com/nodejs/node/pull/19448)
* [[`29a04b7ed6`](https://github.com/nodejs/node/commit/29a04b7ed6)] - **(SEMVER-MINOR)** **n-api**: add napi\_fatal\_exception (Mathias Buus) [#19337](https://github.com/nodejs/node/pull/19337)
* [[`223b42648f`](https://github.com/nodejs/node/commit/223b42648f)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`40916a27bc`](https://github.com/nodejs/node/commit/40916a27bc)] - **path**: fix regression in posix.normalize (Michaël Zasso) [#19520](https://github.com/nodejs/node/pull/19520)
* [[`fad5dcce3b`](https://github.com/nodejs/node/commit/fad5dcce3b)] - **src**: drop CNNIC+StartCom certificate whitelisting (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)
* [[`780a5d6f3a`](https://github.com/nodejs/node/commit/780a5d6f3a)] - **src**: use `unordered\_map` for perf marks (Anna Henningsen) [#19558](https://github.com/nodejs/node/pull/19558)
* [[`f13cc3237e`](https://github.com/nodejs/node/commit/f13cc3237e)] - **stream**: improve stream creation performance (Brian White) [#19401](https://github.com/nodejs/node/pull/19401)
* [[`8996d3cf45`](https://github.com/nodejs/node/commit/8996d3cf45)] - **test**: remove third param from assert.strictEqual (davis.okoth@kemsa.co.ke) [#19536](https://github.com/nodejs/node/pull/19536)
* [[`c1a327b0ed`](https://github.com/nodejs/node/commit/c1a327b0ed)] - **test**: remove custom error message (DingDean) [#19526](https://github.com/nodejs/node/pull/19526)
* [[`9265f4bcb7`](https://github.com/nodejs/node/commit/9265f4bcb7)] - **test**: remove string literal from assertions (Nathaniel Weeks) [#19276](https://github.com/nodejs/node/pull/19276)
* [[`efa38bd1a0`](https://github.com/nodejs/node/commit/efa38bd1a0)] - **test**: remove message from assert.strictEqual() (willhayslett) [#19525](https://github.com/nodejs/node/pull/19525)
* [[`40be64d96d`](https://github.com/nodejs/node/commit/40be64d96d)] - **test**: rename regression tests more expressively (Ujjwal Sharma) [#19495](https://github.com/nodejs/node/pull/19495)
* [[`0310df8fe6`](https://github.com/nodejs/node/commit/0310df8fe6)] - **test**: refactor parallel/test-tls-ca-concat.js (juggernaut451) [#19092](https://github.com/nodejs/node/pull/19092)
* [[`5f1a01d816`](https://github.com/nodejs/node/commit/5f1a01d816)] - **test**: fix buggy getTTYfd() implementation (Rich Trott) [#17781](https://github.com/nodejs/node/pull/17781)
* [[`c6b993bde7`](https://github.com/nodejs/node/commit/c6b993bde7)] - **test**: move firstInvalidFD() out of common module (Rich Trott) [#17781](https://github.com/nodejs/node/pull/17781)
* [[`8e69026962`](https://github.com/nodejs/node/commit/8e69026962)] - **test**: remove getTTYfd() from common module (Rich Trott) [#17781](https://github.com/nodejs/node/pull/17781)
* [[`a8d9ccf8fe`](https://github.com/nodejs/node/commit/a8d9ccf8fe)] - **test**: remove common.projectDir (Rich Trott) [#17781](https://github.com/nodejs/node/pull/17781)
* [[`74582933c9`](https://github.com/nodejs/node/commit/74582933c9)] - **test**: refactor test-fs-readfile-tostring-fail (Rich Trott) [#19404](https://github.com/nodejs/node/pull/19404)
* [[`a56ba1258d`](https://github.com/nodejs/node/commit/a56ba1258d)] - **tools**: update certdata.txt (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)
* [[`e895d54224`](https://github.com/nodejs/node/commit/e895d54224)] - **tools**: simplify tools/doc/preprocess.js (Vse Mozhet Byt) [#19539](https://github.com/nodejs/node/pull/19539)
* [[`4c3465f68a`](https://github.com/nodejs/node/commit/4c3465f68a)] - **tools**: fix nits in tools/doc/common.js (Vse Mozhet Byt) [#19599](https://github.com/nodejs/node/pull/19599)
* [[`ab561c090b`](https://github.com/nodejs/node/commit/ab561c090b)] - **tools**: shorten metadata parsing (Tobias Nießen) [#19512](https://github.com/nodejs/node/pull/19512)
* [[`0db7b8cd87`](https://github.com/nodejs/node/commit/0db7b8cd87)] - **tools**: make metadata parsing less permissive (Tobias Nießen) [#19512](https://github.com/nodejs/node/pull/19512)
* [[`4007d6cbfe`](https://github.com/nodejs/node/commit/4007d6cbfe)] - **tools**: update ESLint to 4.19.1 (Rich Trott) [#19528](https://github.com/nodejs/node/pull/19528)
* [[`89e7a5faad`](https://github.com/nodejs/node/commit/89e7a5faad)] - **tools**: fix nits in tools/doc/preprocess.js (Vse Mozhet Byt) [#19473](https://github.com/nodejs/node/pull/19473)
* [[`0414a8c7ed`](https://github.com/nodejs/node/commit/0414a8c7ed)] - **tools**: fix logic nit in tools/doc/generate.js (Vse Mozhet Byt) [#19475](https://github.com/nodejs/node/pull/19475)

<a id="9.9.0"></a>
## 2018-03-21, Version 9.9.0 (Current), @MylesBorins prepared by @targos

### Notable Changes

* **assert**:
  - From now on all error messages produced by `assert` in strict mode will produce a error diff. (Ruben Bridgewater) [#17615](https://github.com/nodejs/node/pull/17615)
  - From now on it is possible to use a validation object in throws instead of the other possibilities. (Ruben Bridgewater) [#17584](https://github.com/nodejs/node/pull/17584)
* **crypto**:
  - allow passing null as IV unless required (Tobias Nießen) [#18644](https://github.com/nodejs/node/pull/18644)
* **fs**:
  - support as and as+ flags in stringToFlags() (Sarat Addepalli) [#18801](https://github.com/nodejs/node/pull/18801)
* **tls**:
  - expose Finished messages in TLSSocket (Anton Salikhmetov) [#19102](https://github.com/nodejs/node/pull/19102)
* **tty**:
  - Add getColorDepth function to determine if terminal supports colors. (Ruben Bridgewater) [#17615](https://github.com/nodejs/node/pull/17615)
* **util**:
  - add util.inspect compact option (Ruben Bridgewater) [#17576](https://github.com/nodejs/node/pull/17576)
* **Added new collaborators**
  - [watson](https://github.com/watson) Thomas Watson

### Commits

* [[`acc86ed246`](https://github.com/nodejs/node/commit/acc86ed246)] - 2018-03-XX, Version 9.9.0 (Current) (Michaël Zasso)
* [[`8d33e5c214`](https://github.com/nodejs/node/commit/8d33e5c214)] - **assert**: improve error check (Ruben Bridgewater) [#17574](https://github.com/nodejs/node/pull/17574)
* [[`5e6b42ec9c`](https://github.com/nodejs/node/commit/5e6b42ec9c)] - **assert**: show proper differences (Ruben Bridgewater) [#18611](https://github.com/nodejs/node/pull/18611)
* [[`9abbb6b857`](https://github.com/nodejs/node/commit/9abbb6b857)] - **assert**: fix infinite loop (Ruben Bridgewater) [#18611](https://github.com/nodejs/node/pull/18611)
* [[`e9ac468146`](https://github.com/nodejs/node/commit/e9ac468146)] - **assert**: fix throws trace (Ruben Bridgewater) [#18595](https://github.com/nodejs/node/pull/18595)
* [[`d3c2534bbe`](https://github.com/nodejs/node/commit/d3c2534bbe)] - **assert**: use destructuring for errors (Ruben Bridgewater) [#18247](https://github.com/nodejs/node/pull/18247)
* [[`5aa3a2d172`](https://github.com/nodejs/node/commit/5aa3a2d172)] - **(SEMVER-MINOR)** **assert**: improve error messages (Ruben Bridgewater) [#17615](https://github.com/nodejs/node/pull/17615)
* [[`f96ea47cf5`](https://github.com/nodejs/node/commit/f96ea47cf5)] - **assert**: fix strict regression (Ruben Bridgewater) [#17903](https://github.com/nodejs/node/pull/17903)
* [[`ebd60fa505`](https://github.com/nodejs/node/commit/ebd60fa505)] - **(SEMVER-MINOR)** **assert**: .throws accept objects (Ruben Bridgewater) [#17584](https://github.com/nodejs/node/pull/17584)
* [[`612ba1a3f0`](https://github.com/nodejs/node/commit/612ba1a3f0)] - **(SEMVER-MINOR)** **assert**: improve assert.throws (Ruben Bridgewater) [#17585](https://github.com/nodejs/node/pull/17585)
* [[`24aeca7dd5`](https://github.com/nodejs/node/commit/24aeca7dd5)] - **assert**: fix throws and doesNotThrow stack frames (Ruben Bridgewater) [#17703](https://github.com/nodejs/node/pull/17703)
* [[`db73d1c13b`](https://github.com/nodejs/node/commit/db73d1c13b)] - **assert**: use object argument in innerFail (Ruben Bridgewater) [#17582](https://github.com/nodejs/node/pull/17582)
* [[`bae5de1949`](https://github.com/nodejs/node/commit/bae5de1949)] - **(SEMVER-MINOR)** **assert**: add strict functionality export (Ruben Bridgewater) [#17002](https://github.com/nodejs/node/pull/17002)
* [[`f0f31d080a`](https://github.com/nodejs/node/commit/f0f31d080a)] - **async_hooks**: add copyHooks function (Daniel Bevenius) [#19391](https://github.com/nodejs/node/pull/19391)
* [[`71b1c7f79f`](https://github.com/nodejs/node/commit/71b1c7f79f)] - **async_hooks**: don't set hook\_fields\[kTotals\] to 0 (Daniel Bevenius) [#19219](https://github.com/nodejs/node/pull/19219)
* [[`530b8a4077`](https://github.com/nodejs/node/commit/530b8a4077)] - **benchmark**: fix benchmark for url (Sergey Golovin) [#19084](https://github.com/nodejs/node/pull/19084)
* [[`563bed00f5`](https://github.com/nodejs/node/commit/563bed00f5)] - **benchmark,lib,test,tools**: use consistent quotes (Rich Trott) [#19156](https://github.com/nodejs/node/pull/19156)
* [[`3f7c4eea04`](https://github.com/nodejs/node/commit/3f7c4eea04)] - **build**: do not cd on vcbuild help (Vse Mozhet Byt) [#19291](https://github.com/nodejs/node/pull/19291)
* [[`5a1437cdbd`](https://github.com/nodejs/node/commit/5a1437cdbd)] - **build**: update arm64 minimum supported platform (Gibson Fahnestock) [#19164](https://github.com/nodejs/node/pull/19164)
* [[`07845fc19e`](https://github.com/nodejs/node/commit/07845fc19e)] - **console**: port errors to new system (Ruben Bridgewater) [#18857](https://github.com/nodejs/node/pull/18857)
* [[`03c321a713`](https://github.com/nodejs/node/commit/03c321a713)] - **(SEMVER-MINOR)** **crypto**: allow passing null as IV unless required (Tobias Nießen) [#18644](https://github.com/nodejs/node/pull/18644)
* [[`044995e546`](https://github.com/nodejs/node/commit/044995e546)] - **crypto**: use bool over int consistently (Tobias Nießen) [#19238](https://github.com/nodejs/node/pull/19238)
* [[`36f664ef9a`](https://github.com/nodejs/node/commit/36f664ef9a)] - **deps**: V8: backport 596d55a from upstream (Myles Borins) [#19477](https://github.com/nodejs/node/pull/19477)
* [[`5966b8cc06`](https://github.com/nodejs/node/commit/5966b8cc06)] - **deps**: v8: cherry-pick fixes for v8:7535 (Flarna) [#19333](https://github.com/nodejs/node/pull/19333)
* [[`cb732aeda4`](https://github.com/nodejs/node/commit/cb732aeda4)] - **doc**: enable eslint prefer-template rule (Ruben Bridgewater) [#18831](https://github.com/nodejs/node/pull/18831)
* [[`ff82acb95a`](https://github.com/nodejs/node/commit/ff82acb95a)] - **doc**: update buffer examples (Ruben Bridgewater) [#18758](https://github.com/nodejs/node/pull/18758)
* [[`a4c28d77f7`](https://github.com/nodejs/node/commit/a4c28d77f7)] - **doc**: fix deprecation removed by mistake (Michaël Zasso) [#19482](https://github.com/nodejs/node/pull/19482)
* [[`b229912f6f`](https://github.com/nodejs/node/commit/b229912f6f)] - **doc**: do not announce obvious examples (Rich Trott) [#19270](https://github.com/nodejs/node/pull/19270)
* [[`c1fa0926e3`](https://github.com/nodejs/node/commit/c1fa0926e3)] - **doc**: fix typos on n-api (Kyle Robinson Young) [#19385](https://github.com/nodejs/node/pull/19385)
* [[`99e6734f19`](https://github.com/nodejs/node/commit/99e6734f19)] - **doc**: improve best practices in onboarding-extras (Rich Trott) [#19315](https://github.com/nodejs/node/pull/19315)
* [[`5a56327e79`](https://github.com/nodejs/node/commit/5a56327e79)] - **doc**: fix minor issues in async\_hooks.md (Rich Trott) [#19313](https://github.com/nodejs/node/pull/19313)
* [[`5da3ee7719`](https://github.com/nodejs/node/commit/5da3ee7719)] - **doc**: clarify default TLS handshake timeout (Rich Trott) [#19290](https://github.com/nodejs/node/pull/19290)
* [[`7f652c2bcc`](https://github.com/nodejs/node/commit/7f652c2bcc)] - **doc**: update username and email (Yuta Hiroto) [#19338](https://github.com/nodejs/node/pull/19338)
* [[`e247f19ac3`](https://github.com/nodejs/node/commit/e247f19ac3)] - **doc**: improve style guide text (Rich Trott) [#19269](https://github.com/nodejs/node/pull/19269)
* [[`c9b12f302a`](https://github.com/nodejs/node/commit/c9b12f302a)] - **doc**: remove superfluous text in onboarding-extras (Rich Trott) [#19247](https://github.com/nodejs/node/pull/19247)
* [[`6c5afebf55`](https://github.com/nodejs/node/commit/6c5afebf55)] - **doc**: make caveat in stream.md more concise (Rich Trott) [#19251](https://github.com/nodejs/node/pull/19251)
* [[`8e88a180b9`](https://github.com/nodejs/node/commit/8e88a180b9)] - **doc**: add warning to assert.doesNotThrow() (Ruben Bridgewater) [#18699](https://github.com/nodejs/node/pull/18699)
* [[`a04e4ae5e4`](https://github.com/nodejs/node/commit/a04e4ae5e4)] - **doc**: remove confusing "cats" from style guide (Rich Trott) [#19246](https://github.com/nodejs/node/pull/19246)
* [[`7c3617558e`](https://github.com/nodejs/node/commit/7c3617558e)] - **doc**: remove superfluous adverb from style guide (Rich Trott) [#19246](https://github.com/nodejs/node/pull/19246)
* [[`d117f5ff22`](https://github.com/nodejs/node/commit/d117f5ff22)] - **doc**: remove warning against readable/readable.read (Rich Trott) [#19193](https://github.com/nodejs/node/pull/19193)
* [[`5c21d16c31`](https://github.com/nodejs/node/commit/5c21d16c31)] - **doc**: add watson to collaborators (Thomas Watson) [#19234](https://github.com/nodejs/node/pull/19234)
* [[`9557e66ae1`](https://github.com/nodejs/node/commit/9557e66ae1)] - **doc**: update labels info in onboarding-extras.md (Rich Trott) [#19160](https://github.com/nodejs/node/pull/19160)
* [[`84acb9fae5`](https://github.com/nodejs/node/commit/84acb9fae5)] - **doc**: add inspector usage example (Ali Ijaz Sheikh) [#19172](https://github.com/nodejs/node/pull/19172)
* [[`27088cfaa7`](https://github.com/nodejs/node/commit/27088cfaa7)] - **doc**: improve onboarding instructions (Joyee Cheung) [#19108](https://github.com/nodejs/node/pull/19108)
* [[`9ec0eab019`](https://github.com/nodejs/node/commit/9ec0eab019)] - **doc**: make suggestion more direct in stream.md (Rich Trott) [#19124](https://github.com/nodejs/node/pull/19124)
* [[`968b867bf2`](https://github.com/nodejs/node/commit/968b867bf2)] - **doc**: document asserts Weak(Map|Set) behavior (Ruben Bridgewater) [#18248](https://github.com/nodejs/node/pull/18248)
* [[`745709396c`](https://github.com/nodejs/node/commit/745709396c)] - **(SEMVER-MINOR)** **doc**: improve .throws RegExp info (Ruben Bridgewater) [#17585](https://github.com/nodejs/node/pull/17585)
* [[`5a78c6c0a6`](https://github.com/nodejs/node/commit/5a78c6c0a6)] - **(SEMVER-MINOR)** **doc**: improve assert documentation (Ruben Bridgewater) [#17002](https://github.com/nodejs/node/pull/17002)
* [[`f4f0266bfe`](https://github.com/nodejs/node/commit/f4f0266bfe)] - **errors**: add comments about falsy error types (Ruben Bridgewater) [#18857](https://github.com/nodejs/node/pull/18857)
* [[`ffa16aad60`](https://github.com/nodejs/node/commit/ffa16aad60)] - **errors**: update all internal errors (Ruben Bridgewater) [#18857](https://github.com/nodejs/node/pull/18857)
* [[`d57a2421fc`](https://github.com/nodejs/node/commit/d57a2421fc)] - **errors**: implement new error handling (Ruben Bridgewater) [#18857](https://github.com/nodejs/node/pull/18857)
* [[`607b33cfcc`](https://github.com/nodejs/node/commit/607b33cfcc)] - **(SEMVER-MINOR)** **fs**: support as and as+ flags in stringToFlags() (Sarat Addepalli) [#18801](https://github.com/nodejs/node/pull/18801)
* [[`b01bd800c6`](https://github.com/nodejs/node/commit/b01bd800c6)] - **fs**: fix `createReadStream(…, {end: n})` for non-seekable fds (Anna Henningsen) [#19329](https://github.com/nodejs/node/pull/19329)
* [[`3914e97741`](https://github.com/nodejs/node/commit/3914e97741)] - **http2**: fixes error handling (Matteo Collina) [#19232](https://github.com/nodejs/node/pull/19232)
* [[`3bf69cd3e7`](https://github.com/nodejs/node/commit/3bf69cd3e7)] - **http2**: some general code improvements (James M Snell) [#19400](https://github.com/nodejs/node/pull/19400)
* [[`4277635bed`](https://github.com/nodejs/node/commit/4277635bed)] - **http2**: clean up Http2Settings (James M Snell) [#19400](https://github.com/nodejs/node/pull/19400)
* [[`42b6d801dc`](https://github.com/nodejs/node/commit/42b6d801dc)] - **http2**: don't aggressively inline (James M Snell) [#19400](https://github.com/nodejs/node/pull/19400)
* [[`89fbbc48ff`](https://github.com/nodejs/node/commit/89fbbc48ff)] - **http2**: simplify timeout tracking (Anna Henningsen) [#19206](https://github.com/nodejs/node/pull/19206)
* [[`f06622cd56`](https://github.com/nodejs/node/commit/f06622cd56)] - **lib**: define printErr() in script string (cjihrig) [#19285](https://github.com/nodejs/node/pull/19285)
* [[`b35eabb837`](https://github.com/nodejs/node/commit/b35eabb837)] - **lib**: handle `throw undefined` in assert.throws() (Ben Noordhuis) [#18029](https://github.com/nodejs/node/pull/18029)
* [[`0e6f720991`](https://github.com/nodejs/node/commit/0e6f720991)] - **n-api**: separate out async\_hooks test (Gabriel Schulhof) [#19392](https://github.com/nodejs/node/pull/19392)
* [[`528798c3f4`](https://github.com/nodejs/node/commit/528798c3f4)] - **n-api**: add missing exception checking (Michael Dawson) [#19362](https://github.com/nodejs/node/pull/19362)
* [[`f679ac19e0`](https://github.com/nodejs/node/commit/f679ac19e0)] - **n-api**: resolve promise in test (Gabriel Schulhof) [#19245](https://github.com/nodejs/node/pull/19245)
* [[`12f19a6b86`](https://github.com/nodejs/node/commit/12f19a6b86)] - **n-api**: update documentation (Gabriel Schulhof) [#19078](https://github.com/nodejs/node/pull/19078)
* [[`0c9577edfc`](https://github.com/nodejs/node/commit/0c9577edfc)] - **n-api,test**: add int64 bounds tests (Kyle Farnung) [#19309](https://github.com/nodejs/node/pull/19309)
* [[`f36521becf`](https://github.com/nodejs/node/commit/f36521becf)] - **n-api,test**: add a new.target test to addons-napi (Taylor Woll) [#19236](https://github.com/nodejs/node/pull/19236)
* [[`5b12d3a58e`](https://github.com/nodejs/node/commit/5b12d3a58e)] - **net**: do not inherit the no-half-open enforcer (Luigi Pinca) [#18974](https://github.com/nodejs/node/pull/18974)
* [[`a9bd8bff8a`](https://github.com/nodejs/node/commit/a9bd8bff8a)] - **path**: remove redundant function (Sergey Golovin) [#19237](https://github.com/nodejs/node/pull/19237)
* [[`55f7bbb0bd`](https://github.com/nodejs/node/commit/55f7bbb0bd)] - **repl**: refactor code for readability (Ruben Bridgewater) [#17919](https://github.com/nodejs/node/pull/17919)
* [[`6997af7378`](https://github.com/nodejs/node/commit/6997af7378)] - **repl**: upper case comments first char (Ruben Bridgewater) [#17919](https://github.com/nodejs/node/pull/17919)
* [[`3e6858e4a7`](https://github.com/nodejs/node/commit/3e6858e4a7)] - **repl**: better handling of recoverable errors (Prince J Wesley) [#18915](https://github.com/nodejs/node/pull/18915)
* [[`49391a70e1`](https://github.com/nodejs/node/commit/49391a70e1)] - **src**: fix util abort (Ruben Bridgewater) [#19223](https://github.com/nodejs/node/pull/19223)
* [[`1ba1861731`](https://github.com/nodejs/node/commit/1ba1861731)] - **src**: remove unused using declarations async\_wrap (Daniel Bevenius) [#18893](https://github.com/nodejs/node/pull/18893)
* [[`8757799d69`](https://github.com/nodejs/node/commit/8757799d69)] - **src**: remove unused stdlib.h include (Daniel Bevenius) [#19427](https://github.com/nodejs/node/pull/19427)
* [[`da62c5ca68`](https://github.com/nodejs/node/commit/da62c5ca68)] - **src**: fix minor typo in comment stream\_base.h (Daniel Bevenius) [#19429](https://github.com/nodejs/node/pull/19429)
* [[`43c482b9c8`](https://github.com/nodejs/node/commit/43c482b9c8)] - **src**: fix indentation of params in env-inl.h (Daniel Bevenius) [#19390](https://github.com/nodejs/node/pull/19390)
* [[`054dd28da6`](https://github.com/nodejs/node/commit/054dd28da6)] - **src**: make AsyncWrap constructors delegate (Daniel Bevenius) [#19366](https://github.com/nodejs/node/pull/19366)
* [[`7a3d1d205e`](https://github.com/nodejs/node/commit/7a3d1d205e)] - **src**: remove unused uv.h include from async\_wrap.cc (Daniel Bevenius) [#19342](https://github.com/nodejs/node/pull/19342)
* [[`126a161928`](https://github.com/nodejs/node/commit/126a161928)] - **src**: fix indenting of wrap-\>EmitTraceEventBefore (Daniel Bevenius) [#19340](https://github.com/nodejs/node/pull/19340)
* [[`03fb817a1d`](https://github.com/nodejs/node/commit/03fb817a1d)] - **src**: add extractPromiseWrap function (Daniel Bevenius) [#19340](https://github.com/nodejs/node/pull/19340)
* [[`e208282f68`](https://github.com/nodejs/node/commit/e208282f68)] - **src**: refactor emit before/after/promiseResolve (Daniel Bevenius) [#19295](https://github.com/nodejs/node/pull/19295)
* [[`49481d0e3b`](https://github.com/nodejs/node/commit/49481d0e3b)] - **src**: add convenience ctor for async trigger id scope (Anna Henningsen) [#19204](https://github.com/nodejs/node/pull/19204)
* [[`4b9914a318`](https://github.com/nodejs/node/commit/4b9914a318)] - **src**: avoid duplicate Before/AtExitCallback structs (Daniel Bevenius) [#19226](https://github.com/nodejs/node/pull/19226)
* [[`27754c5408`](https://github.com/nodejs/node/commit/27754c5408)] - **src**: add incr/decr operators for Reference (Daniel Bevenius) [#19083](https://github.com/nodejs/node/pull/19083)
* [[`64f646269a`](https://github.com/nodejs/node/commit/64f646269a)] - **src**: use smart pointer in AsyncWrap::WeakCallback (Daniel Bevenius) [#19168](https://github.com/nodejs/node/pull/19168)
* [[`152c931f53`](https://github.com/nodejs/node/commit/152c931f53)] - **stream**: make Duplex inherits from DuplexBase (Luigi Pinca) [#18974](https://github.com/nodejs/node/pull/18974)
* [[`9c0c0e68ac`](https://github.com/nodejs/node/commit/9c0c0e68ac)] - **stream**: add no-half-open enforcer only if needed (Luigi Pinca) [#18953](https://github.com/nodejs/node/pull/18953)
* [[`1eac1d7d85`](https://github.com/nodejs/node/commit/1eac1d7d85)] - **test**: minor refactoring (Ruben Bridgewater) [#18669](https://github.com/nodejs/node/pull/18669)
* [[`574d061c3c`](https://github.com/nodejs/node/commit/574d061c3c)] - **test**: remove assert.doesNotThrow() (Ruben Bridgewater) [#18669](https://github.com/nodejs/node/pull/18669)
* [[`5478746203`](https://github.com/nodejs/node/commit/5478746203)] - **test**: refactor assert test (Ruben Bridgewater) [#18610](https://github.com/nodejs/node/pull/18610)
* [[`4e9279df5c`](https://github.com/nodejs/node/commit/4e9279df5c)] - **test**: remove NodeTestFixture from Env constructor (Daniel Bevenius) [#18558](https://github.com/nodejs/node/pull/18558)
* [[`22b8f9fba6`](https://github.com/nodejs/node/commit/22b8f9fba6)] - **test**: introduce SetUpTestCase/TearDownTestCase (Daniel Bevenius) [#18558](https://github.com/nodejs/node/pull/18558)
* [[`519850f21e`](https://github.com/nodejs/node/commit/519850f21e)] - **test**: http2 client setNextStreamID errors (Trivikram) [#18848](https://github.com/nodejs/node/pull/18848)
* [[`e3ce084f7c`](https://github.com/nodejs/node/commit/e3ce084f7c)] - **test**: fix flaky test-http2-ping-flood (Rich Trott) [#19395](https://github.com/nodejs/node/pull/19395)
* [[`7df6d9ddc8`](https://github.com/nodejs/node/commit/7df6d9ddc8)] - **test**: rename regression tests file names (Ujjwal Sharma) [#19332](https://github.com/nodejs/node/pull/19332)
* [[`f49042131a`](https://github.com/nodejs/node/commit/f49042131a)] - **test**: use descriptive names for regression tests (Ujjwal Sharma) [#19275](https://github.com/nodejs/node/pull/19275)
* [[`01749f07bd`](https://github.com/nodejs/node/commit/01749f07bd)] - **test**: fix flaky test-http2-settings-flood (Rich Trott) [#19349](https://github.com/nodejs/node/pull/19349)
* [[`9aa5090689`](https://github.com/nodejs/node/commit/9aa5090689)] - **test**: fix test-cluster-send-handle-large-payload (Rich Trott) [#19311](https://github.com/nodejs/node/pull/19311)
* [[`11a0ef566a`](https://github.com/nodejs/node/commit/11a0ef566a)] - **test**: delete test/parallel/test-regress-GH-4948 (Ujjwal Sharma) [#19279](https://github.com/nodejs/node/pull/19279)
* [[`be20914958`](https://github.com/nodejs/node/commit/be20914958)] - **test**: shared lib build doesn't handle SIGPIPE (Yihong Wang) [#19211](https://github.com/nodejs/node/pull/19211)
* [[`f84f548986`](https://github.com/nodejs/node/commit/f84f548986)] - **test**: fix assertion argument order (Rich Trott) [#19264](https://github.com/nodejs/node/pull/19264)
* [[`84ae59e5f8`](https://github.com/nodejs/node/commit/84ae59e5f8)] - **test**: fix path in doctool/test-doctool-json (Vse Mozhet Byt) [#19287](https://github.com/nodejs/node/pull/19287)
* [[`b8ca616baa`](https://github.com/nodejs/node/commit/b8ca616baa)] - **test**: fix compiler warnings in callback-scope (Daniel Bevenius) [#19252](https://github.com/nodejs/node/pull/19252)
* [[`d3bc72e9cc`](https://github.com/nodejs/node/commit/d3bc72e9cc)] - **test**: name test files appropriately (Ujjwal Sharma) [#19212](https://github.com/nodejs/node/pull/19212)
* [[`f0c8f6969f`](https://github.com/nodejs/node/commit/f0c8f6969f)] - **test**: fix test-abort-backtrace in shared lib build (Yihong Wang) [#19213](https://github.com/nodejs/node/pull/19213)
* [[`e4c320e5d7`](https://github.com/nodejs/node/commit/e4c320e5d7)] - **test**: Remove unnecessary asserion messages in test-crypto-hash.js (Piotr Grzesik) [#18984](https://github.com/nodejs/node/pull/18984)
* [[`411f3e03fe`](https://github.com/nodejs/node/commit/411f3e03fe)] - **test**: remove flaky status for test-npm-install (Rich Trott) [#19216](https://github.com/nodejs/node/pull/19216)
* [[`a4a4819954`](https://github.com/nodejs/node/commit/a4a4819954)] - **test**: do not check text for engine-generated error (Rich Trott) [#19215](https://github.com/nodejs/node/pull/19215)
* [[`38eb432260`](https://github.com/nodejs/node/commit/38eb432260)] - **test**: refactor http-https-default-ports (Ken Lin) [#19130](https://github.com/nodejs/node/pull/19130)
* [[`0ece7cc227`](https://github.com/nodejs/node/commit/0ece7cc227)] - **test**: rename test-regress-GH-877.js (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`636a5f627e`](https://github.com/nodejs/node/commit/636a5f627e)] - **test**: rename test-regress-GH-784.js (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`c0c6d5848f`](https://github.com/nodejs/node/commit/c0c6d5848f)] - **test**: address nits and rename the corresponding fixture (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`22484e1fb2`](https://github.com/nodejs/node/commit/22484e1fb2)] - **test**: rename tests to remove "regress" keyword (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`2262a34f0b`](https://github.com/nodejs/node/commit/2262a34f0b)] - **test**: rename test-regress-GH-4027 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`bdbfc0e20e`](https://github.com/nodejs/node/commit/bdbfc0e20e)] - **test**: rename test-regress-GH-4015 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`da44c2ccf0`](https://github.com/nodejs/node/commit/da44c2ccf0)] - **test**: rename test-regress-GH-1697 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`fa43d2f69e`](https://github.com/nodejs/node/commit/fa43d2f69e)] - **test**: rename test-regress-GH-1726 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`46b5915dab`](https://github.com/nodejs/node/commit/46b5915dab)] - **test**: skip postmortem metadata test when nm fails (Joyee Cheung) [#19107](https://github.com/nodejs/node/pull/19107)
* [[`16ab3b54d1`](https://github.com/nodejs/node/commit/16ab3b54d1)] - **test**: address unreliable test-performance (Rich Trott) [#19228](https://github.com/nodejs/node/pull/19228)
* [[`1e5c7e3e47`](https://github.com/nodejs/node/commit/1e5c7e3e47)] - **test**: refactor common.expectsError (Ruben Bridgewater) [#17703](https://github.com/nodejs/node/pull/17703)
* [[`060216689a`](https://github.com/nodejs/node/commit/060216689a)] - **(SEMVER-MINOR)** **tls**: expose Finished messages in TLSSocket (Anton Salikhmetov) [#19102](https://github.com/nodejs/node/pull/19102)
* [[`b04dd7b351`](https://github.com/nodejs/node/commit/b04dd7b351)] - **tools**: enable eslint one-var rule (Ruben Bridgewater) [#18831](https://github.com/nodejs/node/pull/18831)
* [[`d4d7df8371`](https://github.com/nodejs/node/commit/d4d7df8371)] - **tools**: enable eslint strict key-spacing (Ruben Bridgewater) [#18831](https://github.com/nodejs/node/pull/18831)
* [[`9e10ddc215`](https://github.com/nodejs/node/commit/9e10ddc215)] - **tools**: enable eslint no-undef-init rule (Ruben Bridgewater) [#18831](https://github.com/nodejs/node/pull/18831)
* [[`9d1e409ee3`](https://github.com/nodejs/node/commit/9d1e409ee3)] - **tools**: enable no-unsafe-finally (Ruben Bridgewater) [#18745](https://github.com/nodejs/node/pull/18745)
* [[`d7958657d7`](https://github.com/nodejs/node/commit/d7958657d7)] - **tools**: add assert.doesNotThrow eslint rule (Ruben Bridgewater) [#18669](https://github.com/nodejs/node/pull/18669)
* [[`66694e28b1`](https://github.com/nodejs/node/commit/66694e28b1)] - **tools**: fix test-npm-package (Michaël Zasso) [#19293](https://github.com/nodejs/node/pull/19293)
* [[`9613e02ff7`](https://github.com/nodejs/node/commit/9613e02ff7)] - **tools,bootstrap**: preprocess gypi files to json (Gus Caplan) [#19140](https://github.com/nodejs/node/pull/19140)
* [[`74f0d1aa60`](https://github.com/nodejs/node/commit/74f0d1aa60)] - **(SEMVER-MINOR)** **tty**: refactor to es6 (Ruben Bridgewater) [#17615](https://github.com/nodejs/node/pull/17615)
* [[`ead727c274`](https://github.com/nodejs/node/commit/ead727c274)] - **(SEMVER-MINOR)** **tty**: add getColorDepth function (Ruben Bridgewater) [#17615](https://github.com/nodejs/node/pull/17615)
* [[`072adfea8c`](https://github.com/nodejs/node/commit/072adfea8c)] - **url**: replace "magic" numbers by constants (Sergey Golovin) [#19035](https://github.com/nodejs/node/pull/19035)
* [[`c18ac52970`](https://github.com/nodejs/node/commit/c18ac52970)] - **(SEMVER-MINOR)** **util**: add util.inspect compact option (Ruben Bridgewater) [#17576](https://github.com/nodejs/node/pull/17576)
* [[`ce3a5af69f`](https://github.com/nodejs/node/commit/ce3a5af69f)] - **(SEMVER-MINOR)** **util**: rename util.inspect argument (Ruben Bridgewater) [#17576](https://github.com/nodejs/node/pull/17576)
* [[`fd4c05ab56`](https://github.com/nodejs/node/commit/fd4c05ab56)] - **(SEMVER-MINOR)** **util**: fix custom inspect description (Ruben Bridgewater) [#17576](https://github.com/nodejs/node/pull/17576)

<a id="9.8.0"></a>
## 2018-03-07, Version 9.8.0 (Current), @MylesBorins

### Notable Changes

* **crypto**:
  - add cert.fingerprint256 as SHA256 fingerprint (Hannes Magnusson) [#17690](https://github.com/nodejs/node/pull/17690)
* **http2**:
  - Fixed issues with aborted connections in the HTTP/2 implementation (Anna Henningsen) [#18987](https://github.com/nodejs/node/pull/18987) [#19002](https://github.com/nodejs/node/pull/19002)
* **loader**:
  - --inspect-brk now works properly for esmodules (Gus Caplan) [#18949](https://github.com/nodejs/node/pull/18949)
* **src**:
  - make process.dlopen() load well-known symbol (Ben Noordhuis) [#18934](https://github.com/nodejs/node/pull/18934)
* **trace_events**:
  - add file pattern cli option (Andreas Madsen) [#18480](https://github.com/nodejs/node/pull/18480)
* **Added new collaborators**
  - [MoonBall](https://github.com/MoonBall) Chen Gang

### Commits

* [[`6ae2cafde3`](https://github.com/nodejs/node/commit/6ae2cafde3)] - **buffer**: coerce offset to integer (Ruben Bridgewater) [#18215](https://github.com/nodejs/node/pull/18215)
* [[`6d17383041`](https://github.com/nodejs/node/commit/6d17383041)] - **buffer**: fix typo in lib/buffer.js (Ujjwal Sharma) [#19126](https://github.com/nodejs/node/pull/19126)
* [[`4b34b2e185`](https://github.com/nodejs/node/commit/4b34b2e185)] - **build**: fix gocvr version used for coverage (Michael Dawson) [#19094](https://github.com/nodejs/node/pull/19094)
* [[`a938e52ffe`](https://github.com/nodejs/node/commit/a938e52ffe)] - **build**: disable openssl build warnings on macos (Ben Noordhuis) [#19046](https://github.com/nodejs/node/pull/19046)
* [[`44d80c5620`](https://github.com/nodejs/node/commit/44d80c5620)] - **build**: fix coverage after gcovr update (killagu) [#18958](https://github.com/nodejs/node/pull/18958)
* [[`28a5362e83`](https://github.com/nodejs/node/commit/28a5362e83)] - **build**: fix lint-md-build dependency (Joyee Cheung) [#18981](https://github.com/nodejs/node/pull/18981)
* [[`e74e422a53`](https://github.com/nodejs/node/commit/e74e422a53)] - **(SEMVER-MINOR)** **crypto**: add cert.fingerprint256 as SHA256 fingerprint (Hannes Magnusson) [#17690](https://github.com/nodejs/node/pull/17690)
* [[`056001dc8f`](https://github.com/nodejs/node/commit/056001dc8f)] - **(SEMVER-MINOR)** **deps**: cherry-pick 0bcb1d6f from upstream V8 (Jakob Kummerow) [#18212](https://github.com/nodejs/node/pull/18212)
* [[`1fadb2edb4`](https://github.com/nodejs/node/commit/1fadb2edb4)] - **doc**: fix/add link to Android info (Vse Mozhet Byt) [#19004](https://github.com/nodejs/node/pull/19004)
* [[`68524610f2`](https://github.com/nodejs/node/commit/68524610f2)] - **doc**: remove subsystem from pull request template (Rich Trott) [#19125](https://github.com/nodejs/node/pull/19125)
* [[`d3a70e9cd4`](https://github.com/nodejs/node/commit/d3a70e9cd4)] - **doc**: remove tentativeness in pull-requests.md (Rich Trott) [#19123](https://github.com/nodejs/node/pull/19123)
* [[`f03079fce6`](https://github.com/nodejs/node/commit/f03079fce6)] - **doc**: update cc list (Ruben Bridgewater) [#19099](https://github.com/nodejs/node/pull/19099)
* [[`9d2de16b13`](https://github.com/nodejs/node/commit/9d2de16b13)] - **doc**: add introduced\_in metadata to \_toc.md (Rich Trott) [#19113](https://github.com/nodejs/node/pull/19113)
* [[`ae2dabb8fc`](https://github.com/nodejs/node/commit/ae2dabb8fc)] - **doc**: new team for bundlers or delivery of Node.js (Michael Dawson) [#19098](https://github.com/nodejs/node/pull/19098)
* [[`0e4f4266a1`](https://github.com/nodejs/node/commit/0e4f4266a1)] - **doc**: add simple example to rename function (punteek) [#18812](https://github.com/nodejs/node/pull/18812)
* [[`e42600fc4b`](https://github.com/nodejs/node/commit/e42600fc4b)] - **doc**: add missing `Returns` in fs & util (Sho Miyamoto) [#18775](https://github.com/nodejs/node/pull/18775)
* [[`4ecf5bbe74`](https://github.com/nodejs/node/commit/4ecf5bbe74)] - **doc**: fix a typo in util.isDeepStrictEqual (Sho Miyamoto) [#18775](https://github.com/nodejs/node/pull/18775)
* [[`cab6c8e95c`](https://github.com/nodejs/node/commit/cab6c8e95c)] - **doc**: add URL.format() example (Zeke Sikelianos) [#18888](https://github.com/nodejs/node/pull/18888)
* [[`a4462b7944`](https://github.com/nodejs/node/commit/a4462b7944)] - **doc**: fix n-api asynchronous threading docs (Eric Bickle) [#19073](https://github.com/nodejs/node/pull/19073)
* [[`bfa894cf37`](https://github.com/nodejs/node/commit/bfa894cf37)] - **doc**: add MoonBall to collaborators (Chen Gang) [#19109](https://github.com/nodejs/node/pull/19109)
* [[`77154cd65d`](https://github.com/nodejs/node/commit/77154cd65d)] - **doc**: update list of re-exported symbols (Richard Lau) [#19013](https://github.com/nodejs/node/pull/19013)
* [[`459f2095a1`](https://github.com/nodejs/node/commit/459f2095a1)] - **doc**: Readable unpipe on Writable error event (George Sapkin) [#18080](https://github.com/nodejs/node/pull/18080)
* [[`68c1337819`](https://github.com/nodejs/node/commit/68c1337819)] - **doc**: add RegExp Unicode Property Escapes to intl (Vse Mozhet Byt) [#19052](https://github.com/nodejs/node/pull/19052)
* [[`71d09ecbf1`](https://github.com/nodejs/node/commit/71d09ecbf1)] - **doc**: make the background section concise and improve its formality (Wilson) [#18928](https://github.com/nodejs/node/pull/18928)
* [[`951054004d`](https://github.com/nodejs/node/commit/951054004d)] - **doc**: lowercase primitives in test/common/README.md (Vse Mozhet Byt) [#18875](https://github.com/nodejs/node/pull/18875)
* [[`5b8c97f6bc`](https://github.com/nodejs/node/commit/5b8c97f6bc)] - **events**: show throw stack trace for uncaught exception (Anna Henningsen) [#19003](https://github.com/nodejs/node/pull/19003)
* [[`0789eeceb6`](https://github.com/nodejs/node/commit/0789eeceb6)] - **http**: prevent aborted event when already completed (Andrew Johnston) [#18999](https://github.com/nodejs/node/pull/18999)
* [[`ae4d83facf`](https://github.com/nodejs/node/commit/ae4d83facf)] - **http**: prevent aborted event when already completed (Andrew Johnston) [#18999](https://github.com/nodejs/node/pull/18999)
* [[`50d1233935`](https://github.com/nodejs/node/commit/50d1233935)] - **http2**: no stream destroy while its data is on the wire (Anna Henningsen) [#19002](https://github.com/nodejs/node/pull/19002)
* [[`551d9752c8`](https://github.com/nodejs/node/commit/551d9752c8)] - **http2**: fix flaky test-http2-https-fallback (Matteo Collina) [#19093](https://github.com/nodejs/node/pull/19093)
* [[`8bc930c269`](https://github.com/nodejs/node/commit/8bc930c269)] - **http2**: fix endless loop when writing empty string (Anna Henningsen) [#18924](https://github.com/nodejs/node/pull/18924)
* [[`aa0fca9426`](https://github.com/nodejs/node/commit/aa0fca9426)] - **http2**: use original error for cancelling pending streams (Anna Henningsen) [#18988](https://github.com/nodejs/node/pull/18988)
* [[`447136999d`](https://github.com/nodejs/node/commit/447136999d)] - **http2**: send error text in case of ALPN mismatch (Anna Henningsen) [#18986](https://github.com/nodejs/node/pull/18986)
* [[`ef8f90f34e`](https://github.com/nodejs/node/commit/ef8f90f34e)] - **http2**: fix condition where data is lost (Matteo Collina) [#18895](https://github.com/nodejs/node/pull/18895)
* [[`e584113b66`](https://github.com/nodejs/node/commit/e584113b66)] - **lib**: re-fix v8\_prof\_processor (Anna Henningsen) [#19059](https://github.com/nodejs/node/pull/19059)
* [[`12856b0dd2`](https://github.com/nodejs/node/commit/12856b0dd2)] - **lib**: change hook -\> hooks in code comment (Daniel Bevenius) [#19053](https://github.com/nodejs/node/pull/19053)
* [[`db8d197e79`](https://github.com/nodejs/node/commit/db8d197e79)] - **lib,test**: remove yoda statements (Ruben Bridgewater) [#18746](https://github.com/nodejs/node/pull/18746)
* [[`59547cc438`](https://github.com/nodejs/node/commit/59547cc438)] - **loader**: fix --inspect-brk (Gus Caplan) [#18949](https://github.com/nodejs/node/pull/18949)
* [[`39e032fe86`](https://github.com/nodejs/node/commit/39e032fe86)] - **module**: fix main lookup regression from #18728 (Guy Bedford) [#18788](https://github.com/nodejs/node/pull/18788)
* [[`f3e3429296`](https://github.com/nodejs/node/commit/f3e3429296)] - **module**: support main w/o extension, pjson cache (Guy Bedford) [#18728](https://github.com/nodejs/node/pull/18728)
* [[`95f6467ffd`](https://github.com/nodejs/node/commit/95f6467ffd)] - **module**: fix cyclical dynamic import (Bradley Farias) [#18965](https://github.com/nodejs/node/pull/18965)
* [[`5c4f703607`](https://github.com/nodejs/node/commit/5c4f703607)] - **n-api**: update reference test (Gabriel Schulhof) [#19086](https://github.com/nodejs/node/pull/19086)
* [[`1b32fc3276`](https://github.com/nodejs/node/commit/1b32fc3276)] - **n-api**: fix object test (Gabriel Schulhof) [#19039](https://github.com/nodejs/node/pull/19039)
* [[`ef4714c2b6`](https://github.com/nodejs/node/commit/ef4714c2b6)] - **net**: inline and simplify onSocketEnd (Anna Henningsen) [#18607](https://github.com/nodejs/node/pull/18607)
* [[`28880cf89d`](https://github.com/nodejs/node/commit/28880cf89d)] - **perf_hooks**: fix timing (Timothy Gu) [#18993](https://github.com/nodejs/node/pull/18993)
* [[`96f0bec48b`](https://github.com/nodejs/node/commit/96f0bec48b)] - **repl**: make last error available as `\_error` (Anna Henningsen) [#18919](https://github.com/nodejs/node/pull/18919)
* [[`420d56c2ea`](https://github.com/nodejs/node/commit/420d56c2ea)] - **src**: don't touch js object in Http2Session dtor (Ben Noordhuis) [#18656](https://github.com/nodejs/node/pull/18656)
* [[`f89f659dcf`](https://github.com/nodejs/node/commit/f89f659dcf)] - **src**: remove unnecessary Reset() calls (Ben Noordhuis) [#18656](https://github.com/nodejs/node/pull/18656)
* [[`67a9742aed`](https://github.com/nodejs/node/commit/67a9742aed)] - **src**: prevent persistent handle resource leaks (Ben Noordhuis) [#18656](https://github.com/nodejs/node/pull/18656)
* [[`08bcdde888`](https://github.com/nodejs/node/commit/08bcdde888)] - **(SEMVER-MINOR)** **src**: handle exceptions in env-\>SetImmediates (James M Snell) [#18297](https://github.com/nodejs/node/pull/18297)
* [[`cc52dae7c4`](https://github.com/nodejs/node/commit/cc52dae7c4)] - **src**: #include \<stdio.h\>" to iculslocs (Steven R. Loomis) [#19150](https://github.com/nodejs/node/pull/19150)
* [[`2f17c52674`](https://github.com/nodejs/node/commit/2f17c52674)] - **src**: use std::unique\_ptr for STACK\_OF(X509) (Ben Noordhuis) [#19087](https://github.com/nodejs/node/pull/19087)
* [[`f10470ce2d`](https://github.com/nodejs/node/commit/f10470ce2d)] - **src**: refactor GetPeerCertificate (Daniel Bevenius) [#19087](https://github.com/nodejs/node/pull/19087)
* [[`4fae6e3904`](https://github.com/nodejs/node/commit/4fae6e3904)] - **(SEMVER-MINOR)** **src**: make process.dlopen() load well-known symbol (Ben Noordhuis) [#18934](https://github.com/nodejs/node/pull/18934)
* [[`89edbae7ab`](https://github.com/nodejs/node/commit/89edbae7ab)] - **(SEMVER-MINOR)** **src**: clean up process.dlopen() (Ben Noordhuis) [#18934](https://github.com/nodejs/node/pull/18934)
* [[`08b83ee27a`](https://github.com/nodejs/node/commit/08b83ee27a)] - **src**: refactor setting JS properties on WriteWrap (Anna Henningsen) [#18963](https://github.com/nodejs/node/pull/18963)
* [[`4d5cd5c6c5`](https://github.com/nodejs/node/commit/4d5cd5c6c5)] - **src**: fix error message in async\_hooks constructor (Daniel Bevenius) [#19000](https://github.com/nodejs/node/pull/19000)
* [[`6787913a68`](https://github.com/nodejs/node/commit/6787913a68)] - **test**: add more information to assert.strictEqual (Ujjwal Sharma) [#19162](https://github.com/nodejs/node/pull/19162)
* [[`ee653ecd09`](https://github.com/nodejs/node/commit/ee653ecd09)] - **test**: move require http2 to after crypto check (Daniel Bevenius) [#19111](https://github.com/nodejs/node/pull/19111)
* [[`5bbf009c1d`](https://github.com/nodejs/node/commit/5bbf009c1d)] - **test**: check symbols in shared lib (Yihong Wang) [#18806](https://github.com/nodejs/node/pull/18806)
* [[`d8833762cb`](https://github.com/nodejs/node/commit/d8833762cb)] - **test**: refactor test-async-wrap-getasyncid (Santiago Gimeno) [#18727](https://github.com/nodejs/node/pull/18727)
* [[`23107ba7b1`](https://github.com/nodejs/node/commit/23107ba7b1)] - **test**: remove assert message and add block scope (wuweiweiwu) [#19054](https://github.com/nodejs/node/pull/19054)
* [[`cc90bbd0f4`](https://github.com/nodejs/node/commit/cc90bbd0f4)] - **test**: fix flaky inspector-stop-profile-after-done (Rich Trott) [#18126](https://github.com/nodejs/node/pull/18126)
* [[`8d595bb25c`](https://github.com/nodejs/node/commit/8d595bb25c)] - **test**: check endless loop while writing empty string (XadillaX) [#18924](https://github.com/nodejs/node/pull/18924)
* [[`a4550069ca`](https://github.com/nodejs/node/commit/a4550069ca)] - **test**: allow running with `NODE\_PENDING\_DEPRECATION` (Anna Henningsen) [#18991](https://github.com/nodejs/node/pull/18991)
* [[`fd27165f73`](https://github.com/nodejs/node/commit/fd27165f73)] - **test**: specify 'dir' for directory symlinks (Kyle Farnung) [#19049](https://github.com/nodejs/node/pull/19049)
* [[`eca333a6e8`](https://github.com/nodejs/node/commit/eca333a6e8)] - **test**: refactor test after review (Andrew Johnston) [#18999](https://github.com/nodejs/node/pull/18999)
* [[`c943cd09a7`](https://github.com/nodejs/node/commit/c943cd09a7)] - **test**: fix repl-tab-complete --without-ssl (Daniel Bevenius) [#17867](https://github.com/nodejs/node/pull/17867)
* [[`f864509991`](https://github.com/nodejs/node/commit/f864509991)] - **test,benchmark**: use new Buffer API where appropriate (Сковорода Никита Андреевич) [#18980](https://github.com/nodejs/node/pull/18980)
* [[`479b622e49`](https://github.com/nodejs/node/commit/479b622e49)] - **tls,http2**: handle writes after SSL destroy more gracefully (Anna Henningsen) [#18987](https://github.com/nodejs/node/pull/18987)
* [[`3d4cda3a7d`](https://github.com/nodejs/node/commit/3d4cda3a7d)] - **(SEMVER-MINOR)** **trace_events**: add file pattern cli option (Andreas Madsen) [#18480](https://github.com/nodejs/node/pull/18480)
* [[`3e8e1524ac`](https://github.com/nodejs/node/commit/3e8e1524ac)] - **util**: use blue on non-windows systems for number (Gus Caplan) [#18925](https://github.com/nodejs/node/pull/18925)

<a id="9.7.1"></a>
## 2018-03-02, Version 9.7.1 (Current), @rvagg

No additional commits. New version published due to a bad node-v9.7.0.pkg file that was published to nodejs.org in the previous release.

<a id="9.7.0"></a>
## 2018-03-01, Version 9.7.0 (Current), @rvagg prepared by @addaleax

### Notable Changes

* **libuv**:
  - Updated to libuv 1.19.2 (Colin Ihrig) [#18918](https://github.com/nodejs/node/pull/18918)

* **src**:
  - Add initial support for Node.js-specific post-mortem metadata (Matheus Marchini) [#14901](https://github.com/nodejs/node/pull/14901)

* **timers**:
  - The return value of `setImmediate()` now has `ref()` and `unref()` methods (Anatoli Papirovski) [#18139](https://github.com/nodejs/node/pull/18139)

* **util**:
  - It is now possible to get the name for a numerical platform-specific error code as a string (Joyee Cheung) [#18186](https://github.com/nodejs/node/pull/18186)

### Commits

* [[`5ddef2988b`](https://github.com/nodejs/node/commit/5ddef2988b)] - **async_wrap**: schedule destroy hook as unref (Anatoli Papirovski) [#18241](https://github.com/nodejs/node/pull/18241)
* [[`be9777c5f6`](https://github.com/nodejs/node/commit/be9777c5f6)] - **benchmark**: add stream.pipe benchmarks (Mathias Buus) [#18617](https://github.com/nodejs/node/pull/18617)
* [[`4012ae8885`](https://github.com/nodejs/node/commit/4012ae8885)] - **build**: fix coverage build (Yihong Wang) [#18409](https://github.com/nodejs/node/pull/18409)
* [[`8c934990ef`](https://github.com/nodejs/node/commit/8c934990ef)] - **build**: add node\_lib\_target\_name to cctest deps (Daniel Bevenius) [#18576](https://github.com/nodejs/node/pull/18576)
* [[`f7e1402923`](https://github.com/nodejs/node/commit/f7e1402923)] - **build**: include the libuv and zlib into node (Yihong Wang) [#18383](https://github.com/nodejs/node/pull/18383)
* [[`237a363dc7`](https://github.com/nodejs/node/commit/237a363dc7)] - **build**: make gyp user defined variables lowercase (Daniel Bevenius) [#16238](https://github.com/nodejs/node/pull/16238)
* [[`16ef386507`](https://github.com/nodejs/node/commit/16ef386507)] - **build, win**: vcbuild improvements (Bartosz Sosnowski) [#17015](https://github.com/nodejs/node/pull/17015)
* [[`4fa1f3197f`](https://github.com/nodejs/node/commit/4fa1f3197f)] - **cluster**: fix inspector port assignment (Santiago Gimeno) [#18696](https://github.com/nodejs/node/pull/18696)
* [[`ec55965501`](https://github.com/nodejs/node/commit/ec55965501)] - **deps**: upgrade libuv to 1.19.2 (cjihrig) [#18918](https://github.com/nodejs/node/pull/18918)
* [[`7fb72a5fa3`](https://github.com/nodejs/node/commit/7fb72a5fa3)] - **deps,src**: align ssize\_t ABI between Node & nghttp2 (Anna Henningsen) [#18565](https://github.com/nodejs/node/pull/18565)
* [[`dd917eb946`](https://github.com/nodejs/node/commit/dd917eb946)] - **doc**: add pending-deprecation to deprecations list (Сковорода Никита Андреевич) [#18433](https://github.com/nodejs/node/pull/18433)
* [[`287946ddff`](https://github.com/nodejs/node/commit/287946ddff)] - **doc**: remove `Returns: {undefined}` (Sho Miyamoto) [#18951](https://github.com/nodejs/node/pull/18951)
* [[`4f454bde74`](https://github.com/nodejs/node/commit/4f454bde74)] - **doc**: mention git-node in the collaborator guide (Joyee Cheung) [#18960](https://github.com/nodejs/node/pull/18960)
* [[`4bc54238b2`](https://github.com/nodejs/node/commit/4bc54238b2)] - **doc**: update 2fa information in onboarding.md (Rich Trott) [#18968](https://github.com/nodejs/node/pull/18968)
* [[`b456e31964`](https://github.com/nodejs/node/commit/b456e31964)] - **doc**: add process.debugPort to doc/api/process.md (flickz) [#18716](https://github.com/nodejs/node/pull/18716)
* [[`6f177e7b5d`](https://github.com/nodejs/node/commit/6f177e7b5d)] - **doc**: `readable.push(undefined)` in non-object mode (陈刚) [#18283](https://github.com/nodejs/node/pull/18283)
* [[`85322518ca`](https://github.com/nodejs/node/commit/85322518ca)] - **doc**: remove extraneous "for example" text (Rich Trott) [#18890](https://github.com/nodejs/node/pull/18890)
* [[`38cf3cf494`](https://github.com/nodejs/node/commit/38cf3cf494)] - **doc**: update description of 'clientError' event (Luigi Pinca) [#18885](https://github.com/nodejs/node/pull/18885)
* [[`e447580872`](https://github.com/nodejs/node/commit/e447580872)] - **doc**: fix link in onboarding.md (Justin Lee) [#18878](https://github.com/nodejs/node/pull/18878)
* [[`205a84cf09`](https://github.com/nodejs/node/commit/205a84cf09)] - **doc**: remove CII badge in README (Roman Reiss) [#18908](https://github.com/nodejs/node/pull/18908)
* [[`1246902bae`](https://github.com/nodejs/node/commit/1246902bae)] - **errors**: move error creation helpers to errors.js (Joyee Cheung) [#18546](https://github.com/nodejs/node/pull/18546)
* [[`b3fe55aada`](https://github.com/nodejs/node/commit/b3fe55aada)] - **errors**: improve the description of ERR\_INVALID\_ARG\_VALUE (Joyee Cheung) [#18358](https://github.com/nodejs/node/pull/18358)
* [[`112c9a3a19`](https://github.com/nodejs/node/commit/112c9a3a19)] - **http**: remove default 'drain' listener on upgrade (Luigi Pinca) [#18866](https://github.com/nodejs/node/pull/18866)
* [[`c7f9608626`](https://github.com/nodejs/node/commit/c7f9608626)] - **http**: allow \_httpMessage to be GC'ed (Luigi Pinca) [#18865](https://github.com/nodejs/node/pull/18865)
* [[`738b0a1f2e`](https://github.com/nodejs/node/commit/738b0a1f2e)] - **lib**: add `process` to internal module wrapper (Anna Henningsen) [#17198](https://github.com/nodejs/node/pull/17198)
* [[`cfb78bc1df`](https://github.com/nodejs/node/commit/cfb78bc1df)] - **process**: use linked reusable queue for ticks (Mathias Buus) [#18617](https://github.com/nodejs/node/pull/18617)
* [[`4acea14197`](https://github.com/nodejs/node/commit/4acea14197)] - **process**: do not directly schedule \_tickCallback in \_fatalException (Anatoli Papirovski) [#17841](https://github.com/nodejs/node/pull/17841)
* [[`d348496345`](https://github.com/nodejs/node/commit/d348496345)] - **process**: refactor nextTick for clarity (Anatoli Papirovski) [#17738](https://github.com/nodejs/node/pull/17738)
* [[`cf0b95c4b1`](https://github.com/nodejs/node/commit/cf0b95c4b1)] - **process**: use more direct sync I/O for stdio (Anna Henningsen) [#18019](https://github.com/nodejs/node/pull/18019)
* [[`b4c933dd44`](https://github.com/nodejs/node/commit/b4c933dd44)] - **promises**: refactor rejection handling (Anatoli Papirovski) [#18207](https://github.com/nodejs/node/pull/18207)
* [[`01398b29e9`](https://github.com/nodejs/node/commit/01398b29e9)] - **repl**: fix tab-complete warning (killagu) [#18881](https://github.com/nodejs/node/pull/18881)
* [[`e33b9fa7b5`](https://github.com/nodejs/node/commit/e33b9fa7b5)] - **src**: fix GetCpuProfiler() deprecation warning (Ben Noordhuis) [#18534](https://github.com/nodejs/node/pull/18534)
* [[`91694497ba`](https://github.com/nodejs/node/commit/91694497ba)] - **src**: refactor WriteWrap and ShutdownWraps (Anna Henningsen) [#18676](https://github.com/nodejs/node/pull/18676)
* [[`fa691f7d95`](https://github.com/nodejs/node/commit/fa691f7d95)] - **src**: only set JSStreamWrap write req after `write()` (Anna Henningsen) [#18676](https://github.com/nodejs/node/pull/18676)
* [[`296523a698`](https://github.com/nodejs/node/commit/296523a698)] - **src**: remove unnecessary async hooks check (Anatoli Papirovski) [#18291](https://github.com/nodejs/node/pull/18291)
* [[`4de4c54069`](https://github.com/nodejs/node/commit/4de4c54069)] - **src**: expose uv.errmap to binding (Joyee Cheung) [#17338](https://github.com/nodejs/node/pull/17338)
* [[`189e566076`](https://github.com/nodejs/node/commit/189e566076)] - **src**: do not redefine private for GenDebugSymbols (Joyee Cheung) [#18653](https://github.com/nodejs/node/pull/18653)
* [[`07c6fb983b`](https://github.com/nodejs/node/commit/07c6fb983b)] - **src**: use AliasedBuffer for TickInfo (Anatoli Papirovski) [#17881](https://github.com/nodejs/node/pull/17881)
* [[`684684e567`](https://github.com/nodejs/node/commit/684684e567)] - **src**: simplify handles for libuv streams (Anna Henningsen) [#18334](https://github.com/nodejs/node/pull/18334)
* [[`cb5ed45603`](https://github.com/nodejs/node/commit/cb5ed45603)] - **src**: refactor stream callbacks and ownership (Anna Henningsen) [#18334](https://github.com/nodejs/node/pull/18334)
* [[`f60757796b`](https://github.com/nodejs/node/commit/f60757796b)] - **src**: use `DoTryWrite()` for not-all-Buffer writev()s too (Anna Henningsen) [#18019](https://github.com/nodejs/node/pull/18019)
* [[`f17987ba16`](https://github.com/nodejs/node/commit/f17987ba16)] - **src**: remove `HasWriteQueue()` (Anna Henningsen) [#18019](https://github.com/nodejs/node/pull/18019)
* [[`2282dceb29`](https://github.com/nodejs/node/commit/2282dceb29)] - **src**: remove node namespace qualifiers (Daniel Bevenius) [#18962](https://github.com/nodejs/node/pull/18962)
* [[`6e7aa3d8f4`](https://github.com/nodejs/node/commit/6e7aa3d8f4)] - **src**: fix abort when taking a heap snapshot (Ben Noordhuis) [#18898](https://github.com/nodejs/node/pull/18898)
* [[`a17d6840e1`](https://github.com/nodejs/node/commit/a17d6840e1)] - **src**: fix deprecation warning in node\_perf.cc (Daniel Bevenius) [#18877](https://github.com/nodejs/node/pull/18877)
* [[`46fc507054`](https://github.com/nodejs/node/commit/46fc507054)] - **(SEMVER-MINOR)** **src, test**: node internals' postmortem metadata (Matheus Marchini) [#14901](https://github.com/nodejs/node/pull/14901)
* [[`7853a7fd2a`](https://github.com/nodejs/node/commit/7853a7fd2a)] - **test**: add test for stream unpipe with 'data' listeners (Anna Henningsen) [#18516](https://github.com/nodejs/node/pull/18516)
* [[`3543c5543b`](https://github.com/nodejs/node/commit/3543c5543b)] - **test**: make sure WriteWrap tests are actually async (Anna Henningsen) [#18676](https://github.com/nodejs/node/pull/18676)
* [[`7dd3c8af88`](https://github.com/nodejs/node/commit/7dd3c8af88)] - **test**: add url type check in Module options (JiaHerr Tee) [#18664](https://github.com/nodejs/node/pull/18664)
* [[`1be5e33f03`](https://github.com/nodejs/node/commit/1be5e33f03)] - **test**: replace assert.throws with expectsError (sreepurnajasti) [#17997](https://github.com/nodejs/node/pull/17997)
* [[`df0d78a7e9`](https://github.com/nodejs/node/commit/df0d78a7e9)] - **test**: stdio pipe behavior tests (Bartosz Sosnowski) [#18614](https://github.com/nodejs/node/pull/18614)
* [[`35cddae18f`](https://github.com/nodejs/node/commit/35cddae18f)] - **test**: fix cctest -Wunused-variable warning (Ben Noordhuis) [#18530](https://github.com/nodejs/node/pull/18530)
* [[`743cf33616`](https://github.com/nodejs/node/commit/743cf33616)] - **test**: introduce SetUpTestCase/TearDownTestCase (Daniel Bevenius) [#18558](https://github.com/nodejs/node/pull/18558)
* [[`edba129df3`](https://github.com/nodejs/node/commit/edba129df3)] - **test**: http2 compat response.write() error checks (Trivikram) [#18859](https://github.com/nodejs/node/pull/18859)
* [[`f2dd17bde9`](https://github.com/nodejs/node/commit/f2dd17bde9)] - **(SEMVER-MINOR)** **timers**: allow Immediates to be unrefed (Anatoli Papirovski) [#18139](https://github.com/nodejs/node/pull/18139)
* [[`37f253e88f`](https://github.com/nodejs/node/commit/37f253e88f)] - **timers**: refactor setImmediate error handling (Anatoli Papirovski) [#17879](https://github.com/nodejs/node/pull/17879)
* [[`8474f86e9f`](https://github.com/nodejs/node/commit/8474f86e9f)] - **timers**: make setImmediate() immune to tampering (Ben Noordhuis) [#17736](https://github.com/nodejs/node/pull/17736)
* [[`484e06d89a`](https://github.com/nodejs/node/commit/484e06d89a)] - **tls**: use after free in tls\_wrap (Kyle Farnung) [#18860](https://github.com/nodejs/node/pull/18860)
* [[`efb4646539`](https://github.com/nodejs/node/commit/efb4646539)] - **tls_wrap**: use DoTryWrite() (Anna Henningsen) [#18676](https://github.com/nodejs/node/pull/18676)
* [[`d255db3ae7`](https://github.com/nodejs/node/commit/d255db3ae7)] - **tools**: ignore VS compiler output in deps/v8 (Michaël Zasso) [#18952](https://github.com/nodejs/node/pull/18952)
* [[`fc6ee39ea6`](https://github.com/nodejs/node/commit/fc6ee39ea6)] - **tools**: fix custom eslint rule errors (Ruben Bridgewater) [#18853](https://github.com/nodejs/node/pull/18853)
* [[`f8691398e4`](https://github.com/nodejs/node/commit/f8691398e4)] - **tools, test**: fix prof polyfill readline (killagu) [#18641](https://github.com/nodejs/node/pull/18641)
* [[`38fd7902ef`](https://github.com/nodejs/node/commit/38fd7902ef)] - **tty**: fix console printing on Windows (Anna Henningsen) [#18214](https://github.com/nodejs/node/pull/18214)
* [[`def51bafbd`](https://github.com/nodejs/node/commit/def51bafbd)] - **url**: reduce deplicated codes in `autoEscapeStr` (Weijia Wang) [#18613](https://github.com/nodejs/node/pull/18613)
* [[`8e31bf42cf`](https://github.com/nodejs/node/commit/8e31bf42cf)] - **util**: skip type checks in internal getSystemErrorName (Joyee Cheung) [#18546](https://github.com/nodejs/node/pull/18546)
* [[`28fa906ec1`](https://github.com/nodejs/node/commit/28fa906ec1)] - **(SEMVER-MINOR)** **util**: implement util.getSystemErrorName() (Joyee Cheung) [#18186](https://github.com/nodejs/node/pull/18186)
* [[`38797b5804`](https://github.com/nodejs/node/commit/38797b5804)] - **vm**: consolidate validation (Timothy O. Peters) [#18816](https://github.com/nodejs/node/pull/18816)

<a id="9.6.1"></a>
## 2018-02-22, Version 9.6.1 (Current), @MylesBorins

This is a special release to fix potentially Semver-Major regression that was released in v9.6.0

### Notable Changes

* **events**:
  - `events.usingDomains` being set to `false` by default was removed in 9.6.0 which was a change in behavior compares to 9.5.0. This behavior change has been reverted and the `events` object now has `usingDomains` preset to `false`, which is the behavior in 9.x prior to 9.6.0 (Myles Borins) [#18944](https://github.com/nodejs/node/pull/18944)

### Commits

* [[`761caec379`](https://github.com/nodejs/node/commit/761caec379)] - **events**: preset `usingDomains` to false (Myles Borins) [#18944](https://github.com/nodejs/node/pull/18944)

<a id="9.6.0"></a>
## 2018-02-22, Version 9.6.0 (Current), @MylesBorins

### Notable Changes

* **async_hooks**:
  - deprecate unsafe emit{Before,After} (Ali Ijaz Sheikh) [#18513](https://github.com/nodejs/node/pull/18513)
  - rename PromiseWrap.parentId to PromiseWrap.isChainedPromise (Ali Ijaz Sheikh) [#18633](https://github.com/nodejs/node/pull/18633)
* **deps**:
  - update node-inspect to 1.11.3 (Jan Krems) [#18354](https://github.com/nodejs/node/pull/18354)
  - ICU 60.2 bump (Steven R. Loomis) [#17687](https://github.com/nodejs/node/pull/17687)
  - Introduce ScriptOrModule and HostDefinedOptions to V8 (Jan Krems) [#16889](https://github.com/nodejs/node/pull/16889)
* **http**:
  - add options to http.createServer() for `IncomingMessage` and `ServerReponse` (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)
* **http2**:
  - add http fallback options to .createServer (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)
* **https**:
  - Adds the remaining options from tls.createSecureContext() to the string generated by Agent#getName(). This allows https.request() to accept the options and generate unique sockets appropriately. (Jeff Principe) [#16402](https://github.com/nodejs/node/pull/16402)
* **inspector**:
  - --inspect-brk for es modules (Guy Bedford) [#18194](https://github.com/nodejs/node/pull/18194)
* **lib**:
  - allow process kill by signal number (Sam Roberts) [#16944](https://github.com/nodejs/node/pull/16944)
* **module**:
  - enable dynamic import (Myles Borins) [#18387](https://github.com/nodejs/node/pull/18387)
  - dynamic import is now supported (Jan Krems) [#15713](https://github.com/nodejs/node/pull/15713)
* **n-api**:
  - add methods to open/close callback scope (Michael Dawson) [#18089](https://github.com/nodejs/node/pull/18089)
* **src**:
  - allow --perf-(basic-)?prof in NODE_OPTIONS (Leko) [#17600](https://github.com/nodejs/node/pull/17600)
* **vm**:
  - add support for es modules (Gus Caplan) [#17560](https://github.com/nodejs/node/pull/17560)

### Commits

* [[`7f5334e243`](https://github.com/nodejs/node/commit/7f5334e243)] - **(SEMVER-MINOR)** **async_hooks**: deprecate unsafe emit{Before,After} (Ali Ijaz Sheikh) [#18513](https://github.com/nodejs/node/pull/18513)
* [[`8e39c3bfd6`](https://github.com/nodejs/node/commit/8e39c3bfd6)] - **(SEMVER-MINOR)** **async_hooks**: rename PromiseWrap.parentId (Ali Ijaz Sheikh) [#18633](https://github.com/nodejs/node/pull/18633)
* [[`0865d11c08`](https://github.com/nodejs/node/commit/0865d11c08)] - **async_hooks**: clean up comments (Ali Ijaz Sheikh) [#18467](https://github.com/nodejs/node/pull/18467)
* [[`4d78eb8663`](https://github.com/nodejs/node/commit/4d78eb8663)] - **benchmark**: improve compare output (Ruben Bridgewater) [#18597](https://github.com/nodejs/node/pull/18597)
* [[`ffbad8350e`](https://github.com/nodejs/node/commit/ffbad8350e)] - **benchmark**: spread operator benchmark (James M Snell) [#18442](https://github.com/nodejs/node/pull/18442)
* [[`9ae513a7de`](https://github.com/nodejs/node/commit/9ae513a7de)] - **benchmark**: shorten config name in http benchmark (Joyee Cheung) [#18452](https://github.com/nodejs/node/pull/18452)
* [[`d469a06ace`](https://github.com/nodejs/node/commit/d469a06ace)] - **benchmark**: cut down http benchmark run time (Joyee Cheung) [#18379](https://github.com/nodejs/node/pull/18379)
* [[`9c125825a9`](https://github.com/nodejs/node/commit/9c125825a9)] - **benchmark**: refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`f0186704cd`](https://github.com/nodejs/node/commit/f0186704cd)] - **benchmark**: (timers) refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`28156e16d1`](https://github.com/nodejs/node/commit/28156e16d1)] - **benchmark**: (http(2)) refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`076b3d9b0a`](https://github.com/nodejs/node/commit/076b3d9b0a)] - **benchmark**: (es) refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`76cb958975`](https://github.com/nodejs/node/commit/76cb958975)] - **benchmark**: (url) refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`0851822b87`](https://github.com/nodejs/node/commit/0851822b87)] - **benchmark**: (crypto) refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`cb13c7c653`](https://github.com/nodejs/node/commit/cb13c7c653)] - **benchmark**: (buffer) refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`9acf7545f0`](https://github.com/nodejs/node/commit/9acf7545f0)] - **benchmark**: (assert) refactor (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`7da01f43fd`](https://github.com/nodejs/node/commit/7da01f43fd)] - **benchmark**: fix variables not being set (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`4a5d7d4248`](https://github.com/nodejs/node/commit/4a5d7d4248)] - **benchmark**: fix platform in basename-win32 (Ruben Bridgewater) [#18320](https://github.com/nodejs/node/pull/18320)
* [[`f3ab106750`](https://github.com/nodejs/node/commit/f3ab106750)] - **buffer**: remove obsolete NaN check (Ruben Bridgewater) [#18744](https://github.com/nodejs/node/pull/18744)
* [[`c38576e526`](https://github.com/nodejs/node/commit/c38576e526)] - **buffer**: simplify check size in assertSize (Mihail Bodrov) [#18665](https://github.com/nodejs/node/pull/18665)
* [[`080368b5d0`](https://github.com/nodejs/node/commit/080368b5d0)] - **build**: no longer have v8-debug.h as dependency. (Yang Guo) [#18677](https://github.com/nodejs/node/pull/18677)
* [[`15db2969fe`](https://github.com/nodejs/node/commit/15db2969fe)] - **build**: do not suppress output in make doc-only (Joyee Cheung) [#18507](https://github.com/nodejs/node/pull/18507)
* [[`c642e229da`](https://github.com/nodejs/node/commit/c642e229da)] - **build**: add doc linting when runnning `make lint` (Camilo Gonzalez) [#18472](https://github.com/nodejs/node/pull/18472)
* [[`be5c293d73`](https://github.com/nodejs/node/commit/be5c293d73)] - **build**: allow x86_64 as a dest_cpu alias for x64 (Rod Vagg) [#18052](https://github.com/nodejs/node/pull/18052)
* [[`9c6bb5f386`](https://github.com/nodejs/node/commit/9c6bb5f386)] - **build**: add cflags for OpenBSD, remove stray comma. (Aaron Bieber) [#18448](https://github.com/nodejs/node/pull/18448)
* [[`2c7de9df50`](https://github.com/nodejs/node/commit/2c7de9df50)] - **build,win**: replace run-python subroutine with single find_python call (Nikolai Vavilov) [#18621](https://github.com/nodejs/node/pull/18621)
* [[`91f2cf9297`](https://github.com/nodejs/node/commit/91f2cf9297)] - **child_process**: fix stdio sockets creation (Santiago Gimeno) [#18701](https://github.com/nodejs/node/pull/18701)
* [[`a893b42791`](https://github.com/nodejs/node/commit/a893b42791)] - **crypto**: use non-deprecated v8::Object::Set (Daniel Bevenius) [#17482](https://github.com/nodejs/node/pull/17482)
* [[`2d98b58c08`](https://github.com/nodejs/node/commit/2d98b58c08)] - **deps**: V8: backport 76c3ac5 from upstream (Ali Ijaz Sheikh) [#18298](https://github.com/nodejs/node/pull/18298)
* [[`442903fb1b`](https://github.com/nodejs/node/commit/442903fb1b)] - **deps**: update node-inspect to 1.11.3 (Jan Krems) [#18354](https://github.com/nodejs/node/pull/18354)
* [[`9e7f8633b6`](https://github.com/nodejs/node/commit/9e7f8633b6)] - **deps**: ICU 60.2 bump (Steven R. Loomis) [#17687](https://github.com/nodejs/node/pull/17687)
* [[`11566fe532`](https://github.com/nodejs/node/commit/11566fe532)] - **deps**: cherry-pick dbfe4a49d8 from upstream V8 (Jan Krems) [#16889](https://github.com/nodejs/node/pull/16889)
* [[`6edf952628`](https://github.com/nodejs/node/commit/6edf952628)] - **doc**: fix nits in tools/doc/README.md (Vse Mozhet Byt) [#18874](https://github.com/nodejs/node/pull/18874)
* [[`7624686888`](https://github.com/nodejs/node/commit/7624686888)] - **doc**: fix minor grammar/typographical issues in onboarding.md (Rich Trott) [#18847](https://github.com/nodejs/node/pull/18847)
* [[`2f836e76bd`](https://github.com/nodejs/node/commit/2f836e76bd)] - **doc**: update onboarding.md for faster exercise completion (Rich Trott) [#18846](https://github.com/nodejs/node/pull/18846)
* [[`e1f82735fe`](https://github.com/nodejs/node/commit/e1f82735fe)] - **doc**: improved documentation for fs.unlink() (dustinnewman98) [#18843](https://github.com/nodejs/node/pull/18843)
* [[`63b0c158f7`](https://github.com/nodejs/node/commit/63b0c158f7)] - **doc**: fix broken link in pull-requests.md (Justin Lee) [#18873](https://github.com/nodejs/node/pull/18873)
* [[`8047c27855`](https://github.com/nodejs/node/commit/8047c27855)] - **doc**: fix typo in http2.md (Vse Mozhet Byt) [#18872](https://github.com/nodejs/node/pull/18872)
* [[`0dd8ea4a00`](https://github.com/nodejs/node/commit/0dd8ea4a00)] - **doc**: refactor manpage to use mdoc(7) macros (Alhadis) [#18559](https://github.com/nodejs/node/pull/18559)
* [[`33271e60f3`](https://github.com/nodejs/node/commit/33271e60f3)] - **doc**: mark accessing IPC channel fd as undefined (Bartosz Sosnowski) [#17545](https://github.com/nodejs/node/pull/17545)
* [[`02e9e9949c`](https://github.com/nodejs/node/commit/02e9e9949c)] - **doc**: fix minor typos in GOVERNANCE.md (Rich Trott) [#18829](https://github.com/nodejs/node/pull/18829)
* [[`1bff0aaae5`](https://github.com/nodejs/node/commit/1bff0aaae5)] - **doc**: add Yihong Wang to collaborators (Yihong Wang) [#18824](https://github.com/nodejs/node/pull/18824)
* [[`1c77929231`](https://github.com/nodejs/node/commit/1c77929231)] - **doc**: warn against concurrent http2stream.respondWithFD (Anna Henningsen) [#18762](https://github.com/nodejs/node/pull/18762)
* [[`cd2fa0412f`](https://github.com/nodejs/node/commit/cd2fa0412f)] - **doc**: activate `no-multiple-empty-lines` rule (Ruben Bridgewater) [#18747](https://github.com/nodejs/node/pull/18747)
* [[`20ad397f93`](https://github.com/nodejs/node/commit/20ad397f93)] - **doc**: note that linting is required in releases.md (Gibson Fahnestock) [#18776](https://github.com/nodejs/node/pull/18776)
* [[`0fc33fb282`](https://github.com/nodejs/node/commit/0fc33fb282)] - **doc**: remove extra space in README.md (Matheus Marchini) [#18822](https://github.com/nodejs/node/pull/18822)
* [[`9bec493510`](https://github.com/nodejs/node/commit/9bec493510)] - **doc**: update crypo Certficate class. (Antoine AMARA) [#18721](https://github.com/nodejs/node/pull/18721)
* [[`17d4dd5cce`](https://github.com/nodejs/node/commit/17d4dd5cce)] - **doc**: move Fedor to TSC Emeritus (Myles Borins) [#18752](https://github.com/nodejs/node/pull/18752)
* [[`92ed0710da`](https://github.com/nodejs/node/commit/92ed0710da)] - **doc**: add mmarchini to collaborators (Matheus Marchini) [#18740](https://github.com/nodejs/node/pull/18740)
* [[`b5073a0744`](https://github.com/nodejs/node/commit/b5073a0744)] - **doc**: mark NAPI_AUTO_LENGTH as code (Tobias Nießen) [#18697](https://github.com/nodejs/node/pull/18697)
* [[`3cfb313e8e`](https://github.com/nodejs/node/commit/3cfb313e8e)] - **doc**: add error check to fs example (Evan Lucas) [#18681](https://github.com/nodejs/node/pull/18681)
* [[`876e186573`](https://github.com/nodejs/node/commit/876e186573)] - **doc**: fix exporting a function example (Aonghus O Nia) [#18661](https://github.com/nodejs/node/pull/18661)
* [[`7b377cffdb`](https://github.com/nodejs/node/commit/7b377cffdb)] - **doc**: add history for url.parse (Steven) [#18685](https://github.com/nodejs/node/pull/18685)
* [[`4981e98889`](https://github.com/nodejs/node/commit/4981e98889)] - **doc**: fix links to Style Guide and CPP Style Guide (Justin Lee) [#18683](https://github.com/nodejs/node/pull/18683)
* [[`af977dbf49`](https://github.com/nodejs/node/commit/af977dbf49)] - **doc**: add devsnek to collaborators (Gus Caplan) [#18679](https://github.com/nodejs/node/pull/18679)
* [[`f0f01039b4`](https://github.com/nodejs/node/commit/f0f01039b4)] - **doc**: fix links in YAML metadata of assert.md (Vse Mozhet Byt) [#18670](https://github.com/nodejs/node/pull/18670)
* [[`832e0522eb`](https://github.com/nodejs/node/commit/832e0522eb)] - **doc**: add missing meta for createCipheriv (Tobias Nießen) [#18651](https://github.com/nodejs/node/pull/18651)
* [[`affddd372a`](https://github.com/nodejs/node/commit/affddd372a)] - **doc**: fix description of createDecipheriv (Tobias Nießen) [#18651](https://github.com/nodejs/node/pull/18651)
* [[`4722004900`](https://github.com/nodejs/node/commit/4722004900)] - **doc**: fix MDN links to avoid redirections (Vse Mozhet Byt) [#18631](https://github.com/nodejs/node/pull/18631)
* [[`e7508e5fcd`](https://github.com/nodejs/node/commit/e7508e5fcd)] - **doc**: fix link in https.md (Vse Mozhet Byt) [#18630](https://github.com/nodejs/node/pull/18630)
* [[`dc4da22220`](https://github.com/nodejs/node/commit/dc4da22220)] - **doc**: be more explicit in the sypnosis (Tim O. Peters) [#17977](https://github.com/nodejs/node/pull/17977)
* [[`54391548d0`](https://github.com/nodejs/node/commit/54391548d0)] - **doc**: add missing "changes" key in YAML comment (Luigi Pinca) [#18605](https://github.com/nodejs/node/pull/18605)
* [[`7241fa0fbd`](https://github.com/nodejs/node/commit/7241fa0fbd)] - **doc**: fix typo in http2.md (Vse Mozhet Byt) [#18602](https://github.com/nodejs/node/pull/18602)
* [[`7a432c1af3`](https://github.com/nodejs/node/commit/7a432c1af3)] - **doc**: update onboarding-extras (Gus Caplan) [#18545](https://github.com/nodejs/node/pull/18545)
* [[`c18d958750`](https://github.com/nodejs/node/commit/c18d958750)] - **doc**: modify the return value of request.write() (陈刚) [#18526](https://github.com/nodejs/node/pull/18526)
* [[`e8a75ee113`](https://github.com/nodejs/node/commit/e8a75ee113)] - **doc**: fix typo in n-api.md (Vse Mozhet Byt) [#18590](https://github.com/nodejs/node/pull/18590)
* [[`4f521c7896`](https://github.com/nodejs/node/commit/4f521c7896)] - **doc**: add introduce about cli options (Weijia Wang) [#18475](https://github.com/nodejs/node/pull/18475)
* [[`4dea9e03d6`](https://github.com/nodejs/node/commit/4dea9e03d6)] - **doc**: small typo in n-api.md (iskore) [#18555](https://github.com/nodejs/node/pull/18555)
* [[`6256d70916`](https://github.com/nodejs/node/commit/6256d70916)] - **doc**: add section for strategic initiatives (Michael Dawson) [#17104](https://github.com/nodejs/node/pull/17104)
* [[`5f0b3431e1`](https://github.com/nodejs/node/commit/5f0b3431e1)] - **doc**: remove usage of you in n-api doc (Michael Dawson) [#18528](https://github.com/nodejs/node/pull/18528)
* [[`2418c86c1e`](https://github.com/nodejs/node/commit/2418c86c1e)] - **doc**: expand on promises and async_hooks (Ali Ijaz Sheikh) [#18540](https://github.com/nodejs/node/pull/18540)
* [[`a7ad003e37`](https://github.com/nodejs/node/commit/a7ad003e37)] - **doc**: shell option for the execFile and execFileSync functions (jvelezpo) [#18237](https://github.com/nodejs/node/pull/18237)
* [[`dae86b3edb`](https://github.com/nodejs/node/commit/dae86b3edb)] - **doc**: improve http.request documentation (Guangcong Luo) [#18289](https://github.com/nodejs/node/pull/18289)
* [[`ffc8e8eb40`](https://github.com/nodejs/node/commit/ffc8e8eb40)] - **doc**: remove removed apis from http2 docs (Kelvin Jin) [#18439](https://github.com/nodejs/node/pull/18439)
* [[`25a7bdece5`](https://github.com/nodejs/node/commit/25a7bdece5)] - **doc**: streamline README intro (Rich Trott) [#18483](https://github.com/nodejs/node/pull/18483)
* [[`58003d4ddf`](https://github.com/nodejs/node/commit/58003d4ddf)] - **doc**: move Brian White to TSC Emeriti list (Rich Trott) [#18482](https://github.com/nodejs/node/pull/18482)
* [[`74a823c788`](https://github.com/nodejs/node/commit/74a823c788)] - **doc**: improve stream documentation (陈刚) [#18375](https://github.com/nodejs/node/pull/18375)
* [[`ae372f0e3d`](https://github.com/nodejs/node/commit/ae372f0e3d)] - **doc**: linkify missing types (Vse Mozhet Byt) [#18444](https://github.com/nodejs/node/pull/18444)
* [[`22093abbc8`](https://github.com/nodejs/node/commit/22093abbc8)] - **doc**: add Gibson Fahnestock to TSC (Rich Trott) [#18481](https://github.com/nodejs/node/pull/18481)
* [[`61d4e1d207`](https://github.com/nodejs/node/commit/61d4e1d207)] - **doc**: reorder section on updating PR branch (Ali Ijaz Sheikh) [#18355](https://github.com/nodejs/node/pull/18355)
* [[`8a627b17a4`](https://github.com/nodejs/node/commit/8a627b17a4)] - **doc**: add pending-deprecation to COLLABORATOR_GUIDE (Сковорода Никита Андреевич) [#18433](https://github.com/nodejs/node/pull/18433)
* [[`b76e111ee4`](https://github.com/nodejs/node/commit/b76e111ee4)] - **doc**: fix manpage warnings (Roman Reiss)
* [[`b841abc328`](https://github.com/nodejs/node/commit/b841abc328)] - **doc**: warn about GCM authenticity (Tobias Nießen) [#18376](https://github.com/nodejs/node/pull/18376)
* [[`2d968ca0d5`](https://github.com/nodejs/node/commit/2d968ca0d5)] - **doc**: Update tools/icu/README.md (Steven R. Loomis) [#16939](https://github.com/nodejs/node/pull/16939)
* [[`8c6dc62dc4`](https://github.com/nodejs/node/commit/8c6dc62dc4)] - **doc**: dedupe links (Vse Mozhet Byt) [#18213](https://github.com/nodejs/node/pull/18213)
* [[`6b1a40e914`](https://github.com/nodejs/node/commit/6b1a40e914)] - **doc**: capitalize non-primitive types (Vse Mozhet Byt) [#18111](https://github.com/nodejs/node/pull/18111)
* [[`44bf0f4f12`](https://github.com/nodejs/node/commit/44bf0f4f12)] - **domain**: further abstract usage in C++ (Anatoli Papirovski) [#18291](https://github.com/nodejs/node/pull/18291)
* [[`35471bcfdf`](https://github.com/nodejs/node/commit/35471bcfdf)] - **domain**: fix error emit handling (Anatoli Papirovski) [#17588](https://github.com/nodejs/node/pull/17588)
* [[`28edc1db99`](https://github.com/nodejs/node/commit/28edc1db99)] - **events**: use Reflect.apply (Anatoli Papirovski) [#17456](https://github.com/nodejs/node/pull/17456)
* [[`3ae5cf205f`](https://github.com/nodejs/node/commit/3ae5cf205f)] - **events**: move domain handling from events to domain (vdeturckheim) [#17403](https://github.com/nodejs/node/pull/17403)
* [[`0568f755da`](https://github.com/nodejs/node/commit/0568f755da)] - **fs**: remove useless comments which duplicate names of variables (Sergey Golovin) [#18739](https://github.com/nodejs/node/pull/18739)
* [[`5b75572494`](https://github.com/nodejs/node/commit/5b75572494)] - **fs**: replace magic numbers by named constants (Sergey Golovin) [#18757](https://github.com/nodejs/node/pull/18757)
* [[`35ce3a8931`](https://github.com/nodejs/node/commit/35ce3a8931)] - **fs**: make URL paths no longer experimental (James M Snell) [#18591](https://github.com/nodejs/node/pull/18591)
* [[`34f49343ee`](https://github.com/nodejs/node/commit/34f49343ee)] - **fs**: fix stack overflow in fs.readdirSync (Joyee Cheung) [#18647](https://github.com/nodejs/node/pull/18647)
* [[`6ce8b24c6d`](https://github.com/nodejs/node/commit/6ce8b24c6d)] - **http**: simplify checkInvalidHeaderChar (Seth Brenith) [#18381](https://github.com/nodejs/node/pull/18381)
* [[`c247cb02a1`](https://github.com/nodejs/node/commit/c247cb02a1)] - **(SEMVER-MINOR)** **http**: add options to http.createServer() (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)
* [[`935eac189d`](https://github.com/nodejs/node/commit/935eac189d)] - **http**: remove domain specific code (Anatoli Papirovski) [#18477](https://github.com/nodejs/node/pull/18477)
* [[`8b2a272772`](https://github.com/nodejs/node/commit/8b2a272772)] - **http**: process headers after setting up agent (Rod Vagg) [#16568](https://github.com/nodejs/node/pull/16568)
* [[`d76403985f`](https://github.com/nodejs/node/commit/d76403985f)] - **http**: switch on string values (Seth Brenith) [#18351](https://github.com/nodejs/node/pull/18351)
* [[`5e5276b418`](https://github.com/nodejs/node/commit/5e5276b418)] - **http2**: use `_final` instead of `on('finish')` (Anna Henningsen) [#18609](https://github.com/nodejs/node/pull/18609)
* [[`c0d6945f4c`](https://github.com/nodejs/node/commit/c0d6945f4c)] - **http2**: add req and res options to server creation (Peter Marton) [#15560](https://github.com/nodejs/node/pull/15560)
* [[`7806c51f30`](https://github.com/nodejs/node/commit/7806c51f30)] - **(SEMVER-MINOR)** **http2**: add http fallback options to .createServer (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)
* [[`7c682f2fd0`](https://github.com/nodejs/node/commit/7c682f2fd0)] - **(SEMVER-MINOR)** **https**: add extra options to Agent#getName() (Jeff Principe) [#16402](https://github.com/nodejs/node/pull/16402)
* [[`74051c64aa`](https://github.com/nodejs/node/commit/74051c64aa)] - **inspector**: --inspect-brk for es modules (Guy Bedford) [#18194](https://github.com/nodejs/node/pull/18194)
* [[`741e82e710`](https://github.com/nodejs/node/commit/741e82e710)] - **(SEMVER-MINOR)** **lib**: allow process kill by signal number (Sam Roberts) [#16944](https://github.com/nodejs/node/pull/16944)
* [[`810925bc17`](https://github.com/nodejs/node/commit/810925bc17)] - **lib**: replace `eval` with `vm.runInThisContext` (Myles Borins) [#18623](https://github.com/nodejs/node/pull/18623)
* [[`16aeddda24`](https://github.com/nodejs/node/commit/16aeddda24)] - **lib**: switch to Number.isNaN (Ruben Bridgewater) [#18744](https://github.com/nodejs/node/pull/18744)
* [[`1557d93a2b`](https://github.com/nodejs/node/commit/1557d93a2b)] - **lib**: set process.execPath on OpenBSD (Aaron Bieber) [#18543](https://github.com/nodejs/node/pull/18543)
* [[`0a97e1d2c0`](https://github.com/nodejs/node/commit/0a97e1d2c0)] - **lib**: provide proper deprecation code (Ruben Bridgewater) [#18694](https://github.com/nodejs/node/pull/18694)
* [[`51a8e1d2d8`](https://github.com/nodejs/node/commit/51a8e1d2d8)] - **lib**: remove debugger dead code (Qingyan Li) [#18426](https://github.com/nodejs/node/pull/18426)
* [[`650ec2d8f1`](https://github.com/nodejs/node/commit/650ec2d8f1)] - **lib**: extract validation functions (Timothy O. Peters) [#18421](https://github.com/nodejs/node/pull/18421)
* [[`1fd1395ee9`](https://github.com/nodejs/node/commit/1fd1395ee9)] - **lib,doc**: revert format name to cjs over commonjs (Guy Bedford) [#18596](https://github.com/nodejs/node/pull/18596)
* [[`cb36b6733c`](https://github.com/nodejs/node/commit/cb36b6733c)] - **loader**: fix up #18394 (Gus Caplan) [#18509](https://github.com/nodejs/node/pull/18509)
* [[`afc87c22d0`](https://github.com/nodejs/node/commit/afc87c22d0)] - **module**: refactor loader (Gus Caplan) [#16874](https://github.com/nodejs/node/pull/16874)
* [[`d89f310127`](https://github.com/nodejs/node/commit/d89f310127)] - **module**: enable dynamic import flag for esmodules (Myles Borins) [#18387](https://github.com/nodejs/node/pull/18387)
* [[`00d5422c43`](https://github.com/nodejs/node/commit/00d5422c43)] - **module**: Set dynamic import callback (Jan Krems) [#15713](https://github.com/nodejs/node/pull/15713)
* [[`9c818cfa83`](https://github.com/nodejs/node/commit/9c818cfa83)] - **n-api**: remove extra reference from test (Gabriel Schulhof) [#18542](https://github.com/nodejs/node/pull/18542)
* [[`4bf8b6a62d`](https://github.com/nodejs/node/commit/4bf8b6a62d)] - **(SEMVER-MINOR)** **n-api**: add methods to open/close callback scope (Michael Dawson) [#18089](https://github.com/nodejs/node/pull/18089)
* [[`d2581120da`](https://github.com/nodejs/node/commit/d2581120da)] - **n-api**: wrap control flow macro in do/while (Ben Noordhuis) [#18532](https://github.com/nodejs/node/pull/18532)
* [[`ae8f5db1b1`](https://github.com/nodejs/node/commit/ae8f5db1b1)] - **n-api**: implement wrapping using private properties (Gabriel Schulhof) [#18311](https://github.com/nodejs/node/pull/18311)
* [[`a07cd06e6c`](https://github.com/nodejs/node/commit/a07cd06e6c)] - **n-api**: change assert ok check to notStrictEqual. (Aaron Kau) [#18414](https://github.com/nodejs/node/pull/18414)
* [[`b9ea4c46e5`](https://github.com/nodejs/node/commit/b9ea4c46e5)] - **net**: simplify net.Socket#end() (Anna Henningsen) [#18708](https://github.com/nodejs/node/pull/18708)
* [[`6ed4e690e4`](https://github.com/nodejs/node/commit/6ed4e690e4)] - **net**: remove Socket.prototoype.read (Anna Henningsen) [#18568](https://github.com/nodejs/node/pull/18568)
* [[`958f5eda9a`](https://github.com/nodejs/node/commit/958f5eda9a)] - **net**: remove redundant code from _writeGeneric() (Luigi Pinca) [#18429](https://github.com/nodejs/node/pull/18429)
* [[`25ce45825f`](https://github.com/nodejs/node/commit/25ce45825f)] - **net,src**: refactor writeQueueSize tracking (Anatoli Papirovski) [#17650](https://github.com/nodejs/node/pull/17650)
* [[`3439635763`](https://github.com/nodejs/node/commit/3439635763)] - **path**: replace duplicate conditions by functions (Sergey Golovin) [#18693](https://github.com/nodejs/node/pull/18693)
* [[`5331454a30`](https://github.com/nodejs/node/commit/5331454a30)] - **path**: replace "magic" numbers by readable constants (Sergey Golovin) [#18654](https://github.com/nodejs/node/pull/18654)
* [[`0a47b98f04`](https://github.com/nodejs/node/commit/0a47b98f04)] - **perf_hooks**: add warning when too many entries in the timeline (James M Snell) [#18087](https://github.com/nodejs/node/pull/18087)
* [[`cec3d1ea80`](https://github.com/nodejs/node/commit/cec3d1ea80)] - **process**: fix reading zero-length env vars on win32 (Anna Henningsen) [#18463](https://github.com/nodejs/node/pull/18463)
* [[`36332eba27`](https://github.com/nodejs/node/commit/36332eba27)] - **readline**: use Date.now() and move test to parallel (Anatoli Papirovski) [#18563](https://github.com/nodejs/node/pull/18563)
* [[`9957916c26`](https://github.com/nodejs/node/commit/9957916c26)] - **src**: add nullptr check for session in DEBUG macro (Daniel Bevenius) [#18815](https://github.com/nodejs/node/pull/18815)
* [[`de3231c13a`](https://github.com/nodejs/node/commit/de3231c13a)] - **src**: factor out some common vm functions (Timothy Gu) [#17560](https://github.com/nodejs/node/pull/17560)
* [[`a258f6b5ce`](https://github.com/nodejs/node/commit/a258f6b5ce)] - **src**: flatten ContextifyContext (Gus Caplan) [#17560](https://github.com/nodejs/node/pull/17560)
* [[`a7419d0902`](https://github.com/nodejs/node/commit/a7419d0902)] - **src**: replace var for let / const. (alejandro estrada) [#18649](https://github.com/nodejs/node/pull/18649)
* [[`d190c9a41e`](https://github.com/nodejs/node/commit/d190c9a41e)] - **src**: add "icu::" prefix before ICU symbols (Steven R. Loomis)
* [[`3ec3c329c6`](https://github.com/nodejs/node/commit/3ec3c329c6)] - **src**: fix crypto.pbkdf2 callback error argument (BufoViridis) [#18458](https://github.com/nodejs/node/pull/18458)
* [[`464df6d9b5`](https://github.com/nodejs/node/commit/464df6d9b5)] - **(SEMVER-MINOR)** **src**: allow --perf-(basic-)?prof in NODE_OPTIONS (Leko) [#17600](https://github.com/nodejs/node/pull/17600)
* [[`43956e9600`](https://github.com/nodejs/node/commit/43956e9600)] - **src**: free memory before re-setting URLHost value (Ivan Filenko) [#18357](https://github.com/nodejs/node/pull/18357)
* [[`272fd2e334`](https://github.com/nodejs/node/commit/272fd2e334)] - **src**: fix vector subscript out of range (Anatoli Papirovski) [#18460](https://github.com/nodejs/node/pull/18460)
* [[`64c36d31b6`](https://github.com/nodejs/node/commit/64c36d31b6)] - **src, lib**: return promises from link (Gus Caplan) [#18394](https://github.com/nodejs/node/pull/18394)
* [[`ba46103291`](https://github.com/nodejs/node/commit/ba46103291)] - **stream**: fix misleading error message (Luigi Pinca) [#18604](https://github.com/nodejs/node/pull/18604)
* [[`27532f4e9a`](https://github.com/nodejs/node/commit/27532f4e9a)] - **stream**: cleanup() when unpiping all streams. (陈刚) [#18266](https://github.com/nodejs/node/pull/18266)
* [[`a4cc0fb1b6`](https://github.com/nodejs/node/commit/a4cc0fb1b6)] - **stream**: delete unused code (陈刚) [#18278](https://github.com/nodejs/node/pull/18278)
* [[`450f5f43bc`](https://github.com/nodejs/node/commit/450f5f43bc)] - **stream**: delete redundant code (陈刚) [#18145](https://github.com/nodejs/node/pull/18145)
* [[`560f657957`](https://github.com/nodejs/node/commit/560f657957)] - **stream**: delete redundant code (陈刚) [#18145](https://github.com/nodejs/node/pull/18145)
* [[`9af1e4b286`](https://github.com/nodejs/node/commit/9af1e4b286)] - **string_decoder**: reset decoder on end (Justin Ridgewell) [#18494](https://github.com/nodejs/node/pull/18494)
* [[`b02f4e1902`](https://github.com/nodejs/node/commit/b02f4e1902)] - **test**: http2 client settings invalid callback (Trivikram) [#18850](https://github.com/nodejs/node/pull/18850)
* [[`b7e6ac78fe`](https://github.com/nodejs/node/commit/b7e6ac78fe)] - **test**: http2 client ping errors (Trivikram) [#18849](https://github.com/nodejs/node/pull/18849)
* [[`f90490d475`](https://github.com/nodejs/node/commit/f90490d475)] - **test**: http2 client operations after destroy (Trivikram) [#18845](https://github.com/nodejs/node/pull/18845)
* [[`d73f214380`](https://github.com/nodejs/node/commit/d73f214380)] - **test**: refactor parallel/test-tls-pause (juggernaut451) [#18714](https://github.com/nodejs/node/pull/18714)
* [[`fa0b987a71`](https://github.com/nodejs/node/commit/fa0b987a71)] - **test**: refactor stream-*-constructor-set-methods (Luigi Pinca) [#18817](https://github.com/nodejs/node/pull/18817)
* [[`dba5e35326`](https://github.com/nodejs/node/commit/dba5e35326)] - **test**: refactor parallel/test-tls-0-dns-altname (juggernaut451) [#18803](https://github.com/nodejs/node/pull/18803)
* [[`f960ad491c`](https://github.com/nodejs/node/commit/f960ad491c)] - **test**: add common.skipIfEslintMissing (Myles Borins) [#18807](https://github.com/nodejs/node/pull/18807)
* [[`dc456853f8`](https://github.com/nodejs/node/commit/dc456853f8)] - **test**: fix warnings in addon tests (Ali Ijaz Sheikh) [#18810](https://github.com/nodejs/node/pull/18810)
* [[`7874cb0f3c`](https://github.com/nodejs/node/commit/7874cb0f3c)] - **test**: refactor parallel/test-tls-addca (juggernaut451) [#18798](https://github.com/nodejs/node/pull/18798)
* [[`b3b5ac5169`](https://github.com/nodejs/node/commit/b3b5ac5169)] - **test**: refactor of test-tls-over-http-tunnel (juggernaut451) [#18784](https://github.com/nodejs/node/pull/18784)
* [[`849f5c31c8`](https://github.com/nodejs/node/commit/849f5c31c8)] - **test**: make tls test more rigorous (Ben Noordhuis) [#18792](https://github.com/nodejs/node/pull/18792)
* [[`cf10a94b48`](https://github.com/nodejs/node/commit/cf10a94b48)] - **test**: reduce benchmark test run time (juggernaut451) [#18787](https://github.com/nodejs/node/pull/18787)
* [[`8b5ca482fa`](https://github.com/nodejs/node/commit/8b5ca482fa)] - **test**: try to connect after server was closed (Leko) [#18257](https://github.com/nodejs/node/pull/18257)
* [[`75c691b788`](https://github.com/nodejs/node/commit/75c691b788)] - **test**: wrap countdown callback in common.mustCall (Bamieh) [#18506](https://github.com/nodejs/node/pull/18506)
* [[`ed55374b98`](https://github.com/nodejs/node/commit/ed55374b98)] - **test**: update a few tests to work on OpenBSD (Aaron Bieber) [#18543](https://github.com/nodejs/node/pull/18543)
* [[`7e75a78c5a`](https://github.com/nodejs/node/commit/7e75a78c5a)] - **test**: add lib path env when node_shared=true (Yihong Wang) [#18626](https://github.com/nodejs/node/pull/18626)
* [[`d6786d2110`](https://github.com/nodejs/node/commit/d6786d2110)] - **test**: add multiline repl input regression test (cjihrig) [#18718](https://github.com/nodejs/node/pull/18718)
* [[`18c493397f`](https://github.com/nodejs/node/commit/18c493397f)] - **test**: remove unnecessary timer (cjihrig) [#18719](https://github.com/nodejs/node/pull/18719)
* [[`5b88cb747e`](https://github.com/nodejs/node/commit/5b88cb747e)] - **test**: add crypto check to test-benchmark-tls (Daniel Bevenius) [#18724](https://github.com/nodejs/node/pull/18724)
* [[`6c041638c3`](https://github.com/nodejs/node/commit/6c041638c3)] - **test**: fix missing param in benchmark-timers (Anatoli Papirovski) [#18734](https://github.com/nodejs/node/pull/18734)
* [[`3362ae79df`](https://github.com/nodejs/node/commit/3362ae79df)] - **test**: fix and improve error message (Kevin Caulfield) [#18449](https://github.com/nodejs/node/pull/18449)
* [[`e9c9200aba`](https://github.com/nodejs/node/commit/e9c9200aba)] - **test**: add useful info to error msg and refactor (Chin Huang) [#18541](https://github.com/nodejs/node/pull/18541)
* [[`72d71594bd`](https://github.com/nodejs/node/commit/72d71594bd)] - **test**: fix flaky repl-timeout-throw (Santiago Gimeno) [#18692](https://github.com/nodejs/node/pull/18692)
* [[`2089814b67`](https://github.com/nodejs/node/commit/2089814b67)] - **test**: properly tag anonymous namespaces (Michael Dawson) [#18583](https://github.com/nodejs/node/pull/18583)
* [[`a667ac1665`](https://github.com/nodejs/node/commit/a667ac1665)] - **test**: fix flaky timers-block-eventloop test (Anatoli Papirovski) [#18567](https://github.com/nodejs/node/pull/18567)
* [[`f3e6c7636a`](https://github.com/nodejs/node/commit/f3e6c7636a)] - **test**: refactor test-http-abort-before-end (cjihrig) [#18508](https://github.com/nodejs/node/pull/18508)
* [[`0277993f49`](https://github.com/nodejs/node/commit/0277993f49)] - **test**: improve error message output (Bhavani Shankar) [#18498](https://github.com/nodejs/node/pull/18498)
* [[`30a233cfce`](https://github.com/nodejs/node/commit/30a233cfce)] - **test**: fix flaky test-http2-session-unref (Anatoli Papirovski) [#18589](https://github.com/nodejs/node/pull/18589)
* [[`ef2d9c2c54`](https://github.com/nodejs/node/commit/ef2d9c2c54)] - **test**: do not check TXT content in test-dns-any (Joyee Cheung) [#18547](https://github.com/nodejs/node/pull/18547)
* [[`10dc25df83`](https://github.com/nodejs/node/commit/10dc25df83)] - **test**: improve tests for test-http-url.parse (Weijia Wang) [#18523](https://github.com/nodejs/node/pull/18523)
* [[`a13fbdd4c3`](https://github.com/nodejs/node/commit/a13fbdd4c3)] - **test**: remove destructor from node_test_fixture (Daniel Bevenius) [#18524](https://github.com/nodejs/node/pull/18524)
* [[`52aeb2a070`](https://github.com/nodejs/node/commit/52aeb2a070)] - **test**: verify the shell option works properly on execFile (jvelezpo) [#18384](https://github.com/nodejs/node/pull/18384)
* [[`0d390f7bdf`](https://github.com/nodejs/node/commit/0d390f7bdf)] - **test**: add test for tls benchmarks (Anatoli Papirovski) [#18489](https://github.com/nodejs/node/pull/18489)
* [[`da0d776593`](https://github.com/nodejs/node/commit/da0d776593)] - **test**: mark test-inspector-stop-profile-after-done flaky (Myles Borins) [#18491](https://github.com/nodejs/node/pull/18491)
* [[`8c9b41aaee`](https://github.com/nodejs/node/commit/8c9b41aaee)] - **test**: show pending exception error in napi tests (Ben Wilcox) [#18413](https://github.com/nodejs/node/pull/18413)
* [[`f6c9a2bc47`](https://github.com/nodejs/node/commit/f6c9a2bc47)] - **test**: speed up parallel/test-tls-session-cache (Anna Henningsen) [#18424](https://github.com/nodejs/node/pull/18424)
* [[`6b74064e65`](https://github.com/nodejs/node/commit/6b74064e65)] - **test**: fix flaky test-http-dns-error (Bryan English) [#16534](https://github.com/nodejs/node/pull/16534)
* [[`eb252527e5`](https://github.com/nodejs/node/commit/eb252527e5)] - **test**: move tmpdir to submodule of common (Rich Trott) [#17856](https://github.com/nodejs/node/pull/17856)
* [[`b5267a6926`](https://github.com/nodejs/node/commit/b5267a6926)] - **test**: force context allocation in test module (Yang Guo) [#18312](https://github.com/nodejs/node/pull/18312)
* [[`cc8091448b`](https://github.com/nodejs/node/commit/cc8091448b)] - **test**: fix flaky cluster unix socket test (Ben Noordhuis) [#17407](https://github.com/nodejs/node/pull/17407)
* [[`19abee149d`](https://github.com/nodejs/node/commit/19abee149d)] - **test**: fix a bug & lint issues in inspector-helper (Anatoli Papirovski) [#18293](https://github.com/nodejs/node/pull/18293)
* [[`b5752ee6a4`](https://github.com/nodejs/node/commit/b5752ee6a4)] - **test**: fix require-deps-deprecation for installed deps (Benjamin Zaslavsky) [#17848](https://github.com/nodejs/node/pull/17848)
* [[`66f8d346b8`](https://github.com/nodejs/node/commit/66f8d346b8)] - **test,benchmark,doc**: enable dot-notation rule (Ruben Bridgewater) [#18749](https://github.com/nodejs/node/pull/18749)
* [[`146e8ac83a`](https://github.com/nodejs/node/commit/146e8ac83a)] - **timers**: remove domain specific code (Anatoli Papirovski) [#18477](https://github.com/nodejs/node/pull/18477)
* [[`f8f1423e7a`](https://github.com/nodejs/node/commit/f8f1423e7a)] - **tls**: tls_wrap causes debug assert in vector (Kyle Farnung) [#18830](https://github.com/nodejs/node/pull/18830)
* [[`3725d4ccea`](https://github.com/nodejs/node/commit/3725d4ccea)] - **tls**: remove cleartext input data queue (Anna Henningsen) [#17883](https://github.com/nodejs/node/pull/17883)
* [[`aa241eda98`](https://github.com/nodejs/node/commit/aa241eda98)] - **tools**: custom eslint autofix for inspector-check.js (Shobhit Chittora) [#16646](https://github.com/nodejs/node/pull/16646)
* [[`3f865ea6cf`](https://github.com/nodejs/node/commit/3f865ea6cf)] - **tools**: auto fix custom crypto-check eslint rule (Shobhit Chittora) [#16647](https://github.com/nodejs/node/pull/16647)
* [[`ae3398aad6`](https://github.com/nodejs/node/commit/ae3398aad6)] - **tools**: fix eslint isRequired (Ruben Bridgewater) [#18729](https://github.com/nodejs/node/pull/18729)
* [[`a33dc81b2f`](https://github.com/nodejs/node/commit/a33dc81b2f)] - **tools**: add fixer for prefer-assert-iferror.js (Shobhit Chittora) [#16648](https://github.com/nodejs/node/pull/16648)
* [[`aabbdc84c2`](https://github.com/nodejs/node/commit/aabbdc84c2)] - **tools**: add .mjs linting for Windows (Vse Mozhet Byt) [#18569](https://github.com/nodejs/node/pull/18569)
* [[`e00bb1657f`](https://github.com/nodejs/node/commit/e00bb1657f)] - **tools**: non-Ascii linter for /lib only (Sarat Addepalli) [#18043](https://github.com/nodejs/node/pull/18043)
* [[`4f4bfbecbf`](https://github.com/nodejs/node/commit/4f4bfbecbf)] - **tools**: auto fix custom eslint rule (Shobhit Chittora) [#16652](https://github.com/nodejs/node/pull/16652)
* [[`ef45bb4305`](https://github.com/nodejs/node/commit/ef45bb4305)] - **tools**: fix icu readme lint error (Anatoli Papirovski) [#18445](https://github.com/nodejs/node/pull/18445)
* [[`1767ef06f3`](https://github.com/nodejs/node/commit/1767ef06f3)] - **url**: simplify constructor URLSearchParams. Remove needless check null (Mihail Bodrov) [#18700](https://github.com/nodejs/node/pull/18700)
* [[`07e4ba2519`](https://github.com/nodejs/node/commit/07e4ba2519)] - **url**: simplify loop in parser (Tobias Nießen) [#18468](https://github.com/nodejs/node/pull/18468)
* [[`c8f729f7a3`](https://github.com/nodejs/node/commit/c8f729f7a3)] - **v8**: add missing ',' in OpenBSD's 'sources' section. (Aaron Bieber) [#18448](https://github.com/nodejs/node/pull/18448)
* [[`02afdbc5c6`](https://github.com/nodejs/node/commit/02afdbc5c6)] - **vm**: flip Module#link's signature (Gus Caplan) [#18471](https://github.com/nodejs/node/pull/18471)
* [[`1cbd76a100`](https://github.com/nodejs/node/commit/1cbd76a100)] - **vm**: add modules (Gus Caplan) [#17560](https://github.com/nodejs/node/pull/17560)
* [[`c34e2f4fc5`](https://github.com/nodejs/node/commit/c34e2f4fc5)] - **win, build**: fix intl-none option (Birunthan Mohanathas) [#18292](https://github.com/nodejs/node/pull/18292)

<a id="9.5.0"></a>
## 2018-01-31, Version 9.5.0 (Current), @evanlucas

### Notable Changes

* **cluster**
  - add cwd to cluster.settings (cjihrig) [#18399](https://github.com/nodejs/node/pull/18399)
* **deps**
  - upgrade libuv to 1.19.1 (cjihrig) [#18260](https://github.com/nodejs/node/pull/18260)
* **meta**
  - add Leko to collaborators (Leko) [#18117](https://github.com/nodejs/node/pull/18117)
  - add vdeturckheim as collaborator (vdeturckheim) [#18432](https://github.com/nodejs/node/pull/18432)
* **n-api**
  - expose n-api version in process.versions (Michael Dawson) [#18067](https://github.com/nodejs/node/pull/18067)
* **perf_hooks**
  - add performance.clear() (James M Snell) [#18046](https://github.com/nodejs/node/pull/18046)
* **stream**
  - avoid writeAfterEnd() while ending (陈刚) [#18170](https://github.com/nodejs/node/pull/18170)

### Commits

* [[`0a68018ad0`](https://github.com/nodejs/node/commit/0a68018ad0)] - **async_hooks**: update defaultTriggerAsyncIdScope for perf (Anatoli Papirovski) [#18004](https://github.com/nodejs/node/pull/18004)
* [[`dd56bd1591`](https://github.com/nodejs/node/commit/dd56bd1591)] - **async_hooks**: use typed array stack as fast path (Anna Henningsen) [#17780](https://github.com/nodejs/node/pull/17780)
* [[`a880e272ff`](https://github.com/nodejs/node/commit/a880e272ff)] - **async_hooks**: use scope for defaultTriggerAsyncId (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
* [[`f56eb2a41e`](https://github.com/nodejs/node/commit/f56eb2a41e)] - **async_hooks**: separate missing from default context (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
* [[`2a4f849c39`](https://github.com/nodejs/node/commit/2a4f849c39)] - **async_hooks**: rename initTriggerId (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
* [[`ac2f98d6a6`](https://github.com/nodejs/node/commit/ac2f98d6a6)] - **(SEMVER-MINOR)** **async_hooks,http**: set HTTPParser trigger to socket (Andreas Madsen) [#18003](https://github.com/nodejs/node/pull/18003)
* [[`e9397d67a3`](https://github.com/nodejs/node/commit/e9397d67a3)] - **async_hooks,test**: only use IPv6 in http test (Andreas Madsen) [#18143](https://github.com/nodejs/node/pull/18143)
* [[`2efa7d1bfd`](https://github.com/nodejs/node/commit/2efa7d1bfd)] - **benchmark**: implement duration in http test double (Joyee Cheung) [#18380](https://github.com/nodejs/node/pull/18380)
* [[`b5ec6ea3d0`](https://github.com/nodejs/node/commit/b5ec6ea3d0)] - **benchmark**: make compare.R easier to understand (Andreas Madsen) [#18373](https://github.com/nodejs/node/pull/18373)
* [[`ea19f7db0d`](https://github.com/nodejs/node/commit/ea19f7db0d)] - **benchmark**: use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`cd9bc8bc50`](https://github.com/nodejs/node/commit/cd9bc8bc50)] - **benchmark**: (dgram) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`e19c77b14e`](https://github.com/nodejs/node/commit/e19c77b14e)] - **benchmark**: (child_process) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`5cf5ab154e`](https://github.com/nodejs/node/commit/5cf5ab154e)] - **benchmark**: (buffers) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`71faa5c1b4`](https://github.com/nodejs/node/commit/71faa5c1b4)] - **benchmark**: (events) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`c25d4d66dc`](https://github.com/nodejs/node/commit/c25d4d66dc)] - **benchmark**: (es) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`59271c8f7f`](https://github.com/nodejs/node/commit/59271c8f7f)] - **benchmark**: (fs) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`4e19cbef86`](https://github.com/nodejs/node/commit/4e19cbef86)] - **benchmark**: (http) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`e9c426b35b`](https://github.com/nodejs/node/commit/e9c426b35b)] - **benchmark**: (misc) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`d13d900eee`](https://github.com/nodejs/node/commit/d13d900eee)] - **benchmark**: (http2) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`97e882061d`](https://github.com/nodejs/node/commit/97e882061d)] - **benchmark**: (string_decoder) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`5b0e3b9860`](https://github.com/nodejs/node/commit/5b0e3b9860)] - **benchmark**: (path) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`7bc5bad74f`](https://github.com/nodejs/node/commit/7bc5bad74f)] - **benchmark**: (os) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`cf666d8529`](https://github.com/nodejs/node/commit/cf666d8529)] - **benchmark**: (net) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`88f4bf219d`](https://github.com/nodejs/node/commit/88f4bf219d)] - **benchmark**: (process) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`f4918289e7`](https://github.com/nodejs/node/commit/f4918289e7)] - **benchmark**: (querystring) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`81abea592f`](https://github.com/nodejs/node/commit/81abea592f)] - **benchmark**: (streams) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`11d6458fd7`](https://github.com/nodejs/node/commit/11d6458fd7)] - **benchmark**: (timers) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`3e3254a2e7`](https://github.com/nodejs/node/commit/3e3254a2e7)] - **benchmark**: (tls) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`c0707c54a5`](https://github.com/nodejs/node/commit/c0707c54a5)] - **benchmark**: (util/v8/vm) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`76f671b84e`](https://github.com/nodejs/node/commit/76f671b84e)] - **benchmark**: (zlib) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`aa47fe0ef9`](https://github.com/nodejs/node/commit/aa47fe0ef9)] - **benchmark**: (url) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`e00dac7b06`](https://github.com/nodejs/node/commit/e00dac7b06)] - **benchmark**: (assert) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`3543458988`](https://github.com/nodejs/node/commit/3543458988)] - **benchmark**: (arrays) use destructuring (Ruben Bridgewater) [#18250](https://github.com/nodejs/node/pull/18250)
* [[`aa21d55403`](https://github.com/nodejs/node/commit/aa21d55403)] - **benchmark**: remove redundant + (sreepurnajasti) [#17803](https://github.com/nodejs/node/pull/17803)
* [[`a4ba791566`](https://github.com/nodejs/node/commit/a4ba791566)] - **benchmark**: add JSStreamWrap benchmark (Anna Henningsen) [#17983](https://github.com/nodejs/node/pull/17983)
* [[`deac028cb6`](https://github.com/nodejs/node/commit/deac028cb6)] - **build**: fix rm commands in tarball rule (Ben Noordhuis) [#18332](https://github.com/nodejs/node/pull/18332)
* [[`2a9afc4c0e`](https://github.com/nodejs/node/commit/2a9afc4c0e)] - **build**: make lint-js independent of local node (Joyee Cheung) [#18272](https://github.com/nodejs/node/pull/18272)
* [[`ce1eb0be7e`](https://github.com/nodejs/node/commit/ce1eb0be7e)] - **build**: make lint-md independent of local node (Joyee Cheung) [#18272](https://github.com/nodejs/node/pull/18272)
* [[`f050521a71`](https://github.com/nodejs/node/commit/f050521a71)] - **build**: define NOMINMAX on windows (Ben Noordhuis) [#18216](https://github.com/nodejs/node/pull/18216)
* [[`70d6fda9f3`](https://github.com/nodejs/node/commit/70d6fda9f3)] - **build**: remove unused vars from configure (Ben Noordhuis) [#18206](https://github.com/nodejs/node/pull/18206)
* [[`f81c62246d`](https://github.com/nodejs/node/commit/f81c62246d)] - **build**: refine static and shared lib build (Yihong Wang) [#17604](https://github.com/nodejs/node/pull/17604)
* [[`1506eb5f25`](https://github.com/nodejs/node/commit/1506eb5f25)] - **build**: remove bench-* targets (Joyee Cheung) [#18150](https://github.com/nodejs/node/pull/18150)
* [[`969c89bf55`](https://github.com/nodejs/node/commit/969c89bf55)] - **build**: fix Makefile wrt finding node executable (Yang Guo) [#18040](https://github.com/nodejs/node/pull/18040)
* [[`dd72f9c9b7`](https://github.com/nodejs/node/commit/dd72f9c9b7)] - **build**: fix cctest target with --enable-static (Qingyan Li) [#17992](https://github.com/nodejs/node/pull/17992)
* [[`2c4e0216de`](https://github.com/nodejs/node/commit/2c4e0216de)] - **build,win**: update lint-cpp on Windows (Kyle Farnung) [#18012](https://github.com/nodejs/node/pull/18012)
* [[`d8ac817cb6`](https://github.com/nodejs/node/commit/d8ac817cb6)] - **build,win**: restore vcbuild TAG functionality (Rod Vagg) [#18031](https://github.com/nodejs/node/pull/18031)
* [[`799fd24acb`](https://github.com/nodejs/node/commit/799fd24acb)] - **(SEMVER-MINOR)** **cluster**: add cwd to cluster.settings (cjihrig) [#18399](https://github.com/nodejs/node/pull/18399)
* [[`6b687cf3c9`](https://github.com/nodejs/node/commit/6b687cf3c9)] - **cluster**: resolve relative unix socket paths (laino) [#16749](https://github.com/nodejs/node/pull/16749)
* [[`693159e627`](https://github.com/nodejs/node/commit/693159e627)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.19.1 (cjihrig) [#18260](https://github.com/nodejs/node/pull/18260)
* [[`506d85bfba`](https://github.com/nodejs/node/commit/506d85bfba)] - **deps**: cherry-pick c3458a8 from upstream V8 (Michaël Zasso) [#18060](https://github.com/nodejs/node/pull/18060)
* [[`45051fa48c`](https://github.com/nodejs/node/commit/45051fa48c)] - **doc**: add vdeturckheim as collaborator (vdeturckheim) [#18432](https://github.com/nodejs/node/pull/18432)
* [[`03cb06944b`](https://github.com/nodejs/node/commit/03cb06944b)] - **doc**: unify type linkification (Vse Mozhet Byt) [#18407](https://github.com/nodejs/node/pull/18407)
* [[`d829237b92`](https://github.com/nodejs/node/commit/d829237b92)] - **doc**: fix typo in REPL docs (Adam Engebretson) [#18404](https://github.com/nodejs/node/pull/18404)
* [[`6ae7bb143a`](https://github.com/nodejs/node/commit/6ae7bb143a)] - **doc**: fix e.g., to e.g. in docs (sreepurnajasti) [#18369](https://github.com/nodejs/node/pull/18369)
* [[`574d3b9ce8`](https://github.com/nodejs/node/commit/574d3b9ce8)] - **doc**: fix documentation of http2Stream.pushstream() (Peter Dalgaard-Jensen) [#18258](https://github.com/nodejs/node/pull/18258)
* [[`4d3121b6ed`](https://github.com/nodejs/node/commit/4d3121b6ed)] - **doc**: fix return value for require.resolve.paths() (Peter Dalgaard-Jensen) [#18350](https://github.com/nodejs/node/pull/18350)
* [[`987480c232`](https://github.com/nodejs/node/commit/987480c232)] - **doc**: add missing word in modules.md (Robert Adamian) [#18343](https://github.com/nodejs/node/pull/18343)
* [[`224cc64d0c`](https://github.com/nodejs/node/commit/224cc64d0c)] - **doc**: add doc for performance.clearGC() (Antony Tran) [#18331](https://github.com/nodejs/node/pull/18331)
* [[`e5f6159958`](https://github.com/nodejs/node/commit/e5f6159958)] - **doc**: document the collaborator nomination process (Joyee Cheung) [#18268](https://github.com/nodejs/node/pull/18268)
* [[`c9e09adc8d`](https://github.com/nodejs/node/commit/c9e09adc8d)] - **doc**: improve the instructions of onboarding PR (Joyee Cheung) [#18268](https://github.com/nodejs/node/pull/18268)
* [[`b055c9efe5`](https://github.com/nodejs/node/commit/b055c9efe5)] - **doc**: split CONTRIBUTING.md (Joyee Cheung) [#18271](https://github.com/nodejs/node/pull/18271)
* [[`485d60eea2`](https://github.com/nodejs/node/commit/485d60eea2)] - **doc**: fix typos in async_hooks (Matthew Turner) [#18314](https://github.com/nodejs/node/pull/18314)
* [[`e3cc0919f6`](https://github.com/nodejs/node/commit/e3cc0919f6)] - **doc**: add missing URL argument types in fs.md (Vse Mozhet Byt) [#18309](https://github.com/nodejs/node/pull/18309)
* [[`1efb9cd271`](https://github.com/nodejs/node/commit/1efb9cd271)] - **doc**: remove confusing signature in fs.md (Vse Mozhet Byt) [#18310](https://github.com/nodejs/node/pull/18310)
* [[`195bed21eb`](https://github.com/nodejs/node/commit/195bed21eb)] - **doc**: use PBKDF2 in text (Tobias Nießen) [#18279](https://github.com/nodejs/node/pull/18279)
* [[`17ef69e6e2`](https://github.com/nodejs/node/commit/17ef69e6e2)] - **doc**: fix typo in async_hooks.md (Matthew Turner) [#18286](https://github.com/nodejs/node/pull/18286)
* [[`01599e2959`](https://github.com/nodejs/node/commit/01599e2959)] - **doc**: Add example of null to assert.ifError (Leko) [#18236](https://github.com/nodejs/node/pull/18236)
* [[`5c5aa4969c`](https://github.com/nodejs/node/commit/5c5aa4969c)] - **doc**: improve process.platform (Mars Wong) [#18057](https://github.com/nodejs/node/pull/18057)
* [[`61df843c95`](https://github.com/nodejs/node/commit/61df843c95)] - **doc**: cjs format is now commonjs (Gus Caplan) [#18165](https://github.com/nodejs/node/pull/18165)
* [[`361fd33709`](https://github.com/nodejs/node/commit/361fd33709)] - **doc**: V8 branch used in 8.x not active anymore (Franziska Hinkelmann) [#18155](https://github.com/nodejs/node/pull/18155)
* [[`b553daa29b`](https://github.com/nodejs/node/commit/b553daa29b)] - **doc**: add change info for async_hooks.executionAsyncId() (Stephen Belanger) [#17813](https://github.com/nodejs/node/pull/17813)
* [[`4b918d79df`](https://github.com/nodejs/node/commit/4b918d79df)] - **doc**: remove uannecessary Require (Michael Dawson) [#18184](https://github.com/nodejs/node/pull/18184)
* [[`926467ab80`](https://github.com/nodejs/node/commit/926467ab80)] - **doc**: add builtin module in building.md (Suixinlei) [#17705](https://github.com/nodejs/node/pull/17705)
* [[`1ef8f4e22e`](https://github.com/nodejs/node/commit/1ef8f4e22e)] - **doc**: warn users about non-ASCII paths on build (Matheus Marchini) [#16735](https://github.com/nodejs/node/pull/16735)
* [[`a1096a6b05`](https://github.com/nodejs/node/commit/a1096a6b05)] - **doc**: simplify sentences that use "considered" (Rich Trott) [#18095](https://github.com/nodejs/node/pull/18095)
* [[`1d74c33148`](https://github.com/nodejs/node/commit/1d74c33148)] - **doc**: update sample output for process.versions (Michael Dawson) [#18167](https://github.com/nodejs/node/pull/18167)
* [[`2fb5f19894`](https://github.com/nodejs/node/commit/2fb5f19894)] - **doc**: fix typo in TextEncoding section (Yosuke Furukawa) [#18201](https://github.com/nodejs/node/pull/18201)
* [[`b4e7260d3e`](https://github.com/nodejs/node/commit/b4e7260d3e)] - **doc**: fix typo in http2stream.close param default (Moritz Peters) [#18166](https://github.com/nodejs/node/pull/18166)
* [[`b05f09a587`](https://github.com/nodejs/node/commit/b05f09a587)] - **doc**: suggest not to throw JS errors from C++ (Joyee Cheung) [#18149](https://github.com/nodejs/node/pull/18149)
* [[`5a95905d91`](https://github.com/nodejs/node/commit/5a95905d91)] - **doc**: napi: make header style consistent (Ali Ijaz Sheikh) [#18122](https://github.com/nodejs/node/pull/18122)
* [[`990abbf06c`](https://github.com/nodejs/node/commit/990abbf06c)] - **doc**: napi: fix unbalanced emphasis (Ali Ijaz Sheikh) [#18122](https://github.com/nodejs/node/pull/18122)
* [[`f8f809b7fa`](https://github.com/nodejs/node/commit/f8f809b7fa)] - **doc**: add documentation for deprecation properties (Jon Moss) [#16539](https://github.com/nodejs/node/pull/16539)
* [[`0e8596e2a6`](https://github.com/nodejs/node/commit/0e8596e2a6)] - **doc**: prefer make test-only when verifying the build (Joyee Cheung) [#18061](https://github.com/nodejs/node/pull/18061)
* [[`bbdc3c4ae8`](https://github.com/nodejs/node/commit/bbdc3c4ae8)] - **doc**: add Leko to collaborators (Leko) [#18117](https://github.com/nodejs/node/pull/18117)
* [[`afc30a56e3`](https://github.com/nodejs/node/commit/afc30a56e3)] - **doc**: decapitalize primitive types (Vse Mozhet Byt) [#18110](https://github.com/nodejs/node/pull/18110)
* [[`30e2221a15`](https://github.com/nodejs/node/commit/30e2221a15)] - **doc**: fix s/rstStream/close in example (James M Snell) [#18088](https://github.com/nodejs/node/pull/18088)
* [[`1c81a055df`](https://github.com/nodejs/node/commit/1c81a055df)] - **doc**: update pushStream docs to use err first (James M Snell) [#18088](https://github.com/nodejs/node/pull/18088)
* [[`de70a363eb`](https://github.com/nodejs/node/commit/de70a363eb)] - **doc**: be less tentative about undefined behavior (Rich Trott) [#18091](https://github.com/nodejs/node/pull/18091)
* [[`5ebd0178a6`](https://github.com/nodejs/node/commit/5ebd0178a6)] - **doc**: add descriptions of state properties (James M Snell) [#18044](https://github.com/nodejs/node/pull/18044)
* [[`7911b9b493`](https://github.com/nodejs/node/commit/7911b9b493)] - **doc**: examples for fast-tracking regression fixes (Refael Ackermann) [#17379](https://github.com/nodejs/node/pull/17379)
* [[`f0a0fdd83a`](https://github.com/nodejs/node/commit/f0a0fdd83a)] - **doc**: multiple updates to BUILDING.md (Rich Trott) [#17985](https://github.com/nodejs/node/pull/17985)
* [[`278450fc72`](https://github.com/nodejs/node/commit/278450fc72)] - **doc**: multiple updates to child_process.md (Rich Trott) [#17990](https://github.com/nodejs/node/pull/17990)
* [[`722fe464bc`](https://github.com/nodejs/node/commit/722fe464bc)] - ***Revert*** "**doc**: import() is supported now" (Myles Borins) [#18141](https://github.com/nodejs/node/pull/18141)
* [[`39970e9caf`](https://github.com/nodejs/node/commit/39970e9caf)] - **doc**: un-mark Socket#write “removal” as notable change (Anna Henningsen) [#18083](https://github.com/nodejs/node/pull/18083)
* [[`df8cb401a0`](https://github.com/nodejs/node/commit/df8cb401a0)] - **errors**: remove ERR_OUTOFMEMORY (Tobias Nießen) [#17877](https://github.com/nodejs/node/pull/17877)
* [[`230a102647`](https://github.com/nodejs/node/commit/230a102647)] - **fs**: cleanup fd lchown and lchownSync (James M Snell) [#18329](https://github.com/nodejs/node/pull/18329)
* [[`778d57c2c2`](https://github.com/nodejs/node/commit/778d57c2c2)] - **fs**: fix options.end of fs.ReadStream() (陈刚) [#18121](https://github.com/nodejs/node/pull/18121)
* [[`7fc395a0d7`](https://github.com/nodejs/node/commit/7fc395a0d7)] - **http**: there is no `corked` property of `stream` (Fedor Indutny) [#18325](https://github.com/nodejs/node/pull/18325)
* [[`b87939cf53`](https://github.com/nodejs/node/commit/b87939cf53)] - **http**: use strict comparison (leeseean) [#17011](https://github.com/nodejs/node/pull/17011)
* [[`0250e1b9c0`](https://github.com/nodejs/node/commit/0250e1b9c0)] - **http**: free the parser before emitting 'upgrade' (Luigi Pinca) [#18209](https://github.com/nodejs/node/pull/18209)
* [[`155622847f`](https://github.com/nodejs/node/commit/155622847f)] - **http**: fix parsing of binary upgrade response body (Ben Noordhuis) [#17806](https://github.com/nodejs/node/pull/17806)
* [[`8e084d8bfb`](https://github.com/nodejs/node/commit/8e084d8bfb)] - **http**: simplify parser lifetime tracking (Anna Henningsen) [#18135](https://github.com/nodejs/node/pull/18135)
* [[`ee6217a4c7`](https://github.com/nodejs/node/commit/ee6217a4c7)] - **http2**: add checks for server close callback (James M Snell) [#18182](https://github.com/nodejs/node/pull/18182)
* [[`b3332cce46`](https://github.com/nodejs/node/commit/b3332cce46)] - **http2**: refactor read mechanism (Anna Henningsen) [#18030](https://github.com/nodejs/node/pull/18030)
* [[`eee40c71c9`](https://github.com/nodejs/node/commit/eee40c71c9)] - **http2**: remember sent headers (James M Snell) [#18045](https://github.com/nodejs/node/pull/18045)
* [[`39612a8657`](https://github.com/nodejs/node/commit/39612a8657)] - **http2,perf_hooks**: perf state using AliasedBuffer (Kyle Farnung) [#18300](https://github.com/nodejs/node/pull/18300)
* [[`14f7f607f6`](https://github.com/nodejs/node/commit/14f7f607f6)] - **(SEMVER-MINOR)** **lib**: add internal removeColors helper (Ruben Bridgewater) [#17615](https://github.com/nodejs/node/pull/17615)
* [[`74c1f4ef78`](https://github.com/nodejs/node/commit/74c1f4ef78)] - **lib**: fix typo in trace_events_async_hooks.js (Gilles De Mey) [#18280](https://github.com/nodejs/node/pull/18280)
* [[`485d656013`](https://github.com/nodejs/node/commit/485d656013)] - **lib**: use american spelling as per style guide (sreepurnajasti) [#18226](https://github.com/nodejs/node/pull/18226)
* [[`dcdb646ada`](https://github.com/nodejs/node/commit/dcdb646ada)] - **lib**: fix spelling in comments (Tobias Nießen) [#18018](https://github.com/nodejs/node/pull/18018)
* [[`8f8e7479cb`](https://github.com/nodejs/node/commit/8f8e7479cb)] - **lib**: remove queue implementation from JSStreamWrap (Anna Henningsen) [#17918](https://github.com/nodejs/node/pull/17918)
* [[`9edf023694`](https://github.com/nodejs/node/commit/9edf023694)] - **n-api**: throw RangeError napi_create_typedarray() (Jinho Bang) [#18037](https://github.com/nodejs/node/pull/18037)
* [[`0668a75c39`](https://github.com/nodejs/node/commit/0668a75c39)] - **(SEMVER-MINOR)** **n-api**: expose n-api version in process.versions (Michael Dawson) [#18067](https://github.com/nodejs/node/pull/18067)
* [[`f693e81ee5`](https://github.com/nodejs/node/commit/f693e81ee5)] - **n-api**: throw RangeError in napi_create_dataview() with invalid range (Jinho Bang) [#17869](https://github.com/nodejs/node/pull/17869)
* [[`470832f203`](https://github.com/nodejs/node/commit/470832f203)] - **path**: fix path.normalize for relative paths (Weijia Wang) [#17974](https://github.com/nodejs/node/pull/17974)
* [[`645be73b9d`](https://github.com/nodejs/node/commit/645be73b9d)] - **(SEMVER-MINOR)** **perf_hooks,http2**: add performance.clear() (James M Snell) [#18046](https://github.com/nodejs/node/pull/18046)
* [[`11982aecd4`](https://github.com/nodejs/node/commit/11982aecd4)] - **process**: JS fast path for bindings (Anatoli Papirovski) [#18365](https://github.com/nodejs/node/pull/18365)
* [[`ce7ce9d1ee`](https://github.com/nodejs/node/commit/ce7ce9d1ee)] - **process**: clean up signal handler setup (Anatoli Papirovski) [#18330](https://github.com/nodejs/node/pull/18330)
* [[`a5b35db5d2`](https://github.com/nodejs/node/commit/a5b35db5d2)] - **process**: remove dead code (Anatoli Papirovski) [#18330](https://github.com/nodejs/node/pull/18330)
* [[`56a9ae7773`](https://github.com/nodejs/node/commit/56a9ae7773)] - **readline**: update references to archived repository (Tobias Nießen) [#17924](https://github.com/nodejs/node/pull/17924)
* [[`144cfb4b99`](https://github.com/nodejs/node/commit/144cfb4b99)] - **src**: remove outdated domain reference (Anatoli Papirovski) [#18291](https://github.com/nodejs/node/pull/18291)
* [[`3ab391d3d3`](https://github.com/nodejs/node/commit/3ab391d3d3)] - **src**: remove unnecessary block scope (Anatoli Papirovski) [#18291](https://github.com/nodejs/node/pull/18291)
* [[`84f8e62f97`](https://github.com/nodejs/node/commit/84f8e62f97)] - **src**: DRY ip address parsing code in cares_wrap.cc (Ben Noordhuis) [#18398](https://github.com/nodejs/node/pull/18398)
* [[`ecf5bea485`](https://github.com/nodejs/node/commit/ecf5bea485)] - **src**: remove unused variable (cjihrig) [#18385](https://github.com/nodejs/node/pull/18385)
* [[`1c8df28752`](https://github.com/nodejs/node/commit/1c8df28752)] - **src**: fix -Wimplicit-fallthrough warning (Ben Noordhuis) [#18205](https://github.com/nodejs/node/pull/18205)
* [[`4513cbb4fe`](https://github.com/nodejs/node/commit/4513cbb4fe)] - **src**: refactor callback #defines into C++ templates (Anna Henningsen) [#18133](https://github.com/nodejs/node/pull/18133)
* [[`077bcbd202`](https://github.com/nodejs/node/commit/077bcbd202)] - **src**: introduce internal buffer slice constructor (Anna Henningsen) [#18030](https://github.com/nodejs/node/pull/18030)
* [[`87e3d3db89`](https://github.com/nodejs/node/commit/87e3d3db89)] - **src**: fix code coverage cleanup (Michael Dawson) [#18081](https://github.com/nodejs/node/pull/18081)
* [[`15aaf18b72`](https://github.com/nodejs/node/commit/15aaf18b72)] - **src**: remove declarations for missing functions (Anna Henningsen) [#18134](https://github.com/nodejs/node/pull/18134)
* [[`ac0a0a6775`](https://github.com/nodejs/node/commit/ac0a0a6775)] - **src**: harden JSStream callbacks (Anna Henningsen) [#18028](https://github.com/nodejs/node/pull/18028)
* [[`217ddd8ba2`](https://github.com/nodejs/node/commit/217ddd8ba2)] - **src,doc,test**: Fix common misspellings (Roman Reiss) [#18151](https://github.com/nodejs/node/pull/18151)
* [[`c4abdcdc30`](https://github.com/nodejs/node/commit/c4abdcdc30)] - **(SEMVER-MINOR)** **stream**: avoid writeAfterEnd() while ending (陈刚) [#18170](https://github.com/nodejs/node/pull/18170)
* [[`25bebae61c`](https://github.com/nodejs/node/commit/25bebae61c)] - **stream**: simplify `src._readableState` to `state` (陈刚) [#18264](https://github.com/nodejs/node/pull/18264)
* [[`f7d57d039a`](https://github.com/nodejs/node/commit/f7d57d039a)] - **stream**: remove unreachable code (Luigi Pinca) [#18239](https://github.com/nodejs/node/pull/18239)
* [[`117b20e621`](https://github.com/nodejs/node/commit/117b20e621)] - **test**: adds tests for vm invalid arguments (Gilles De Mey) [#18282](https://github.com/nodejs/node/pull/18282)
* [[`c84dd03120`](https://github.com/nodejs/node/commit/c84dd03120)] - **test**: refactor addons-napi/test_exception/test.js (Rich Trott) [#18340](https://github.com/nodejs/node/pull/18340)
* [[`1458e51d2f`](https://github.com/nodejs/node/commit/1458e51d2f)] - **test**: fix test-tls-server-verify.js on Windows CI (Rich Trott) [#18382](https://github.com/nodejs/node/pull/18382)
* [[`7d27228e90`](https://github.com/nodejs/node/commit/7d27228e90)] - **test**: use correct size in test-stream-buffer-list (Luigi Pinca) [#18239](https://github.com/nodejs/node/pull/18239)
* [[`5855a57d52`](https://github.com/nodejs/node/commit/5855a57d52)] - **test**: change assert message to default (ryanmahan) [#18259](https://github.com/nodejs/node/pull/18259)
* [[`fc89cea5cd`](https://github.com/nodejs/node/commit/fc89cea5cd)] - **test**: use countdown timer (Mandeep Singh) [#17326](https://github.com/nodejs/node/pull/17326)
* [[`761f26eb12`](https://github.com/nodejs/node/commit/761f26eb12)] - **test**: make async-wrap-getasyncid parallelizable (Joyee Cheung) [#18245](https://github.com/nodejs/node/pull/18245)
* [[`506c6e841c`](https://github.com/nodejs/node/commit/506c6e841c)] - **test**: refactor test-http-parser (Jon Moss) [#18219](https://github.com/nodejs/node/pull/18219)
* [[`5b5f5b1b32`](https://github.com/nodejs/node/commit/5b5f5b1b32)] - **test**: add assertions for TextEncoder/Decoder (Sho Miyamoto) [#18132](https://github.com/nodejs/node/pull/18132)
* [[`3299a1a19b`](https://github.com/nodejs/node/commit/3299a1a19b)] - **test**: remove trivial buffer imports (sreepurnajasti) [#18034](https://github.com/nodejs/node/pull/18034)
* [[`78e05da071`](https://github.com/nodejs/node/commit/78e05da071)] - **test**: use shorthand properties (Tobias Nießen) [#18105](https://github.com/nodejs/node/pull/18105)
* [[`63be0d6daa`](https://github.com/nodejs/node/commit/63be0d6daa)] - **test**: simplify loadDHParam in TLS test (Tobias Nießen) [#18103](https://github.com/nodejs/node/pull/18103)
* [[`1dcae5756e`](https://github.com/nodejs/node/commit/1dcae5756e)] - **test**: improve to use template string (sreepurnajasti) [#18097](https://github.com/nodejs/node/pull/18097)
* [[`0c8b5d5bfb`](https://github.com/nodejs/node/commit/0c8b5d5bfb)] - **test**: fixed typos in napi test (furstenheim) [#18148](https://github.com/nodejs/node/pull/18148)
* [[`2aeb025999`](https://github.com/nodejs/node/commit/2aeb025999)] - **test**: add common.crashOnUnhandledRejection to addons/callback-scope (Sho Miyamoto) [#18076](https://github.com/nodejs/node/pull/18076)
* [[`7706e5f1ea`](https://github.com/nodejs/node/commit/7706e5f1ea)] - **test**: remove orphaned entries from status (Kyle Farnung) [#18092](https://github.com/nodejs/node/pull/18092)
* [[`5fccb6ea3a`](https://github.com/nodejs/node/commit/5fccb6ea3a)] - **test**: fix spelling in test case comments (Tobias Nießen) [#18018](https://github.com/nodejs/node/pull/18018)
* [[`3456e61b44`](https://github.com/nodejs/node/commit/3456e61b44)] - **test**: use smaller input file for test-zlib.js (Rich Trott) [#17988](https://github.com/nodejs/node/pull/17988)
* [[`733df362fa`](https://github.com/nodejs/node/commit/733df362fa)] - **test**: update references to archived repository (Tobias Nießen) [#17924](https://github.com/nodejs/node/pull/17924)
* [[`2eb1aa81fa`](https://github.com/nodejs/node/commit/2eb1aa81fa)] - **test**: move common.fires() to inspector-helper (Rich Trott) [#17401](https://github.com/nodejs/node/pull/17401)
* [[`167e9c6dcd`](https://github.com/nodejs/node/commit/167e9c6dcd)] - **test**: refactor test-repl (Anna Henningsen) [#17926](https://github.com/nodejs/node/pull/17926)
* [[`7b73e704ca`](https://github.com/nodejs/node/commit/7b73e704ca)] - **timers**: attach listOnTimeout function to TimerWrap (Matteo Collina) [#18388](https://github.com/nodejs/node/pull/18388)
* [[`96b072233a`](https://github.com/nodejs/node/commit/96b072233a)] - **tls**: refactor write queues away (Anna Henningsen) [#17883](https://github.com/nodejs/node/pull/17883)
* [[`be9958afb6`](https://github.com/nodejs/node/commit/be9958afb6)] - **tools**: use babel-eslint as ESLint parser (Michaël Zasso) [#17820](https://github.com/nodejs/node/pull/17820)
* [[`715e673d06`](https://github.com/nodejs/node/commit/715e673d06)] - **tools**: add babel-eslint (Michaël Zasso) [#17820](https://github.com/nodejs/node/pull/17820)
* [[`d349fcae11`](https://github.com/nodejs/node/commit/d349fcae11)] - **tools**: update ESLint to 4.15.0 (Michaël Zasso) [#17820](https://github.com/nodejs/node/pull/17820)
* [[`4bc4d004b1`](https://github.com/nodejs/node/commit/4bc4d004b1)] - **tools**: move eslint from tools to tools/node_modules (Michaël Zasso) [#17820](https://github.com/nodejs/node/pull/17820)

<a id="9.4.0"></a>
## 2018-01-10, Version 9.4.0 (Current), @MylesBorins

### Notable Changes

* **async\_hooks**:
  - deprecate AsyncHooks Sensitive API and runInAsyncIdScope. Neither API were documented. (Andreas Madsen) [#16972](https://github.com/nodejs/node/pull/16972)
* **deps**:
  - update nghttp2 to 1.29.0 (James M Snell) [#17908](https://github.com/nodejs/node/pull/17908)
  - upgrade npm to 5.6.0 (Kat Marchán) [#17535](https://github.com/nodejs/node/pull/17535)
  - cherry-pick 50f7455 from upstream V8 (Michaël Zasso) [#16591](https://github.com/nodejs/node/pull/16591)
* **events**:
  - remove reaches into _events internals (Anatoli Papirovski) [#17440](https://github.com/nodejs/node/pull/17440)
* **http**:
  - add rawPacket in err of `clientError` event (XadillaX) [#17672](https://github.com/nodejs/node/pull/17672)
* **http2**:
  - implement maxSessionMemory (James M Snell) [#17967](https://github.com/nodejs/node/pull/17967)
  - add initial support for originSet (James M Snell) [#17935](https://github.com/nodejs/node/pull/17935)
  - add altsvc support (James M Snell) [#17917](https://github.com/nodejs/node/pull/17917)
  - perf_hooks integration (James M Snell) [#17906](https://github.com/nodejs/node/pull/17906)
  - Refactoring and cleanup of Http2Session and Http2Stream destroy (James M Snell) [#17406](https://github.com/nodejs/node/pull/17406)
* **net**:
  - remove Socket.prototype.listen (Ruben Bridgewater) [#13735](https://github.com/nodejs/node/pull/13735)
* **repl**:
  - show lexically scoped vars in tab completion (Michaël Zasso) [#16591](https://github.com/nodejs/node/pull/16591)
* **stream**:
  - rm {writeable/readable}State.length (Calvin Metcalf) [#12857](https://github.com/nodejs/node/pull/12857)
  - add flow and buffer properties to streams (Calvin Metcalf) [#12855](https://github.com/nodejs/node/pull/12855)
* **util**:
  - allow wildcards in NODE_DEBUG variable (Tyler) [#17609](https://github.com/nodejs/node/pull/17609)
* **zlib**:
  - add ArrayBuffer support (Jem Bezooyen) [#16042](https://github.com/nodejs/node/pull/16042)
* **Added new collaborator**
  - [starkwang](https://github.com/starkwang) Weijia Wang
* **Added new TSC member**
  - [danbev](https://github.com/danbev) Daniel Bevenius

### Commits

* [[`ec443c3430`](https://github.com/nodejs/node/commit/ec443c3430)] - **assert**: fix .throws operator (Ruben Bridgewater) [#17575](https://github.com/nodejs/node/pull/17575)
* [[`0843ed6ae7`](https://github.com/nodejs/node/commit/0843ed6ae7)] - **async_hooks**: use CHECK instead of throwing error (Jon Moss) [#17832](https://github.com/nodejs/node/pull/17832)
* [[`23f4433f89`](https://github.com/nodejs/node/commit/23f4433f89)] - **(SEMVER-MINOR)** **async_hooks**: deprecate undocumented API (Andreas Madsen) [#16972](https://github.com/nodejs/node/pull/16972)
* [[`63c23a1ff2`](https://github.com/nodejs/node/commit/63c23a1ff2)] - **benchmark**: fix timeout in write-stream-throughput (Anatoli Papirovski) [#17958](https://github.com/nodejs/node/pull/17958)
* [[`14eb97ebf7`](https://github.com/nodejs/node/commit/14eb97ebf7)] - **benchmark**: make temp file path configurable (Rich Trott) [#17811](https://github.com/nodejs/node/pull/17811)
* [[`27227cf4c7`](https://github.com/nodejs/node/commit/27227cf4c7)] - **benchmark**: refactor console benchmark (Ruben Bridgewater) [#17707](https://github.com/nodejs/node/pull/17707)
* [[`0aa403b649`](https://github.com/nodejs/node/commit/0aa403b649)] - **buffer**: optimize readDouble and readFloat methods (Ben Noordhuis) [#17775](https://github.com/nodejs/node/pull/17775)
* [[`d93b4765a5`](https://github.com/nodejs/node/commit/d93b4765a5)] - **build**: document targets in the Makefile (Joyee Cheung) [#16975](https://github.com/nodejs/node/pull/16975)
* [[`224033db56`](https://github.com/nodejs/node/commit/224033db56)] - **build**: put .PHONY directly before its target (Oky Antoro) [#17964](https://github.com/nodejs/node/pull/17964)
* [[`2d857ed7c8`](https://github.com/nodejs/node/commit/2d857ed7c8)] - **build**: remove duplicate async-hooks and known_issues test runs (Rich Trott) [#17912](https://github.com/nodejs/node/pull/17912)
* [[`d066db7014`](https://github.com/nodejs/node/commit/d066db7014)] - **cluster**: support windowsHide option for workers (Todd Wong) [#17412](https://github.com/nodejs/node/pull/17412)
* [[`28283efd89`](https://github.com/nodejs/node/commit/28283efd89)] - **console**: order functions and remove \n\n (Ruben Bridgewater) [#17707](https://github.com/nodejs/node/pull/17707)
* [[`41e2bb185d`](https://github.com/nodejs/node/commit/41e2bb185d)] - **console**: make variables and checks stricter (Ruben Bridgewater) [#17707](https://github.com/nodejs/node/pull/17707)
* [[`0573c0fb23`](https://github.com/nodejs/node/commit/0573c0fb23)] - **console**: make error handling engine agnostic (Ruben Bridgewater) [#17707](https://github.com/nodejs/node/pull/17707)
* [[`1b8d3ec5e7`](https://github.com/nodejs/node/commit/1b8d3ec5e7)] - **crypto**: add ocsp_request ClientHelloParser::Reset (Daniel Bevenius) [#17753](https://github.com/nodejs/node/pull/17753)
* [[`d387c178b2`](https://github.com/nodejs/node/commit/d387c178b2)] - **crypto**: warn on invalid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* [[`7153434fae`](https://github.com/nodejs/node/commit/7153434fae)] - **crypto**: reuse variable instead of reevaluation (Tobias Nießen) [#17735](https://github.com/nodejs/node/pull/17735)
* [[`7d03567287`](https://github.com/nodejs/node/commit/7d03567287)] - **crypto**: remove unused header in clienthello.h (Daniel Bevenius) [#17752](https://github.com/nodejs/node/pull/17752)
* [[`dfb9b5e83a`](https://github.com/nodejs/node/commit/dfb9b5e83a)] - **crypto**: move node_crypto_clienthello-inl.h to cc (Daniel Bevenius) [#17606](https://github.com/nodejs/node/pull/17606)
* [[`43fbc393e3`](https://github.com/nodejs/node/commit/43fbc393e3)] - **deps**: cherry-pick 50f7455 from upstream V8 (Michaël Zasso) [#16591](https://github.com/nodejs/node/pull/16591)
* [[`5df8c76ea9`](https://github.com/nodejs/node/commit/5df8c76ea9)] - **deps**: update nghttp2 to 1.29.0 (James M Snell) [#17908](https://github.com/nodejs/node/pull/17908)
* [[`8f3b2d7e8a`](https://github.com/nodejs/node/commit/8f3b2d7e8a)] - **deps**: V8: cherry-pick ac0fe8ec from upstream (Ali Ijaz Sheikh) [#17695](https://github.com/nodejs/node/pull/17695)
* [[`ffe1ad6c12`](https://github.com/nodejs/node/commit/ffe1ad6c12)] - **deps**: upgrade npm to 5.6.0 (Kat Marchán) [#17535](https://github.com/nodejs/node/pull/17535)
* [[`ffc2659964`](https://github.com/nodejs/node/commit/ffc2659964)] - **doc**: fix incorrect argument type in fs.readSync (Mykola Bilochub) [#18022](https://github.com/nodejs/node/pull/18022)
* [[`ef317014e2`](https://github.com/nodejs/node/commit/ef317014e2)] - **doc**: compact eslint directives in common/README (Vse Mozhet Byt) [#17971](https://github.com/nodejs/node/pull/17971)
* [[`3623cf7ec7`](https://github.com/nodejs/node/commit/3623cf7ec7)] - **doc**: add guide on maintaining build files (Joyee Cheung) [#16975](https://github.com/nodejs/node/pull/16975)
* [[`b593d946e4`](https://github.com/nodejs/node/commit/b593d946e4)] - **doc**: re-alphabetise sections in common/README.md (Vse Mozhet Byt) [#17971](https://github.com/nodejs/node/pull/17971)
* [[`3bcdb3b996`](https://github.com/nodejs/node/commit/3bcdb3b996)] - **doc**: fix code nits in common/README (Vse Mozhet Byt) [#17971](https://github.com/nodejs/node/pull/17971)
* [[`0ad783afaf`](https://github.com/nodejs/node/commit/0ad783afaf)] - **doc**: fix link for https api change (Myles Borins) [#17630](https://github.com/nodejs/node/pull/17630)
* [[`1181ff7ecc`](https://github.com/nodejs/node/commit/1181ff7ecc)] - **doc**: correct spelling (sreepurnajasti) [#17911](https://github.com/nodejs/node/pull/17911)
* [[`43ac36c6de`](https://github.com/nodejs/node/commit/43ac36c6de)] - **doc**: grammar fixes in http2.md (Rich Trott) [#17972](https://github.com/nodejs/node/pull/17972)
* [[`46f39b590b`](https://github.com/nodejs/node/commit/46f39b590b)] - **doc**: add docs for common/http2.js utility (James M Snell) [#17942](https://github.com/nodejs/node/pull/17942)
* [[`83c725dc73`](https://github.com/nodejs/node/commit/83c725dc73)] - **doc**: updates examples to use NULL (Michael Dawson) [#18008](https://github.com/nodejs/node/pull/18008)
* [[`72ed11ac78`](https://github.com/nodejs/node/commit/72ed11ac78)] - **doc**: move matthewloring to emeriti (Rich Trott) [#17998](https://github.com/nodejs/node/pull/17998)
* [[`6efef47c2a`](https://github.com/nodejs/node/commit/6efef47c2a)] - **doc**: move joshgav to TSC emeriti list (Rich Trott) [#17953](https://github.com/nodejs/node/pull/17953)
* [[`294c5f4ef0`](https://github.com/nodejs/node/commit/294c5f4ef0)] - **doc**: improve security section of README.md (Rich Trott) [#17929](https://github.com/nodejs/node/pull/17929)
* [[`445c911ba4`](https://github.com/nodejs/node/commit/445c911ba4)] - **doc**: edit for concision (Rich Trott) [#17891](https://github.com/nodejs/node/pull/17891)
* [[`3fd65815f8`](https://github.com/nodejs/node/commit/3fd65815f8)] - **doc**: remove x86 from os.arch() options (Gibson Fahnestock) [#17899](https://github.com/nodejs/node/pull/17899)
* [[`14499f8185`](https://github.com/nodejs/node/commit/14499f8185)] - **doc**: improve PR-review paragraph in CONTRIBUTING.md (Rich Trott) [#17931](https://github.com/nodejs/node/pull/17931)
* [[`54cf75ddb5`](https://github.com/nodejs/node/commit/54cf75ddb5)] - **doc**: fix typos in CONTRIBUTING.md (Rich Trott) [#17930](https://github.com/nodejs/node/pull/17930)
* [[`16fbd5718a`](https://github.com/nodejs/node/commit/16fbd5718a)] - **doc**: remove non-style information from style guide (Rich Trott) [#17866](https://github.com/nodejs/node/pull/17866)
* [[`a702fcbd4b`](https://github.com/nodejs/node/commit/a702fcbd4b)] - **doc**: copy-edit COLLABORATOR_GUIDE.md (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`240121ec42`](https://github.com/nodejs/node/commit/240121ec42)] - **doc**: improve alt text (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`312ad06cfe`](https://github.com/nodejs/node/commit/312ad06cfe)] - **doc**: fix spelling of contributors (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`2f7030de31`](https://github.com/nodejs/node/commit/2f7030de31)] - **doc**: add references to PR communication articles (Salame William) [#17902](https://github.com/nodejs/node/pull/17902)
* [[`d2b1601bd3`](https://github.com/nodejs/node/commit/d2b1601bd3)] - **doc**: replace wrong U+00A0 by common spaces (Vse Mozhet Byt) [#17940](https://github.com/nodejs/node/pull/17940)
* [[`658bdb34aa`](https://github.com/nodejs/node/commit/658bdb34aa)] - **doc**: remove duplicate words in API docs (Tobias Nießen) [#17937](https://github.com/nodejs/node/pull/17937)
* [[`181b8970b1`](https://github.com/nodejs/node/commit/181b8970b1)] - **doc**: fix duplicate words & spellings in docs (sreepurnajasti) [#17923](https://github.com/nodejs/node/pull/17923)
* [[`4850c87348`](https://github.com/nodejs/node/commit/4850c87348)] - **doc**: doc imitating the old behavior of http.Server.keepAliveTimeout (Tyson Andre) [#17660](https://github.com/nodejs/node/pull/17660)
* [[`b15f029b04`](https://github.com/nodejs/node/commit/b15f029b04)] - **doc**: fs doc improvements (James M Snell) [#17831](https://github.com/nodejs/node/pull/17831)
* [[`9fc9bb1c09`](https://github.com/nodejs/node/commit/9fc9bb1c09)] - **doc**: fix typo (Tobias Nießen) [#17900](https://github.com/nodejs/node/pull/17900)
* [[`2c9dab313e`](https://github.com/nodejs/node/commit/2c9dab313e)] - **doc**: use my legal name in README (Timothy Gu) [#17894](https://github.com/nodejs/node/pull/17894)
* [[`cb127de634`](https://github.com/nodejs/node/commit/cb127de634)] - **doc**: improve module.builtinModules text (Rich Trott) [#17865](https://github.com/nodejs/node/pull/17865)
* [[`1be0086ec8`](https://github.com/nodejs/node/commit/1be0086ec8)] - **doc**: use dashes instead of asterisks (Ruben Bridgewater) [#17722](https://github.com/nodejs/node/pull/17722)
* [[`26fbb0f78a`](https://github.com/nodejs/node/commit/26fbb0f78a)] - **doc**: use consistent new lines (Ruben Bridgewater) [#17722](https://github.com/nodejs/node/pull/17722)
* [[`a63d3c514d`](https://github.com/nodejs/node/commit/a63d3c514d)] - **doc**: update formatting to fit our 80 chars rule (Ruben Bridgewater) [#17722](https://github.com/nodejs/node/pull/17722)
* [[`59711ae42a`](https://github.com/nodejs/node/commit/59711ae42a)] - **doc**: update AUTHORS list (Ruben Bridgewater) [#17805](https://github.com/nodejs/node/pull/17805)
* [[`2d11f6b669`](https://github.com/nodejs/node/commit/2d11f6b669)] - **doc**: add starkwang to collaborators (Weijia Wang) [#17847](https://github.com/nodejs/node/pull/17847)
* [[`fe1f67f184`](https://github.com/nodejs/node/commit/fe1f67f184)] - **doc**: mark DEP0002 as end of life (Jon Moss) [#17815](https://github.com/nodejs/node/pull/17815)
* [[`d4666d0d7a`](https://github.com/nodejs/node/commit/d4666d0d7a)] - **doc**: require CI status indicator in PRs (Nikolai Vavilov) [#17151](https://github.com/nodejs/node/pull/17151)
* [[`541d189db9`](https://github.com/nodejs/node/commit/541d189db9)] - **doc**: use american spelling as per style guide (sreepurnajasti) [#17818](https://github.com/nodejs/node/pull/17818)
* [[`69945596e4`](https://github.com/nodejs/node/commit/69945596e4)] - **doc**: removed extra explanation in api/buffer.md (Waleed Ashraf) [#17796](https://github.com/nodejs/node/pull/17796)
* [[`c328e580d1`](https://github.com/nodejs/node/commit/c328e580d1)] - **doc**: improve module.builtinModules documentation (Thomas Watson) [#17712](https://github.com/nodejs/node/pull/17712)
* [[`1d935a0b2d`](https://github.com/nodejs/node/commit/1d935a0b2d)] - **doc**: instructions on how to make membership public (Michael Dawson) [#17688](https://github.com/nodejs/node/pull/17688)
* [[`b6d2090c8b`](https://github.com/nodejs/node/commit/b6d2090c8b)] - **doc**: improve fs api descriptions (Evan Lucas) [#17679](https://github.com/nodejs/node/pull/17679)
* [[`b1a8ac7774`](https://github.com/nodejs/node/commit/b1a8ac7774)] - **doc**: remove old console note (Ruben Bridgewater) [#17707](https://github.com/nodejs/node/pull/17707)
* [[`c982494433`](https://github.com/nodejs/node/commit/c982494433)] - **doc**: remove duplicate the from onboarding.md (sreepurnajasti) [#17733](https://github.com/nodejs/node/pull/17733)
* [[`206c4f85c5`](https://github.com/nodejs/node/commit/206c4f85c5)] - **doc**: fix typo in README.md (Weijia Wang) [#17729](https://github.com/nodejs/node/pull/17729)
* [[`dbc554a225`](https://github.com/nodejs/node/commit/dbc554a225)] - **doc**: fix typo in child_process.md (Rich Trott) [#17727](https://github.com/nodejs/node/pull/17727)
* [[`dd9d07caa7`](https://github.com/nodejs/node/commit/dd9d07caa7)] - **doc**: remove unused link definition (Jon Moss) [#17741](https://github.com/nodejs/node/pull/17741)
* [[`dcfe840a1e`](https://github.com/nodejs/node/commit/dcfe840a1e)] - **doc**: edit CONTRIBUTING.md preamble (Rich Trott) [#17700](https://github.com/nodejs/node/pull/17700)
* [[`ed9f2fef70`](https://github.com/nodejs/node/commit/ed9f2fef70)] - **doc**: improve release guide (Evan Lucas) [#17677](https://github.com/nodejs/node/pull/17677)
* [[`861f6adb70`](https://github.com/nodejs/node/commit/861f6adb70)] - **doc**: some fs doc improvements (James M Snell) [#17692](https://github.com/nodejs/node/pull/17692)
* [[`ecbc70fe5d`](https://github.com/nodejs/node/commit/ecbc70fe5d)] - **doc**: not all example code can be run without 1:1 (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`68722fd16e`](https://github.com/nodejs/node/commit/68722fd16e)] - **doc**: adjust TTY wording & add inter-doc links (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`d19343147b`](https://github.com/nodejs/node/commit/d19343147b)] - **doc**: fix fs.existsSync description (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`444362e048`](https://github.com/nodejs/node/commit/444362e048)] - **doc**: improve documentation.md (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`d1af106b76`](https://github.com/nodejs/node/commit/d1af106b76)] - **doc**: add countdown module to writing tests guide (Bamieh) [#17201](https://github.com/nodejs/node/pull/17201)
* [[`e059bc5503`](https://github.com/nodejs/node/commit/e059bc5503)] - **doc**: change "Node.js style cb" to "error-first cb" (Ram Goli) [#17638](https://github.com/nodejs/node/pull/17638)
* [[`712848bc7d`](https://github.com/nodejs/node/commit/712848bc7d)] - **doc**: change eventName type annotations (April Webster) [#17666](https://github.com/nodejs/node/pull/17666)
* [[`c24b4dd898`](https://github.com/nodejs/node/commit/c24b4dd898)] - **doc**: remove extra whitespace in module docs (Thomas Watson) [#17711](https://github.com/nodejs/node/pull/17711)
* [[`af1b340e39`](https://github.com/nodejs/node/commit/af1b340e39)] - **doc**: add C++ style comments to the style guide (Matheus Marchini) [#17617](https://github.com/nodejs/node/pull/17617)
* [[`5999a11526`](https://github.com/nodejs/node/commit/5999a11526)] - **doc**: include Daniel Bevenius as a TSC member (Rich Trott) [#17652](https://github.com/nodejs/node/pull/17652)
* [[`977fb13bd5`](https://github.com/nodejs/node/commit/977fb13bd5)] - **doc**: import() is supported now (Gus Caplan) [#17395](https://github.com/nodejs/node/pull/17395)
* [[`ed4d013f48`](https://github.com/nodejs/node/commit/ed4d013f48)] - **doc**: correct pbkdf2 salt length recommendation (Will Clark) [#17524](https://github.com/nodejs/node/pull/17524)
* [[`d70e6dc850`](https://github.com/nodejs/node/commit/d70e6dc850)] - **doc**: note that randomBytes throws when passed null (Tobias Nießen) [#17594](https://github.com/nodejs/node/pull/17594)
* [[`da448216cc`](https://github.com/nodejs/node/commit/da448216cc)] - **doc**: clearify promisify behavior for bad arguments (Ram Goli) [#17593](https://github.com/nodejs/node/pull/17593)
* [[`26025dec62`](https://github.com/nodejs/node/commit/26025dec62)] - **doc**: replace ArrayBufferView in crypto (Tobias Nießen) [#17595](https://github.com/nodejs/node/pull/17595)
* [[`1a84005150`](https://github.com/nodejs/node/commit/1a84005150)] - **doc,test**: mention Duplex support for TLS (Anna Henningsen) [#17599](https://github.com/nodejs/node/pull/17599)
* [[`7008719fb6`](https://github.com/nodejs/node/commit/7008719fb6)] - **(SEMVER-MINOR)** **events**: remove reaches into _events internals (Anatoli Papirovski) [#17440](https://github.com/nodejs/node/pull/17440)
* [[`f1485565ef`](https://github.com/nodejs/node/commit/f1485565ef)] - **fs**: guarantee order of callbacks in ws.close (Matteo Collina) [#18002](https://github.com/nodejs/node/pull/18002)
* [[`66c1a038a1`](https://github.com/nodejs/node/commit/66c1a038a1)] - **gitignore**: ignore *.VC.db files (Tobias Nießen) [#17898](https://github.com/nodejs/node/pull/17898)
* [[`8e1011f93b`](https://github.com/nodejs/node/commit/8e1011f93b)] - **http**: remove duplicate export (Evan Lucas) [#17982](https://github.com/nodejs/node/pull/17982)
* [[`f82439b6a0`](https://github.com/nodejs/node/commit/f82439b6a0)] - **(SEMVER-MINOR)** **http**: add rawPacket in err of `clientError` event (XadillaX) [#17672](https://github.com/nodejs/node/pull/17672)
* [[`9306de280f`](https://github.com/nodejs/node/commit/9306de280f)] - **http**: remove adapter frame from onParserExecute (Ben Noordhuis) [#17693](https://github.com/nodejs/node/pull/17693)
* [[`1ad7df6acc`](https://github.com/nodejs/node/commit/1ad7df6acc)] - **http2**: use aliased buffer for perf stats, add stats (James M Snell) [#18020](https://github.com/nodejs/node/pull/18020)
* [[`6a67dfd927`](https://github.com/nodejs/node/commit/6a67dfd927)] - **http2**: verify flood error and unsolicited frames (James M Snell) [#17969](https://github.com/nodejs/node/pull/17969)
* [[`6839283403`](https://github.com/nodejs/node/commit/6839283403)] - **http2**: verify that a dependency cycle may exist (James M Snell) [#17968](https://github.com/nodejs/node/pull/17968)
* [[`865da60e75`](https://github.com/nodejs/node/commit/865da60e75)] - **http2**: implement maxSessionMemory (James M Snell) [#17967](https://github.com/nodejs/node/pull/17967)
* [[`f17a5b92dc`](https://github.com/nodejs/node/commit/f17a5b92dc)] - **http2**: properly handle already closed stream error (James M Snell) [#17942](https://github.com/nodejs/node/pull/17942)
* [[`79d3198b7f`](https://github.com/nodejs/node/commit/79d3198b7f)] - **http2**: add aligned padding strategy (James M Snell) [#17938](https://github.com/nodejs/node/pull/17938)
* [[`2b6a5d90bd`](https://github.com/nodejs/node/commit/2b6a5d90bd)] - **http2**: add initial support for originSet (James M Snell) [#17935](https://github.com/nodejs/node/pull/17935)
* [[`9ad7a9a333`](https://github.com/nodejs/node/commit/9ad7a9a333)] - **http2**: add altsvc support (James M Snell) [#17917](https://github.com/nodejs/node/pull/17917)
* [[`e7a727e9ba`](https://github.com/nodejs/node/commit/e7a727e9ba)] - **http2**: strictly limit number on concurrent streams (James M Snell) [#16766](https://github.com/nodejs/node/pull/16766)
* [[`06aaaa8ad7`](https://github.com/nodejs/node/commit/06aaaa8ad7)] - **http2**: perf_hooks integration (James M Snell) [#17906](https://github.com/nodejs/node/pull/17906)
* [[`a003ded7fb`](https://github.com/nodejs/node/commit/a003ded7fb)] - **http2**: remove duplicate words in comments (Tobias Nießen) [#17939](https://github.com/nodejs/node/pull/17939)
* [[`1b7ce1ea02`](https://github.com/nodejs/node/commit/1b7ce1ea02)] - **http2**: implement ref() and unref() on client sessions (Kelvin Jin) [#17620](https://github.com/nodejs/node/pull/17620)
* [[`b8deb7522f`](https://github.com/nodejs/node/commit/b8deb7522f)] - **http2**: keep session objects alive during Http2Scope (Anna Henningsen) [#17863](https://github.com/nodejs/node/pull/17863)
* [[`e3c567f05b`](https://github.com/nodejs/node/commit/e3c567f05b)] - **http2**: fix compiling with `--debug-http2` (Anna Henningsen) [#17863](https://github.com/nodejs/node/pull/17863)
* [[`3a6b2ad19a`](https://github.com/nodejs/node/commit/3a6b2ad19a)] - **http2**: convert Http2Settings to an AsyncWrap (James M Snell) [#17763](https://github.com/nodejs/node/pull/17763)
* [[`bfc7e014cc`](https://github.com/nodejs/node/commit/bfc7e014cc)] - **http2**: refactor outgoing write mechanism (Anna Henningsen) [#17718](https://github.com/nodejs/node/pull/17718)
* [[`9592691d56`](https://github.com/nodejs/node/commit/9592691d56)] - **http2**: remove redundant write indirection (Anna Henningsen) [#17718](https://github.com/nodejs/node/pull/17718)
* [[`5abb60933e`](https://github.com/nodejs/node/commit/5abb60933e)] - **http2**: cleanup Http2Stream/Http2Session destroy (James M Snell) [#17406](https://github.com/nodejs/node/pull/17406)
* [[`f699a74e66`](https://github.com/nodejs/node/commit/f699a74e66)] - **http2**: be sure to destroy the Http2Stream (James M Snell) [#17406](https://github.com/nodejs/node/pull/17406)
* [[`30e75e601b`](https://github.com/nodejs/node/commit/30e75e601b)] - **http2**: only schedule write when necessary (Anna Henningsen) [#17183](https://github.com/nodejs/node/pull/17183)
* [[`d06ad0d4f0`](https://github.com/nodejs/node/commit/d06ad0d4f0)] - **http2**: don't call into JS from GC (Anna Henningsen) [#17183](https://github.com/nodejs/node/pull/17183)
* [[`f18d826660`](https://github.com/nodejs/node/commit/f18d826660)] - **http2**: simplify onSelectPadding (Anna Henningsen) [#17717](https://github.com/nodejs/node/pull/17717)
* [[`8d4fca3fb5`](https://github.com/nodejs/node/commit/8d4fca3fb5)] - **inspector**: make Coverity happy (Eugene Ostroukhov) [#17656](https://github.com/nodejs/node/pull/17656)
* [[`b817a8a6b2`](https://github.com/nodejs/node/commit/b817a8a6b2)] - **lib**: enable dot-notation eslint rule (Anatoli Papirovski) [#18007](https://github.com/nodejs/node/pull/18007)
* [[`2d61b9eb9f`](https://github.com/nodejs/node/commit/2d61b9eb9f)] - **lib, src**: use process.config instead of regex (Jon Moss) [#17814](https://github.com/nodejs/node/pull/17814)
* [[`3b2d8cba23`](https://github.com/nodejs/node/commit/3b2d8cba23)] - **module**: print better message on esm import error (Michaël Zasso) [#17786](https://github.com/nodejs/node/pull/17786)
* [[`79a283307a`](https://github.com/nodejs/node/commit/79a283307a)] - **n-api**: fix memory leak in napi_async_destroy() (alnyan) [#17714](https://github.com/nodejs/node/pull/17714)
* [[`74a5bbaff4`](https://github.com/nodejs/node/commit/74a5bbaff4)] - **net**: remove ADDRCONFIG DNS hint on Windows (Bartosz Sosnowski) [#17662](https://github.com/nodejs/node/pull/17662)
* [[`c3810e27bd`](https://github.com/nodejs/node/commit/c3810e27bd)] - **net**: remove Socket.prototype.write (Anna Henningsen) [#17644](https://github.com/nodejs/node/pull/17644)
* [[`e58a5ca854`](https://github.com/nodejs/node/commit/e58a5ca854)] - **net**: remove Socket.prototype.listen (Ruben Bridgewater) [#13735](https://github.com/nodejs/node/pull/13735)
* [[`0e116a01c8`](https://github.com/nodejs/node/commit/0e116a01c8)] - **perf_hooks**: fix scheduling regression (Anatoli Papirovski) [#18051](https://github.com/nodejs/node/pull/18051)
* [[`a329cf62ab`](https://github.com/nodejs/node/commit/a329cf62ab)] - **perf_hooks**: refactor internals (James M Snell) [#17822](https://github.com/nodejs/node/pull/17822)
* [[`bf0a7b6e13`](https://github.com/nodejs/node/commit/bf0a7b6e13)] - **process**: fix coverage generation (Evan Lucas) [#17651](https://github.com/nodejs/node/pull/17651)
* [[`b1bc768a57`](https://github.com/nodejs/node/commit/b1bc768a57)] - **readline**: refactor filter() callback (Rich Trott) [#17858](https://github.com/nodejs/node/pull/17858)
* [[`3831d87514`](https://github.com/nodejs/node/commit/3831d87514)] - **repl**: show lexically scoped vars in tab completion (Michaël Zasso) [#16591](https://github.com/nodejs/node/pull/16591)
* [[`2cc50530d2`](https://github.com/nodejs/node/commit/2cc50530d2)] - **repl**: fix coloring of `process.versions` (Ben Noordhuis) [#17861](https://github.com/nodejs/node/pull/17861)
* [[`bb9219bd19`](https://github.com/nodejs/node/commit/bb9219bd19)] - **src**: update make for new code coverage locations (Michael Dawson) [#17987](https://github.com/nodejs/node/pull/17987)
* [[`aa7519095c`](https://github.com/nodejs/node/commit/aa7519095c)] - **src**: remove duplicate words in comments (Tobias Nießen) [#17939](https://github.com/nodejs/node/pull/17939)
* [[`f9c84c557f`](https://github.com/nodejs/node/commit/f9c84c557f)] - **src**: silence http2 -Wunused-result warnings (cjihrig) [#17954](https://github.com/nodejs/node/pull/17954)
* [[`7e680807f8`](https://github.com/nodejs/node/commit/7e680807f8)] - **src**: add optional keep-alive object to SetImmediate (Anna Henningsen) [#17183](https://github.com/nodejs/node/pull/17183)
* [[`98dc554a2a`](https://github.com/nodejs/node/commit/98dc554a2a)] - **src**: inline HostentToAddresses() (Ben Noordhuis) [#17860](https://github.com/nodejs/node/pull/17860)
* [[`87b336a2e5`](https://github.com/nodejs/node/commit/87b336a2e5)] - **src**: remove unused GetHostByNameWrap (Ben Noordhuis) [#17860](https://github.com/nodejs/node/pull/17860)
* [[`2aa75a1f0b`](https://github.com/nodejs/node/commit/2aa75a1f0b)] - **src**: remove redundant `JSStream::DoAfterWrite` (Anna Henningsen) [#17713](https://github.com/nodejs/node/pull/17713)
* [[`99c62cc454`](https://github.com/nodejs/node/commit/99c62cc454)] - **src**: remove unused async hooks methods (Anna Henningsen) [#17757](https://github.com/nodejs/node/pull/17757)
* [[`d6c588586a`](https://github.com/nodejs/node/commit/d6c588586a)] - **src**: remove nonexistent method from header file (Anna Henningsen) [#17748](https://github.com/nodejs/node/pull/17748)
* [[`a93ed5c282`](https://github.com/nodejs/node/commit/a93ed5c282)] - **src**: replace SetAccessor w/ SetAccessorProperty (Jure Triglav) [#17665](https://github.com/nodejs/node/pull/17665)
* [[`d84d9be6ef`](https://github.com/nodejs/node/commit/d84d9be6ef)] - **src**: rename `On*` -\> `Emit*` for stream callbacks (Anna Henningsen) [#17701](https://github.com/nodejs/node/pull/17701)
* [[`6f520e3f69`](https://github.com/nodejs/node/commit/6f520e3f69)] - **src**: remove unused strings from env.h (Anna Henningsen) [#17643](https://github.com/nodejs/node/pull/17643)
* [[`6634dc4d0c`](https://github.com/nodejs/node/commit/6634dc4d0c)] - **src**: fix -Wundefined-inline warnings (Ben Noordhuis) [#17649](https://github.com/nodejs/node/pull/17649)
* [[`0c6d9ae72e`](https://github.com/nodejs/node/commit/0c6d9ae72e)] - **src**: fix compile warnings introduced in 73ad3f9bea (Ben Noordhuis) [#17649](https://github.com/nodejs/node/pull/17649)
* [[`008336c920`](https://github.com/nodejs/node/commit/008336c920)] - **src**: minor refactoring to StreamBase writes (Anna Henningsen) [#17564](https://github.com/nodejs/node/pull/17564)
* [[`7ed9e5de39`](https://github.com/nodejs/node/commit/7ed9e5de39)] - **src**: remove `StreamResourc::Cast()` (Anna Henningsen) [#17564](https://github.com/nodejs/node/pull/17564)
* [[`d879b63077`](https://github.com/nodejs/node/commit/d879b63077)] - **src**: make FSEventWrap/StatWatcher::Start more robust (Timothy Gu) [#17432](https://github.com/nodejs/node/pull/17432)
* [[`6ba00b8d48`](https://github.com/nodejs/node/commit/6ba00b8d48)] - **src**: refactor and harden `ProcessEmitWarning()` (Anna Henningsen) [#17420](https://github.com/nodejs/node/pull/17420)
* [[`316da5e667`](https://github.com/nodejs/node/commit/316da5e667)] - **src**: use correct OOB check for IPv6 parsing (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`ca3c2551b6`](https://github.com/nodejs/node/commit/ca3c2551b6)] - **src**: make url host a proper C++ class (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`9f1fe63c39`](https://github.com/nodejs/node/commit/9f1fe63c39)] - **src**: move url internals into anonymous namespace (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`75f99b7c16`](https://github.com/nodejs/node/commit/75f99b7c16)] - **src**: minor cleanups to node_url.cc (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`6bd0aff092`](https://github.com/nodejs/node/commit/6bd0aff092)] - **src**: remove unused variable in node_contextify (Daniel Bevenius) [#17491](https://github.com/nodejs/node/pull/17491)
* [[`df6acf9a84`](https://github.com/nodejs/node/commit/df6acf9a84)] - **src**: remove tracking for exception arrow data (Anna Henningsen) [#17394](https://github.com/nodejs/node/pull/17394)
* [[`e63e4a1fac`](https://github.com/nodejs/node/commit/e63e4a1fac)] - **src**: remove async_hooks destroy timer handle (Anna Henningsen) [#17117](https://github.com/nodejs/node/pull/17117)
* [[`e1f0846a2b`](https://github.com/nodejs/node/commit/e1f0846a2b)] - **src**: introduce internal C++ SetImmediate() mechanism (Anna Henningsen) [#17117](https://github.com/nodejs/node/pull/17117)
* [[`7d1d7390eb`](https://github.com/nodejs/node/commit/7d1d7390eb)] - **src**: fix inspector nullptr deref on abrupt exit (Ben Noordhuis) [#17577](https://github.com/nodejs/node/pull/17577)
* [[`c5c4a534d1`](https://github.com/nodejs/node/commit/c5c4a534d1)] - **(SEMVER-MINOR)** **stream**: rm {writeable/readable}State.length (Calvin Metcalf) [#12857](https://github.com/nodejs/node/pull/12857)
* [[`4b0c8759d3`](https://github.com/nodejs/node/commit/4b0c8759d3)] - **(SEMVER-MINOR)** **stream**: add flow and buffer properties to streams (Calvin Metcalf) [#12855](https://github.com/nodejs/node/pull/12855)
* [[`757e685803`](https://github.com/nodejs/node/commit/757e685803)] - **stream**: remove `undefined` check (Anna Henningsen) [#17644](https://github.com/nodejs/node/pull/17644)
* [[`b313e81783`](https://github.com/nodejs/node/commit/b313e81783)] - **test**: fix flaky test-http-pipeline-flood (Anatoli Papirovski) [#17955](https://github.com/nodejs/node/pull/17955)
* [[`51eab4b005`](https://github.com/nodejs/node/commit/51eab4b005)] - **test**: rename regression tests (Tobias Nießen) [#17948](https://github.com/nodejs/node/pull/17948)
* [[`8806e54c24`](https://github.com/nodejs/node/commit/8806e54c24)] - **test**: fix flaky test-http-highwatermark (Anatoli Papirovski) [#17949](https://github.com/nodejs/node/pull/17949)
* [[`3399e8ac5a`](https://github.com/nodejs/node/commit/3399e8ac5a)] - **test**: fix flaky test-pipe-unref (Anatoli Papirovski) [#17950](https://github.com/nodejs/node/pull/17950)
* [[`79980582b4`](https://github.com/nodejs/node/commit/79980582b4)] - **test**: fix flaky http-writable-true-after-close (Anatoli Papirovski) [#17952](https://github.com/nodejs/node/pull/17952)
* [[`591dd4e398`](https://github.com/nodejs/node/commit/591dd4e398)] - **test**: fix crypto test case to use correct encoding (Tobias Nießen) [#17956](https://github.com/nodejs/node/pull/17956)
* [[`f87a1a6ca8`](https://github.com/nodejs/node/commit/f87a1a6ca8)] - **test**: simplify test-buffer-slice.js (Weijia Wang) [#17962](https://github.com/nodejs/node/pull/17962)
* [[`3cc9882e8c`](https://github.com/nodejs/node/commit/3cc9882e8c)] - **test**: fix flaky test-resolve-async (Anatoli Papirovski) [#17957](https://github.com/nodejs/node/pull/17957)
* [[`3927c6f64e`](https://github.com/nodejs/node/commit/3927c6f64e)] - **test**: improve readability of some crypto tests (Tobias Nießen) [#17904](https://github.com/nodejs/node/pull/17904)
* [[`2f4da8b801`](https://github.com/nodejs/node/commit/2f4da8b801)] - **test**: use countdown in test file (sreepurnajasti) [#17874](https://github.com/nodejs/node/pull/17874)
* [[`ef533c99ba`](https://github.com/nodejs/node/commit/ef533c99ba)] - **test**: add hasCrypto when using binding('crypto') (Daniel Bevenius) [#17867](https://github.com/nodejs/node/pull/17867)
* [[`421eb750b2`](https://github.com/nodejs/node/commit/421eb750b2)] - **test**: improve to use template string (sreepurnajasti) [#17895](https://github.com/nodejs/node/pull/17895)
* [[`275970973e`](https://github.com/nodejs/node/commit/275970973e)] - **test**: replace map() with forEach() where appropriate (Rich Trott) [#17858](https://github.com/nodejs/node/pull/17858)
* [[`f25bab5606`](https://github.com/nodejs/node/commit/f25bab5606)] - **test**: fix flaky test-benchmark-fs (Rich Trott) [#17885](https://github.com/nodejs/node/pull/17885)
* [[`411e7724d4`](https://github.com/nodejs/node/commit/411e7724d4)] - **test**: make test-tls-invoke-queued use public API (Anna Henningsen) [#17864](https://github.com/nodejs/node/pull/17864)
* [[`1dd859d413`](https://github.com/nodejs/node/commit/1dd859d413)] - **test**: refactor test-tls-securepair-fiftharg (Anna Henningsen) [#17836](https://github.com/nodejs/node/pull/17836)
* [[`8b666d61c7`](https://github.com/nodejs/node/commit/8b666d61c7)] - **test**: reduce scope of variable in common module (Rich Trott) [#17830](https://github.com/nodejs/node/pull/17830)
* [[`9110654965`](https://github.com/nodejs/node/commit/9110654965)] - **test**: remove undefined function (Rich Trott) [#17845](https://github.com/nodejs/node/pull/17845)
* [[`ca35d08291`](https://github.com/nodejs/node/commit/ca35d08291)] - **test**: remove ambiguous error messages from test_error (Nicholas Drane) [#17812](https://github.com/nodejs/node/pull/17812)
* [[`ee4cbac52b`](https://github.com/nodejs/node/commit/ee4cbac52b)] - **test**: fix unreliable async-hooks/test-signalwrap (Rich Trott) [#17827](https://github.com/nodejs/node/pull/17827)
* [[`fea5d08d65`](https://github.com/nodejs/node/commit/fea5d08d65)] - **test**: fix flaky test-benchmark-fs (Rich Trott) [#17853](https://github.com/nodejs/node/pull/17853)
* [[`ded097a2bb`](https://github.com/nodejs/node/commit/ded097a2bb)] - **test**: use common module API in test-child-process-exec-stdout-stderr-data-string (sreepurnajasti) [#17751](https://github.com/nodejs/node/pull/17751)
* [[`06862f0c32`](https://github.com/nodejs/node/commit/06862f0c32)] - **test**: do not open fixture files for writing (Rich Trott) [#17810](https://github.com/nodejs/node/pull/17810)
* [[`e9ace7e4dd`](https://github.com/nodejs/node/commit/e9ace7e4dd)] - **test**: do not open fixture files for writing (Rich Trott) [#17808](https://github.com/nodejs/node/pull/17808)
* [[`f79d2efedb`](https://github.com/nodejs/node/commit/f79d2efedb)] - **test**: use valid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* [[`112b655107`](https://github.com/nodejs/node/commit/112b655107)] - **test**: improve flaky test-listen-fd-ebadf.js (Rich Trott) [#17797](https://github.com/nodejs/node/pull/17797)
* [[`dce7d7fc64`](https://github.com/nodejs/node/commit/dce7d7fc64)] - **test**: refactor test-repl-definecommand (Rich Trott) [#17795](https://github.com/nodejs/node/pull/17795)
* [[`60ae55680c`](https://github.com/nodejs/node/commit/60ae55680c)] - **test**: refactor test-net-connect-buffer (Anna Henningsen) [#17710](https://github.com/nodejs/node/pull/17710)
* [[`c9539678ca`](https://github.com/nodejs/node/commit/c9539678ca)] - **test**: increase diffie-hellman test coverage (Leko) [#17728](https://github.com/nodejs/node/pull/17728)
* [[`6d15185235`](https://github.com/nodejs/node/commit/6d15185235)] - **test**: increase pbkdf2 test coverage (Leko) [#17730](https://github.com/nodejs/node/pull/17730)
* [[`dd14004eed`](https://github.com/nodejs/node/commit/dd14004eed)] - **test**: fix typo in test-inspector-cluster-port-clash.js (Rich Trott) [#17782](https://github.com/nodejs/node/pull/17782)
* [[`5a9694eb60`](https://github.com/nodejs/node/commit/5a9694eb60)] - **test**: change callback function to arrow function (rt33) [#17734](https://github.com/nodejs/node/pull/17734)
* [[`305dd5671c`](https://github.com/nodejs/node/commit/305dd5671c)] - **test**: add test for postmortem metadata validation (cjihrig) [#17685](https://github.com/nodejs/node/pull/17685)
* [[`d9190c17ed`](https://github.com/nodejs/node/commit/d9190c17ed)] - **test**: Use countdown in test file (sreepurnajasti) [#17646](https://github.com/nodejs/node/pull/17646)
* [[`46f8a9eddc`](https://github.com/nodejs/node/commit/46f8a9eddc)] - **test**: update test-http-content-length to use countdown (Bamieh) [#17201](https://github.com/nodejs/node/pull/17201)
* [[`373d5df3b7`](https://github.com/nodejs/node/commit/373d5df3b7)] - **test**: coverage for emitExperimentalWarning (Mithun Sasidharan) [#17635](https://github.com/nodejs/node/pull/17635)
* [[`bc45354cce`](https://github.com/nodejs/node/commit/bc45354cce)] - **test**: change callback function to arrow function (routerman) [#17697](https://github.com/nodejs/node/pull/17697)
* [[`d48a1b99ee`](https://github.com/nodejs/node/commit/d48a1b99ee)] - **test**: change callback function to arrow function (you12724) [#17698](https://github.com/nodejs/node/pull/17698)
* [[`a9d83ce9e0`](https://github.com/nodejs/node/commit/a9d83ce9e0)] - **test**: change callback function to arrow function (Shinya Kanamaru) [#17699](https://github.com/nodejs/node/pull/17699)
* [[`bdddb82595`](https://github.com/nodejs/node/commit/bdddb82595)] - **test**: check socketOnDrain where needPause is false (Leko) [#17654](https://github.com/nodejs/node/pull/17654)
* [[`b8265285ff`](https://github.com/nodejs/node/commit/b8265285ff)] - **test**: fix flaky test-benchmark-misc (Rich Trott) [#17686](https://github.com/nodejs/node/pull/17686)
* [[`b1fd50a773`](https://github.com/nodejs/node/commit/b1fd50a773)] - **test**: remove literals that obscure assert messages (Rich Trott) [#17642](https://github.com/nodejs/node/pull/17642)
* [[`f16eca4383`](https://github.com/nodejs/node/commit/f16eca4383)] - **test**: improve coverage for util.promisify (Mithun Sasidharan) [#17591](https://github.com/nodejs/node/pull/17591)
* [[`97eaaf907f`](https://github.com/nodejs/node/commit/97eaaf907f)] - **test**: remove unused disposed_ variable (Daniel Bevenius) [#17628](https://github.com/nodejs/node/pull/17628)
* [[`cc683bd0cb`](https://github.com/nodejs/node/commit/cc683bd0cb)] - **test**: expand test-https-keep-alive-large-write (Anna Henningsen) [#17564](https://github.com/nodejs/node/pull/17564)
* [[`6cb4cc2f1c`](https://github.com/nodejs/node/commit/6cb4cc2f1c)] - **test**: fix flaky test-child-process-pass-fd (Rich Trott) [#17598](https://github.com/nodejs/node/pull/17598)
* [[`5cd08d3a59`](https://github.com/nodejs/node/commit/5cd08d3a59)] - **test**: add unhandled rejection guard (babygoat) [#17275](https://github.com/nodejs/node/pull/17275)
* [[`b379d8d105`](https://github.com/nodejs/node/commit/b379d8d105)] - **test**: improve crypto/random.js coverage (Leko) [#17555](https://github.com/nodejs/node/pull/17555)
* [[`bc7dc65229`](https://github.com/nodejs/node/commit/bc7dc65229)] - **test**: add test description to fs.readFile tests (Jamie Davis) [#17610](https://github.com/nodejs/node/pull/17610)
* [[`70588f7f21`](https://github.com/nodejs/node/commit/70588f7f21)] - **test**: simplify common.expectsError (Ruben Bridgewater) [#17616](https://github.com/nodejs/node/pull/17616)
* [[`fb640c66cb`](https://github.com/nodejs/node/commit/fb640c66cb)] - **timers**: remove domain enter and exit (Anatoli Papirovski) [#17880](https://github.com/nodejs/node/pull/17880)
* [[`3997617869`](https://github.com/nodejs/node/commit/3997617869)] - **tls**: set servername on client side too (James M Snell) [#17935](https://github.com/nodejs/node/pull/17935)
* [[`e69ea78974`](https://github.com/nodejs/node/commit/e69ea78974)] - **tls**: fix SNICallback without .server option (Anna Henningsen) [#17835](https://github.com/nodejs/node/pull/17835)
* [[`b44f245b14`](https://github.com/nodejs/node/commit/b44f245b14)] - **tls**: comment about old-style errors (xortiz) [#17759](https://github.com/nodejs/node/pull/17759)
* [[`41702ef457`](https://github.com/nodejs/node/commit/41702ef457)] - **tls**: unconsume stream on destroy (Anna Henningsen) [#17478](https://github.com/nodejs/node/pull/17478)
* [[`5514330406`](https://github.com/nodejs/node/commit/5514330406)] - **tls**: use correct class name in deprecation message (Anna Henningsen) [#17561](https://github.com/nodejs/node/pull/17561)
* [[`4dacff72b5`](https://github.com/nodejs/node/commit/4dacff72b5)] - **tools**: do not override V8's gitignore (Yang Guo) [#18010](https://github.com/nodejs/node/pull/18010)
* [[`adc59a3e71`](https://github.com/nodejs/node/commit/adc59a3e71)] - **tools**: host remark-preset-lint-node in-tree (Jon Moss) [#17441](https://github.com/nodejs/node/pull/17441)
* [[`c91a7c09ae`](https://github.com/nodejs/node/commit/c91a7c09ae)] - **tools**: add check for using process.binding crypto (Daniel Bevenius) [#17867](https://github.com/nodejs/node/pull/17867)
* [[`4391ea4a57`](https://github.com/nodejs/node/commit/4391ea4a57)] - **tools**: enable array-callback-return ESLint rule (Rich Trott) [#17858](https://github.com/nodejs/node/pull/17858)
* [[`b89cda4cbd`](https://github.com/nodejs/node/commit/b89cda4cbd)] - **tools**: fix AttributeError: \_\_exit\_\_ on Python 2.6 (Dmitriy Kasyanov) [#17663](https://github.com/nodejs/node/pull/17663)
* [[`2d07243cac`](https://github.com/nodejs/node/commit/2d07243cac)] - **tools**: autofixer for lowercase-name-for-primitive (Shobhit Chittora) [#17715](https://github.com/nodejs/node/pull/17715)
* [[`7ef876d89d`](https://github.com/nodejs/node/commit/7ef876d89d)] - **tools**: fix man pages linking regex (Diego Rodríguez Baquero) [#17724](https://github.com/nodejs/node/pull/17724)
* [[`6531401cde`](https://github.com/nodejs/node/commit/6531401cde)] - **tools**: add number-isnan rule (Jon Moss) [#17556](https://github.com/nodejs/node/pull/17556)
* [[`eaa2d9116a`](https://github.com/nodejs/node/commit/eaa2d9116a)] - **tools**: simplify lowercase-name-for-primitive rule (cjihrig) [#17653](https://github.com/nodejs/node/pull/17653)
* [[`3ad8cf14f5`](https://github.com/nodejs/node/commit/3ad8cf14f5)] - **tools**: add lowercase-name-for-primitive eslint rule (Weijia Wang) [#17568](https://github.com/nodejs/node/pull/17568)
* [[`7bf6be0b7c`](https://github.com/nodejs/node/commit/7bf6be0b7c)] - **trace_events**: stop tracing agent in process.exit() (Andreas Madsen) [#18005](https://github.com/nodejs/node/pull/18005)
* [[`ed7f59a1ee`](https://github.com/nodejs/node/commit/ed7f59a1ee)] - **url**: added url fragment lookup table (Hakan Kimeiga) [#17627](https://github.com/nodejs/node/pull/17627)
* [[`28ef3de2ba`](https://github.com/nodejs/node/commit/28ef3de2ba)] - **url**: added space to class string of iterator objects (Haejin Jo) [#17558](https://github.com/nodejs/node/pull/17558)
* [[`6d9b1e4c83`](https://github.com/nodejs/node/commit/6d9b1e4c83)] - **util**: allow wildcards in NODE_DEBUG variable (Tyler) [#17609](https://github.com/nodejs/node/pull/17609)
* [[`6cc622f01b`](https://github.com/nodejs/node/commit/6cc622f01b)] - **vm**: allow modifying context name in inspector (Timothy Gu) [#17720](https://github.com/nodejs/node/pull/17720)
* [[`e2767114ff`](https://github.com/nodejs/node/commit/e2767114ff)] - **vm**: never abort on caught syntax error (Anna Henningsen) [#17394](https://github.com/nodejs/node/pull/17394)
* [[`7bf4102db9`](https://github.com/nodejs/node/commit/7bf4102db9)] - **win, build**: fix without-intl option (Bartosz Sosnowski) [#17614](https://github.com/nodejs/node/pull/17614)
* [[`584e74d8cc`](https://github.com/nodejs/node/commit/584e74d8cc)] - **(SEMVER-MINOR)** **zlib**: add ArrayBuffer support (Jem Bezooyen) [#16042](https://github.com/nodejs/node/pull/16042)

<a id="9.3.0"></a>
## 2017-12-12, Version 9.3.0 (Current), @MylesBorins

### Notable Changes

* **async\_hooks**:
  - add trace events to async_hooks (Andreas Madsen) [#15538](https://github.com/nodejs/node/pull/15538)
  - add provider types for net server (Andreas Madsen) [#17157](https://github.com/nodejs/node/pull/17157)
* **console**:
  - console.debug can now be used outside of the inspector (Benjamin Zaslavsky) [#17033](https://github.com/nodejs/node/pull/17033)
* **deps**:
  - upgrade libuv to 1.18.0 (cjihrig) [#17282](https://github.com/nodejs/node/pull/17282)
  - patch V8 to 6.2.414.46 (Myles Borins) [#17206](https://github.com/nodejs/node/pull/17206)
* **module**:
  - module.builtinModules will return a list of built in modules (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
* **n-api**:
  - add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* **process**:
  - process.setUncaughtExceptionCaptureCallback can now be used to customize behavior for `--abort-on-uncaught-exception` (Anna Henningsen) [#17159](https://github.com/nodejs/node/pull/17159)
  - A signal handler is now able to receive the signal code that triggered the handler. (Robert Rossmann) [#15606](https://github.com/nodejs/node/pull/15606)
* **src**:
  - embedders can now use Node::CreatePlatform to create an instance of NodePlatform (Cheng Zhao) [#16981](https://github.com/nodejs/node/pull/16981)
* **stream**:
  - writable.writableHighWaterMark and readable.readableHighWaterMark will return the values the stream object was instantiated with (Calvin Metcalf) [#12860](https://github.com/nodejs/node/pull/12860)
* **Added new collaborators**
  * [maclover7](https://github.com/maclover7) Jon Moss
  * [guybedford](https://github.com/guybedford) Guy Bedford
  * [hashseed](https://github.com/hashseed) Yang Guo

### Commits

* [[`623b589921`](https://github.com/nodejs/node/commit/623b589921)] - tools/doc: add tools/remark-* to eslintignore (Ivan Wei) [#17240](https://github.com/nodejs/node/pull/17240)
* [[`cf0d7cfc46`](https://github.com/nodejs/node/commit/cf0d7cfc46)] - **async_hooks**: add destroy event for gced AsyncResources (Sebastian Mayr) [#16998](https://github.com/nodejs/node/pull/16998)
* [[`cf7e15cf78`](https://github.com/nodejs/node/commit/cf7e15cf78)] - **(SEMVER-MINOR)** **async_hooks**: add trace events to async_hooks (Andreas Madsen) [#15538](https://github.com/nodejs/node/pull/15538)
* [[`e0ce7cf1e9`](https://github.com/nodejs/node/commit/e0ce7cf1e9)] - **(SEMVER-MINOR)** **async_wrap**: add provider types for net server (Andreas Madsen) [#17157](https://github.com/nodejs/node/pull/17157)
* [[`cbd0be59f0`](https://github.com/nodejs/node/commit/cbd0be59f0)] - **benchmark**: fix http/simple.js benchmark (Anatoli Papirovski) [#17583](https://github.com/nodejs/node/pull/17583)
* [[`120d756e47`](https://github.com/nodejs/node/commit/120d756e47)] - **benchmark**: refactor to use template string (Antonio V) [#17313](https://github.com/nodejs/node/pull/17313)
* [[`b16d570395`](https://github.com/nodejs/node/commit/b16d570395)] - **benchmark**: set maxHeaderListPairs in h2 headers.js (Anatoli Papirovski) [#17194](https://github.com/nodejs/node/pull/17194)
* [[`9ffdee811d`](https://github.com/nodejs/node/commit/9ffdee811d)] - **benchmark**: use unique filenames in fs benchmarks (Rich Trott) [#16776](https://github.com/nodejs/node/pull/16776)
* [[`ee84fc333d`](https://github.com/nodejs/node/commit/ee84fc333d)] - **benchmark,path**: remove unused variables (薛定谔的猫) [#15789](https://github.com/nodejs/node/pull/15789)
* [[`883281bca9`](https://github.com/nodejs/node/commit/883281bca9)] - **buffer**: don't predefine error (buji) [#17021](https://github.com/nodejs/node/pull/17021)
* [[`dcb53c10e2`](https://github.com/nodejs/node/commit/dcb53c10e2)] - **build**: allow running configure from any directory (Gibson Fahnestock) [#17321](https://github.com/nodejs/node/pull/17321)
* [[`5d1463a0bc`](https://github.com/nodejs/node/commit/5d1463a0bc)] - **build**: define HAVE_OPENSSL macro for cctest (Matheus Marchini) [#17461](https://github.com/nodejs/node/pull/17461)
* [[`4bb27a2db3`](https://github.com/nodejs/node/commit/4bb27a2db3)] - **build**: add a `make help` option for common targets (Gibson Fahnestock) [#17323](https://github.com/nodejs/node/pull/17323)
* [[`5e0f39323f`](https://github.com/nodejs/node/commit/5e0f39323f)] - **build**: add serial commas to messages in configure script (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`742a4566ee`](https://github.com/nodejs/node/commit/742a4566ee)] - **build**: fix test-v8 target (Michaël Zasso) [#17269](https://github.com/nodejs/node/pull/17269)
* [[`46c1d999d9`](https://github.com/nodejs/node/commit/46c1d999d9)] - **build**: add make lint-js-fix (Joyee Cheung) [#17283](https://github.com/nodejs/node/pull/17283)
* [[`0a40a1133d`](https://github.com/nodejs/node/commit/0a40a1133d)] - **build**: fix bsd build with gcc (Matheus Marchini) [#16737](https://github.com/nodejs/node/pull/16737)
* [[`0f727c07b9`](https://github.com/nodejs/node/commit/0f727c07b9)] - **build**: remove empty VCLibrarianTool entry (Daniel Bevenius) [#17191](https://github.com/nodejs/node/pull/17191)
* [[`09bd797711`](https://github.com/nodejs/node/commit/09bd797711)] - **build**: Allow linking against an external copy of nghttp2. (Ed Schouten) [#16788](https://github.com/nodejs/node/pull/16788)
* [[`9093392954`](https://github.com/nodejs/node/commit/9093392954)] - **build**: do not build doc in source tarball (Joyee Cheung) [#17100](https://github.com/nodejs/node/pull/17100)
* [[`9a4abe47d5`](https://github.com/nodejs/node/commit/9a4abe47d5)] - **build**: minor corrections to configure descriptions (Daniel Bevenius) [#17094](https://github.com/nodejs/node/pull/17094)
* [[`035a24e619`](https://github.com/nodejs/node/commit/035a24e619)] - **build**: enforce order of dependency when building addons (Joyee Cheung) [#17048](https://github.com/nodejs/node/pull/17048)
* [[`91385be239`](https://github.com/nodejs/node/commit/91385be239)] - **build**: fix cctest target --with-dtrace (Daniel Bevenius) [#17039](https://github.com/nodejs/node/pull/17039)
* [[`2eec94489d`](https://github.com/nodejs/node/commit/2eec94489d)] - ***Revert*** "**build**: for --enable-static, run only cctest" (Daniel Bevenius) [#14986](https://github.com/nodejs/node/pull/14986)
* [[`578d80b59b`](https://github.com/nodejs/node/commit/578d80b59b)] - **build**: prevent echoing of recipes for test target (Daniel Bevenius) [#17010](https://github.com/nodejs/node/pull/17010)
* [[`5fc1e27e98`](https://github.com/nodejs/node/commit/5fc1e27e98)] - **build, win**: faster Release rebuilds (Bartosz Sosnowski) [#17393](https://github.com/nodejs/node/pull/17393)
* [[`90a5e9f19b`](https://github.com/nodejs/node/commit/90a5e9f19b)] - **build,win**: vcbuild refactoring call configure (Refael Ackermann) [#17299](https://github.com/nodejs/node/pull/17299)
* [[`87c885bd44`](https://github.com/nodejs/node/commit/87c885bd44)] - **build,win,msi**: support WiX with VS2017 (João Reis) [#17101](https://github.com/nodejs/node/pull/17101)
* [[`23967b2713`](https://github.com/nodejs/node/commit/23967b2713)] - **console**: make dirxml an alias for console.log (Benjamin Zaslavsky) [#17152](https://github.com/nodejs/node/pull/17152)
* [[`40d4fee8d7`](https://github.com/nodejs/node/commit/40d4fee8d7)] - **console**: add support for console.debug (Benjamin Zaslavsky) [#17033](https://github.com/nodejs/node/pull/17033)
* [[`4a5e32206a`](https://github.com/nodejs/node/commit/4a5e32206a)] - **crypto**: remove BIO_set_shutdown (Daniel Bevenius) [#17542](https://github.com/nodejs/node/pull/17542)
* [[`c951e2c7d4`](https://github.com/nodejs/node/commit/c951e2c7d4)] - **crypto**: remove explicit qualifiers in Initialize (Daniel Bevenius) [#17490](https://github.com/nodejs/node/pull/17490)
* [[`8c2143091d`](https://github.com/nodejs/node/commit/8c2143091d)] - **crypto**: do not reach into OpenSSL internals for ThrowCryptoError (David Benjamin) [#16701](https://github.com/nodejs/node/pull/16701)
* [[`49402b12d0`](https://github.com/nodejs/node/commit/49402b12d0)] - **crypto**: declare int return type for set_field (Daniel Bevenius) [#17468](https://github.com/nodejs/node/pull/17468)
* [[`9e50f1721e`](https://github.com/nodejs/node/commit/9e50f1721e)] - **crypto**: use SetNull instead of Set (Daniel Bevenius) [#17521](https://github.com/nodejs/node/pull/17521)
* [[`e3df569d1c`](https://github.com/nodejs/node/commit/e3df569d1c)] - **deps**: upgrade libuv to 1.18.0 (cjihrig) [#17282](https://github.com/nodejs/node/pull/17282)
* [[`9f282ddaf7`](https://github.com/nodejs/node/commit/9f282ddaf7)] - **deps**: cherry-pick 1420e44db0 from upstream V8 (Timothy Gu) [#17344](https://github.com/nodejs/node/pull/17344)
* [[`47cd49a8cb`](https://github.com/nodejs/node/commit/47cd49a8cb)] - **deps**: backport 3c8195d from V8 upstream (Myles Borins) [#17383](https://github.com/nodejs/node/pull/17383)
* [[`465a32a087`](https://github.com/nodejs/node/commit/465a32a087)] - ***Revert*** "**deps**: cherry-pick 3c8195d from V8 upstream" (Myles Borins) [#17383](https://github.com/nodejs/node/pull/17383)
* [[`49d23a3021`](https://github.com/nodejs/node/commit/49d23a3021)] - **deps**: V8: backport 14ac02c from upstream (Ali Ijaz Sheikh) [#17512](https://github.com/nodejs/node/pull/17512)
* [[`7c2a9bba64`](https://github.com/nodejs/node/commit/7c2a9bba64)] - **deps**: patch V8 to 6.2.414.46 (Myles Borins) [#17206](https://github.com/nodejs/node/pull/17206)
* [[`04115724dc`](https://github.com/nodejs/node/commit/04115724dc)] - **deps**: cherry-pick 98c40a4bae915 from V8 upstream (Anna Henningsen) [#17134](https://github.com/nodejs/node/pull/17134)
* [[`7812c93a41`](https://github.com/nodejs/node/commit/7812c93a41)] - **deps**: cherry-pick c690f54d95802 from V8 upstream (Anna Henningsen) [#17134](https://github.com/nodejs/node/pull/17134)
* [[`24bb99a808`](https://github.com/nodejs/node/commit/24bb99a808)] - **deps**: cherry-pick upstream ICU fix (Mathias Bynens) [#16931](https://github.com/nodejs/node/pull/16931)
* [[`026f76024b`](https://github.com/nodejs/node/commit/026f76024b)] - **dns**: fix crash while setting server during query (XadillaX) [#14891](https://github.com/nodejs/node/pull/14891)
* [[`ccffbd96d1`](https://github.com/nodejs/node/commit/ccffbd96d1)] - **doc**: fix modules.md export example (Anatoli Papirovski) [#17579](https://github.com/nodejs/node/pull/17579)
* [[`7e2fa5a2d6`](https://github.com/nodejs/node/commit/7e2fa5a2d6)] - **doc**: add link to debugger in process.md (Delapouite) [#17522](https://github.com/nodejs/node/pull/17522)
* [[`a965dda849`](https://github.com/nodejs/node/commit/a965dda849)] - **doc**: simplify and clarify FIPS text in BUILDING.md (Rich Trott) [#17538](https://github.com/nodejs/node/pull/17538)
* [[`b015747156`](https://github.com/nodejs/node/commit/b015747156)] - **doc**: esm loader example with module.builtinModules (Guy Bedford) [#17385](https://github.com/nodejs/node/pull/17385)
* [[`1eff647fd3`](https://github.com/nodejs/node/commit/1eff647fd3)] - **doc**: 'constructor' implies use of new keyword (Cameron Moorehead) [#17364](https://github.com/nodejs/node/pull/17364)
* [[`8a17b7b6f3`](https://github.com/nodejs/node/commit/8a17b7b6f3)] - **doc**: use correct and consistent typography for products (Rich Trott) [#17492](https://github.com/nodejs/node/pull/17492)
* [[`0a0a56aa34`](https://github.com/nodejs/node/commit/0a0a56aa34)] - **doc**: add "Hello world" example for N-API (Franziska Hinkelmann) [#17425](https://github.com/nodejs/node/pull/17425)
* [[`865c4520b6`](https://github.com/nodejs/node/commit/865c4520b6)] - **doc**: immprove inode text in fs.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`18d6dab19d`](https://github.com/nodejs/node/commit/18d6dab19d)] - **doc**: improve text for Console constructor (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`cb09959e8f`](https://github.com/nodejs/node/commit/cb09959e8f)] - **doc**: improve readability of README.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`0948238aa2`](https://github.com/nodejs/node/commit/0948238aa2)] - **doc**: improve readability of COLLABORATOR_GUIDE.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`7f2764debb`](https://github.com/nodejs/node/commit/7f2764debb)] - **doc**: add info on post-publishing ARM6 builds (Michael Dawson) [#17455](https://github.com/nodejs/node/pull/17455)
* [[`6aa6d418e2`](https://github.com/nodejs/node/commit/6aa6d418e2)] - **doc**: mention node-test-pull-request-lite job (Jon Moss) [#17513](https://github.com/nodejs/node/pull/17513)
* [[`b8141a42d0`](https://github.com/nodejs/node/commit/b8141a42d0)] - **doc**: fix typo in repl.md (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`232a486c0c`](https://github.com/nodejs/node/commit/232a486c0c)] - **doc**: fix common typo involving one-time listeners (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`07df234ea2`](https://github.com/nodejs/node/commit/07df234ea2)] - **doc**: fix typo in dns.md (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`6c97f7fed5`](https://github.com/nodejs/node/commit/6c97f7fed5)] - **doc**: use American spellings per style guide (Rich Trott) [#17471](https://github.com/nodejs/node/pull/17471)
* [[`35d492c428`](https://github.com/nodejs/node/commit/35d492c428)] - **doc**: remove unused link reference (Anatoli Papirovski) [#17510](https://github.com/nodejs/node/pull/17510)
* [[`e9ee168a3d`](https://github.com/nodejs/node/commit/e9ee168a3d)] - **doc**: remove IPC channel implementation details (Bartosz Sosnowski) [#17460](https://github.com/nodejs/node/pull/17460)
* [[`7e38821df2`](https://github.com/nodejs/node/commit/7e38821df2)] - **doc**: use arrow functions in util.md sample code (Mithun Sasidharan) [#17459](https://github.com/nodejs/node/pull/17459)
* [[`53ed05582a`](https://github.com/nodejs/node/commit/53ed05582a)] - **doc**: update AUTHORS list (Michaël Zasso) [#17452](https://github.com/nodejs/node/pull/17452)
* [[`f7b0054b2b`](https://github.com/nodejs/node/commit/f7b0054b2b)] - **doc**: use serial comma in tls.md (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`20dcbfce89`](https://github.com/nodejs/node/commit/20dcbfce89)] - **doc**: add serial comma in CPP_STYLE_GUIDE.md (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`01be9462d5`](https://github.com/nodejs/node/commit/01be9462d5)] - **doc**: edit module introduction (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`4fff2ab7ca`](https://github.com/nodejs/node/commit/4fff2ab7ca)] - **doc**: standardize preposition usage in fs.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`f3ec355123`](https://github.com/nodejs/node/commit/f3ec355123)] - **doc**: improve punctuation in fs.open() text (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`ef7444cc94`](https://github.com/nodejs/node/commit/ef7444cc94)] - **doc**: use colon consistently in assert.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`cd7cee57e9`](https://github.com/nodejs/node/commit/cd7cee57e9)] - **doc**: update example in module registration (Franziska Hinkelmann) [#17424](https://github.com/nodejs/node/pull/17424)
* [[`d3e76e78ff`](https://github.com/nodejs/node/commit/d3e76e78ff)] - **doc**: introduce categories to Cpp style guide (Franziska Hinkelmann) [#17095](https://github.com/nodejs/node/pull/17095)
* [[`e00923bf5e`](https://github.com/nodejs/node/commit/e00923bf5e)] - **doc**: add missing serial commas (Rich Trott) [#17384](https://github.com/nodejs/node/pull/17384)
* [[`9df52dd115`](https://github.com/nodejs/node/commit/9df52dd115)] - **doc**: be concise about serial commas (Rich Trott) [#17384](https://github.com/nodejs/node/pull/17384)
* [[`7849d53158`](https://github.com/nodejs/node/commit/7849d53158)] - **doc**: document tls.checkServerIdentity (Hannes Magnusson) [#17203](https://github.com/nodejs/node/pull/17203)
* [[`a596577a31`](https://github.com/nodejs/node/commit/a596577a31)] - **doc**: improve checkServerIdentity docs (Hannes Magnusson) [#17203](https://github.com/nodejs/node/pull/17203)
* [[`2a4f4f8125`](https://github.com/nodejs/node/commit/2a4f4f8125)] - **doc**: add guide to maintaining npm (Myles Borins) [#16541](https://github.com/nodejs/node/pull/16541)
* [[`3807c6887a`](https://github.com/nodejs/node/commit/3807c6887a)] - **doc**: fix doc example for cctest (Matheus Marchini) [#17355](https://github.com/nodejs/node/pull/17355)
* [[`bd55a79422`](https://github.com/nodejs/node/commit/bd55a79422)] - **doc**: clarify fast-track of reversions (Refael Ackermann) [#17332](https://github.com/nodejs/node/pull/17332)
* [[`dcd87acb7b`](https://github.com/nodejs/node/commit/dcd87acb7b)] - **doc**: make error descriptions more concise (Rich Trott) [#16954](https://github.com/nodejs/node/pull/16954)
* [[`cc91a00af6`](https://github.com/nodejs/node/commit/cc91a00af6)] - **doc**: fix typo in stream.md (Matthew Leon) [#17357](https://github.com/nodejs/node/pull/17357)
* [[`048878288b`](https://github.com/nodejs/node/commit/048878288b)] - **doc**: non-partitioned async crypto operations (Jamie Davis) [#17250](https://github.com/nodejs/node/pull/17250)
* [[`0443909848`](https://github.com/nodejs/node/commit/0443909848)] - **doc**: move Code of Conduct to admin repo (Myles Borins) [#17301](https://github.com/nodejs/node/pull/17301)
* [[`5756d67f95`](https://github.com/nodejs/node/commit/5756d67f95)] - **doc**: fix typo occuring -\> occurring (Leko) [#17350](https://github.com/nodejs/node/pull/17350)
* [[`94be7fdfec`](https://github.com/nodejs/node/commit/94be7fdfec)] - **doc**: Add link for ECMAScript 2015 (smatsu-hl) [#17317](https://github.com/nodejs/node/pull/17317)
* [[`a0acd91470`](https://github.com/nodejs/node/commit/a0acd91470)] - **doc**: caution against removing pseudoheaders (James M Snell) [#17329](https://github.com/nodejs/node/pull/17329)
* [[`2bd241e974`](https://github.com/nodejs/node/commit/2bd241e974)] - **doc**: replace string with template string (Leko) [#17316](https://github.com/nodejs/node/pull/17316)
* [[`0b1448897d`](https://github.com/nodejs/node/commit/0b1448897d)] - **doc**: replace function with arrow function in vm.md (narirou) [#17307](https://github.com/nodejs/node/pull/17307)
* [[`078b4a625b`](https://github.com/nodejs/node/commit/078b4a625b)] - **doc**: replace function with arrow function (Leko) [#17304](https://github.com/nodejs/node/pull/17304)
* [[`4fafeae4a2`](https://github.com/nodejs/node/commit/4fafeae4a2)] - **doc**: update maintainting V8 guide (Michaël Zasso) [#17260](https://github.com/nodejs/node/pull/17260)
* [[`524db29844`](https://github.com/nodejs/node/commit/524db29844)] - **doc**: fix typo in api doc of url.format(urlObject) (pkovacs) [#17295](https://github.com/nodejs/node/pull/17295)
* [[`c901ccec40`](https://github.com/nodejs/node/commit/c901ccec40)] - **doc**: add ES Modules entry to who-to-cc (Rich Trott) [#17205](https://github.com/nodejs/node/pull/17205)
* [[`e45c9c651a`](https://github.com/nodejs/node/commit/e45c9c651a)] - **doc**: add maclover7 to collaborators (Jon Moss) [#17289](https://github.com/nodejs/node/pull/17289)
* [[`f13667221b`](https://github.com/nodejs/node/commit/f13667221b)] - **doc**: update http URLs to https in README.md (Ronald Eddy Jr) [#17264](https://github.com/nodejs/node/pull/17264)
* [[`c67612963c`](https://github.com/nodejs/node/commit/c67612963c)] - **doc**: update http URLs to https in doc/api (Ronald Eddy Jr) [#17263](https://github.com/nodejs/node/pull/17263)
* [[`c345a107a6`](https://github.com/nodejs/node/commit/c345a107a6)] - **doc**: update http URLs to https in GOVERNANCE.md (Ronald Eddy Jr) [#17262](https://github.com/nodejs/node/pull/17262)
* [[`f3c5f76fe8`](https://github.com/nodejs/node/commit/f3c5f76fe8)] - **doc**: update http URLs to https in CONTRIBUTING.md (Ronald Eddy Jr) [#17261](https://github.com/nodejs/node/pull/17261)
* [[`df5436cee1`](https://github.com/nodejs/node/commit/df5436cee1)] - **doc**: add SharedArrayBuffer to Buffer documentation (Thomas den Hollander) [#15489](https://github.com/nodejs/node/pull/15489)
* [[`821951e2a9`](https://github.com/nodejs/node/commit/821951e2a9)] - **doc**: document resolve hook formats (Lucas Azzola) [#16375](https://github.com/nodejs/node/pull/16375)
* [[`04c4c1f260`](https://github.com/nodejs/node/commit/04c4c1f260)] - **doc**: fs.readFile is async but not partitioned (Jamie Davis) [#17154](https://github.com/nodejs/node/pull/17154)
* [[`74506f72e6`](https://github.com/nodejs/node/commit/74506f72e6)] - **doc**: add description for inspector-only console methods. (Benjamin Zaslavsky) [#17004](https://github.com/nodejs/node/pull/17004)
* [[`1a3aadb2e9`](https://github.com/nodejs/node/commit/1a3aadb2e9)] - **doc**: use better terminology for build machines (Anna Henningsen) [#17142](https://github.com/nodejs/node/pull/17142)
* [[`2fccf84015`](https://github.com/nodejs/node/commit/2fccf84015)] - **doc**: use "JavaScript" instead of "Javascript" (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`9dcf748000`](https://github.com/nodejs/node/commit/9dcf748000)] - **doc**: prepare for v8/V8 linting in doc text (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`bd1dbcef85`](https://github.com/nodejs/node/commit/bd1dbcef85)] - **doc**: add capitalization styling to STYLE_GUIDE (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`68870161cc`](https://github.com/nodejs/node/commit/68870161cc)] - **doc**: update mgol in AUTHORS.txt, add to .mailmap (Michał Gołębiowski-Owczarek) [#17239](https://github.com/nodejs/node/pull/17239)
* [[`ef4c909335`](https://github.com/nodejs/node/commit/ef4c909335)] - **doc**: update release table in V8 guide (Ali Ijaz Sheikh) [#17136](https://github.com/nodejs/node/pull/17136)
* [[`3f363d3cda`](https://github.com/nodejs/node/commit/3f363d3cda)] - **doc**: add guybedford to collaborators (Guy Bedford) [#17197](https://github.com/nodejs/node/pull/17197)
* [[`7b5a05bc0f`](https://github.com/nodejs/node/commit/7b5a05bc0f)] - **doc**: update AUTHORS list (Michaël Zasso) [#16571](https://github.com/nodejs/node/pull/16571)
* [[`4c23e6a8c7`](https://github.com/nodejs/node/commit/4c23e6a8c7)] - **doc**: normalize ToC indentation with heading levels in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`f1d19d5eb9`](https://github.com/nodejs/node/commit/f1d19d5eb9)] - **doc**: add Contributing to Node.js to the README ToC (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`fa82f3a5c4`](https://github.com/nodejs/node/commit/fa82f3a5c4)] - **doc**: merge Working Groups with Contributing to Node.js in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`39cfecd568`](https://github.com/nodejs/node/commit/39cfecd568)] - **doc**: remove IRC node-dev link from README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`976ed7507b`](https://github.com/nodejs/node/commit/976ed7507b)] - **doc**: add missing introduced_in comments (Luigi Pinca) [#16741](https://github.com/nodejs/node/pull/16741)
* [[`39cb687ee5`](https://github.com/nodejs/node/commit/39cb687ee5)] - **doc**: change v8 to V8 (Rich Trott) [#17089](https://github.com/nodejs/node/pull/17089)
* [[`4b35dfbb31`](https://github.com/nodejs/node/commit/4b35dfbb31)] - **doc**: avoid mentioning 'uncaughtException' (Luigi Pinca) [#16905](https://github.com/nodejs/node/pull/16905)
* [[`18b08f082a`](https://github.com/nodejs/node/commit/18b08f082a)] - **doc**: add note about using cluster without networking (pimlie) [#17031](https://github.com/nodejs/node/pull/17031)
* [[`2f34d35b0a`](https://github.com/nodejs/node/commit/2f34d35b0a)] - **doc**: explicitly document highWaterMark option (Sebastian Silbermann) [#17049](https://github.com/nodejs/node/pull/17049)
* [[`c917cd6fdd`](https://github.com/nodejs/node/commit/c917cd6fdd)] - **doc**: fix a link in dgram.md (Vse Mozhet Byt) [#17107](https://github.com/nodejs/node/pull/17107)
* [[`a12bc2df0e`](https://github.com/nodejs/node/commit/a12bc2df0e)] - **doc**: reorganize collaborator guide (Joyee Cheung) [#17056](https://github.com/nodejs/node/pull/17056)
* [[`4a9c75a279`](https://github.com/nodejs/node/commit/4a9c75a279)] - **doc**: delete unused definition in README.md (Vse Mozhet Byt) [#17108](https://github.com/nodejs/node/pull/17108)
* [[`378439e2cb`](https://github.com/nodejs/node/commit/378439e2cb)] - **doc**: add Support section in README (Rich Trott) [#16533](https://github.com/nodejs/node/pull/16533)
* [[`8dc05e4630`](https://github.com/nodejs/node/commit/8dc05e4630)] - **doc**: document common pattern for instanceof checks (Michael Dawson) [#16699](https://github.com/nodejs/node/pull/16699)
* [[`03803ee505`](https://github.com/nodejs/node/commit/03803ee505)] - **doc**: mention smart pointers in Cpp style guide (Franziska Hinkelmann) [#17055](https://github.com/nodejs/node/pull/17055)
* [[`b87030c5cf`](https://github.com/nodejs/node/commit/b87030c5cf)] - **doc**: correct the wrong added meta data (Gaara) [#17072](https://github.com/nodejs/node/pull/17072)
* [[`73295370cc`](https://github.com/nodejs/node/commit/73295370cc)] - **doc**: document fs.realpath.native() (Ben Noordhuis) [#17059](https://github.com/nodejs/node/pull/17059)
* [[`4bdd05dd84`](https://github.com/nodejs/node/commit/4bdd05dd84)] - **doc**: add Table of Contents to Cpp style guide (Franziska Hinkelmann) [#17052](https://github.com/nodejs/node/pull/17052)
* [[`7d49bd0045`](https://github.com/nodejs/node/commit/7d49bd0045)] - **doc**: add `clientCertEngine` to docs (Rich Trott)
* [[`7594032fac`](https://github.com/nodejs/node/commit/7594032fac)] - **doc**: add hashseed to collaborators (Yang Guo)
* [[`a256482318`](https://github.com/nodejs/node/commit/a256482318)] - **doc,test**: remove unnecessary await with return instances (Rich Trott) [#17265](https://github.com/nodejs/node/pull/17265)
* [[`bccdea623d`](https://github.com/nodejs/node/commit/bccdea623d)] - **doc,win**: clarify WSL support (João Reis) [#17008](https://github.com/nodejs/node/pull/17008)
* [[`9b16e15f44`](https://github.com/nodejs/node/commit/9b16e15f44)] - **domain**: re-implement domain over async_hook (vladimir) [#16222](https://github.com/nodejs/node/pull/16222)
* [[`9c2f24e288`](https://github.com/nodejs/node/commit/9c2f24e288)] - **errors**: fix typo in TLS_SESSION_ATTACK message (Tom Hallam) [#17388](https://github.com/nodejs/node/pull/17388)
* [[`a333e71342`](https://github.com/nodejs/node/commit/a333e71342)] - **errors**: consistent format for error message (Anatoli Papirovski) [#16904](https://github.com/nodejs/node/pull/16904)
* [[`715baf8214`](https://github.com/nodejs/node/commit/715baf8214)] - **fs**: use rest param & Reflect.apply in makeCallback (Mithun Sasidharan) [#17486](https://github.com/nodejs/node/pull/17486)
* [[`7ebaf83602`](https://github.com/nodejs/node/commit/7ebaf83602)] - **fs**: use arrow functions instead of `.bind` and `self` (Weijia Wang) [#17137](https://github.com/nodejs/node/pull/17137)
* [[`24dc57bc71`](https://github.com/nodejs/node/commit/24dc57bc71)] - **http**: simplify checkIsHttpToken() (Rich Trott) [#17399](https://github.com/nodejs/node/pull/17399)
* [[`5a4b6c4bc0`](https://github.com/nodejs/node/commit/5a4b6c4bc0)] - **http**: do not assign intermediate variable (Jon Moss) [#17335](https://github.com/nodejs/node/pull/17335)
* [[`a6b6acb68c`](https://github.com/nodejs/node/commit/a6b6acb68c)] - **http, stream**: writeHWM -\> writableHighWaterMark (Matteo Collina) [#17050](https://github.com/nodejs/node/pull/17050)
* [[`658338e317`](https://github.com/nodejs/node/commit/658338e317)] - **http2**: use more descriptive names (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`4994d57890`](https://github.com/nodejs/node/commit/4994d57890)] - **http2**: remove unnecessary event handlers (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`67abc1e697`](https://github.com/nodejs/node/commit/67abc1e697)] - **http2**: reduce code duplication in settings (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`e5f92cda7e`](https://github.com/nodejs/node/commit/e5f92cda7e)] - **http2**: general cleanups (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`54cd7dfd88`](https://github.com/nodejs/node/commit/54cd7dfd88)] - **inspector**: Fix crash for WS connection (Eugene Ostroukhov) [#17085](https://github.com/nodejs/node/pull/17085)
* [[`94e0488a33`](https://github.com/nodejs/node/commit/94e0488a33)] - **inspector**: no async tracking for promises (Anna Henningsen) [#17118](https://github.com/nodejs/node/pull/17118)
* [[`8fd316f63b`](https://github.com/nodejs/node/commit/8fd316f63b)] - **internal**: add emitExperimentalWarning function (Cody Deckard) [#16497](https://github.com/nodejs/node/pull/16497)
* [[`1a8b0e9fa5`](https://github.com/nodejs/node/commit/1a8b0e9fa5)] - **lib**: replace string concatenation with template (Vijayalakshmi Kannan) [#16923](https://github.com/nodejs/node/pull/16923)
* [[`b719b77215`](https://github.com/nodejs/node/commit/b719b77215)] - **module**: print better message on esm syntax error (Ben Noordhuis) [#17281](https://github.com/nodejs/node/pull/17281)
* [[`5736dc4ab9`](https://github.com/nodejs/node/commit/5736dc4ab9)] - **module**: fix for #17130 shared loader cjs dep (Guy Bedford) [#17131](https://github.com/nodejs/node/pull/17131)
* [[`06da8a7f16`](https://github.com/nodejs/node/commit/06da8a7f16)] - **module**: be lazy when creating CJS facades (Bradley Farias) [#17153](https://github.com/nodejs/node/pull/17153)
* [[`7ae7124039`](https://github.com/nodejs/node/commit/7ae7124039)] - **(SEMVER-MINOR)** **module**: add builtinModules (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
* [[`caff930d47`](https://github.com/nodejs/node/commit/caff930d47)] - **module**: replace default paths in require.resolve() (cjihrig) [#17113](https://github.com/nodejs/node/pull/17113)
* [[`b833a5989c`](https://github.com/nodejs/node/commit/b833a5989c)] - **n-api**: use nullptr instead of NULL in node_api.cc (Daniel Bevenius) [#17276](https://github.com/nodejs/node/pull/17276)
* [[`8d222d42ab`](https://github.com/nodejs/node/commit/8d222d42ab)] - **(SEMVER-MINOR)** **n-api**: add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* [[`8366a74bbf`](https://github.com/nodejs/node/commit/8366a74bbf)] - **path**: remove obsolete comment (Rich Trott) [#17023](https://github.com/nodejs/node/pull/17023)
* [[`a159a2c6ac`](https://github.com/nodejs/node/commit/a159a2c6ac)] - **process**: slight refinements to nextTick (Anatoli Papirovski) [#17421](https://github.com/nodejs/node/pull/17421)
* [[`347164a703`](https://github.com/nodejs/node/commit/347164a703)] - **(SEMVER-MINOR)** **process**: add flag for uncaught exception abort (Anna Henningsen) [#17159](https://github.com/nodejs/node/pull/17159)
* [[`9d657247df`](https://github.com/nodejs/node/commit/9d657247df)] - **process**: slightly simplify next tick execution (Anatoli Papirovski) [#16888](https://github.com/nodejs/node/pull/16888)
* [[`8d90db5120`](https://github.com/nodejs/node/commit/8d90db5120)] - **(SEMVER-MINOR)** **process**: Send signal name to signal handlers (Robert Rossmann) [#15606](https://github.com/nodejs/node/pull/15606)
* [[`9a9aa88797`](https://github.com/nodejs/node/commit/9a9aa88797)] - **process**: improve unhandled rejection message (Madara Uchiha) [#17158](https://github.com/nodejs/node/pull/17158)
* [[`8dcc40a84f`](https://github.com/nodejs/node/commit/8dcc40a84f)] - **src**: remove unused include node_crypto_clienthello (Daniel Bevenius) [#17546](https://github.com/nodejs/node/pull/17546)
* [[`fb3ea4c4dc`](https://github.com/nodejs/node/commit/fb3ea4c4dc)] - **src**: fix missing handlescope bug in inspector (Ben Noordhuis) [#17539](https://github.com/nodejs/node/pull/17539)
* [[`40acda2e6b`](https://github.com/nodejs/node/commit/40acda2e6b)] - **src**: use uv_os_getpid() to get process id (cjihrig) [#17415](https://github.com/nodejs/node/pull/17415)
* [[`9b41c0b021`](https://github.com/nodejs/node/commit/9b41c0b021)] - **src**: node_http2_state.h should not be executable (Jon Moss) [#17408](https://github.com/nodejs/node/pull/17408)
* [[`419cde79b1`](https://github.com/nodejs/node/commit/419cde79b1)] - **src**: use non-deprecated versions of `-\>To*()` utils (Leko) [#17343](https://github.com/nodejs/node/pull/17343)
* [[`ceda8c57aa`](https://github.com/nodejs/node/commit/ceda8c57aa)] - **src**: use nullptr instead of NULL (Daniel Bevenius) [#17373](https://github.com/nodejs/node/pull/17373)
* [[`7f55f98a84`](https://github.com/nodejs/node/commit/7f55f98a84)] - **src**: fix typo in NODE_OPTIONS whitelist (Evan Lucas) [#17369](https://github.com/nodejs/node/pull/17369)
* [[`9b27bc85ae`](https://github.com/nodejs/node/commit/9b27bc85ae)] - **src**: introduce USE() for silencing compiler warnings (Anna Henningsen) [#17333](https://github.com/nodejs/node/pull/17333)
* [[`0db1f87825`](https://github.com/nodejs/node/commit/0db1f87825)] - **src**: use NODE_BUILTIN_MODULE_CONTEXT_AWARE() macro (Ben Noordhuis) [#17071](https://github.com/nodejs/node/pull/17071)
* [[`6a7a59a8c1`](https://github.com/nodejs/node/commit/6a7a59a8c1)] - **src**: remove `ClearFatalExceptionHandlers()` (Anna Henningsen) [#17333](https://github.com/nodejs/node/pull/17333)
* [[`9c7a42a2e4`](https://github.com/nodejs/node/commit/9c7a42a2e4)] - **src**: explicitly register built-in modules (Yihong Wang) [#16565](https://github.com/nodejs/node/pull/16565)
* [[`4667c5e720`](https://github.com/nodejs/node/commit/4667c5e720)] - **src**: start heap object tracking after platform is initialized (Hannes Payer) [#17249](https://github.com/nodejs/node/pull/17249)
* [[`63f6947a41`](https://github.com/nodejs/node/commit/63f6947a41)] - **src**: make base64.h self-contained (Daniel Bevenius) [#17177](https://github.com/nodejs/node/pull/17177)
* [[`14ebda5218`](https://github.com/nodejs/node/commit/14ebda5218)] - **(SEMVER-MINOR)** **src**: add public API for managing NodePlatform (Cheng Zhao) [#16981](https://github.com/nodejs/node/pull/16981)
* [[`9832b8e206`](https://github.com/nodejs/node/commit/9832b8e206)] - **src**: add napi_handle_scope_mismatch to msg list (neta) [#17161](https://github.com/nodejs/node/pull/17161)
* [[`0b128842f6`](https://github.com/nodejs/node/commit/0b128842f6)] - **src**: fix compiler warning (cjihrig) [#17195](https://github.com/nodejs/node/pull/17195)
* [[`9c0c33625a`](https://github.com/nodejs/node/commit/9c0c33625a)] - **src**: remove unprofessional slang in assertions (Alexey Orlenko) [#17166](https://github.com/nodejs/node/pull/17166)
* [[`936c0b2b83`](https://github.com/nodejs/node/commit/936c0b2b83)] - **src**: implement v8::TaskRunner API in NodePlatform (Anna Henningsen) [#17134](https://github.com/nodejs/node/pull/17134)
* [[`a9be7bf35b`](https://github.com/nodejs/node/commit/a9be7bf35b)] - **src**: remove unused variable (cjihrig) [#17150](https://github.com/nodejs/node/pull/17150)
* [[`84b707089e`](https://github.com/nodejs/node/commit/84b707089e)] - **(SEMVER-MINOR)** **src**: add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* [[`362b8c7d5d`](https://github.com/nodejs/node/commit/362b8c7d5d)] - **src**: inspector context name = program title + pid (Ben Noordhuis) [#17087](https://github.com/nodejs/node/pull/17087)
* [[`7ecec6704f`](https://github.com/nodejs/node/commit/7ecec6704f)] - **src**: abstract getpid() operation (Ben Noordhuis) [#17087](https://github.com/nodejs/node/pull/17087)
* [[`e7db034571`](https://github.com/nodejs/node/commit/e7db034571)] - **src**: add NODE_VERSION_IS_LTS to node_version.h (Gibson Fahnestock) [#16697](https://github.com/nodejs/node/pull/16697)
* [[`60423f5845`](https://github.com/nodejs/node/commit/60423f5845)] - **src**: use unique_ptr for http2_state (Franziska Hinkelmann) [#17078](https://github.com/nodejs/node/pull/17078)
* [[`e9000901ca`](https://github.com/nodejs/node/commit/e9000901ca)] - **src**: add missing include in node_platform.h (Anna Henningsen) [#17133](https://github.com/nodejs/node/pull/17133)
* [[`1b76cfe3c2`](https://github.com/nodejs/node/commit/1b76cfe3c2)] - **src**: use unique_ptr for scheduled delayed tasks (Franziska Hinkelmann) [#17083](https://github.com/nodejs/node/pull/17083)
* [[`af63df80b4`](https://github.com/nodejs/node/commit/af63df80b4)] - **src**: use std::unique_ptr in base-object-inl.h (Franziska Hinkelmann) [#17079](https://github.com/nodejs/node/pull/17079)
* [[`4387a73514`](https://github.com/nodejs/node/commit/4387a73514)] - **src**: remove superfluous check in backtrace_posix.cc (Anna Henningsen) [#16950](https://github.com/nodejs/node/pull/16950)
* [[`3ab3b0d4e2`](https://github.com/nodejs/node/commit/3ab3b0d4e2)] - **src**: fix size of CounterSet (Witthawat Piwawatthanapanit) [#16984](https://github.com/nodejs/node/pull/16984)
* [[`d74c7c5461`](https://github.com/nodejs/node/commit/d74c7c5461)] - **src**: rename req-wrap -\> req_wrap (Daniel Bevenius) [#17022](https://github.com/nodejs/node/pull/17022)
* [[`5119bb1a6d`](https://github.com/nodejs/node/commit/5119bb1a6d)] - **src**: rename base-object -\> base_object (Daniel Bevenius) [#17022](https://github.com/nodejs/node/pull/17022)
* [[`8ba513ee2e`](https://github.com/nodejs/node/commit/8ba513ee2e)] - **src**: rename async-wrap -\> async_wrap (Daniel Bevenius) [#17022](https://github.com/nodejs/node/pull/17022)
* [[`da8414e09a`](https://github.com/nodejs/node/commit/da8414e09a)] - **src**: use smart pointer instead of new and delete (Franziska Hinkelmann) [#17020](https://github.com/nodejs/node/pull/17020)
* [[`17e31dc66a`](https://github.com/nodejs/node/commit/17e31dc66a)] - **src**: perf_hooks: fix wrong sized delete (Ali Ijaz Sheikh) [#16898](https://github.com/nodejs/node/pull/16898)
* [[`a1a99570aa`](https://github.com/nodejs/node/commit/a1a99570aa)] - **src**: make ownership of stdio_pipes explicit (Franziska Hinkelmann) [#17030](https://github.com/nodejs/node/pull/17030)
* [[`98a07709f4`](https://github.com/nodejs/node/commit/98a07709f4)] - **src**: use unique pointer for tracing_agent (Franziska Hinkelmann) [#17012](https://github.com/nodejs/node/pull/17012)
* [[`a05c49c48d`](https://github.com/nodejs/node/commit/a05c49c48d)] - **src**: use unique_ptr for requests in crypto (Franziska Hinkelmann) [#17000](https://github.com/nodejs/node/pull/17000)
* [[`6f805c6967`](https://github.com/nodejs/node/commit/6f805c6967)] - **src**: implement backtrace-on-abort for windows (Anna Henningsen) [#16951](https://github.com/nodejs/node/pull/16951)
* [[`7ac760b603`](https://github.com/nodejs/node/commit/7ac760b603)] - **src**: fix SetClientCertEngine() nullptr dereference (Ben Noordhuis) [#16965](https://github.com/nodejs/node/pull/16965)
* [[`f6ec5fa4e8`](https://github.com/nodejs/node/commit/f6ec5fa4e8)] - **src**: fix bad sizeof expression (Ben Noordhuis) [#17014](https://github.com/nodejs/node/pull/17014)
* [[`8522e2420d`](https://github.com/nodejs/node/commit/8522e2420d)] - **src**: use unique_ptr in platform implementation (Franziska Hinkelmann) [#16970](https://github.com/nodejs/node/pull/16970)
* [[`c2431d553b`](https://github.com/nodejs/node/commit/c2431d553b)] - **src**: cancel pending delayed platform tasks on exit (Anna Henningsen) [#16700](https://github.com/nodejs/node/pull/16700)
* [[`37a60a8c3c`](https://github.com/nodejs/node/commit/37a60a8c3c)] - **src**: prepare v8 platform for multi-isolate support (Anna Henningsen) [#16700](https://github.com/nodejs/node/pull/16700)
* [[`b36c726206`](https://github.com/nodejs/node/commit/b36c726206)] - **stream**: improve the error message of `ERR_INVALID_ARG_TYPE` (Weijia Wang) [#17145](https://github.com/nodejs/node/pull/17145)
* [[`78b82b03c5`](https://github.com/nodejs/node/commit/78b82b03c5)] - **stream**: use arrow fns for 'this' in readable (Vipin Menon) [#16927](https://github.com/nodejs/node/pull/16927)
* [[`edb9846884`](https://github.com/nodejs/node/commit/edb9846884)] - **(SEMVER-MINOR)** **stream**: remove usage of *State.highWaterMark (Calvin Metcalf) [#12860](https://github.com/nodejs/node/pull/12860)
* [[`e7ae8eb457`](https://github.com/nodejs/node/commit/e7ae8eb457)] - **test**: refactor test-child-process-pass-fd (Rich Trott) [#17596](https://github.com/nodejs/node/pull/17596)
* [[`5a9172fe06`](https://github.com/nodejs/node/commit/5a9172fe06)] - **test**: remove unnecessary use of common.PORT in addons test (Rich Trott) [#17563](https://github.com/nodejs/node/pull/17563)
* [[`39e2fb6ad4`](https://github.com/nodejs/node/commit/39e2fb6ad4)] - **test**: simplify common.PORT code (Rich Trott) [#17559](https://github.com/nodejs/node/pull/17559)
* [[`f45ef442bb`](https://github.com/nodejs/node/commit/f45ef442bb)] - **test**: refactor test-http-default-port (Anna Henningsen) [#17562](https://github.com/nodejs/node/pull/17562)
* [[`49d662846e`](https://github.com/nodejs/node/commit/49d662846e)] - **test**: replace assert.throws w/ common.expectsError (Anatoli Papirovski) [#17557](https://github.com/nodejs/node/pull/17557)
* [[`f7e5ab082d`](https://github.com/nodejs/node/commit/f7e5ab082d)] - **test**: refactored to remove unnecessary variables (Mithun Sasidharan) [#17553](https://github.com/nodejs/node/pull/17553)
* [[`bb780d2d84`](https://github.com/nodejs/node/commit/bb780d2d84)] - **test**: use Countdown in http-agent test (Federico Kauffman) [#17537](https://github.com/nodejs/node/pull/17537)
* [[`510116ebe6`](https://github.com/nodejs/node/commit/510116ebe6)] - **test**: update http test to use common.mustCall (Collins Abitekaniza) [#17528](https://github.com/nodejs/node/pull/17528)
* [[`39d8e4413a`](https://github.com/nodejs/node/commit/39d8e4413a)] - **test**: improve assert messages in repl-reset-event (Adri Van Houdt) [#16836](https://github.com/nodejs/node/pull/16836)
* [[`6576382eaa`](https://github.com/nodejs/node/commit/6576382eaa)] - **test**: update test-http-should-keep-alive to use countdown (TomerOmri) [#17505](https://github.com/nodejs/node/pull/17505)
* [[`f3d619882e`](https://github.com/nodejs/node/commit/f3d619882e)] - **test**: fix flaky test-benchmark-es (Rich Trott) [#17516](https://github.com/nodejs/node/pull/17516)
* [[`ff59d3a30e`](https://github.com/nodejs/node/commit/ff59d3a30e)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17483](https://github.com/nodejs/node/pull/17483)
* [[`28b2d8ac20`](https://github.com/nodejs/node/commit/28b2d8ac20)] - **test**: use common.expectsError in tests (Mithun Sasidharan) [#17484](https://github.com/nodejs/node/pull/17484)
* [[`d15cdc6fdb`](https://github.com/nodejs/node/commit/d15cdc6fdb)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17498](https://github.com/nodejs/node/pull/17498)
* [[`993b1cbc6d`](https://github.com/nodejs/node/commit/993b1cbc6d)] - **test**: use Countdown in http test (idandagan1) [#17506](https://github.com/nodejs/node/pull/17506)
* [[`1aae28b7c9`](https://github.com/nodejs/node/commit/1aae28b7c9)] - **test**: use Number.isNaN instead of global isNaN (Mithun Sasidharan) [#17515](https://github.com/nodejs/node/pull/17515)
* [[`2a5da9c2c9`](https://github.com/nodejs/node/commit/2a5da9c2c9)] - **test**: use Countdown in http-response-statuscode (Mandeep Singh) [#17327](https://github.com/nodejs/node/pull/17327)
* [[`919625bd6a`](https://github.com/nodejs/node/commit/919625bd6a)] - **test**: use Countdown in test-http-set-cookies (Shilo Mangam) [#17504](https://github.com/nodejs/node/pull/17504)
* [[`f399667784`](https://github.com/nodejs/node/commit/f399667784)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17497](https://github.com/nodejs/node/pull/17497)
* [[`c2ff36ed7f`](https://github.com/nodejs/node/commit/c2ff36ed7f)] - **test**: replace assert.throws w/ common.expectsError (Mithun Sasidharan) [#17494](https://github.com/nodejs/node/pull/17494)
* [[`af8e27d10e`](https://github.com/nodejs/node/commit/af8e27d10e)] - **test**: Use common.mustCall in http test (sreepurnajasti) [#17487](https://github.com/nodejs/node/pull/17487)
* [[`7b8622f946`](https://github.com/nodejs/node/commit/7b8622f946)] - **test**: update http test to use Countdown (Francisco Gerardo Neri Andriano) [#17477](https://github.com/nodejs/node/pull/17477)
* [[`fb553b5b59`](https://github.com/nodejs/node/commit/fb553b5b59)] - **test**: improve crypto test coverage (Leko) [#17426](https://github.com/nodejs/node/pull/17426)
* [[`928aecc92c`](https://github.com/nodejs/node/commit/928aecc92c)] - **test**: replace fs.accessSync with fs.existsSync (Leko) [#17446](https://github.com/nodejs/node/pull/17446)
* [[`7d3a84388d`](https://github.com/nodejs/node/commit/7d3a84388d)] - **test**: fix flaky test-benchmark-querystring (Rich Trott) [#17517](https://github.com/nodejs/node/pull/17517)
* [[`50f120eaac`](https://github.com/nodejs/node/commit/50f120eaac)] - **test**: fix flaky test-benchmark-util (Rich Trott) [#17473](https://github.com/nodejs/node/pull/17473)
* [[`a407a48bdf`](https://github.com/nodejs/node/commit/a407a48bdf)] - **test**: expand coverage for crypto (Leko) [#17447](https://github.com/nodejs/node/pull/17447)
* [[`07547346a8`](https://github.com/nodejs/node/commit/07547346a8)] - **test**: add common.crashOnUnhandledRejection() (IHsuan) [#17247](https://github.com/nodejs/node/pull/17247)
* [[`8c32b4a37a`](https://github.com/nodejs/node/commit/8c32b4a37a)] - **test**: refactor code to use common.mustCall (Mithun Sasidharan) [#17437](https://github.com/nodejs/node/pull/17437)
* [[`fe9d9f732b`](https://github.com/nodejs/node/commit/fe9d9f732b)] - **test**: remove hidden use of common.PORT in parallel tests (Rich Trott) [#17466](https://github.com/nodejs/node/pull/17466)
* [[`cca3526faf`](https://github.com/nodejs/node/commit/cca3526faf)] - **test**: add more settings to test-benchmark-dgram (Rich Trott) [#17462](https://github.com/nodejs/node/pull/17462)
* [[`562007ce2a`](https://github.com/nodejs/node/commit/562007ce2a)] - **test**: add dgram benchmark test (jopann) [#17462](https://github.com/nodejs/node/pull/17462)
* [[`619cbc4364`](https://github.com/nodejs/node/commit/619cbc4364)] - **test**: fix flaky test-benchmark-events (Rich Trott) [#17472](https://github.com/nodejs/node/pull/17472)
* [[`d8018bc91d`](https://github.com/nodejs/node/commit/d8018bc91d)] - **test**: update test-http-request-dont-override-options to use common.mustCall (Mithun Sasidharan) [#17438](https://github.com/nodejs/node/pull/17438)
* [[`0ac87c2525`](https://github.com/nodejs/node/commit/0ac87c2525)] - **test**: replace assert.throws with common.expectsError (Leko) [#17445](https://github.com/nodejs/node/pull/17445)
* [[`07fd4cfbe0`](https://github.com/nodejs/node/commit/07fd4cfbe0)] - **test**: use common.mustCall in test-http-malformed-request (Mithun Sasidharan) [#17439](https://github.com/nodejs/node/pull/17439)
* [[`0ade4888f2`](https://github.com/nodejs/node/commit/0ade4888f2)] - **test**: forbid `common.mustCall*()` in process exit handlers (Rich Trott) [#17453](https://github.com/nodejs/node/pull/17453)
* [[`85e6271995`](https://github.com/nodejs/node/commit/85e6271995)] - **test**: use Countdown in http test (Mithun Sasidharan) [#17436](https://github.com/nodejs/node/pull/17436)
* [[`8c81ba0b1c`](https://github.com/nodejs/node/commit/8c81ba0b1c)] - **test**: remove common.PORT from parallel tests (Rich Trott) [#17410](https://github.com/nodejs/node/pull/17410)
* [[`5fecdbaca9`](https://github.com/nodejs/node/commit/5fecdbaca9)] - **test**: update test-http-response-multiheaders to use countdown (hmammedzadeh) [#17419](https://github.com/nodejs/node/pull/17419)
* [[`69e775d454`](https://github.com/nodejs/node/commit/69e775d454)] - **test**: update test-http-timeout to use countdown (Mithun Sasidharan) [#17341](https://github.com/nodejs/node/pull/17341)
* [[`9cbb0dadc0`](https://github.com/nodejs/node/commit/9cbb0dadc0)] - **test**: make common.mustNotCall show file:linenumber (Lance Ball) [#17257](https://github.com/nodejs/node/pull/17257)
* [[`259f2d331d`](https://github.com/nodejs/node/commit/259f2d331d)] - **test**: remove fixturesDir from common module (Rich Trott) [#17400](https://github.com/nodejs/node/pull/17400)
* [[`92b29cd659`](https://github.com/nodejs/node/commit/92b29cd659)] - **test**: remove common.fixturesDir from tests (Rich Trott) [#17400](https://github.com/nodejs/node/pull/17400)
* [[`0afcea280e`](https://github.com/nodejs/node/commit/0afcea280e)] - **test**: add test case for missing branch (Leko) [#17418](https://github.com/nodejs/node/pull/17418)
* [[`c9a4f4f8f1`](https://github.com/nodejs/node/commit/c9a4f4f8f1)] - **test**: update test-http-upgrade-client to use countdown (Mithun Sasidharan) [#17339](https://github.com/nodejs/node/pull/17339)
* [[`91d541627e`](https://github.com/nodejs/node/commit/91d541627e)] - **test**: update test-http-status-reason-invalid-chars to use countdown (Mithun Sasidharan) [#17342](https://github.com/nodejs/node/pull/17342)
* [[`4fb070873e`](https://github.com/nodejs/node/commit/4fb070873e)] - **test**: refactored test-http-allow-req-after-204-res to countdown (Mithun Sasidharan) [#17211](https://github.com/nodejs/node/pull/17211)
* [[`ef25de7493`](https://github.com/nodejs/node/commit/ef25de7493)] - **test**: update test/parallel/test-http-pipe-fs.js to use countdown (ChungNgoops) [#17346](https://github.com/nodejs/node/pull/17346)
* [[`1866b05042`](https://github.com/nodejs/node/commit/1866b05042)] - **test**: refactored test-http-response-splitting to use countdown (Mithun Sasidharan) [#17348](https://github.com/nodejs/node/pull/17348)
* [[`ee1c95f992`](https://github.com/nodejs/node/commit/ee1c95f992)] - **test**: expanded assertions for console.timeEnd() output (NiveditN) [#17368](https://github.com/nodejs/node/pull/17368)
* [[`8336e4f88e`](https://github.com/nodejs/node/commit/8336e4f88e)] - **test**: add test case for process.dlopen with undefined (Leko) [#17343](https://github.com/nodejs/node/pull/17343)
* [[`f0608814af`](https://github.com/nodejs/node/commit/f0608814af)] - **test**: add test case for throwing an exception with vm.Script (Leko) [#17343](https://github.com/nodejs/node/pull/17343)
* [[`78592a34c6`](https://github.com/nodejs/node/commit/78592a34c6)] - **test**: make CreateParams stack-allocated (Daniel Bevenius) [#17366](https://github.com/nodejs/node/pull/17366)
* [[`ca81d4bb3f`](https://github.com/nodejs/node/commit/ca81d4bb3f)] - **test**: use v8 Default Allocator in cctest fixture (Daniel Bevenius) [#17366](https://github.com/nodejs/node/pull/17366)
* [[`6e3a8be43a`](https://github.com/nodejs/node/commit/6e3a8be43a)] - **test**: replace function with arrow function (Leko) [#17345](https://github.com/nodejs/node/pull/17345)
* [[`f5a1e6cbc4`](https://github.com/nodejs/node/commit/f5a1e6cbc4)] - **test**: fix flaky async-hooks/test-graph.signal (Rich Trott) [#17509](https://github.com/nodejs/node/pull/17509)
* [[`f1b26be684`](https://github.com/nodejs/node/commit/f1b26be684)] - **test**: remove common.tmpDirName (Rich Trott) [#17266](https://github.com/nodejs/node/pull/17266)
* [[`047bac2475`](https://github.com/nodejs/node/commit/047bac2475)] - **test**: fixup test-http2-create-client-secure-session (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`3d45a94b56`](https://github.com/nodejs/node/commit/3d45a94b56)] - **test**: mock the lookup function in parallel tests (Joyee Cheung) [#17296](https://github.com/nodejs/node/pull/17296)
* [[`4e789a3bf8`](https://github.com/nodejs/node/commit/4e789a3bf8)] - **test**: add common.dns.errorLookupMock (Joyee Cheung) [#17296](https://github.com/nodejs/node/pull/17296)
* [[`71eb186572`](https://github.com/nodejs/node/commit/71eb186572)] - **test**: replace function with ES6 arrow function (Junichi Kajiwara) [#17306](https://github.com/nodejs/node/pull/17306)
* [[`36e2643d7b`](https://github.com/nodejs/node/commit/36e2643d7b)] - **test**: add es6 module global leakage tests (WhoMeNope) [#16341](https://github.com/nodejs/node/pull/16341)
* [[`afdfc4de8f`](https://github.com/nodejs/node/commit/afdfc4de8f)] - **test**: Enable specifying flaky tests on fips (Nikhil Komawar) [#16329](https://github.com/nodejs/node/pull/16329)
* [[`24d08fee45`](https://github.com/nodejs/node/commit/24d08fee45)] - **test**: refactored http test to use countdown (Mithun Sasidharan) [#17241](https://github.com/nodejs/node/pull/17241)
* [[`b033d38022`](https://github.com/nodejs/node/commit/b033d38022)] - **test**: Update test-http-parser-free to use countdown timer (Mandeep Singh) [#17322](https://github.com/nodejs/node/pull/17322)
* [[`4a749c3a70`](https://github.com/nodejs/node/commit/4a749c3a70)] - **test**: Update test-http-client-agent to use countdown timer (Mandeep Singh) [#17325](https://github.com/nodejs/node/pull/17325)
* [[`1e3aed0be3`](https://github.com/nodejs/node/commit/1e3aed0be3)] - **test**: fix flaky parallel/test-http2-client-upload (Anna Henningsen) [#17361](https://github.com/nodejs/node/pull/17361)
* [[`1adccc6a6a`](https://github.com/nodejs/node/commit/1adccc6a6a)] - **test**: fix isNAN-\>Number.isNAN (yuza yuko) [#17309](https://github.com/nodejs/node/pull/17309)
* [[`91e21171c7`](https://github.com/nodejs/node/commit/91e21171c7)] - **test**: make use of Number.isNaN to test-readfloat.js (Hiromu Yoshiwara) [#17310](https://github.com/nodejs/node/pull/17310)
* [[`97a279e375`](https://github.com/nodejs/node/commit/97a279e375)] - **test**: replace function with arrow function (spring_raining) [#17312](https://github.com/nodejs/node/pull/17312)
* [[`e35acedca5`](https://github.com/nodejs/node/commit/e35acedca5)] - **test**: refactor using template string (Yoshiya Hinosawa) [#17314](https://github.com/nodejs/node/pull/17314)
* [[`f51cb1c0cd`](https://github.com/nodejs/node/commit/f51cb1c0cd)] - **test**: replace function with arrow function (Hiroaki KARASAWA) [#17308](https://github.com/nodejs/node/pull/17308)
* [[`3f4d0fc76b`](https://github.com/nodejs/node/commit/3f4d0fc76b)] - **test**: replace function with arrow function (kou-hin) [#17305](https://github.com/nodejs/node/pull/17305)
* [[`d8e4d9593b`](https://github.com/nodejs/node/commit/d8e4d9593b)] - **test**: use arrow function (koooge) [#17318](https://github.com/nodejs/node/pull/17318)
* [[`b420209fc6`](https://github.com/nodejs/node/commit/b420209fc6)] - **test**: use common.hasIntl instead of typeof Intl (Aqui Tsuchida) [#17311](https://github.com/nodejs/node/pull/17311)
* [[`284dad7468`](https://github.com/nodejs/node/commit/284dad7468)] - **test**: use Number.isNaN() (MURAKAMI Masahiko) [#17319](https://github.com/nodejs/node/pull/17319)
* [[`94abefba93`](https://github.com/nodejs/node/commit/94abefba93)] - **test**: add test of stream Transform (Yoshiya Hinosawa) [#17303](https://github.com/nodejs/node/pull/17303)
* [[`e026132726`](https://github.com/nodejs/node/commit/e026132726)] - **test**: refactor concat string to template string (jimmy) [#17252](https://github.com/nodejs/node/pull/17252)
* [[`0e5ff6f44b`](https://github.com/nodejs/node/commit/0e5ff6f44b)] - **test**: use common.crashOnUnhandledRejection (yozian) [#17242](https://github.com/nodejs/node/pull/17242)
* [[`24b1839aed`](https://github.com/nodejs/node/commit/24b1839aed)] - **test**: use common.crashOnUnhandledRejection (Kcin1993) [#17235](https://github.com/nodejs/node/pull/17235)
* [[`497195a1a3`](https://github.com/nodejs/node/commit/497195a1a3)] - **test**: add common.crashOnUnhandledRejection() (Andy Chen) [#17234](https://github.com/nodejs/node/pull/17234)
* [[`c375816667`](https://github.com/nodejs/node/commit/c375816667)] - **test**: use common.crashOnUnhandledRejection (zhengyuanjie) [#17215](https://github.com/nodejs/node/pull/17215)
* [[`cb3348715b`](https://github.com/nodejs/node/commit/cb3348715b)] - **test**: use common.crashOnUnhandledRejection (Jason Chung) [#17233](https://github.com/nodejs/node/pull/17233)
* [[`8d1ec5d24a`](https://github.com/nodejs/node/commit/8d1ec5d24a)] - **test**: use common.crashOnUnhandledRejection() (sorarize@gmail.com) [#17232](https://github.com/nodejs/node/pull/17232)
* [[`e3db509b47`](https://github.com/nodejs/node/commit/e3db509b47)] - **test**: use common.crashOnUnhandledRejection (Kurt Hsu) [#17229](https://github.com/nodejs/node/pull/17229)
* [[`017379e89b`](https://github.com/nodejs/node/commit/017379e89b)] - **test**: add common.crashOnHandleRejection (jackyen) [#17225](https://github.com/nodejs/node/pull/17225)
* [[`ce284fcb5d`](https://github.com/nodejs/node/commit/ce284fcb5d)] - **test**: add crashonUnhandledRejection (danielLin) [#17237](https://github.com/nodejs/node/pull/17237)
* [[`5cbe0f2420`](https://github.com/nodejs/node/commit/5cbe0f2420)] - **test**: keep coverage reports after coverage-clean (Anatoli Papirovski) [#15470](https://github.com/nodejs/node/pull/15470)
* [[`2d2e7803b2`](https://github.com/nodejs/node/commit/2d2e7803b2)] - **test**: add test on unhandled rejection (Larry Lu) [#17228](https://github.com/nodejs/node/pull/17228)
* [[`a536b031d8`](https://github.com/nodejs/node/commit/a536b031d8)] - **test**: use common.crashOnUnhandledRejection (aryung chen) [#17221](https://github.com/nodejs/node/pull/17221)
* [[`2010b800b8`](https://github.com/nodejs/node/commit/2010b800b8)] - **test**: use common.crashOnUnhandledRejection (Zack Yang) [#17217](https://github.com/nodejs/node/pull/17217)
* [[`d50671b061`](https://github.com/nodejs/node/commit/d50671b061)] - **test**: add common.crashOnUnhandledRejection() (Scya597) [#17212](https://github.com/nodejs/node/pull/17212)
* [[`42a8f03a8b`](https://github.com/nodejs/node/commit/42a8f03a8b)] - **test**: remove unlink function which is needless (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`5c70cef403`](https://github.com/nodejs/node/commit/5c70cef403)] - **test**: dont need to remove nonexistent directory (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`696c962bf3`](https://github.com/nodejs/node/commit/696c962bf3)] - **test**: use common.crashOnUnhandledRejection() (Ivan Wei) [#17227](https://github.com/nodejs/node/pull/17227)
* [[`caa59b9a47`](https://github.com/nodejs/node/commit/caa59b9a47)] - **test**: add common.crashOnUnhandledRejection() (Kyle Yu) [#17236](https://github.com/nodejs/node/pull/17236)
* [[`c232542494`](https://github.com/nodejs/node/commit/c232542494)] - **test**: use crashOnUnhandledRejection (YuLun Shih) [#17220](https://github.com/nodejs/node/pull/17220)
* [[`63f9a13299`](https://github.com/nodejs/node/commit/63f9a13299)] - **test**: fix linting error (James M Snell) [#17251](https://github.com/nodejs/node/pull/17251)
* [[`dc4aa89224`](https://github.com/nodejs/node/commit/dc4aa89224)] - **test**: use common.crashOnUnhandledRejection (jimliu7434) [#17231](https://github.com/nodejs/node/pull/17231)
* [[`9bf2da3429`](https://github.com/nodejs/node/commit/9bf2da3429)] - **test**: use crashOnUnhandledRejection (Roth Peng) [#17226](https://github.com/nodejs/node/pull/17226)
* [[`582f1f01f8`](https://github.com/nodejs/node/commit/582f1f01f8)] - **test**: use common.crashOnUnhandledRejection (esbb48) [#17218](https://github.com/nodejs/node/pull/17218)
* [[`5cfd4ea3ed`](https://github.com/nodejs/node/commit/5cfd4ea3ed)] - **test**: use arrow function instead of bind (Lance Ball) [#17202](https://github.com/nodejs/node/pull/17202)
* [[`25ff8bef18`](https://github.com/nodejs/node/commit/25ff8bef18)] - **test**: use crashOnUnhandledRejection (Chiahao Lin) [#17219](https://github.com/nodejs/node/pull/17219)
* [[`965051dc14`](https://github.com/nodejs/node/commit/965051dc14)] - **test**: use common.crashOnUnhandledRejection (Whien) [#17214](https://github.com/nodejs/node/pull/17214)
* [[`72e480d85e`](https://github.com/nodejs/node/commit/72e480d85e)] - **test**: clean up inappropriate language (Gus Caplan) [#17170](https://github.com/nodejs/node/pull/17170)
* [[`c2bb4b211e`](https://github.com/nodejs/node/commit/c2bb4b211e)] - **test**: bypass dns for IPv6 net tests (Refael Ackermann) [#16976](https://github.com/nodejs/node/pull/16976)
* [[`417e7d1ac2`](https://github.com/nodejs/node/commit/417e7d1ac2)] - **test**: wrap callback in common.mustCall (suman-mitra) [#17173](https://github.com/nodejs/node/pull/17173)
* [[`b2c10cad51`](https://github.com/nodejs/node/commit/b2c10cad51)] - **test**: remove unused parameter in test-next-tick-error-spin.js (Francois KY) [#17185](https://github.com/nodejs/node/pull/17185)
* [[`2bbc1f070d`](https://github.com/nodejs/node/commit/2bbc1f070d)] - **test**: remove unused parameter (Fran Herrero) [#17193](https://github.com/nodejs/node/pull/17193)
* [[`c2b30a99b7`](https://github.com/nodejs/node/commit/c2b30a99b7)] - **test**: remove unused variable (Pierre-Loic Doulcet) [#17186](https://github.com/nodejs/node/pull/17186)
* [[`2e311266f7`](https://github.com/nodejs/node/commit/2e311266f7)] - **test**: remove unused variable (Guillaume Flandre) [#17187](https://github.com/nodejs/node/pull/17187)
* [[`a08bcaeca9`](https://github.com/nodejs/node/commit/a08bcaeca9)] - **test**: remove unused parameter (François Descamps) [#17184](https://github.com/nodejs/node/pull/17184)
* [[`36281f4003`](https://github.com/nodejs/node/commit/36281f4003)] - **test**: remove unused parameter (Xavier Balloy) [#17188](https://github.com/nodejs/node/pull/17188)
* [[`15b6bcf68b`](https://github.com/nodejs/node/commit/15b6bcf68b)] - **test**: make debugging of inspector-port-zero easier (Gibson Fahnestock) [#16685](https://github.com/nodejs/node/pull/16685)
* [[`9914bcaae9`](https://github.com/nodejs/node/commit/9914bcaae9)] - **test**: replace assert.throws w/ common.expectsError (sgreylyn) [#17091](https://github.com/nodejs/node/pull/17091)
* [[`e16d833076`](https://github.com/nodejs/node/commit/e16d833076)] - **test**: reduce benchmark cases in test-benchmark-buffer (Rich Trott) [#17111](https://github.com/nodejs/node/pull/17111)
* [[`79ba8637d0`](https://github.com/nodejs/node/commit/79ba8637d0)] - **test**: fs.write() if 3rd argument is a callback, not offset (Patrick Heneise) [#17045](https://github.com/nodejs/node/pull/17045)
* [[`23c98fa796`](https://github.com/nodejs/node/commit/23c98fa796)] - **test**: utilize common.mustCall() on child exit (sreepurnajasti) [#16996](https://github.com/nodejs/node/pull/16996)
* [[`2776816945`](https://github.com/nodejs/node/commit/2776816945)] - **test**: use arrow functions instead of bind (Tobias Nießen) [#17070](https://github.com/nodejs/node/pull/17070)
* [[`b9311697db`](https://github.com/nodejs/node/commit/b9311697db)] - **test**: move timing-sensitive test to sequential (Rich Trott) [#16775](https://github.com/nodejs/node/pull/16775)
* [[`acf6f24ef2`](https://github.com/nodejs/node/commit/acf6f24ef2)] - **test**: make REPL test pass in coverage mode (Anna Henningsen) [#17082](https://github.com/nodejs/node/pull/17082)
* [[`70060eef65`](https://github.com/nodejs/node/commit/70060eef65)] - **test**: --enable-static linked executable (Daniel Bevenius) [#14986](https://github.com/nodejs/node/pull/14986)
* [[`113dd2b573`](https://github.com/nodejs/node/commit/113dd2b573)] - **test**: add basic WebAssembly test (Steve Kinney) [#16760](https://github.com/nodejs/node/pull/16760)
* [[`f80cf5a33d`](https://github.com/nodejs/node/commit/f80cf5a33d)] - **test**: add coverage to tty module (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)
* [[`121245f25f`](https://github.com/nodejs/node/commit/121245f25f)] - **test**: add tls clientcertengine tests (Rich Trott)
* [[`3b1db7f54b`](https://github.com/nodejs/node/commit/3b1db7f54b)] - **test**: flag known flake (Refael Ackermann)
* [[`0093840044`](https://github.com/nodejs/node/commit/0093840044)] - **test,doc**: do not indicate that non-functions "return" values (Rich Trott) [#17267](https://github.com/nodejs/node/pull/17267)
* [[`b6929e2aa9`](https://github.com/nodejs/node/commit/b6929e2aa9)] - **test,doc**: document where common modules go (Gibson Fahnestock) [#16089](https://github.com/nodejs/node/pull/16089)
* [[`89d31ee048`](https://github.com/nodejs/node/commit/89d31ee048)] - **timers**: improvements to TimersList management (Anatoli Papirovski) [#17429](https://github.com/nodejs/node/pull/17429)
* [[`bd79c3788b`](https://github.com/nodejs/node/commit/bd79c3788b)] - **timers**: clean up for readability (Anatoli Papirovski) [#17279](https://github.com/nodejs/node/pull/17279)
* [[`fd501b31c6`](https://github.com/nodejs/node/commit/fd501b31c6)] - **timers**: cross JS/C++ border less frequently (Anna Henningsen) [#17064](https://github.com/nodejs/node/pull/17064)
* [[`33c1e8b3d5`](https://github.com/nodejs/node/commit/33c1e8b3d5)] - **tls**: implement clientCertEngine option (joelostrowski)
* [[`f7a1e39139`](https://github.com/nodejs/node/commit/f7a1e39139)] - **tools**: simplify no-let-in-for-declaration rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`e157e1c922`](https://github.com/nodejs/node/commit/e157e1c922)] - **tools**: simplify buffer-constructor rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`01e7b446d1`](https://github.com/nodejs/node/commit/01e7b446d1)] - **tools**: simplify prefer-assert-methods rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`d59b0a7c73`](https://github.com/nodejs/node/commit/d59b0a7c73)] - **tools**: simplify prefer-common-mustnotcall rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`aa32bd08a8`](https://github.com/nodejs/node/commit/aa32bd08a8)] - **tools**: prefer common.expectsError in tests (Anatoli Papirovski) [#17557](https://github.com/nodejs/node/pull/17557)
* [[`89964183c0`](https://github.com/nodejs/node/commit/89964183c0)] - **tools**: don't lint-md as part of main lint target (Refael Ackermann) [#17587](https://github.com/nodejs/node/pull/17587)
* [[`70cfe687ca`](https://github.com/nodejs/node/commit/70cfe687ca)] - **tools**: replace space with \b in regex (Diego Rodríguez Baquero) [#17479](https://github.com/nodejs/node/pull/17479)
* [[`e57af5aada`](https://github.com/nodejs/node/commit/e57af5aada)] - **tools**: lint for additional strings in docs (Rich Trott) [#17492](https://github.com/nodejs/node/pull/17492)
* [[`0e5dc8f925`](https://github.com/nodejs/node/commit/0e5dc8f925)] - **tools**: update markdown lint presets (Rich Trott) [#17382](https://github.com/nodejs/node/pull/17382)
* [[`6c65e04231`](https://github.com/nodejs/node/commit/6c65e04231)] - **tools**: enable no-return-await lint rule (Rich Trott) [#17265](https://github.com/nodejs/node/pull/17265)
* [[`1e34a0e9a8`](https://github.com/nodejs/node/commit/1e34a0e9a8)] - **tools**: add cpplint rule for NULL usage (Daniel Bevenius) [#17373](https://github.com/nodejs/node/pull/17373)
* [[`e41344f1b8`](https://github.com/nodejs/node/commit/e41344f1b8)] - **tools**: add docs for prefer-util-format-errors rule (Jon Moss) [#17376](https://github.com/nodejs/node/pull/17376)
* [[`1cc6df29a7`](https://github.com/nodejs/node/commit/1cc6df29a7)] - **tools**: add Boxstarter script (Bartosz Sosnowski) [#17046](https://github.com/nodejs/node/pull/17046)
* [[`6624ac3131`](https://github.com/nodejs/node/commit/6624ac3131)] - **tools**: update to ESLint 4.12.0 (cjihrig) [#16948](https://github.com/nodejs/node/pull/16948)
* [[`8e5b7117bc`](https://github.com/nodejs/node/commit/8e5b7117bc)] - **tools**: prohibit notDeepEqual usage (Ruben Bridgewater) [#16325](https://github.com/nodejs/node/pull/16325)
* [[`b7f81ae266`](https://github.com/nodejs/node/commit/b7f81ae266)] - **tools**: add lint fixer for `require-buffer` (Bamieh) [#17144](https://github.com/nodejs/node/pull/17144)
* [[`f0f32dccfe`](https://github.com/nodejs/node/commit/f0f32dccfe)] - **tools**: fix gitignore for tools/doc/ (Richard Littauer) [#17224](https://github.com/nodejs/node/pull/17224)
* [[`5247ab3792`](https://github.com/nodejs/node/commit/5247ab3792)] - **tools**: make doc tool a bit more readable (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`c8247a7c7d`](https://github.com/nodejs/node/commit/c8247a7c7d)] - **tools**: remove useless function declaration (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`34bfbfece4`](https://github.com/nodejs/node/commit/34bfbfece4)] - **tools**: avoid using process.cwd in tools/lint-js (Tobias Nießen) [#17121](https://github.com/nodejs/node/pull/17121)
* [[`c4eb683020`](https://github.com/nodejs/node/commit/c4eb683020)] - **tools**: use built-in padStart instead of padString (Tobias Nießen) [#17120](https://github.com/nodejs/node/pull/17120)
* [[`4954eef481`](https://github.com/nodejs/node/commit/4954eef481)] - **tools**: allow running test.py without configuring (Gibson Fahnestock) [#16621](https://github.com/nodejs/node/pull/16621)
* [[`16f181e3b9`](https://github.com/nodejs/node/commit/16f181e3b9)] - **tools**: bump remark-cli to 4.0 (Refael Ackermann) [#17028](https://github.com/nodejs/node/pull/17028)
* [[`4f518a4780`](https://github.com/nodejs/node/commit/4f518a4780)] - **tools**: fail tests if malformed status file (Rich Trott) [#16703](https://github.com/nodejs/node/pull/16703)
* [[`7fe6a8f5d5`](https://github.com/nodejs/node/commit/7fe6a8f5d5)] - **tools**: try installing js-yaml only once (Joyee Cheung) [#16661](https://github.com/nodejs/node/pull/16661)
* [[`4d0c70a6f6`](https://github.com/nodejs/node/commit/4d0c70a6f6)] - **tools**: speed up lint-md-build (Refael Ackermann) [#16945](https://github.com/nodejs/node/pull/16945)
* [[`03d2514b46`](https://github.com/nodejs/node/commit/03d2514b46)] - **tools,test**: throw if common.PORT used in parallel tests (Rich Trott) [#17559](https://github.com/nodejs/node/pull/17559)
* [[`8bd74c4061`](https://github.com/nodejs/node/commit/8bd74c4061)] - **tools,test**: use Execute instead of check_output (Refael Ackermann) [#17381](https://github.com/nodejs/node/pull/17381)
* [[`855bb8d486`](https://github.com/nodejs/node/commit/855bb8d486)] - **trace_events**: add executionAsyncId to init events (Andreas Madsen) [#17196](https://github.com/nodejs/node/pull/17196)
* [[`f321921573`](https://github.com/nodejs/node/commit/f321921573)] - **tty**: fix 'resize' event regression (Ben Noordhuis) [#16225](https://github.com/nodejs/node/pull/16225)
* [[`4e3aa9a899`](https://github.com/nodejs/node/commit/4e3aa9a899)] - **tty**: refactor exports (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)
* [[`8383c348b8`](https://github.com/nodejs/node/commit/8383c348b8)] - **util**: fix negative 0 check in inspect (Gus Caplan) [#17507](https://github.com/nodejs/node/pull/17507)
* [[`c5d20b36e1`](https://github.com/nodejs/node/commit/c5d20b36e1)] - **util**: remove check for global.process (Gus Caplan) [#17435](https://github.com/nodejs/node/pull/17435)
* [[`a37eb32c32`](https://github.com/nodejs/node/commit/a37eb32c32)] - **util**: escaping object keys in util.inspect() (buji) [#16986](https://github.com/nodejs/node/pull/16986)
* [[`57ee0dd5e3`](https://github.com/nodejs/node/commit/57ee0dd5e3)] - **zlib**: remove unnecessary else branch (john) [#17057](https://github.com/nodejs/node/pull/17057)
* [[`45ca714005`](https://github.com/nodejs/node/commit/45ca714005)] - **zlib**: fix assert fail for bad write in object mode (Kevin Locke) [#16960](https://github.com/nodejs/node/pull/16960)
* [[`fa01fe6819`](https://github.com/nodejs/node/commit/fa01fe6819)] - **zlib**: fix decompression of empty data streams (Anna Henningsen) [#17042](https://github.com/nodejs/node/pull/17042)

<a id="9.2.1"></a>
## 2017-12-08, Version 9.2.1 (Current), @evanlucas

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/december-2017-security-releases/ for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2017-15896
* CVE-2017-15897
* CVE-2017-3738 (from the openssl project)

### Notable Changes

* **buffer**:
  * buffer allocated with an invalid content will now be zero filled (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* **deps**:
  * openssl updated to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)

### Commits

* [[`15bf640668`](https://github.com/nodejs/node/commit/15bf640668)] - **buffer**: zero-fill buffer allocated with invalid content (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* [[`c0954f4ba1`](https://github.com/nodejs/node/commit/c0954f4ba1)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`dfd7cd3038`](https://github.com/nodejs/node/commit/dfd7cd3038)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`76e7ff2915`](https://github.com/nodejs/node/commit/76e7ff2915)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`593f21ee9c`](https://github.com/nodejs/node/commit/593f21ee9c)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`235c78f968`](https://github.com/nodejs/node/commit/235c78f968)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`b0ebe5cb4b`](https://github.com/nodejs/node/commit/b0ebe5cb4b)] - **deps**: upgrade openssl sources to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`99fc75e9bc`](https://github.com/nodejs/node/commit/99fc75e9bc)] - **doc**: warn against filling buffer with invalid data (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* [[`f0f9e1abf0`](https://github.com/nodejs/node/commit/f0f9e1abf0)] - **http2**: use correct connect event for TLS Socket (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`65f209ccf1`](https://github.com/nodejs/node/commit/65f209ccf1)] - **http2**: use 'close' event instead of 'streamClosed' (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`d3e2bf0c8d`](https://github.com/nodejs/node/commit/d3e2bf0c8d)] - **http2**: general cleanups in core.js (James M Snell) [#17209](https://github.com/nodejs/node/pull/17209)
* [[`6a76097fad`](https://github.com/nodejs/node/commit/6a76097fad)] - **http2**: major update to internals (James M Snell) [#17105](https://github.com/nodejs/node/pull/17105)
* [[`e14c0babe0`](https://github.com/nodejs/node/commit/e14c0babe0)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)

<a id="9.2.0"></a>
## 2017-11-14, Version 9.2.0 (Current), @evanlucas

### Notable Changes

* **crypto**:
  - Support building with both 1.1.0 and 1.0.2 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* **fs**:
  - fs.realpathSync.native and fs.realpath.native are now exposed (Ben Noordhuis) [#15776](https://github.com/nodejs/node/pull/15776)
* **process**:
  - expose process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)

### Commits

* [[`02ea0ee507`](https://github.com/nodejs/node/commit/02ea0ee507)] - **build**: fix cctest compilation (Daniel Bevenius) [#16887](https://github.com/nodejs/node/pull/16887)
* [[`a4557f294a`](https://github.com/nodejs/node/commit/a4557f294a)] - **build**: remove cctest extension (Yihong Wang) [#16680](https://github.com/nodejs/node/pull/16680)
* [[`1dc4fc1390`](https://github.com/nodejs/node/commit/1dc4fc1390)] - **build**: include src\tracing when linting on win (Daniel Bevenius) [#16720](https://github.com/nodejs/node/pull/16720)
* [[`4c11801ed7`](https://github.com/nodejs/node/commit/4c11801ed7)] - **build**: add missing options to help message (Daniel Bevenius) [#16707](https://github.com/nodejs/node/pull/16707)
* [[`bed0560fb5`](https://github.com/nodejs/node/commit/bed0560fb5)] - **console**: avoid adding infinite error listeners (Matteo Collina) [#16770](https://github.com/nodejs/node/pull/16770)
* [[`31dadd2007`](https://github.com/nodejs/node/commit/31dadd2007)] - **(SEMVER-MINOR)** **crypto**: deprecate {ecdhCurve: false} (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`f952caa677`](https://github.com/nodejs/node/commit/f952caa677)] - **(SEMVER-MINOR)** **crypto**: clear some SSL_METHOD deprecation warnings (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`a5e7255385`](https://github.com/nodejs/node/commit/a5e7255385)] - **(SEMVER-MINOR)** **crypto**: make ALPN the same for OpenSSL 1.0.2 & 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`07102ace9e`](https://github.com/nodejs/node/commit/07102ace9e)] - **(SEMVER-MINOR)** **crypto**: remove deprecated ECDH calls w/ OpenSSL 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`627a15f9e5`](https://github.com/nodejs/node/commit/627a15f9e5)] - **(SEMVER-MINOR)** **crypto**: emulate OpenSSL 1.0 ticket scheme in 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`8a8ac8ce4d`](https://github.com/nodejs/node/commit/8a8ac8ce4d)] - **(SEMVER-MINOR)** **crypto**: hard-code tlsSocket.getCipher().version (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`c42935b79c`](https://github.com/nodejs/node/commit/c42935b79c)] - **(SEMVER-MINOR)** **crypto**: add compat logic for "DSS1" and "dss1" (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`5c24fc32c9`](https://github.com/nodejs/node/commit/5c24fc32c9)] - **(SEMVER-MINOR)** **crypto**: Make Hmac 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`fa1fc16c3e`](https://github.com/nodejs/node/commit/fa1fc16c3e)] - **(SEMVER-MINOR)** **crypto**: make SignBase compatible with OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`abe3dc48cc`](https://github.com/nodejs/node/commit/abe3dc48cc)] - **(SEMVER-MINOR)** **crypto**: make Hash 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`59acd27409`](https://github.com/nodejs/node/commit/59acd27409)] - **(SEMVER-MINOR)** **crypto**: make CipherBase 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`6c3ae36cab`](https://github.com/nodejs/node/commit/6c3ae36cab)] - **(SEMVER-MINOR)** **crypto**: remove locking callbacks for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`81760ffea9`](https://github.com/nodejs/node/commit/81760ffea9)] - **(SEMVER-MINOR)** **crypto**: use RSA and DH accessors (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`568d9d0eac`](https://github.com/nodejs/node/commit/568d9d0eac)] - **(SEMVER-MINOR)** **crypto**: test DH keys work without a public half (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`6a9c528a50`](https://github.com/nodejs/node/commit/6a9c528a50)] - **(SEMVER-MINOR)** **crypto**: account for new 1.1.0 SSL APIs (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`cc744b9b26`](https://github.com/nodejs/node/commit/cc744b9b26)] - **(SEMVER-MINOR)** **crypto**: remove unnecessary SSLerr calls (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`201393f655`](https://github.com/nodejs/node/commit/201393f655)] - **(SEMVER-MINOR)** **crypto**: estimate kExternalSize (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`efd9bc36fa`](https://github.com/nodejs/node/commit/efd9bc36fa)] - **(SEMVER-MINOR)** **crypto**: make node_crypto_bio compat w/ OpenSSL 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`8da4983cb4`](https://github.com/nodejs/node/commit/8da4983cb4)] - **(SEMVER-MINOR)** **crypto**: use X509_STORE_CTX_new (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`9c6f63bf3b`](https://github.com/nodejs/node/commit/9c6f63bf3b)] - **deps**: cherry-pick 3c8195d from V8 upstream (Franziska Hinkelmann) [#16897](https://github.com/nodejs/node/pull/16897)
* [[`6ddba2e08e`](https://github.com/nodejs/node/commit/6ddba2e08e)] - **deps**: patch V8 to 6.2.414.44 (Myles Borins) [#16848](https://github.com/nodejs/node/pull/16848)
* [[`f82d3e44c8`](https://github.com/nodejs/node/commit/f82d3e44c8)] - **deps**: upgrade libuv to 1.16.1 (cjihrig) [#16835](https://github.com/nodejs/node/pull/16835)
* [[`38ac50a084`](https://github.com/nodejs/node/commit/38ac50a084)] - **deps**: cherry-pick cc55747 from V8 upstream (Franziska Hinkelmann) [#16890](https://github.com/nodejs/node/pull/16890)
* [[`75405a1481`](https://github.com/nodejs/node/commit/75405a1481)] - **deps**: ICU 60 bump (Steven R. Loomis) [#16876](https://github.com/nodejs/node/pull/16876)
* [[`28b7bf062a`](https://github.com/nodejs/node/commit/28b7bf062a)] - **deps**: cherry-pick b8331cc030 from upstream V8 (Daniel Bevenius) [#16900](https://github.com/nodejs/node/pull/16900)
* [[`2266cafba5`](https://github.com/nodejs/node/commit/2266cafba5)] - ***Revert*** "**deps**: cherry-pick b8331cc030 from upstream V8" (Daniel Bevenius) [#16899](https://github.com/nodejs/node/pull/16899)
* [[`81f14bffff`](https://github.com/nodejs/node/commit/81f14bffff)] - **deps**: cherry-pick b8331cc030 from upstream V8 (Daniel Bevenius) [#16743](https://github.com/nodejs/node/pull/16743)
* [[`6922fda1b5`](https://github.com/nodejs/node/commit/6922fda1b5)] - **doc**: recommend node-core-utils for metadata (Rich Trott) [#16978](https://github.com/nodejs/node/pull/16978)
* [[`ccf1f6aa13`](https://github.com/nodejs/node/commit/ccf1f6aa13)] - **doc**: fix typo in http2 doc (Gus Caplan) [#16993](https://github.com/nodejs/node/pull/16993)
* [[`54768f5094`](https://github.com/nodejs/node/commit/54768f5094)] - **doc**: reorganize COLLABORATOR_GUIDE.md (Rich Trott) [#15710](https://github.com/nodejs/node/pull/15710)
* [[`c4e2343bfb`](https://github.com/nodejs/node/commit/c4e2343bfb)] - **doc**: drop support for VS2015 (Nikolai Vavilov) [#16868](https://github.com/nodejs/node/pull/16868)
* [[`74f33724a2`](https://github.com/nodejs/node/commit/74f33724a2)] - **doc**: clarify the prerequisites for building with VS2017 (Nikolai Vavilov) [#16903](https://github.com/nodejs/node/pull/16903)
* [[`1510fda1b0`](https://github.com/nodejs/node/commit/1510fda1b0)] - **doc**: outline commit message for breaking changes (Maton Anthony) [#16846](https://github.com/nodejs/node/pull/16846)
* [[`1fcd95e517`](https://github.com/nodejs/node/commit/1fcd95e517)] - **doc**: remove duplicate 'the' from http2 API doc (Vipin Menon) [#16924](https://github.com/nodejs/node/pull/16924)
* [[`b46714c023`](https://github.com/nodejs/node/commit/b46714c023)] - **doc**: fix typos in N-API (Swathi Kalahastri) [#16911](https://github.com/nodejs/node/pull/16911)
* [[`3ba52c1582`](https://github.com/nodejs/node/commit/3ba52c1582)] - **doc**: correct the spelling of omitting in dgram.md (Vidya Subramanyam) [#16910](https://github.com/nodejs/node/pull/16910)
* [[`e60eff6c01`](https://github.com/nodejs/node/commit/e60eff6c01)] - **doc**: fix a typo in the documentation (Mamatha J V) [#16909](https://github.com/nodejs/node/pull/16909)
* [[`6e9973e912`](https://github.com/nodejs/node/commit/6e9973e912)] - **doc**: improve documentation for the vm module (Franziska Hinkelmann) [#16867](https://github.com/nodejs/node/pull/16867)
* [[`15dcb96b28`](https://github.com/nodejs/node/commit/15dcb96b28)] - **doc**: fix a typo in n-api documentation (Vipin Menon) [#16879](https://github.com/nodejs/node/pull/16879)
* [[`928647c77c`](https://github.com/nodejs/node/commit/928647c77c)] - **doc**: fix typo in assert.md (Andres Kalle) [#16866](https://github.com/nodejs/node/pull/16866)
* [[`a184dbcb2c`](https://github.com/nodejs/node/commit/a184dbcb2c)] - **doc**: update subprocess.killed (cjihrig) [#16748](https://github.com/nodejs/node/pull/16748)
* [[`deff9f5527`](https://github.com/nodejs/node/commit/deff9f5527)] - **events**: remove emit micro-optimizations (Anatoli Papirovski) [#16869](https://github.com/nodejs/node/pull/16869)
* [[`8611e3b93b`](https://github.com/nodejs/node/commit/8611e3b93b)] - **(SEMVER-MINOR)** **fs**: expose realpath(3) bindings (Ben Noordhuis) [#15776](https://github.com/nodejs/node/pull/15776)
* [[`8dfd5a515a`](https://github.com/nodejs/node/commit/8dfd5a515a)] - **http2**: multiple smaller code cleanups (James M Snell) [#16764](https://github.com/nodejs/node/pull/16764)
* [[`8245e5a2d4`](https://github.com/nodejs/node/commit/8245e5a2d4)] - **http2**: simplify subsequent rstStream calls (Anatoli Papirovski) [#16753](https://github.com/nodejs/node/pull/16753)
* [[`afbdd017c1`](https://github.com/nodejs/node/commit/afbdd017c1)] - **lib**: replace string concatenation with template (Suryanarayana Murthy N) [#16933](https://github.com/nodejs/node/pull/16933)
* [[`6c0fd55488`](https://github.com/nodejs/node/commit/6c0fd55488)] - **lib**: guard inspector console using process var (Daniel Bevenius) [#15008](https://github.com/nodejs/node/pull/15008)
* [[`c1792544e8`](https://github.com/nodejs/node/commit/c1792544e8)] - **lib**: improve the usage of TypeError\[INVALID_ARG_TYPE\] (Weijia Wang) [#16401](https://github.com/nodejs/node/pull/16401)
* [[`44c3cc2bec`](https://github.com/nodejs/node/commit/44c3cc2bec)] - **lib**: change concatenated string to template (Pawan Jangid) [#16930](https://github.com/nodejs/node/pull/16930)
* [[`8eb32e1b35`](https://github.com/nodejs/node/commit/8eb32e1b35)] - **lib**: replace String concatenation with template (saiHemak) [#16922](https://github.com/nodejs/node/pull/16922)
* [[`678e738d70`](https://github.com/nodejs/node/commit/678e738d70)] - **lib**: change concatenated string to template (Nayana Das K) [#16925](https://github.com/nodejs/node/pull/16925)
* [[`df181745b8`](https://github.com/nodejs/node/commit/df181745b8)] - **lib**: replace string concatenation with template (Jayashree S Kumar) [#16921](https://github.com/nodejs/node/pull/16921)
* [[`a9358068db`](https://github.com/nodejs/node/commit/a9358068db)] - **lib**: replace string concatenation with template (Chandrakala) [#16920](https://github.com/nodejs/node/pull/16920)
* [[`16c622209a`](https://github.com/nodejs/node/commit/16c622209a)] - **lib**: replace string concatenation with template (subrahmanya chari p) [#16917](https://github.com/nodejs/node/pull/16917)
* [[`64a0c80773`](https://github.com/nodejs/node/commit/64a0c80773)] - **loader**: test search module (Cyril Lakech) [#16795](https://github.com/nodejs/node/pull/16795)
* [[`bfdaa28fdb`](https://github.com/nodejs/node/commit/bfdaa28fdb)] - **meta**: 32 bit linux is experimental (Refael Ackermann) [#16723](https://github.com/nodejs/node/pull/16723)
* [[`76e6422868`](https://github.com/nodejs/node/commit/76e6422868)] - **src**: fix compiler warning in process.ppid (cjihrig) [#16958](https://github.com/nodejs/node/pull/16958)
* [[`60a6caea76`](https://github.com/nodejs/node/commit/60a6caea76)] - **src**: turn inspector raw pointer into unique_ptr (Franziska Hinkelmann) [#16974](https://github.com/nodejs/node/pull/16974)
* [[`79648496ec`](https://github.com/nodejs/node/commit/79648496ec)] - **src**: explain implementation of vm module (Franziska Hinkelmann) [#16962](https://github.com/nodejs/node/pull/16962)
* [[`a79d86db21`](https://github.com/nodejs/node/commit/a79d86db21)] - **src**: use unrefed async for GC tracking (Anna Henningsen) [#16758](https://github.com/nodejs/node/pull/16758)
* [[`5df3dc1169`](https://github.com/nodejs/node/commit/5df3dc1169)] - **src**: make StreamBase prototype accessors robust (Joyee Cheung) [#16860](https://github.com/nodejs/node/pull/16860)
* [[`41937bedf9`](https://github.com/nodejs/node/commit/41937bedf9)] - **(SEMVER-MINOR)** **src**: add process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)
* [[`0b93bbb419`](https://github.com/nodejs/node/commit/0b93bbb419)] - **src**: add openssl-system-ca-path configure option (Daniel Bevenius) [#16790](https://github.com/nodejs/node/pull/16790)
* [[`43c5726028`](https://github.com/nodejs/node/commit/43c5726028)] - **src**: fix UB in InternalModuleReadFile() (Ben Noordhuis) [#16871](https://github.com/nodejs/node/pull/16871)
* [[`bce5db2225`](https://github.com/nodejs/node/commit/bce5db2225)] - **src**: CHECK() for argument overflow in Spawn() (cjihrig) [#16761](https://github.com/nodejs/node/pull/16761)
* [[`120db20a1a`](https://github.com/nodejs/node/commit/120db20a1a)] - **test**: reuse existing PassThrough implementation (Tobias Nießen) [#16936](https://github.com/nodejs/node/pull/16936)
* [[`9f0b0fbd0e`](https://github.com/nodejs/node/commit/9f0b0fbd0e)] - **test**: use fixtures module for path resolve (sercan yersen) [#16842](https://github.com/nodejs/node/pull/16842)
* [[`d5f2601bc8`](https://github.com/nodejs/node/commit/d5f2601bc8)] - **test**: refactor comments in test-child-process-spawnsync-maxbuf (ChrBergert) [#16829](https://github.com/nodejs/node/pull/16829)
* [[`93af193821`](https://github.com/nodejs/node/commit/93af193821)] - **test**: refactor addons-napi/test_promise/test.js (ka3e) [#16814](https://github.com/nodejs/node/pull/16814)
* [[`ad02676816`](https://github.com/nodejs/node/commit/ad02676816)] - **test**: used fixturesDir from fixtures modules (Klemen Kogovsek) [#16813](https://github.com/nodejs/node/pull/16813)
* [[`809dc099ac`](https://github.com/nodejs/node/commit/809dc099ac)] - **test**: refactor fs.write() test (Patrick Heneise) [#16827](https://github.com/nodejs/node/pull/16827)
* [[`35fc317d8f`](https://github.com/nodejs/node/commit/35fc317d8f)] - **test**: add a test description (Grant Gasparyan) [#16833](https://github.com/nodejs/node/pull/16833)
* [[`83f9604adc`](https://github.com/nodejs/node/commit/83f9604adc)] - **test**: use ES6 classes instead of util.inherits (Tobias Nießen) [#16938](https://github.com/nodejs/node/pull/16938)
* [[`7c364a269c`](https://github.com/nodejs/node/commit/7c364a269c)] - **test**: use common/fixtures module in hash-seed test (Javier Blanco) [#16823](https://github.com/nodejs/node/pull/16823)
* [[`3136578871`](https://github.com/nodejs/node/commit/3136578871)] - **test**: make test-tls-external-accessor agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`0be7f8c48c`](https://github.com/nodejs/node/commit/0be7f8c48c)] - **test**: make test-require-json engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`835ca63595`](https://github.com/nodejs/node/commit/835ca63595)] - **test**: make test-repl engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`f8337cea8e`](https://github.com/nodejs/node/commit/f8337cea8e)] - **test**: make test-repl-syntax-error-stack agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`c81b086928`](https://github.com/nodejs/node/commit/c81b086928)] - **test**: make test-repl-harmony engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`591a6927ee`](https://github.com/nodejs/node/commit/591a6927ee)] - **test**: make test-querystring-escape engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`e2f564821e`](https://github.com/nodejs/node/commit/e2f564821e)] - **test**: make test-process-env-symbols agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`9bf887475e`](https://github.com/nodejs/node/commit/9bf887475e)] - **test**: make test-os-eol engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`79e183186c`](https://github.com/nodejs/node/commit/79e183186c)] - **test**: make error stack test engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`b5b23bd3e8`](https://github.com/nodejs/node/commit/b5b23bd3e8)] - **test**: make test-http-outgoing-proto agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`bd7822b8f6`](https://github.com/nodejs/node/commit/bd7822b8f6)] - **test**: make test-error-reporting engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`4604294647`](https://github.com/nodejs/node/commit/4604294647)] - **test**: make test-console engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`025eadfcd5`](https://github.com/nodejs/node/commit/025eadfcd5)] - **test**: make test-console-count engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`c74467f938`](https://github.com/nodejs/node/commit/c74467f938)] - **test**: make test-cli-syntax engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`2e2e8020e7`](https://github.com/nodejs/node/commit/2e2e8020e7)] - **test**: make test-buffer-slow engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`7a5378377f`](https://github.com/nodejs/node/commit/7a5378377f)] - **test**: improve template value for test message (Stephan Smith) [#16826](https://github.com/nodejs/node/pull/16826)
* [[`6ea8768141`](https://github.com/nodejs/node/commit/6ea8768141)] - **test**: unmark flaky test (Anna Henningsen) [#16758](https://github.com/nodejs/node/pull/16758)
* [[`651fee4c54`](https://github.com/nodejs/node/commit/651fee4c54)] - **test**: change concatenated string to template (Deepthi Sebastian) [#16929](https://github.com/nodejs/node/pull/16929)
* [[`1ea546c9ee`](https://github.com/nodejs/node/commit/1ea546c9ee)] - **test**: change concatenated string to template (Anawesha Khuntia) [#16912](https://github.com/nodejs/node/pull/16912)
* [[`385f65826a`](https://github.com/nodejs/node/commit/385f65826a)] - **test**: change string concatenation to template (Suryanarayana Murthy N) [#16919](https://github.com/nodejs/node/pull/16919)
* [[`61fbd857d7`](https://github.com/nodejs/node/commit/61fbd857d7)] - **test**: use template string for concatenation (Vipin Menon) [#16918](https://github.com/nodejs/node/pull/16918)
* [[`fbec5ec4d9`](https://github.com/nodejs/node/commit/fbec5ec4d9)] - **test**: replace string concatenation with template (Kabir Islam) [#16916](https://github.com/nodejs/node/pull/16916)
* [[`407eb6f93e`](https://github.com/nodejs/node/commit/407eb6f93e)] - **test**: enable mustCall() during child exit (Vipin Menon) [#16915](https://github.com/nodejs/node/pull/16915)
* [[`26e4c587eb`](https://github.com/nodejs/node/commit/26e4c587eb)] - **(SEMVER-MINOR)** **test**: fix flaky test-http2-create-client-connect (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`8c294203cf`](https://github.com/nodejs/node/commit/8c294203cf)] - **(SEMVER-MINOR)** **test**: fix test-https-agent-session-eviction for 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`3d438f84b2`](https://github.com/nodejs/node/commit/3d438f84b2)] - **(SEMVER-MINOR)** **test**: configure certs in tests (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`08ac21423e`](https://github.com/nodejs/node/commit/08ac21423e)] - **(SEMVER-MINOR)** **test**: revise test-tls-econnreset for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`d95b608d98`](https://github.com/nodejs/node/commit/d95b608d98)] - **(SEMVER-MINOR)** **test**: test with a larger RSA key (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`85ffc2f960`](https://github.com/nodejs/node/commit/85ffc2f960)] - **(SEMVER-MINOR)** **test**: remove sha from test expectations (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`bec042183c`](https://github.com/nodejs/node/commit/bec042183c)] - **(SEMVER-MINOR)** **test**: update test expectations for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`b42013c31e`](https://github.com/nodejs/node/commit/b42013c31e)] - **test**: replace string concatenation with template (Sabari Lakshmi Krishnamoorthy) [#16914](https://github.com/nodejs/node/pull/16914)
* [[`fbc7451553`](https://github.com/nodejs/node/commit/fbc7451553)] - **test**: replace string concatenation with template (Tanvi Kini) [#16913](https://github.com/nodejs/node/pull/16913)
* [[`7f7dec8b08`](https://github.com/nodejs/node/commit/7f7dec8b08)] - **test**: cover vm.runInNewContext() (cjihrig) [#16906](https://github.com/nodejs/node/pull/16906)
* [[`8311561ed5`](https://github.com/nodejs/node/commit/8311561ed5)] - **test**: improve assertion messages (Neil Vass) [#16885](https://github.com/nodejs/node/pull/16885)
* [[`1ee6df9612`](https://github.com/nodejs/node/commit/1ee6df9612)] - **test**: pass process.env to child processes (Rod Vagg) [#16405](https://github.com/nodejs/node/pull/16405)
* [[`172652ba27`](https://github.com/nodejs/node/commit/172652ba27)] - **test**: improve assert messages in stream test (Katie Stockton Roberts) [#16884](https://github.com/nodejs/node/pull/16884)
* [[`271c89e569`](https://github.com/nodejs/node/commit/271c89e569)] - **test**: improve assertion in test-require-dot (Adam Wegrzynek) [#16805](https://github.com/nodejs/node/pull/16805)
* [[`5d3a4ad1cf`](https://github.com/nodejs/node/commit/5d3a4ad1cf)] - **test**: improve error emssage reporting in testNapiRun.js (Paul Ashfield) [#16821](https://github.com/nodejs/node/pull/16821)
* [[`f71f41d79b`](https://github.com/nodejs/node/commit/f71f41d79b)] - **test**: add values to error message (Adam Jeffery) [#16831](https://github.com/nodejs/node/pull/16831)
* [[`c1cdc658c0`](https://github.com/nodejs/node/commit/c1cdc658c0)] - **test**: replace common.fixtiresDir with fixtures.readKey() (woj) [#16817](https://github.com/nodejs/node/pull/16817)
* [[`c662cc0b70`](https://github.com/nodejs/node/commit/c662cc0b70)] - **test**: use internet.addresses in internet tests (Joyee Cheung) [#16390](https://github.com/nodejs/node/pull/16390)
* [[`a465f2bc78`](https://github.com/nodejs/node/commit/a465f2bc78)] - **test**: introduce test/common/internet.addresses (Joyee Cheung) [#16390](https://github.com/nodejs/node/pull/16390)
* [[`bc19a93093`](https://github.com/nodejs/node/commit/bc19a93093)] - **test**: use tmpDir in test-fs-utimes (Rich Trott) [#16774](https://github.com/nodejs/node/pull/16774)
* [[`4d55a1dc2f`](https://github.com/nodejs/node/commit/4d55a1dc2f)] - **test**: improve assert messages in napi exception test (Paul Blanche) [#16820](https://github.com/nodejs/node/pull/16820)
* [[`8ad4f768c0`](https://github.com/nodejs/node/commit/8ad4f768c0)] - **test**: remove message argument in cluster setup test (mbornath) [#16838](https://github.com/nodejs/node/pull/16838)
* [[`21e9888237`](https://github.com/nodejs/node/commit/21e9888237)] - **test**: check session timeout in http2 (Anatoli Papirovski) [#16754](https://github.com/nodejs/node/pull/16754)
* [[`be266bdbbd`](https://github.com/nodejs/node/commit/be266bdbbd)] - **test**: move test-http-keepalive-maxsockets to sequential (Rich Trott) [#16777](https://github.com/nodejs/node/pull/16777)
* [[`adcaddfce8`](https://github.com/nodejs/node/commit/adcaddfce8)] - **test**: improve assert messages in test-global (Mark McNelis) [#16843](https://github.com/nodejs/node/pull/16843)
* [[`535eb64e55`](https://github.com/nodejs/node/commit/535eb64e55)] - **tools**: enforce no unused trailing arguments tools directory (Rich Trott) [#16953](https://github.com/nodejs/node/pull/16953)
* [[`ad27e2c2e8`](https://github.com/nodejs/node/commit/ad27e2c2e8)] - **tools**: remove unused trailing function arguments (Rich Trott) [#16953](https://github.com/nodejs/node/pull/16953)
* [[`7ba35995a7`](https://github.com/nodejs/node/commit/7ba35995a7)] - **tools**: fix inspector-check reporting (Daniel Bevenius) [#16902](https://github.com/nodejs/node/pull/16902)
* [[`25dd8f66be`](https://github.com/nodejs/node/commit/25dd8f66be)] - **tools**: add direct anchors for error codes (Joyee Cheung) [#16779](https://github.com/nodejs/node/pull/16779)
* [[`625999b840`](https://github.com/nodejs/node/commit/625999b840)] - **tools**: don't lint files that have not changed (Joyee Cheung) [#16581](https://github.com/nodejs/node/pull/16581)
* [[`942a9ed6a8`](https://github.com/nodejs/node/commit/942a9ed6a8)] - **tools,build**: allow build without `remark-cli` (Refael Ackermann) [#16893](https://github.com/nodejs/node/pull/16893)

<a id="9.1.0"></a>
## 2017-11-07, Version 9.1.0 (Current), @cjihrig

### Notable Changes

* **CLI**:
  - `NODE_OPTIONS` now supports the `--stack-trace-limit` option. [#16495](https://github.com/nodejs/node/pull/16495)
* **deps**:
  - OpenSSL is upgraded to 1.0.2m [#16691](https://github.com/nodejs/node/pull/16691)
* **http**:
  - A `'connect'` event handler leak has been fixed. [#16725](https://github.com/nodejs/node/pull/16725)
  - The `103 Early Hints` status code is now supported. [#16644](https://github.com/nodejs/node/pull/16644)

### Commits

* [[`32417999ac`](https://github.com/nodejs/node/commit/32417999ac)] - **build**: suppress lint-md output (Gibson Fahnestock) [#16551](https://github.com/nodejs/node/pull/16551)
* [[`433745e7eb`](https://github.com/nodejs/node/commit/433745e7eb)] - **build**: add missing comma in sources list (Daniel Bevenius) [#16613](https://github.com/nodejs/node/pull/16613)
* [[`8bc5249223`](https://github.com/nodejs/node/commit/8bc5249223)] - **build**: make test-doc and lint addon docs (Joyee Cheung) [#16377](https://github.com/nodejs/node/pull/16377)
* [[`88ad01fce7`](https://github.com/nodejs/node/commit/88ad01fce7)] - **build**: make doc target quiet (Daniel Bevenius) [#16516](https://github.com/nodejs/node/pull/16516)
* [[`f3e01618f1`](https://github.com/nodejs/node/commit/f3e01618f1)] - **build,src**: Add CloudABI as a POSIX-like runtime environment. (Ed Schouten) [#16612](https://github.com/nodejs/node/pull/16612)
* [[`7349d42945`](https://github.com/nodejs/node/commit/7349d42945)] - **(SEMVER-MINOR)** **cli**: add --stack-trace-limit to NODE_OPTIONS (Anna Henningsen) [#16495](https://github.com/nodejs/node/pull/16495)
* [[`ed0fbd8d72`](https://github.com/nodejs/node/commit/ed0fbd8d72)] - **deps**: cherry-pick e7f4e9e from upstream libuv (Bartosz Sosnowski) [#16724](https://github.com/nodejs/node/pull/16724)
* [[`185229e258`](https://github.com/nodejs/node/commit/185229e258)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`162686f5f4`](https://github.com/nodejs/node/commit/162686f5f4)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`e0f6dee961`](https://github.com/nodejs/node/commit/e0f6dee961)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3d7eea5da8`](https://github.com/nodejs/node/commit/3d7eea5da8)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3438765781`](https://github.com/nodejs/node/commit/3438765781)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`b130febd1d`](https://github.com/nodejs/node/commit/b130febd1d)] - **deps**: upgrade openssl sources to 1.0.2m (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`90e8e81bbb`](https://github.com/nodejs/node/commit/90e8e81bbb)] - **doc**: mention constant-time in crypto doc (Mithun Sasidharan) [#16604](https://github.com/nodejs/node/pull/16604)
* [[`dee7800ae8`](https://github.com/nodejs/node/commit/dee7800ae8)] - **doc**: add links to EventEmitter in errors.md (Delapouite) [#16861](https://github.com/nodejs/node/pull/16861)
* [[`f097e2775b`](https://github.com/nodejs/node/commit/f097e2775b)] - **doc**: fix a link in dgram.md (Vse Mozhet Byt) [#16854](https://github.com/nodejs/node/pull/16854)
* [[`978aa8476b`](https://github.com/nodejs/node/commit/978aa8476b)] - **doc**: add isTTY property documentation (SonaySevik) [#16828](https://github.com/nodejs/node/pull/16828)
* [[`6739f41f2d`](https://github.com/nodejs/node/commit/6739f41f2d)] - **doc**: fix json generator warnings (Luigi Pinca) [#16742](https://github.com/nodejs/node/pull/16742)
* [[`2bb148f7bb`](https://github.com/nodejs/node/commit/2bb148f7bb)] - **doc**: make stream.Readable consistent (Sakthipriyan Vairamani (thefourtheye)) [#16786](https://github.com/nodejs/node/pull/16786)
* [[`e05d4f43b6`](https://github.com/nodejs/node/commit/e05d4f43b6)] - **doc**: correct effects to affects (gowpen) [#16794](https://github.com/nodejs/node/pull/16794)
* [[`d7df4dfa1c`](https://github.com/nodejs/node/commit/d7df4dfa1c)] - **doc**: correct EventEmitter reference (gowpen) [#16791](https://github.com/nodejs/node/pull/16791)
* [[`77e4ec8c51`](https://github.com/nodejs/node/commit/77e4ec8c51)] - **doc**: update license to include node-inspect (Myles Borins) [#16659](https://github.com/nodejs/node/pull/16659)
* [[`7388144dbc`](https://github.com/nodejs/node/commit/7388144dbc)] - **doc**: add 9.x to version picker and mark 8.x as LTS (Chris Young) [#16672](https://github.com/nodejs/node/pull/16672)
* [[`e585c41487`](https://github.com/nodejs/node/commit/e585c41487)] - **doc**: add docs for Zlib#close() (Luigi Pinca) [#16592](https://github.com/nodejs/node/pull/16592)
* [[`d5ea177652`](https://github.com/nodejs/node/commit/d5ea177652)] - **doc**: add nodejs/gyp team for GYP related issues (Gibson Fahnestock) [#16638](https://github.com/nodejs/node/pull/16638)
* [[`09181eb976`](https://github.com/nodejs/node/commit/09181eb976)] - **doc**: add details about rss on process.memoryUsage (Anthony Nandaa) [#16566](https://github.com/nodejs/node/pull/16566)
* [[`3fd7eddb44`](https://github.com/nodejs/node/commit/3fd7eddb44)] - **doc**: add windowsVerbatimArguments docs (Andrew Stucki) [#16299](https://github.com/nodejs/node/pull/16299)
* [[`1771bb5039`](https://github.com/nodejs/node/commit/1771bb5039)] - **doc**: fix Changelog link order (Gibson Fahnestock) [#16632](https://github.com/nodejs/node/pull/16632)
* [[`6ee28b2823`](https://github.com/nodejs/node/commit/6ee28b2823)] - **doc**: util.isDeepStrictEqual returns boolean (Lucas Azzola) [#16653](https://github.com/nodejs/node/pull/16653)
* [[`59a4789eee`](https://github.com/nodejs/node/commit/59a4789eee)] - **doc**: howto decode buffers extending from Writable (dicearr) [#16403](https://github.com/nodejs/node/pull/16403)
* [[`d733dd9468`](https://github.com/nodejs/node/commit/d733dd9468)] - **doc**: add *-inl.h include rule to C++ style guide (Joyee Cheung) [#16548](https://github.com/nodejs/node/pull/16548)
* [[`1cef9ef1de`](https://github.com/nodejs/node/commit/1cef9ef1de)] - **doc**: make default values and periods consistent (Matej Krajčovič) [#16563](https://github.com/nodejs/node/pull/16563)
* [[`77f0359708`](https://github.com/nodejs/node/commit/77f0359708)] - **http**: use 'connect' event only if socket is connecting (Luigi Pinca) [#16725](https://github.com/nodejs/node/pull/16725)
* [[`9c39d79908`](https://github.com/nodejs/node/commit/9c39d79908)] - **http**: use arrow fns for lexical `this` in Agent (Bryan English) [#16475](https://github.com/nodejs/node/pull/16475)
* [[`1b090c9b66`](https://github.com/nodejs/node/commit/1b090c9b66)] - **http, http2**: add 103 Early Hints status code (Yosuke Furukawa) [#16644](https://github.com/nodejs/node/pull/16644)
* [[`d6d461003f`](https://github.com/nodejs/node/commit/d6d461003f)] - **http, tls**: better support for IPv6 addresses (Mattias Holmlund) [#14772](https://github.com/nodejs/node/pull/14772)
* [[`762a11fab3`](https://github.com/nodejs/node/commit/762a11fab3)] - **http2**: improve errors thrown in header validation (Joyee Cheung) [#16718](https://github.com/nodejs/node/pull/16718)
* [[`72d0e7e70b`](https://github.com/nodejs/node/commit/72d0e7e70b)] - **http2**: refactor multiple internals (James M Snell) [#16676](https://github.com/nodejs/node/pull/16676)
* [[`e3283c71ce`](https://github.com/nodejs/node/commit/e3283c71ce)] - **http2**: allocate on every chunk send (James M Snell) [#16669](https://github.com/nodejs/node/pull/16669)
* [[`dfe56847ac`](https://github.com/nodejs/node/commit/dfe56847ac)] - **http2**: refactor settings handling (James M Snell) [#16668](https://github.com/nodejs/node/pull/16668)
* [[`bf7dc38ae4`](https://github.com/nodejs/node/commit/bf7dc38ae4)] - **http2**: make sessions garbage-collectible (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`3f529620cc`](https://github.com/nodejs/node/commit/3f529620cc)] - **http2**: remove unused assignment (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`b50c33470e`](https://github.com/nodejs/node/commit/b50c33470e)] - **http2**: track async state for sending (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`224ea159ae`](https://github.com/nodejs/node/commit/224ea159ae)] - **http2**: move uv_prepare handle to `Http2Session` (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`6074c8cdbb`](https://github.com/nodejs/node/commit/6074c8cdbb)] - **inspector**: include node_platform.h header (Alexey Kuzmin) [#16677](https://github.com/nodejs/node/pull/16677)
* [[`e0c7b3d13f`](https://github.com/nodejs/node/commit/e0c7b3d13f)] - **lib**: shuffle v8_prof_polyfill.js for unit testing (Ben Noordhuis) [#16769](https://github.com/nodejs/node/pull/16769)
* [[`c14030ec7a`](https://github.com/nodejs/node/commit/c14030ec7a)] - **lib**: fix version check in tick processor (Ben Noordhuis) [#16769](https://github.com/nodejs/node/pull/16769)
* [[`a0b94f4e12`](https://github.com/nodejs/node/commit/a0b94f4e12)] - **lib**: refactor ES module loader for readability (Anna Henningsen) [#16579](https://github.com/nodejs/node/pull/16579)
* [[`083a6e3830`](https://github.com/nodejs/node/commit/083a6e3830)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`05f90478fc`](https://github.com/nodejs/node/commit/05f90478fc)] - **repl**: avoid crashing from null and undefined errors (cPhost) [#16574](https://github.com/nodejs/node/pull/16574)
* [[`da66610798`](https://github.com/nodejs/node/commit/da66610798)] - **src**: fix -Winconsistent-missing-override warning (Ben Noordhuis) [#16726](https://github.com/nodejs/node/pull/16726)
* [[`6a2cb124e3`](https://github.com/nodejs/node/commit/6a2cb124e3)] - **src**: clean up uv_fs_t's in module_wrap.cc (cjihrig) [#16722](https://github.com/nodejs/node/pull/16722)
* [[`8a2b4ee7bb`](https://github.com/nodejs/node/commit/8a2b4ee7bb)] - **src**: remove unnecessary call to SetHiddenPrototype (Toon Verwaest) [#16554](https://github.com/nodejs/node/pull/16554)
* [[`a87f846cc1`](https://github.com/nodejs/node/commit/a87f846cc1)] - **src**: add method to compute storage in WriteWrap (Anna Henningsen) [#16727](https://github.com/nodejs/node/pull/16727)
* [[`a814786a06`](https://github.com/nodejs/node/commit/a814786a06)] - **src**: improve module loader readability (Anna Henningsen) [#16536](https://github.com/nodejs/node/pull/16536)
* [[`c40b3c6d2a`](https://github.com/nodejs/node/commit/c40b3c6d2a)] - **src**: add 'dynamic' process.release.lts property (Rod Vagg) [#16656](https://github.com/nodejs/node/pull/16656)
* [[`f3a65a85d9`](https://github.com/nodejs/node/commit/f3a65a85d9)] - **src**: pass context to Get() operations for cares_wrap (Evan Lucas) [#16641](https://github.com/nodejs/node/pull/16641)
* [[`4f8765d4c8`](https://github.com/nodejs/node/commit/4f8765d4c8)] - **src**: remove unused includes in string_bytes.h (Daniel Bevenius) [#16606](https://github.com/nodejs/node/pull/16606)
* [[`c4736cfcba`](https://github.com/nodejs/node/commit/c4736cfcba)] - **src**: fix etw provider include on Windows (Joyee Cheung) [#16639](https://github.com/nodejs/node/pull/16639)
* [[`f31b796175`](https://github.com/nodejs/node/commit/f31b796175)] - **src**: add `InternalCallbackScope` util constructor (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`97fd6df920`](https://github.com/nodejs/node/commit/97fd6df920)] - **src**: do not include x.h if x-inl.h is included (Joyee Cheung) [#16548](https://github.com/nodejs/node/pull/16548)
* [[`2294ba49be`](https://github.com/nodejs/node/commit/2294ba49be)] - **test**: tick processor version check regression test (Ben Noordhuis) [#16769](https://github.com/nodejs/node/pull/16769)
* [[`b44157378a`](https://github.com/nodejs/node/commit/b44157378a)] - **test**: use default assertion message (jonask) [#16819](https://github.com/nodejs/node/pull/16819)
* [[`a409b874d9`](https://github.com/nodejs/node/commit/a409b874d9)] - **test**: improve message in test-fs-readfile-pipe-large (fjau) [#16840](https://github.com/nodejs/node/pull/16840)
* [[`527dddac2f`](https://github.com/nodejs/node/commit/527dddac2f)] - **test**: remove custom message from assertion (Nicolas Morel) [#16824](https://github.com/nodejs/node/pull/16824)
* [[`a85d6e9be8`](https://github.com/nodejs/node/commit/a85d6e9be8)] - **test**: show incorrect value on test failure (Sean Karson) [#16818](https://github.com/nodejs/node/pull/16818)
* [[`50d505c188`](https://github.com/nodejs/node/commit/50d505c188)] - **test**: include file mode in assert message (Sascha Tandel) [#16815](https://github.com/nodejs/node/pull/16815)
* [[`5f88543778`](https://github.com/nodejs/node/commit/5f88543778)] - **test**: refactor tls test to use fixtres.readSync (Brian O'Connell) [#16816](https://github.com/nodejs/node/pull/16816)
* [[`d054e94fdc`](https://github.com/nodejs/node/commit/d054e94fdc)] - **test**: add detailed message for assertion failure (Attila Gonda) [#16812](https://github.com/nodejs/node/pull/16812)
* [[`6831e42988`](https://github.com/nodejs/node/commit/6831e42988)] - **test**: use fixtures module in test-repl (Maring, Damian Lion) [#16809](https://github.com/nodejs/node/pull/16809)
* [[`ef679803a0`](https://github.com/nodejs/node/commit/ef679803a0)] - **test**: update test to use fixtures.readKey (Dara Hayes) [#16811](https://github.com/nodejs/node/pull/16811)
* [[`219ac4bde6`](https://github.com/nodejs/node/commit/219ac4bde6)] - **test**: fix typos in read-buffer tests (Jimi van der Woning) [#16834](https://github.com/nodejs/node/pull/16834)
* [[`e4b3c00e48`](https://github.com/nodejs/node/commit/e4b3c00e48)] - **test**: replace fixturesDir with usage of fixtures module (Octavian Ionescu) [#16810](https://github.com/nodejs/node/pull/16810)
* [[`021ccb4011`](https://github.com/nodejs/node/commit/021ccb4011)] - **test**: use default assertion messages (John Byrne) [#16808](https://github.com/nodejs/node/pull/16808)
* [[`2156828f20`](https://github.com/nodejs/node/commit/2156828f20)] - **test**: clarified assert message for test-require-json.js (Matthias Reis) [#16807](https://github.com/nodejs/node/pull/16807)
* [[`ec1b1108af`](https://github.com/nodejs/node/commit/ec1b1108af)] - **test**: replace common.fixturesDir with fixtures module (Dumitru Glavan) [#16803](https://github.com/nodejs/node/pull/16803)
* [[`700c5e7795`](https://github.com/nodejs/node/commit/700c5e7795)] - **test**: replace common.fixturesDir with fixtures.readSync() (Adri Van Houdt) [#16802](https://github.com/nodejs/node/pull/16802)
* [[`bcd818af2a`](https://github.com/nodejs/node/commit/bcd818af2a)] - **test**: replace `common.fixturesDir` usage (Sascha Tandel) [#16800](https://github.com/nodejs/node/pull/16800)
* [[`f3e63f254c`](https://github.com/nodejs/node/commit/f3e63f254c)] - **test**: update test to use fixtures (Adam Wegrzynek) [#16799](https://github.com/nodejs/node/pull/16799)
* [[`0ab3d37be5`](https://github.com/nodejs/node/commit/0ab3d37be5)] - **test**: refactor exitedAfterDisconnect test (Rich Trott) [#16729](https://github.com/nodejs/node/pull/16729)
* [[`26f1a1d9e9`](https://github.com/nodejs/node/commit/26f1a1d9e9)] - **test**: fix test-cli-node-options on Windows (Anna Henningsen) [#16709](https://github.com/nodejs/node/pull/16709)
* [[`fc58c5231f`](https://github.com/nodejs/node/commit/fc58c5231f)] - **test**: fix malformed parallel.status line (Rich Trott) [#16702](https://github.com/nodejs/node/pull/16702)
* [[`689c9d401e`](https://github.com/nodejs/node/commit/689c9d401e)] - **test**: mark test-async-wrap-uncaughtexception as flaky (Refael Ackermann) [#16694](https://github.com/nodejs/node/pull/16694)
* [[`0b337cbee8`](https://github.com/nodejs/node/commit/0b337cbee8)] - **test**: fix flaky test-http2-server-rst-stream.js (Anatoli Papirovski) [#16690](https://github.com/nodejs/node/pull/16690)
* [[`5077faffaa`](https://github.com/nodejs/node/commit/5077faffaa)] - **test**: pause child until parent is ready (jBarz) [#15774](https://github.com/nodejs/node/pull/15774)
* [[`d178c6dc91`](https://github.com/nodejs/node/commit/d178c6dc91)] - **test**: update process-release for Node 8 Carbon (Jeremiah Senkpiel) [#16656](https://github.com/nodejs/node/pull/16656)
* [[`ffe4d7b468`](https://github.com/nodejs/node/commit/ffe4d7b468)] - **test**: increase coverage for ModuleMap (Rob Paton) [#16045](https://github.com/nodejs/node/pull/16045)
* [[`f9b2099d51`](https://github.com/nodejs/node/commit/f9b2099d51)] - **test**: use fixtures module in test-https-pfx (Ken Takagi) [#15895](https://github.com/nodejs/node/pull/15895)
* [[`6998591be7`](https://github.com/nodejs/node/commit/6998591be7)] - **test,net**: remove scatological terminology (Rich Trott) [#16599](https://github.com/nodejs/node/pull/16599)
* [[`87b4e3ed49`](https://github.com/nodejs/node/commit/87b4e3ed49)] - **tls**: accept array of protocols in TLSSocket (Mark S. Everitt) [#16655](https://github.com/nodejs/node/pull/16655)
* [[`e9396d28b1`](https://github.com/nodejs/node/commit/e9396d28b1)] - **tools**: remove unneeded parentheses in doc/html.js (Vse Mozhet Byt) [#16845](https://github.com/nodejs/node/pull/16845)
* [[`6e22dc817f`](https://github.com/nodejs/node/commit/6e22dc817f)] - **tools**: replace string concatenation with template literals (Kevin Yu) [#16804](https://github.com/nodejs/node/pull/16804)
* [[`e781d93bd0`](https://github.com/nodejs/node/commit/e781d93bd0)] - **tools**: replace string concatenation with template literals (Giovanni Lela) [#16806](https://github.com/nodejs/node/pull/16806)
* [[`422d3158ee`](https://github.com/nodejs/node/commit/422d3158ee)] - **tools**: replace string concetation with templates (Patrick Heneise) [#16801](https://github.com/nodejs/node/pull/16801)
* [[`fa5a8419c7`](https://github.com/nodejs/node/commit/fa5a8419c7)] - **tools**: update to ESLint 4.10.0 (cjihrig) [#16738](https://github.com/nodejs/node/pull/16738)
* [[`326a048a5c`](https://github.com/nodejs/node/commit/326a048a5c)] - **tools**: add fixer for no-let-in-for-declaration (Weijia Wang) [#16642](https://github.com/nodejs/node/pull/16642)
* [[`d6a0ffe367`](https://github.com/nodejs/node/commit/d6a0ffe367)] - **zlib**: warn before crash on invalid internals usage (Anna Henningsen) [#16657](https://github.com/nodejs/node/pull/16657)

<a id="9.0.0"></a>
## 2017-10-31, Version 9.0.0 (Current), @jasnell

### Notable Changes

* **Async hooks**
  * Older experimental APIs have been removed. [[`d731369b1d`](https://github.com/nodejs/node/commit/d731369b1d)] [#14414](https://github.com/nodejs/node/pull/14414)

* **Errors**
  * Improvements have been made to `buffer` module error messages. [[`9e0f771224`](https://github.com/nodejs/node/commit/9e0f771224)] [#14975](https://github.com/nodejs/node/pull/14975)
  * The assignment of static error codes to Node.js error continues:
    * `buffer`: [[`e79a61cf80`](https://github.com/nodejs/node/commit/e79a61cf80)] [#16352](https://github.com/nodejs/node/pull/16352), [[`dbfe8c4ea2`](https://github.com/nodejs/node/commit/dbfe8c4ea2)] [#13976](https://github.com/nodejs/node/pull/13976)
    * `child_process`: [[`fe730d34ce`](https://github.com/nodejs/node/commit/fe730d34ce)] [#14009](https://github.com/nodejs/node/pull/14009)
    * `console`: [[`0ecdf29340`](https://github.com/nodejs/node/commit/0ecdf29340)] [#11340](https://github.com/nodejs/node/pull/11340)
    * `crypto`: [[`ee76f3153b`](https://github.com/nodejs/node/commit/ee76f3153b)] [#16428](https://github.com/nodejs/node/pull/16428), [[`df8c6c3651`](https://github.com/nodejs/node/commit/df8c6c3651)] [#16453](https://github.com/nodejs/node/pull/16453), [[`0a03e350fb`](https://github.com/nodejs/node/commit/0a03e350fb)] [#16454](https://github.com/nodejs/node/pull/16454), [[`eeada6ca63`](https://github.com/nodejs/node/commit/eeada6ca63)] [#16448](https://github.com/nodejs/node/pull/16448), [[`a78327f48b`](https://github.com/nodejs/node/commit/a78327f48b)] [#16429](https://github.com/nodejs/node/pull/16429), [[`b8bc652869`](https://github.com/nodejs/node/commit/b8bc652869)] [#15757](https://github.com/nodejs/node/pull/15757), [[`7124b466d9`](https://github.com/nodejs/node/commit/7124b466d9)] [#15746](https://github.com/nodejs/node/pull/15746), [[`3ddc88b5c2`](https://github.com/nodejs/node/commit/3ddc88b5c2)] [#15756](https://github.com/nodejs/node/pull/15756)
    * `dns`: [[`9cb390d899`](https://github.com/nodejs/node/commit/9cb390d899)] [#14212](https://github.com/nodejs/node/pull/14212)
    * `events`: [[`e5ad5456a2`](https://github.com/nodejs/node/commit/e5ad5456a2)] [#15623](https://github.com/nodejs/node/pull/15623)
    * `fs`: [[`219932a9f7`](https://github.com/nodejs/node/commit/219932a9f7)] [#15043](https://github.com/nodejs/node/pull/15043), [[`b61cab2234`](https://github.com/nodejs/node/commit/b61cab2234)] [#11317](https://github.com/nodejs/node/pull/11317)
    * `http`: [[`11a2ca29ba`](https://github.com/nodejs/node/commit/11a2ca29ba)] [#14735](https://github.com/nodejs/node/pull/14735), [[`a9f798ebcc`](https://github.com/nodejs/node/commit/a9f798ebcc)] [#13301](https://github.com/nodejs/node/pull/13301), [[`bdfbce9241`](https://github.com/nodejs/node/commit/bdfbce9241)] [#14423](https://github.com/nodejs/node/pull/14423), [[`4843c2f415`](https://github.com/nodejs/node/commit/4843c2f415)] [#15603](https://github.com/nodejs/node/pull/15603)
    * `inspector`: [[`4cf56ad6f2`](https://github.com/nodejs/node/commit/4cf56ad6f2)] [#15619](https://github.com/nodejs/node/pull/15619)
    * `net`: [[`a03d8cee1f`](https://github.com/nodejs/node/commit/a03d8cee1f)] [#11356](https://github.com/nodejs/node/pull/11356), [[`7f55349079`](https://github.com/nodejs/node/commit/7f55349079)] [#14782](https://github.com/nodejs/node/pull/14782)
    * `path`: [[`dcfbbacba8`](https://github.com/nodejs/node/commit/dcfbbacba8)] [#11319](https://github.com/nodejs/node/pull/11319)
    * `process`: [[`a0f7284346`](https://github.com/nodejs/node/commit/a0f7284346)] [#13739](https://github.com/nodejs/node/pull/13739), [[`062071a9c3`](https://github.com/nodejs/node/commit/062071a9c3)] [#13285](https://github.com/nodejs/node/pull/13285), [[`3129b2c035`](https://github.com/nodejs/node/commit/3129b2c035)] [#13982](https://github.com/nodejs/node/pull/13982)
    * `querystring`: [[`9788e96836`](https://github.com/nodejs/node/commit/9788e96836)] [#15565](https://github.com/nodejs/node/pull/15565)
    * `readline`: [[`7f3f72c19b`](https://github.com/nodejs/node/commit/7f3f72c19b)] [#11390](https://github.com/nodejs/node/pull/11390)
    * `repl`: [[`aff8d358fa`](https://github.com/nodejs/node/commit/aff8d358fa)] [#11347](https://github.com/nodejs/node/pull/11347), [[`28227963fa`](https://github.com/nodejs/node/commit/28227963fa)] [#13299](https://github.com/nodejs/node/pull/13299)
    * `streams`: [[`d50a802feb`](https://github.com/nodejs/node/commit/d50a802feb)] [#13310](https://github.com/nodejs/node/pull/13310), [[`d2913384aa`](https://github.com/nodejs/node/commit/d2913384aa)] [#13291](https://github.com/nodejs/node/pull/13291), [[`6e86a6651c`](https://github.com/nodejs/node/commit/6e86a6651c)] [#16589](https://github.com/nodejs/node/pull/16589), [[`88fb359c57`](https://github.com/nodejs/node/commit/88fb359c57)] [#15042](https://github.com/nodejs/node/pull/15042), [[`db7d1339c3`](https://github.com/nodejs/node/commit/db7d1339c3)] [#15665](https://github.com/nodejs/node/pull/15665)
    * `string_decoder`: [[`eb4940e2d2`](https://github.com/nodejs/node/commit/eb4940e2d2)] [#14682](https://github.com/nodejs/node/pull/14682)
    * `timers`: [[`4d893e093a`](https://github.com/nodejs/node/commit/4d893e093a)] [#14659](https://github.com/nodejs/node/pull/14659)
    * `tls`: [[`f67aa566a6`](https://github.com/nodejs/node/commit/f67aa566a6)] [#13476](https://github.com/nodejs/node/pull/13476), [[`3ccfeb483d`](https://github.com/nodejs/node/commit/3ccfeb483d)] [#13994](https://github.com/nodejs/node/pull/13994)
    * `url`: [[`473f0eff29`](https://github.com/nodejs/node/commit/473f0eff29)] [#13963](https://github.com/nodejs/node/pull/13963)
    * `util`: [[`de4a749788`](https://github.com/nodejs/node/commit/de4a749788)] [#11301](https://github.com/nodejs/node/pull/11301), [[`1609899142`](https://github.com/nodejs/node/commit/1609899142)] [#13293](https://github.com/nodejs/node/pull/13293)
    * `v8`: [[`ef238fb485`](https://github.com/nodejs/node/commit/ef238fb485)] [#16535](https://github.com/nodejs/node/pull/16535)
    * `zlib`: [[`896eaf6820`](https://github.com/nodejs/node/commit/896eaf6820)] [#16540](https://github.com/nodejs/node/pull/16540), [[`74891412f1`](https://github.com/nodejs/node/commit/74891412f1)] [#15618](https://github.com/nodejs/node/pull/15618)

* **Child Processes**
  * Errors are emitted on process nextTick. [[`f2b01cba7b`](https://github.com/nodejs/node/commit/f2b01cba7b)] [#4670](https://github.com/nodejs/node/pull/4670)

* **Domains**
  * The long-deprecated `.dispose()` method has been removed [[`602fd36d95`](https://github.com/nodejs/node/commit/602fd36d95)] [#15412](https://github.com/nodejs/node/pull/15412)

* **fs**
  * The `fs.ReadStream` and `fs.WriteStream` classes now use `destroy()`. [[`e5c290bed9`](https://github.com/nodejs/node/commit/e5c290bed9)] [#15407](https://github.com/nodejs/node/pull/15407)
  * `fs` module callbacks are now invoked with an undefined context. [[`2249234fee`](https://github.com/nodejs/node/commit/2249234fee)] [#14645](https://github.com/nodejs/node/pull/14645)

* **HTTP/1**
  * A 400 Bad Request response will now be sent when parsing fails. [[`f2f391e575`](https://github.com/nodejs/node/commit/f2f391e575)] [#15324](https://github.com/nodejs/node/pull/15324)
  * Socket timeout will be set when the socket connects. [[`10be20a0e8`](https://github.com/nodejs/node/commit/10be20a0e8)] [#8895](https://github.com/nodejs/node/pull/8895)
  * A bug causing the request `'error'` event to fire twice was fixed. [[`620ba41694`](https://github.com/nodejs/node/commit/620ba41694)] [#14659](https://github.com/nodejs/node/pull/14659)
  * HTTP clients may now use generic `Duplex` streams in addition to `net.Socket`. [[`3e25e4d00f`](https://github.com/nodejs/node/commit/3e25e4d00f)] [#16267](https://github.com/nodejs/node/pull/16267)

* **Intl**
  * The deprecated `Intl.v8BreakIterator` has been removed. [[`668ad44922`](https://github.com/nodejs/node/commit/668ad44922)] [#15238](https://github.com/nodejs/node/pull/15238)

* **OS**
  * The `os.EOL` property is now read-only [[`f6caeb9526`](https://github.com/nodejs/node/commit/f6caeb9526)] [#14622](https://github.com/nodejs/node/pull/14622)

* **Timers**
  * `setTimeout()` will emit a warning if the timeout is larger that the maximum 32-bit unsigned integer. [[`ce3586da31`](https://github.com/nodejs/node/commit/ce3586da31)] [#15627](https://github.com/nodejs/node/pull/15627)

### Commits

#### Semver-Major

* [[`de4a749788`](https://github.com/nodejs/node/commit/de4a749788)] - **(SEMVER-MAJOR)** internal/util: use internal/errors.js (Sebastian Van Sande) [#11301](https://github.com/nodejs/node/pull/11301)
* [[`db2e093e05`](https://github.com/nodejs/node/commit/db2e093e05)] - **(SEMVER-MAJOR)** **assert**: handle enumerable symbol keys (Ruben Bridgewater) [#15169](https://github.com/nodejs/node/pull/15169)
* [[`b0d3bec95c`](https://github.com/nodejs/node/commit/b0d3bec95c)] - **(SEMVER-MAJOR)** **assert**: use Same-value equality in deepStrictEqual (Ruben Bridgewater) [#15398](https://github.com/nodejs/node/pull/15398)
* [[`e13d1df89b`](https://github.com/nodejs/node/commit/e13d1df89b)] - **(SEMVER-MAJOR)** **assert**: support custom errors (geek) [#15304](https://github.com/nodejs/node/pull/15304)
* [[`ea2e6363f2`](https://github.com/nodejs/node/commit/ea2e6363f2)] - **(SEMVER-MAJOR)** **assert**: use SameValueZero in deepStrictEqual (Ruben Bridgewater) [#15036](https://github.com/nodejs/node/pull/15036)
* [[`c53db1e8e9`](https://github.com/nodejs/node/commit/c53db1e8e9)] - **(SEMVER-MAJOR)** **assert**: show thrown message in doesNotThrow() (Ruslan Bekenev) [#12167](https://github.com/nodejs/node/pull/12167)
* [[`fc463639fa`](https://github.com/nodejs/node/commit/fc463639fa)] - **(SEMVER-MAJOR)** **assert**: fix assert.fail with zero arguments (Ruben Bridgewater) [#13974](https://github.com/nodejs/node/pull/13974)
* [[`07d71c94ef`](https://github.com/nodejs/node/commit/07d71c94ef)] - **(SEMVER-MAJOR)** **async_hooks**: enable runtime checks by default (Andreas Madsen) [#16318](https://github.com/nodejs/node/pull/16318)
* [[`d731369b1d`](https://github.com/nodejs/node/commit/d731369b1d)] - **(SEMVER-MAJOR)** **async_hooks**: remove deprecated APIs (Anna Henningsen) [#14414](https://github.com/nodejs/node/pull/14414)
* [[`97c43940c8`](https://github.com/nodejs/node/commit/97c43940c8)] - **(SEMVER-MAJOR)** **benchmark**: cover more nextTick() code (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`e79a61cf80`](https://github.com/nodejs/node/commit/e79a61cf80)] - **(SEMVER-MAJOR)** **buffer**: buffer.transcode to use internal/errors (Weijia Wang) [#16352](https://github.com/nodejs/node/pull/16352)
* [[`9e0f771224`](https://github.com/nodejs/node/commit/9e0f771224)] - **(SEMVER-MAJOR)** **buffer**: improve error messages (Weijia Wang) [#14975](https://github.com/nodejs/node/pull/14975)
* [[`70832bc353`](https://github.com/nodejs/node/commit/70832bc353)] - **(SEMVER-MAJOR)** **build**: add V8 embedder version string (Michaël Zasso) [#15785](https://github.com/nodejs/node/pull/15785)
* [[`c5eb5bfc2e`](https://github.com/nodejs/node/commit/c5eb5bfc2e)] - **(SEMVER-MAJOR)** **build**: enable runtime linking (jBarz) [#15286](https://github.com/nodejs/node/pull/15286)
* [[`2062a69879`](https://github.com/nodejs/node/commit/2062a69879)] - **(SEMVER-MAJOR)** **build**: stop support building addons with VS 2013 (Michaël Zasso) [#14764](https://github.com/nodejs/node/pull/14764)
* [[`f2b01cba7b`](https://github.com/nodejs/node/commit/f2b01cba7b)] - **(SEMVER-MAJOR)** **child_process**: defer error to next tick (Tristian Flanagan) [#4670](https://github.com/nodejs/node/pull/4670)
* [[`fe730d34ce`](https://github.com/nodejs/node/commit/fe730d34ce)] - **(SEMVER-MAJOR)** **child_process**: use internal/errors (Tobias Nießen) [#14009](https://github.com/nodejs/node/pull/14009)
* [[`448c4c62d2`](https://github.com/nodejs/node/commit/448c4c62d2)] - **(SEMVER-MAJOR)** **child_process**: do not extend result for *Sync() (Brian White) [#13601](https://github.com/nodejs/node/pull/13601)
* [[`1fcb76e8f2`](https://github.com/nodejs/node/commit/1fcb76e8f2)] - **(SEMVER-MAJOR)** **cluster**: remove deprecated property (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`4da8b99a74`](https://github.com/nodejs/node/commit/4da8b99a74)] - **(SEMVER-MAJOR)** **console**: coerce label to string in console.time() (James M Snell) [#14643](https://github.com/nodejs/node/pull/14643)
* [[`ee76f3153b`](https://github.com/nodejs/node/commit/ee76f3153b)] - **(SEMVER-MAJOR)** **crypto**: migrate setFipsCrypto to internal/errors (James M Snell) [#16428](https://github.com/nodejs/node/pull/16428)
* [[`df8c6c3651`](https://github.com/nodejs/node/commit/df8c6c3651)] - **(SEMVER-MAJOR)** **crypto**: use CHECK instead in getSSLCiphers (James M Snell) [#16453](https://github.com/nodejs/node/pull/16453)
* [[`0a03e350fb`](https://github.com/nodejs/node/commit/0a03e350fb)] - **(SEMVER-MAJOR)** **crypto**: migrate crypto.randomBytes to internal/errors (James M Snell) [#16454](https://github.com/nodejs/node/pull/16454)
* [[`eeada6ca63`](https://github.com/nodejs/node/commit/eeada6ca63)] - **(SEMVER-MAJOR)** **crypto**: migrate timingSafeEqual to internal/errors (James M Snell) [#16448](https://github.com/nodejs/node/pull/16448)
* [[`a78327f48b`](https://github.com/nodejs/node/commit/a78327f48b)] - **(SEMVER-MAJOR)** **crypto**: migrate setEngine to internal/errors (James M Snell) [#16429](https://github.com/nodejs/node/pull/16429)
* [[`b8bc652869`](https://github.com/nodejs/node/commit/b8bc652869)] - **(SEMVER-MAJOR)** **crypto**: migrate crypto sign to internal/errors (James M Snell) [#15757](https://github.com/nodejs/node/pull/15757)
* [[`7124b466d9`](https://github.com/nodejs/node/commit/7124b466d9)] - **(SEMVER-MAJOR)** **crypto**: refactor argument validation for pbkdf2 (James M Snell) [#15746](https://github.com/nodejs/node/pull/15746)
* [[`3ddc88b5c2`](https://github.com/nodejs/node/commit/3ddc88b5c2)] - **(SEMVER-MAJOR)** **crypto**: migrate Certificate to internal/errors (James M Snell) [#15756](https://github.com/nodejs/node/pull/15756)
* [[`c75f87cc4c`](https://github.com/nodejs/node/commit/c75f87cc4c)] - **(SEMVER-MAJOR)** **crypto**: refactor the crypto module (James M Snell) [#15231](https://github.com/nodejs/node/pull/15231)
* [[`484bfa2e37`](https://github.com/nodejs/node/commit/484bfa2e37)] - **(SEMVER-MAJOR)** **crypto**: accept decimal Number in randomBytes (Benjamin Gruenbaum) [#15130](https://github.com/nodejs/node/pull/15130)
* [[`c39caa997c`](https://github.com/nodejs/node/commit/c39caa997c)] - **(SEMVER-MAJOR)** **deps**: backport 0f1dfae from V8 upstream (Tobias Tebbi) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`2780f01392`](https://github.com/nodejs/node/commit/2780f01392)] - **(SEMVER-MAJOR)** **deps**: backport b096c44 from upstream V8 (Michaël Zasso) [#15785](https://github.com/nodejs/node/pull/15785)
* [[`3d1b3df948`](https://github.com/nodejs/node/commit/3d1b3df948)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.2.414.32 (Michaël Zasso) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`acb9b8f73c`](https://github.com/nodejs/node/commit/acb9b8f73c)] - **(SEMVER-MAJOR)** **deps**: backport b096c44 from upstream V8 (Michaël Zasso) [#15785](https://github.com/nodejs/node/pull/15785)
* [[`d82e1075db`](https://github.com/nodejs/node/commit/d82e1075db)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.1.534.36 (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`0a66b223e1`](https://github.com/nodejs/node/commit/0a66b223e1)] - **(SEMVER-MAJOR)** **deps**: update V8 to 6.0.286.52 (Myles Borins) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`2db2857c72`](https://github.com/nodejs/node/commit/2db2857c72)] - **(SEMVER-MAJOR)** **deps**: cherry-pick 6d38f89 from upstream V8 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`bc8e4878c0`](https://github.com/nodejs/node/commit/bc8e4878c0)] - **(SEMVER-MAJOR)** **deps**: add missing include to V8 i18n.cc (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`9b4a891ca2`](https://github.com/nodejs/node/commit/9b4a891ca2)] - **(SEMVER-MAJOR)** **deps**: run memory hungry V8 test in exclusive mode (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`3dc8c3bed4`](https://github.com/nodejs/node/commit/3dc8c3bed4)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.9.211.32 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`1a452f1928`](https://github.com/nodejs/node/commit/1a452f1928)] - **(SEMVER-MAJOR)** **dgram,process,util**: refactor Error to TypeError (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`758a17f1d5`](https://github.com/nodejs/node/commit/758a17f1d5)] - **(SEMVER-MAJOR)** **dns**: return TypeError on invalid resolve() input (Rich Trott) [#13090](https://github.com/nodejs/node/pull/13090)
* [[`1789dcfc87`](https://github.com/nodejs/node/commit/1789dcfc87)] - **(SEMVER-MAJOR)** **doc**: add missing changelogs to assert docs (Ruben Bridgewater) [#15036](https://github.com/nodejs/node/pull/15036)
* [[`8ca9338655`](https://github.com/nodejs/node/commit/8ca9338655)] - **(SEMVER-MAJOR)** **doc**: document missing error types (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`3fab9f2cd7`](https://github.com/nodejs/node/commit/3fab9f2cd7)] - **(SEMVER-MAJOR)** **doc**: EOL deprecated API and update notes (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`602fd36d95`](https://github.com/nodejs/node/commit/602fd36d95)] - **(SEMVER-MAJOR)** **domain**: remove `.dispose()` (Anna Henningsen) [#15412](https://github.com/nodejs/node/pull/15412)
* [[`219932a9f7`](https://github.com/nodejs/node/commit/219932a9f7)] - **(SEMVER-MAJOR)** **errors**: convert 'fs' (matzavinos) [#15043](https://github.com/nodejs/node/pull/15043)
* [[`11a2ca29ba`](https://github.com/nodejs/node/commit/11a2ca29ba)] - **(SEMVER-MAJOR)** **errors**: migrate _http_outgoing (Weijia Wang) [#14735](https://github.com/nodejs/node/pull/14735)
* [[`9cb390d899`](https://github.com/nodejs/node/commit/9cb390d899)] - **(SEMVER-MAJOR)** **errors**: migrate dns to use internal/errors (Weijia Wang) [#14212](https://github.com/nodejs/node/pull/14212)
* [[`a03d8cee1f`](https://github.com/nodejs/node/commit/a03d8cee1f)] - **(SEMVER-MAJOR)** **errors**: migrate socket_list to internal/errors (Bougarfaoui El houcine) [#11356](https://github.com/nodejs/node/pull/11356)
* [[`f67aa566a6`](https://github.com/nodejs/node/commit/f67aa566a6)] - **(SEMVER-MAJOR)** **errors**: migrate tls_wrap to use internal/errors (Bidisha Pyne) [#13476](https://github.com/nodejs/node/pull/13476)
* [[`b61cab2234`](https://github.com/nodejs/node/commit/b61cab2234)] - **(SEMVER-MAJOR)** **errors**: port internal/fs errors to internal/errors (Gunar C. Gessner) [#11317](https://github.com/nodejs/node/pull/11317)
* [[`1698c8e165`](https://github.com/nodejs/node/commit/1698c8e165)] - **(SEMVER-MAJOR)** **errors**: fix and improve error types (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`3e178848a5`](https://github.com/nodejs/node/commit/3e178848a5)] - **(SEMVER-MAJOR)** **errors**: improve ERR_INVALID_ARG_TYPE (Ruben Bridgewater) [#13730](https://github.com/nodejs/node/pull/13730)
* [[`0ecdf29340`](https://github.com/nodejs/node/commit/0ecdf29340)] - **(SEMVER-MAJOR)** **errors**: migrate lib/console (mskec) [#11340](https://github.com/nodejs/node/pull/11340)
* [[`7f3f72c19b`](https://github.com/nodejs/node/commit/7f3f72c19b)] - **(SEMVER-MAJOR)** **errors, readline**: migrate to use internal/errors.js (Scott McKenzie) [#11390](https://github.com/nodejs/node/pull/11390)
* [[`aff8d358fa`](https://github.com/nodejs/node/commit/aff8d358fa)] - **(SEMVER-MAJOR)** **errors, repl**: migrate to use internal/errors.js (Dan Homola) [#11347](https://github.com/nodejs/node/pull/11347)
* [[`dbfe8c4ea2`](https://github.com/nodejs/node/commit/dbfe8c4ea2)] - **(SEMVER-MAJOR)** **errors,buffer**: port errors to internal/errors (starkwang) [#13976](https://github.com/nodejs/node/pull/13976)
* [[`a9f798ebcc`](https://github.com/nodejs/node/commit/a9f798ebcc)] - **(SEMVER-MAJOR)** **errors,http_server**: migrate to use internal/errors.js (Bidisha Pyne) [#13301](https://github.com/nodejs/node/pull/13301)
* [[`a0f7284346`](https://github.com/nodejs/node/commit/a0f7284346)] - **(SEMVER-MAJOR)** **errors,process**: fix error message of hrtime() (Tobias Nießen) [#13739](https://github.com/nodejs/node/pull/13739)
* [[`062071a9c3`](https://github.com/nodejs/node/commit/062071a9c3)] - **(SEMVER-MAJOR)** **errors,process**: migrate to use internal/errors.js (sreepurnajasti) [#13285](https://github.com/nodejs/node/pull/13285)
* [[`28227963fa`](https://github.com/nodejs/node/commit/28227963fa)] - **(SEMVER-MAJOR)** **errors,repl**: migrate to use internal/errors.js (sreepurnajasti) [#13299](https://github.com/nodejs/node/pull/13299)
* [[`d50a802feb`](https://github.com/nodejs/node/commit/d50a802feb)] - **(SEMVER-MAJOR)** **errors,stream-transform**: migrate to use internal/errors.js (sreepurnajasti) [#13310](https://github.com/nodejs/node/pull/13310)
* [[`d2913384aa`](https://github.com/nodejs/node/commit/d2913384aa)] - **(SEMVER-MAJOR)** **errors,stream_wrap**: use internal/errors.js (LAKSHMI SWETHA GOPIREDDY) [#13291](https://github.com/nodejs/node/pull/13291)
* [[`473f0eff29`](https://github.com/nodejs/node/commit/473f0eff29)] - **(SEMVER-MAJOR)** **errors,url**: port url errors to internal/errors (starkwang) [#13963](https://github.com/nodejs/node/pull/13963)
* [[`1609899142`](https://github.com/nodejs/node/commit/1609899142)] - **(SEMVER-MAJOR)** **errors,util**: migrate to use internal/errors.js (Bidisha Pyne) [#13293](https://github.com/nodejs/node/pull/13293)
* [[`e5ad5456a2`](https://github.com/nodejs/node/commit/e5ad5456a2)] - **(SEMVER-MAJOR)** **events**: migrate to internal/errors (James M Snell) [#15623](https://github.com/nodejs/node/pull/15623)
* [[`e5c290bed9`](https://github.com/nodejs/node/commit/e5c290bed9)] - **(SEMVER-MAJOR)** **fs**: refactor close to use destroy (Matteo Collina) [#15407](https://github.com/nodejs/node/pull/15407)
* [[`2249234fee`](https://github.com/nodejs/node/commit/2249234fee)] - **(SEMVER-MAJOR)** **fs**: invoke callbacks with undefined context (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`f2f391e575`](https://github.com/nodejs/node/commit/f2f391e575)] - **(SEMVER-MAJOR)** **http**: send 400 bad request on parse error (mog422) [#15324](https://github.com/nodejs/node/pull/15324)
* [[`10be20a0e8`](https://github.com/nodejs/node/commit/10be20a0e8)] - **(SEMVER-MAJOR)** **http**: set socket timeout when socket connects (Luigi Pinca) [#8895](https://github.com/nodejs/node/pull/8895)
* [[`620ba41694`](https://github.com/nodejs/node/commit/620ba41694)] - **(SEMVER-MAJOR)** **http**: don't double-fire the req error event (fengmk2) [#14659](https://github.com/nodejs/node/pull/14659)
* [[`156549d8ff`](https://github.com/nodejs/node/commit/156549d8ff)] - **(SEMVER-MAJOR)** **http**: disable OutgoingMessage pipe method (Roee Kasher) [#14358](https://github.com/nodejs/node/pull/14358)
* [[`2fa2a60721`](https://github.com/nodejs/node/commit/2fa2a60721)] - **(SEMVER-MAJOR)** **http**: simplify if statement (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`80c9ef0b6b`](https://github.com/nodejs/node/commit/80c9ef0b6b)] - **(SEMVER-MAJOR)** **http**: edit _storeHeader to check for Trailer header (Artur G Vieira) [#12990](https://github.com/nodejs/node/pull/12990)
* [[`f55ee6e24a`](https://github.com/nodejs/node/commit/f55ee6e24a)] - **(SEMVER-MAJOR)** **http2**: make --expose-http2 flag a non-op (James M Snell) [#15535](https://github.com/nodejs/node/pull/15535)
* [[`bdfbce9241`](https://github.com/nodejs/node/commit/bdfbce9241)] - **(SEMVER-MAJOR)** **http_client, errors**: migrate to internal/errors (Weijia Wang) [#14423](https://github.com/nodejs/node/pull/14423)
* [[`4843c2f415`](https://github.com/nodejs/node/commit/4843c2f415)] - **(SEMVER-MAJOR)** **https**: convert to using internal/errors (Rami Moshe) [#15603](https://github.com/nodejs/node/pull/15603)
* [[`4cf56ad6f2`](https://github.com/nodejs/node/commit/4cf56ad6f2)] - **(SEMVER-MAJOR)** **inspector**: migrate to internal/errors (James M Snell) [#15619](https://github.com/nodejs/node/pull/15619)
* [[`668ad44922`](https://github.com/nodejs/node/commit/668ad44922)] - **(SEMVER-MAJOR)** **intl**: unexpose Intl.v8BreakIterator (Ben Noordhuis) [#15238](https://github.com/nodejs/node/pull/15238)
* [[`c885ea727d`](https://github.com/nodejs/node/commit/c885ea727d)] - **(SEMVER-MAJOR)** **lib**: deprecate fd usage for fs.truncate(Sync) (r1cebank) [#15990](https://github.com/nodejs/node/pull/15990)
* [[`095357e26e`](https://github.com/nodejs/node/commit/095357e26e)] - **(SEMVER-MAJOR)** **lib**: tweak use of internal/errors (Ruben Bridgewater) [#13829](https://github.com/nodejs/node/pull/13829)
* [[`8520e6f280`](https://github.com/nodejs/node/commit/8520e6f280)] - **(SEMVER-MAJOR)** **lib**: fix urlObject parameter name in url.format (Eduardo Leggiero) [#14031](https://github.com/nodejs/node/pull/14031)
* [[`9836cf5717`](https://github.com/nodejs/node/commit/9836cf5717)] - **(SEMVER-MAJOR)** **lib**: lazy instantiation of fs.Stats dates (Daniel Pihlstrom) [#12818](https://github.com/nodejs/node/pull/12818)
* [[`234353a1b8`](https://github.com/nodejs/node/commit/234353a1b8)] - **(SEMVER-MAJOR)** **lib,src**: refactor buffer out of range index (larissayvette) [#11296](https://github.com/nodejs/node/pull/11296)
* [[`9d7574eef5`](https://github.com/nodejs/node/commit/9d7574eef5)] - **(SEMVER-MAJOR)** **module**: deprecate Module._debug (Jackson Tian) [#13948](https://github.com/nodejs/node/pull/13948)
* [[`a517466aa7`](https://github.com/nodejs/node/commit/a517466aa7)] - **(SEMVER-MAJOR)** **module**: mark DEP0019 as EOL and remove compat code (Roman Reiss) [#3384](https://github.com/nodejs/node/pull/3384)
* [[`7f55349079`](https://github.com/nodejs/node/commit/7f55349079)] - **(SEMVER-MAJOR)** **net**: convert to using internal/errors (matzavinos) [#14782](https://github.com/nodejs/node/pull/14782)
* [[`b24e269a48`](https://github.com/nodejs/node/commit/b24e269a48)] - **(SEMVER-MAJOR)** **net**: multiple listen() events fail silently (Eduard Bondarenko) [#13149](https://github.com/nodejs/node/pull/13149)
* [[`75a19fb379`](https://github.com/nodejs/node/commit/75a19fb379)] - **(SEMVER-MAJOR)** **net,child_process**: improve naming in internal code (Anna Henningsen) [#14449](https://github.com/nodejs/node/pull/14449)
* [[`f6caeb9526`](https://github.com/nodejs/node/commit/f6caeb9526)] - **(SEMVER-MAJOR)** **os**: make EOL configurable and read only (XadillaX) [#14622](https://github.com/nodejs/node/pull/14622)
* [[`1f8d527e94`](https://github.com/nodejs/node/commit/1f8d527e94)] - **(SEMVER-MAJOR)** **path**: deprecate internal _makeLong, replace (James M Snell) [#14956](https://github.com/nodejs/node/pull/14956)
* [[`dcfbbacba8`](https://github.com/nodejs/node/commit/dcfbbacba8)] - **(SEMVER-MAJOR)** **path**: use internal/errors.js (Sebastian Van Sande) [#11319](https://github.com/nodejs/node/pull/11319)
* [[`a253704446`](https://github.com/nodejs/node/commit/a253704446)] - **(SEMVER-MAJOR)** **process**: make `this` value consistent (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`43e105f645`](https://github.com/nodejs/node/commit/43e105f645)] - **(SEMVER-MAJOR)** **process**: improve hrtime() error message (Rich Trott) [#14324](https://github.com/nodejs/node/pull/14324)
* [[`3129b2c035`](https://github.com/nodejs/node/commit/3129b2c035)] - **(SEMVER-MAJOR)** **process**: use internal/errors in internalNextTick (Tobias Nießen) [#13982](https://github.com/nodejs/node/pull/13982)
* [[`9788e96836`](https://github.com/nodejs/node/commit/9788e96836)] - **(SEMVER-MAJOR)** **querystring**: convert to using internal/errors (Rami Moshe) [#15565](https://github.com/nodejs/node/pull/15565)
* [[`7a29f44071`](https://github.com/nodejs/node/commit/7a29f44071)] - **(SEMVER-MAJOR)** **repl**: deprecate REPLServer.prototype.memory (Lance Ball) [#16242](https://github.com/nodejs/node/pull/16242)
* [[`e416b3ee36`](https://github.com/nodejs/node/commit/e416b3ee36)] - **(SEMVER-MAJOR)** **repl**: deprecate turnOffEditorMode (Lance Ball) [#15136](https://github.com/nodejs/node/pull/15136)
* [[`ed1ba4580b`](https://github.com/nodejs/node/commit/ed1ba4580b)] - **(SEMVER-MAJOR)** **repl**: remove REPLServer.createContext side effects (Lance Ball) [#14331](https://github.com/nodejs/node/pull/14331)
* [[`2ca9f94e33`](https://github.com/nodejs/node/commit/2ca9f94e33)] - **(SEMVER-MAJOR)** **repl**: make REPLServer.bufferedCommand private (Lance Ball) [#13687](https://github.com/nodejs/node/pull/13687)
* [[`3d9e7bb1d4`](https://github.com/nodejs/node/commit/3d9e7bb1d4)] - **(SEMVER-MAJOR)** **repl**: remove unused function convertToContext (Nikolai Vavilov) [#13434](https://github.com/nodejs/node/pull/13434)
* [[`33b2b10b68`](https://github.com/nodejs/node/commit/33b2b10b68)] - **(SEMVER-MAJOR)** **src**: fix rename of entry frame in v8abbr.h (geek) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`8f9e738a69`](https://github.com/nodejs/node/commit/8f9e738a69)] - **(SEMVER-MAJOR)** **src**: update ustack offset identifiers (geek) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`205a4d2331`](https://github.com/nodejs/node/commit/205a4d2331)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 59 (Michaël Zasso) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`ddc16e505b`](https://github.com/nodejs/node/commit/ddc16e505b)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 58 (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`5f22375922`](https://github.com/nodejs/node/commit/5f22375922)] - **(SEMVER-MAJOR)** **src**: add support to pass flags to dlopen (Ezequiel Garcia) [#12794](https://github.com/nodejs/node/pull/12794)
* [[`784c6d40f8`](https://github.com/nodejs/node/commit/784c6d40f8)] - **(SEMVER-MAJOR)** **src**: use proper errors as coming from StringBytes (Anna Henningsen) [#14579](https://github.com/nodejs/node/pull/14579)
* [[`80ebb4282d`](https://github.com/nodejs/node/commit/80ebb4282d)] - **(SEMVER-MAJOR)** **src**: adjust windows abort behavior (Jared Kantrowitz) [#13947](https://github.com/nodejs/node/pull/13947)
* [[`db476fc8b5`](https://github.com/nodejs/node/commit/db476fc8b5)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 57 (Myles Borins) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`24709b2e4a`](https://github.com/nodejs/node/commit/24709b2e4a)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 56 (Michaël Zasso) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`6e86a6651c`](https://github.com/nodejs/node/commit/6e86a6651c)] - **(SEMVER-MAJOR)** **stream**: complete migration to internal/errors (Matteo Collina) [#16589](https://github.com/nodejs/node/pull/16589)
* [[`88fb359c57`](https://github.com/nodejs/node/commit/88fb359c57)] - **(SEMVER-MAJOR)** **stream**: migrate _stream_readable use error codes (Ben Halverson) [#15042](https://github.com/nodejs/node/pull/15042)
* [[`db7d1339c3`](https://github.com/nodejs/node/commit/db7d1339c3)] - **(SEMVER-MAJOR)** **stream**: migrate to internal/errors (Ruben Bridgewater) [#15665](https://github.com/nodejs/node/pull/15665)
* [[`4536128e7c`](https://github.com/nodejs/node/commit/4536128e7c)] - **(SEMVER-MAJOR)** **stream**: remove dead code (Ruben Bridgewater) [#15665](https://github.com/nodejs/node/pull/15665)
* [[`eb4940e2d2`](https://github.com/nodejs/node/commit/eb4940e2d2)] - **(SEMVER-MAJOR)** **string_decoder**: Migrate to use internal/errors (Weijia Wang) [#14682](https://github.com/nodejs/node/pull/14682)
* [[`a7487c92e2`](https://github.com/nodejs/node/commit/a7487c92e2)] - **(SEMVER-MAJOR)** **test**: fix message test after V8 upgrade (Michaël Zasso) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`fca7e49e44`](https://github.com/nodejs/node/commit/fca7e49e44)] - **(SEMVER-MAJOR)** **test**: adjust windows failed alloc test to V8 6.2 (Bartosz Sosnowski) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`95c8df18f1`](https://github.com/nodejs/node/commit/95c8df18f1)] - **(SEMVER-MAJOR)** **test**: add test to verify ErrnoException path (Daniel Bevenius) [#13958](https://github.com/nodejs/node/pull/13958)
* [[`0d3ef5b0f8`](https://github.com/nodejs/node/commit/0d3ef5b0f8)] - **(SEMVER-MAJOR)** **test**: check `this` value for `nextTick()` (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`c6126b1308`](https://github.com/nodejs/node/commit/c6126b1308)] - **(SEMVER-MAJOR)** **test**: refactor test-fs-stat (Rich Trott) [#14645](https://github.com/nodejs/node/pull/14645)
* [[`eaaec57332`](https://github.com/nodejs/node/commit/eaaec57332)] - **(SEMVER-MAJOR)** **test**: use worker.exitedAfterDisconnect consistently (James M Snell) [#13702](https://github.com/nodejs/node/pull/13702)
* [[`839faae45a`](https://github.com/nodejs/node/commit/839faae45a)] - **(SEMVER-MAJOR)** **timers**: cleanup extraneous property on Immediates (Jeremiah Senkpiel) [#16355](https://github.com/nodejs/node/pull/16355)
* [[`ce3586da31`](https://github.com/nodejs/node/commit/ce3586da31)] - **(SEMVER-MAJOR)** **timers**: warn on overflowed timeout duration (Jeremiah Senkpiel) [#15627](https://github.com/nodejs/node/pull/15627)
* [[`11f7dcf91e`](https://github.com/nodejs/node/commit/11f7dcf91e)] - **(SEMVER-MAJOR)** **timers**: do not expose .unref()._handle._list (Jeremiah Senkpiel) [#8422](https://github.com/nodejs/node/pull/8422)
* [[`4d893e093a`](https://github.com/nodejs/node/commit/4d893e093a)] - **(SEMVER-MAJOR)** **timers**: Migrate to use internal/errors (Weijia Wang) [#14659](https://github.com/nodejs/node/pull/14659)
* [[`468110b327`](https://github.com/nodejs/node/commit/468110b327)] - **(SEMVER-MAJOR)** **tls**: deprecate parseCertString & move to internal (XadillaX) [#14249](https://github.com/nodejs/node/pull/14249)
* [[`0f7c06eb2d`](https://github.com/nodejs/node/commit/0f7c06eb2d)] - **(SEMVER-MAJOR)** **tls**: fix object prototype type confusion (Ben Noordhuis) [#14447](https://github.com/nodejs/node/pull/14447)
* [[`a7dccd040d`](https://github.com/nodejs/node/commit/a7dccd040d)] - **(SEMVER-MAJOR)** **tls**: type checking for `key`, `cert` and `ca` options (Jimmy Cann) [#14807](https://github.com/nodejs/node/pull/14807)
* [[`3ccfeb483d`](https://github.com/nodejs/node/commit/3ccfeb483d)] - **(SEMVER-MAJOR)** **tls**: migrate tls.js to use internal/errors.js (Michael Dawson) [#13994](https://github.com/nodejs/node/pull/13994)
* [[`c88ba036b4`](https://github.com/nodejs/node/commit/c88ba036b4)] - **(SEMVER-MAJOR)** **url**: ensure search property is consistently null vs empty (Justin Beckwith) [#13606](https://github.com/nodejs/node/pull/13606)
* [[`b1c8f15c5f`](https://github.com/nodejs/node/commit/b1c8f15c5f)] - **(SEMVER-MAJOR)** **util**: use constructor name (Ruben Bridgewater) [#14886](https://github.com/nodejs/node/pull/14886)
* [[`3b0e800f18`](https://github.com/nodejs/node/commit/3b0e800f18)] - **(SEMVER-MAJOR)** **util**: make util.debuglog() consistent with doc (Vse Mozhet Byt) [#13841](https://github.com/nodejs/node/pull/13841)
* [[`58831b2f24`](https://github.com/nodejs/node/commit/58831b2f24)] - **(SEMVER-MAJOR)** **uv**: improvements to process.binding('uv') (James M Snell) [#14933](https://github.com/nodejs/node/pull/14933)
* [[`ef238fb485`](https://github.com/nodejs/node/commit/ef238fb485)] - **(SEMVER-MAJOR)** **v8**: migrate setFlagsFromString to internal/errors (James M Snell) [#16535](https://github.com/nodejs/node/pull/16535)
* [[`b3e5c4621d`](https://github.com/nodejs/node/commit/b3e5c4621d)] - **(SEMVER-MAJOR)** **v8**: add new to the throw statement (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`88e55fe5e0`](https://github.com/nodejs/node/commit/88e55fe5e0)] - **(SEMVER-MAJOR)** **vm**: deprecate vm.runInDebugContext (Josh Gavant) [#12815](https://github.com/nodejs/node/pull/12815)
* [[`896eaf6820`](https://github.com/nodejs/node/commit/896eaf6820)] - **(SEMVER-MAJOR)** **zlib**: finish migrating to internal/errors (James M Snell) [#16540](https://github.com/nodejs/node/pull/16540)
* [[`74891412f1`](https://github.com/nodejs/node/commit/74891412f1)] - **(SEMVER-MAJOR)** **zlib**: migrate to internal/errors (James M Snell) [#15618](https://github.com/nodejs/node/pull/15618)

#### Semver-Minor

* [[`3e25e4d00f`](https://github.com/nodejs/node/commit/3e25e4d00f)] - **(SEMVER-MINOR)** **http**: support generic `Duplex` streams (Anna Henningsen) [#16267](https://github.com/nodejs/node/pull/16267)
* [[`af3aa682ac`](https://github.com/nodejs/node/commit/af3aa682ac)] - **(SEMVER-MINOR)** **util**: add callbackify (Refael Ackermann) [#12712](https://github.com/nodejs/node/pull/12712)
* [[`36732084db`](https://github.com/nodejs/node/commit/36732084db)] - **(SEMVER-MINOR)** **util,assert**: expose util.isDeepStrictEqual() (Rich Trott) [#16084](https://github.com/nodejs/node/pull/16084)

#### Semver-Patch

* [[`6e86a70da2`](https://github.com/nodejs/node/commit/6e86a70da2)] - **assert**: replace many if's with if-else statement (kuroljov) [#14043](https://github.com/nodejs/node/pull/14043)
* [[`f8063d51d7`](https://github.com/nodejs/node/commit/f8063d51d7)] - **benchmark**: fix punycode test for --without-intl (Timothy Gu) [#16251](https://github.com/nodejs/node/pull/16251)
* [[`095c0de94d`](https://github.com/nodejs/node/commit/095c0de94d)] - **benchmark,lib,test**: use braces for multiline block (Rich Trott) [#13828](https://github.com/nodejs/node/pull/13828)
* [[`8172f4547e`](https://github.com/nodejs/node/commit/8172f4547e)] - **buffer**: move setupBufferJS to internal (Bryan English) [#16391](https://github.com/nodejs/node/pull/16391)
* [[`355523fcfb`](https://github.com/nodejs/node/commit/355523fcfb)] - **buffer**: refactor module.exports, imports (James M Snell) [#13807](https://github.com/nodejs/node/pull/13807)
* [[`e0340af455`](https://github.com/nodejs/node/commit/e0340af455)] - **buffer**: fix indentation nits (Rich Trott) [#14224](https://github.com/nodejs/node/pull/14224)
* [[`aa011a111d`](https://github.com/nodejs/node/commit/aa011a111d)] - ***Revert*** "**build**: don't add libraries when --enable-static" (Ben Noordhuis) [#14893](https://github.com/nodejs/node/pull/14893)
* [[`be63c26e8c`](https://github.com/nodejs/node/commit/be63c26e8c)] - **build**: don't add libraries when --enable-static (Daniel Bevenius) [#14837](https://github.com/nodejs/node/pull/14837)
* [[`556ebab30e`](https://github.com/nodejs/node/commit/556ebab30e)] - **child_process**: restore exec{File}Sync error props (Michaël Zasso) [#16060](https://github.com/nodejs/node/pull/16060)
* [[`9bc4f86201`](https://github.com/nodejs/node/commit/9bc4f86201)] - **crypto**: make createXYZ inlineable (Matteo Collina) [#16067](https://github.com/nodejs/node/pull/16067)
* [[`43e7e8d106`](https://github.com/nodejs/node/commit/43e7e8d106)] - **crypto**: remove useless if statement (Weijia Wang) [#15041](https://github.com/nodejs/node/pull/15041)
* [[`237067d54e`](https://github.com/nodejs/node/commit/237067d54e)] - **deps**: manually add 9.x support to npm (Myles Borins) [#16509](https://github.com/nodejs/node/pull/16509)
* [[`0ea8ff3deb`](https://github.com/nodejs/node/commit/0ea8ff3deb)] - **deps**: backport 4ca695819 from npm upstream (Myles Borins) [#16509](https://github.com/nodejs/node/pull/16509)
* [[`664512678d`](https://github.com/nodejs/node/commit/664512678d)] - ***Revert*** "**deps**: update V8 to 6.2.414.33" (Michaël Zasso) [#16513](https://github.com/nodejs/node/pull/16513)
* [[`d4033c1547`](https://github.com/nodejs/node/commit/d4033c1547)] - **deps**: update V8 to 6.2.414.33 (Michaël Zasso) [#16412](https://github.com/nodejs/node/pull/16412)
* [[`801e61ad5a`](https://github.com/nodejs/node/commit/801e61ad5a)] - **deps**: cherry-pick 37a3a15c3 from V8 upstream (Franziska Hinkelmann) [#16294](https://github.com/nodejs/node/pull/16294)
* [[`34d125f16c`](https://github.com/nodejs/node/commit/34d125f16c)] - **deps**: c-ares float, win ipv6 bad fec0 prefix (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`af171b7ba2`](https://github.com/nodejs/node/commit/af171b7ba2)] - **deps**: c-ares float, manual ares_ssize_t definition (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`13c74706ef`](https://github.com/nodejs/node/commit/13c74706ef)] - **deps**: upgrade to c-ares v1.13.0 (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`d0d1eba872`](https://github.com/nodejs/node/commit/d0d1eba872)] - **deps**: update license-builder & LICENSE for c-ares (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`a9f125449e`](https://github.com/nodejs/node/commit/a9f125449e)] - **deps**: upgrade to c-ares v1.12.0 (Rod Vagg) [#15378](https://github.com/nodejs/node/pull/15378)
* [[`8dce05fa71`](https://github.com/nodejs/node/commit/8dce05fa71)] - **deps**: backport rehash strings after deserialization (Yang Guo) [#14345](https://github.com/nodejs/node/pull/14345)
* [[`785a9e5a57`](https://github.com/nodejs/node/commit/785a9e5a57)] - **deps**: cherry-pick 6cb999b97b from V8 upstream (Igor Sheludko) [#14188](https://github.com/nodejs/node/pull/14188)
* [[`31349e2245`](https://github.com/nodejs/node/commit/31349e2245)] - **deps**: cherry-pick 3f4536894ac from V8 upstream (ochang) [#13985](https://github.com/nodejs/node/pull/13985)
* [[`0ba74dbcc6`](https://github.com/nodejs/node/commit/0ba74dbcc6)] - **deps**: backport c0f1ff2 from upstream V8 (Michaël Zasso) [#13517](https://github.com/nodejs/node/pull/13517)
* [[`7cdcca7623`](https://github.com/nodejs/node/commit/7cdcca7623)] - **deps**: cherry-pick 866ee63 from upstream V8 (Michaël Zasso) [#13630](https://github.com/nodejs/node/pull/13630)
* [[`8f907b6baf`](https://github.com/nodejs/node/commit/8f907b6baf)] - **deps**: update V8 to 5.9.211.37 (Michaël Zasso) [#13631](https://github.com/nodejs/node/pull/13631)
* [[`554fa24916`](https://github.com/nodejs/node/commit/554fa24916)] - **deps**: cherry-pick f5fad6d from upstream v8 (daniel.bevenius) [#12826](https://github.com/nodejs/node/pull/12826)
* [[`36ba9e6e0c`](https://github.com/nodejs/node/commit/36ba9e6e0c)] - **deps**: cherry-pick bfae9db from upstream v8 (Ben Noordhuis) [#12722](https://github.com/nodejs/node/pull/12722)
* [[`863d1922df`](https://github.com/nodejs/node/commit/863d1922df)] - **doc**: add link for stream.pipe() (Jon Moss) [#16593](https://github.com/nodejs/node/pull/16593)
* [[`fb477f3fa5`](https://github.com/nodejs/node/commit/fb477f3fa5)] - **doc**: add missing error codes (James M Snell) [#16450](https://github.com/nodejs/node/pull/16450)
* [[`1261b94a3f`](https://github.com/nodejs/node/commit/1261b94a3f)] - **doc**: fix unassigned deprecation code (James M Snell) [#15741](https://github.com/nodejs/node/pull/15741)
* [[`cd1b55a942`](https://github.com/nodejs/node/commit/cd1b55a942)] - **doc**: delete link to removed doc part (Vse Mozhet Byt) [#15510](https://github.com/nodejs/node/pull/15510)
* [[`a5916107dd`](https://github.com/nodejs/node/commit/a5916107dd)] - **doc**: fix wrong history entry in deepStrictEqual (hisener) [#15381](https://github.com/nodejs/node/pull/15381)
* [[`8b2c61c169`](https://github.com/nodejs/node/commit/8b2c61c169)] - **doc**: fix api docs style (Daijiro Wachi) [#13970](https://github.com/nodejs/node/pull/13970)
* [[`102e1aa4e3`](https://github.com/nodejs/node/commit/102e1aa4e3)] - **doc**: fix ordering error in errors.md (Rich Trott) [#13274](https://github.com/nodejs/node/pull/13274)
* [[`8a8a6865c0`](https://github.com/nodejs/node/commit/8a8a6865c0)] - **doc,net**: assign deprecation code (Anna Henningsen) [#14576](https://github.com/nodejs/node/pull/14576)
* [[`55d49eb3cc`](https://github.com/nodejs/node/commit/55d49eb3cc)] - **errors**: replace `.split()` with `.replace()` (Rich Trott) [#15545](https://github.com/nodejs/node/pull/15545)
* [[`cef6e1c55f`](https://github.com/nodejs/node/commit/cef6e1c55f)] - **errors**: refactor `invalidArgType()` (Rich Trott) [#15544](https://github.com/nodejs/node/pull/15544)
* [[`324aa6488f`](https://github.com/nodejs/node/commit/324aa6488f)] - **errors**: alphabetize error codes (Jon Moss) [#15083](https://github.com/nodejs/node/pull/15083)
* [[`fa73087fcf`](https://github.com/nodejs/node/commit/fa73087fcf)] - **errors**: keep error codes in alphabetical order (Weijia Wang) [#14242](https://github.com/nodejs/node/pull/14242)
* [[`873e2f270f`](https://github.com/nodejs/node/commit/873e2f270f)] - **errors**: add missing ERR_ prefix on util.callbackify error (James M Snell) [#13604](https://github.com/nodejs/node/pull/13604)
* [[`5f469446e1`](https://github.com/nodejs/node/commit/5f469446e1)] - **errors,tools**: ASCIIbetical instead of alphabetical (Refael Ackermann) [#15578](https://github.com/nodejs/node/pull/15578)
* [[`fe13e0077f`](https://github.com/nodejs/node/commit/fe13e0077f)] - **events**: onceWrapper apply directly with arguments (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`d5fb78982a`](https://github.com/nodejs/node/commit/d5fb78982a)] - **events**: use spread function param in emit (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`fd166a8759`](https://github.com/nodejs/node/commit/fd166a8759)] - **events**: return values directly in listeners (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`c8d4ff1d52`](https://github.com/nodejs/node/commit/c8d4ff1d52)] - **events**: remove unnecessary console instantiation (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`f61cc15c6a`](https://github.com/nodejs/node/commit/f61cc15c6a)] - **events**: stricter prop & variable checks for perf (Anatoli Papirovski) [#16212](https://github.com/nodejs/node/pull/16212)
* [[`5d99a9bf65`](https://github.com/nodejs/node/commit/5d99a9bf65)] - **http**: emit close as the last event in the client (Robert Nagy) [#15588](https://github.com/nodejs/node/pull/15588)
* [[`f912080bf2`](https://github.com/nodejs/node/commit/f912080bf2)] - ***Revert*** "**http2**: refactor error handling" (Rich Trott) [#15047](https://github.com/nodejs/node/pull/15047)
* [[`a6973a3811`](https://github.com/nodejs/node/commit/a6973a3811)] - ***Revert*** "**inspector**: rewrite inspector test helper" (Anna Henningsen) [#14777](https://github.com/nodejs/node/pull/14777)
* [[`2296b677fb`](https://github.com/nodejs/node/commit/2296b677fb)] - **inspector**: rewrite inspector test helper (Eugene Ostroukhov) [#14460](https://github.com/nodejs/node/pull/14460)
* [[`e6dfd59be0`](https://github.com/nodejs/node/commit/e6dfd59be0)] - **lib**: pass internalBinding more implicitly (Anna Henningsen) [#16218](https://github.com/nodejs/node/pull/16218)
* [[`a577bde917`](https://github.com/nodejs/node/commit/a577bde917)] - **lib**: fix off-by-one indentation (Rich Trott) [#14064](https://github.com/nodejs/node/pull/14064)
* [[`c474f88987`](https://github.com/nodejs/node/commit/c474f88987)] - **lib**: fix typos (Ruben Bridgewater) [#13741](https://github.com/nodejs/node/pull/13741)
* [[`ae6c7044c8`](https://github.com/nodejs/node/commit/ae6c7044c8)] - ***Revert*** "**lib**: lazy instantiation of fs.Stats dates" (Anna Henningsen) [#13256](https://github.com/nodejs/node/pull/13256)
* [[`45873d24e4`](https://github.com/nodejs/node/commit/45873d24e4)] - **module**: revert #3384 DEP0019 EOL (Myles Borins) [#16634](https://github.com/nodejs/node/pull/16634)
* [[`44256bb0aa`](https://github.com/nodejs/node/commit/44256bb0aa)] - **path**: fix incorrect use of ERR_INVALID_ARG_TYPE (Tobias Nießen) [#14011](https://github.com/nodejs/node/pull/14011)
* [[`c5f54b1fad`](https://github.com/nodejs/node/commit/c5f54b1fad)] - **repl**: remove internal frames from runtime errors (Lance Ball) [#15351](https://github.com/nodejs/node/pull/15351)
* [[`da40050b59`](https://github.com/nodejs/node/commit/da40050b59)] - **repl**: fix deprecation code (Ruben Bridgewater) [#15668](https://github.com/nodejs/node/pull/15668)
* [[`766506a2e9`](https://github.com/nodejs/node/commit/766506a2e9)] - **repl**: deprecate REPLServer.parseREPLKeyword (Lance Ball)
* [[`f0b871bada`](https://github.com/nodejs/node/commit/f0b871bada)] - **src**: remove unused warning in node_contextify (Michaël Zasso) [#16408](https://github.com/nodejs/node/pull/16408)
* [[`f1d6b04ac9`](https://github.com/nodejs/node/commit/f1d6b04ac9)] - **src**: use new V8 API in vm module (Franziska Hinkelmann) [#16293](https://github.com/nodejs/node/pull/16293)
* [[`2146c88bc7`](https://github.com/nodejs/node/commit/2146c88bc7)] - **src**: fix NewContext for --without-intl (Timothy Gu) [#16251](https://github.com/nodejs/node/pull/16251)
* [[`a84c3be075`](https://github.com/nodejs/node/commit/a84c3be075)] - **src**: unset `NODE_VERSION_IS_RELEASE` (Anna Henningsen) [#14005](https://github.com/nodejs/node/pull/14005)
* [[`1b54371c50`](https://github.com/nodejs/node/commit/1b54371c50)] - **stream**: use more explicit statements (Ruben Bridgewater) [#13863](https://github.com/nodejs/node/pull/13863)
* [[`9702ac5088`](https://github.com/nodejs/node/commit/9702ac5088)] - **test**: add test for WrapStream readStop (Ashish Kaila) [#16356](https://github.com/nodejs/node/pull/16356)
* [[`a37a0ad5f6`](https://github.com/nodejs/node/commit/a37a0ad5f6)] - **test**: add test for prop interceptors on sandbox (Michaël Zasso) [#16409](https://github.com/nodejs/node/pull/16409)
* [[`ed116dc3c6`](https://github.com/nodejs/node/commit/ed116dc3c6)] - **test**: fix test for inherited properties on vm (Franziska Hinkelmann) [#16411](https://github.com/nodejs/node/pull/16411)
* [[`438e7fdaf2`](https://github.com/nodejs/node/commit/438e7fdaf2)] - **test**: remove --harmony-sharedarraybuffer usage (Ben Smith) [#16343](https://github.com/nodejs/node/pull/16343)
* [[`cd5ee52d70`](https://github.com/nodejs/node/commit/cd5ee52d70)] - **test**: add tests for eslint rules (Teddy Katz) [#16138](https://github.com/nodejs/node/pull/16138)
* [[`16ed116203`](https://github.com/nodejs/node/commit/16ed116203)] - **test**: clean up string concat in dlopen-ping-pong (agilbert) [#15820](https://github.com/nodejs/node/pull/15820)
* [[`2e215f169a`](https://github.com/nodejs/node/commit/2e215f169a)] - **test**: fix and refactor test-http-invalid-urls (Rich Trott) [#15678](https://github.com/nodejs/node/pull/15678)
* [[`44d486500d`](https://github.com/nodejs/node/commit/44d486500d)] - **test**: increase coverage for internal/errors.js (Weijia Wang) [#15044](https://github.com/nodejs/node/pull/15044)
* [[`467385a49b`](https://github.com/nodejs/node/commit/467385a49b)] - **test**: use invalid host according to RFC2606 (Tobias Nießen) [#14863](https://github.com/nodejs/node/pull/14863)
* [[`f417add1f4`](https://github.com/nodejs/node/commit/f417add1f4)] - **test**: add test-benchmark-zlib (Rich Trott) [#14763](https://github.com/nodejs/node/pull/14763)
* [[`3566195196`](https://github.com/nodejs/node/commit/3566195196)] - **test**: replace concatenation with template literals (xeodou) [#14281](https://github.com/nodejs/node/pull/14281)
* [[`b923b9dee1`](https://github.com/nodejs/node/commit/b923b9dee1)] - **test**: replace string concat in test-child-process-constructor (mac-haojin) [#14283](https://github.com/nodejs/node/pull/14283)
* [[`2a621d4051`](https://github.com/nodejs/node/commit/2a621d4051)] - **test**: validate more properties in expectsError (Ruben Bridgewater) [#14058](https://github.com/nodejs/node/pull/14058)
* [[`5ffb5b6fce`](https://github.com/nodejs/node/commit/5ffb5b6fce)] - **test**: improve the test common documentation (Ruben Bridgewater) [#14148](https://github.com/nodejs/node/pull/14148)
* [[`1b2733f272`](https://github.com/nodejs/node/commit/1b2733f272)] - **test**: common.expectsError should be a must call (Ruben Bridgewater) [#14088](https://github.com/nodejs/node/pull/14088)
* [[`d69ecc6f51`](https://github.com/nodejs/node/commit/d69ecc6f51)] - ***Revert*** "**test**: improve test-process-kill-null for Windows" (Refael Ackermann) [#14142](https://github.com/nodejs/node/pull/14142)
* [[`d6fece1436`](https://github.com/nodejs/node/commit/d6fece1436)] - **test**: add optional throw fn to expectsError (Ruben Bridgewater) [#14089](https://github.com/nodejs/node/pull/14089)
* [[`44483b6898`](https://github.com/nodejs/node/commit/44483b6898)] - **test**: improve test-process-kill-null for Windows (starkwang) [#14099](https://github.com/nodejs/node/pull/14099)
* [[`5723b5dbbc`](https://github.com/nodejs/node/commit/5723b5dbbc)] - **tls**: improve TLSSocket & Server performance (Anatoli Papirovski) [#15575](https://github.com/nodejs/node/pull/15575)
* [[`1403d28e7d`](https://github.com/nodejs/node/commit/1403d28e7d)] - **tls**: re-allow falsey option values (Anna Henningsen) [#15131](https://github.com/nodejs/node/pull/15131)
* [[`5723c4c5f0`](https://github.com/nodejs/node/commit/5723c4c5f0)] - **tls**: replace forEach with for (Brian White) [#15053](https://github.com/nodejs/node/pull/15053)
* [[`193926ecab`](https://github.com/nodejs/node/commit/193926ecab)] - **tls,doc**: fix unallocated deprecation code (James M Snell) [#15534](https://github.com/nodejs/node/pull/15534)
* [[`76b8803630`](https://github.com/nodejs/node/commit/76b8803630)] - **tools**: add eslint rule for documented errors (James M Snell) [#16450](https://github.com/nodejs/node/pull/16450)
* [[`50fe1a8409`](https://github.com/nodejs/node/commit/50fe1a8409)] - **tools, benchmark**: test util benchmark (Sarah Meyer) [#16050](https://github.com/nodejs/node/pull/16050)
* [[`44f5523260`](https://github.com/nodejs/node/commit/44f5523260)] - **v8**: fix stack overflow in recursive method (Ben Noordhuis) [#12460](https://github.com/nodejs/node/pull/12460)
* [[`241eb6122e`](https://github.com/nodejs/node/commit/241eb6122e)] - **zlib**: gracefully set windowBits from 8 to 9 (Myles Borins) [#16511](https://github.com/nodejs/node/pull/16511)
* [[`2421984727`](https://github.com/nodejs/node/commit/2421984727)] - **zlib**: check cleanup return values (Anna Henningsen) [#14673](https://github.com/nodejs/node/pull/14673)
* [[`add4b0ab8c`](https://github.com/nodejs/node/commit/add4b0ab8c)] - **zlib**: improve performance (Brian White) [#13322](https://github.com/nodejs/node/pull/13322)
