# Node Foundation CTC Meeting 2016-06-22

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: https://github.com/nodejs/node/issues/7366
* **Minutes Google Doc**: <https://docs.google.com/document/d/1X9PTcpYgTKJO-PRKOLBrL4fIV-7XDR0x71FAxJWn0II>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1e7JdFHVtMtW9_o0Gi3NNz6g7TK50q4u9LYKFzBeHOQ8>_

## Present

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Chris Dickinson @chrisdickinson (CTC)
* Evan Lucas @evanlucas (CTC)
* James M Snell @jasnell (CTC)
* John-David Dalton @jdalton (observer/Lodash/Microsoft)
* Yuval Brik @jhamhader (observer)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Shigeki Ohtsu @shigeki (CTC)
* Steven R. Loomis @srl295 (observer/IBM/ICU)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)

## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* Node 6 fs.realpath behavior changes [#7175](https://github.com/nodejs/node/issues/7175)

## Standup

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
    * Need for APM / JIT Cache hooks investigation
    * Investigation into VM support for V8 and ES Modules
* Chris Dickinson @chrisdickinson (CTC)
    * Keeping track of ES Modules proposals
    * tooling gn to be npm installable
* Evan Lucas @evanlucas (CTC)
    * working on security fixes
    * looking for ways to streamline landing commits
* James M Snell @jasnell (CTC)
    * Vacation last week (worked on an experimental http/2 impl)
    * Working on WHATWG URL implementation
    * Various other performance related and doc PRs
    * And a heads up.. Will be on vacation again the 2nd and 3rd weeks of July.
* John-David Dalton @jdalton (observer/Lodash/Microsoft)
    * Retooled proposal to simplify it and make it more generic so it will work with things other than just script and module
    * Babel now supports export {} and therefore supports Unambiguous Modules proposal
    * Pinged some v8 devs to ask about impact there
    * Met with TypeScript folks too to discuss things that are a bit out of the scope of Unambiguous JavaScript but still modules
    * Initial round of feedback on Unambiguous JavaScript. Will be in JavaScript Weekly tomorrow.
* Josh Gavant @joshgav (observer/Microsoft)
    * hacking on inspector and tracing stuff
    * es6 modules a bit
    * monitoring issues, PRs, etc.
* Michael Dawson @mhdawson (CTC)
    * Chasing PPC machine issues
    * Chasing new AIX machines (expect this month)
    * Contributing to ABI stable module API PoC (NaN examples 1-8 now work)
    * Misc reviews/commenting
    * misc PRs/lands
    * Keeping up with issues
* Brian White @mscdex (CTC)
    * Reviewing PRs/issues
* Shigeki Ohtsu @shigeki (CTC)
    * Reviewing just one PR for root cert update.
* Steven R. Loomis @srl295 (observer/IBM/ICU)
    * helping @jasnell (a little) with https://github.com/nodejs/node/pull/7355
* Trevor Norris @trevnorris (CTC)
    * Additional work on the AsyncWrap EP
    * Misc PR reviews
* Rich Trott @Trott (CTC)
    * CO: Continuous Onboarding (welcome @RReverser!)
    * CI: Investigating and fixing flaky tests as time allows
* Ali Ijaz Sheikh @ofrobots(CTC)
    * Working on FFI, and other miscellaneous things.


## Minutes

### Review of last meeting

* url: return valid file: urls fom url.format() [#7234](https://github.com/nodejs/node/pull/7234)
* http: don't inherit from Object.prototype [#6102](https://github.com/nodejs/node/pull/6102)
* ES6 Modules

### fs.realpath

- https://github.com/nodejs/node/issues/7175
- https://github.com/nodejs/CTC/issues/9
- https://github.com/nodejs/node/issues/7192
- https://github.com/nodejs/node/issues/7044
- https://github.com/nodejs/node/issues/7294

When we made changes to rely on libuv realpath it was a semver-major change which introduced new errors and removed `cache` argument. This broke some ecosystem modules, notably `glob`. Also broke some path-related stuff in Windows.

We chose libuv realpath because it’s much more performant.

Options:
- Revert to old behavior. Would lose perf gains. Would be semver-major change.
- Add new method e.g. `realpath2` which uses old behavior.
- **Keep new behavior and add logic in Node to handle new/unexpected errors.**

@jasnell - We did a semver-major revert for the symlink issue.<br />
@trevnorris - No need to revert, just handle the errors.<br />
@jasnell - Do we really know what the errors are so we can be sure we’re handling all of them?<br />
@trevnorris - we can compare to old impl.<br />
@jasnell - Add an option to the options object to suppress errors, turn on by default.<br />

**@trevnorris will work on option 3.**

Post-mortem: https://github.com/nodejs/CTC/issues/9
- Postpone till Rod is present.
- @jasnell - We didn’t follow typical deprecation path for `cache` parameter change.


### ES6 modules

- https://github.com/bmeck/UnambiguousJavaScriptGrammar

- Any code with `import` or `export` is a module, otherwise a script.
- `modules.root` aspect removed, so “fat packages” (i.e. incl. both ES6 and CJS) are not addressed. Recommendation is to use one or the other and transpile as needed. Or discuss `modules.root` separately.
- Users can explicitly specify module goal in package.json. This way even if dev removes all `import/export` from their code it’s still treated as a module.
- TC39 could provide a “recommendation” or endorsement supporting this. They may suggest a spec extension.

@bradleymeck - still need modules.root for fat packages.

What about bytecode caching? Provide hooks to allow user to handle as desired. That means caching is in userland. Might split this into separate proposal.

@trevnorris analyzed perf hit of double parsing and found max 25% perf hit.

In-band detection (from the code itself) is preferable to out-of-band detections (e.g. package.json, file extension).

CJS and ES6 semantic interoperability: Bradley is working on this, working with WHATWG Loader spec and V8.
- `this` value
- live bindings for getters (get updated values) (?)
- immutability - hooks for APM providers to wrap original functions. To be handled by WHATWG Loader spec.

**@jdalton - How do we finalize consensus on this?**
- **PR to change [node-eps:/002-es6-modules.md](https://github.com/nodejs/node-eps/blob/master/002-es6-modules.md)**

### Q/A on public fora
None.

### Next Meeting
2016-06-29
