# Node Foundation TSC Meeting 2015-08-26

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-08-26
* **GitHub Issue**: https://github.com/nodejs/node/issues/2560
* **Minutes Google Doc**: https://docs.google.com/document/d/1aB76ClCgdjZUw3p-gHq9j6YwU11zWgJ4pmYPEWk6gjE
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1q2bFjnf0Y23Ljxoze56Pmrbailaj5-UAqIUqIYVhiIk>_

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

### joyent/node

* Update README to reflect move to nodejs/node [#25897](https://github.com/joyent/node/pull/25897)

### nodejs/node

* doc: merge CHANGELOG.md with joyent/node ChangeLog [#2536](https://github.com/nodejs/node/pull/2536)
* (guidance on) rename of "language groups" from iojs-\* to nodejs-\*? [#2525](https://github.com/nodejs/node/issues/2525)
* Node.js v4 Release Timeline [#2522](https://github.com/nodejs/node/issues/2522)

### nodejs/collaboration

* How to onboard into WG? [#4](https://github.com/nodejs/collaboration/issues/4)

## Minutes


### Present

* Rod Vagg (TSC)
* Brian White (TSC)
* Steven R Loomis (TSC) 
* Fedor Indutny (TSC)
* Bert Belder (TSC)
* Colin Ihrig (TSC)
* Ben Noordhuis (TSC)
* Mikeal Rogers
* Alexis Campailla (TSC)
* Trevor Norris (TSC)
* Shigeki Ohtsu (TSC)


### Review of the previous meeting

* Travel assistance amendment (no issue for this)
* FYI: Collaboration WG: https://github.com/nodejs/collaboration  
* Summit recap
* level-set on repo rename
* Future: “project lifecycle” (Mikeal) - process by which top level projects are added (libuv, node-gyp, etc), (conferences…)

### Standup:

* Rod Vagg: v4 release stuff, got certificates from/for the foundation, new website including CDN offering from CloudFlare
* Brian White: continuing work on benchmark app for node.js/io.js, triaging, reviewing/answering issues and pull requests.
* Steven R Loomis: Intl for convergence VS2015
* Fedor Indutny: http perf improvement PR, reviewing PRS, looking at issue for shared ports for http cluster
* Bert Belder: busy with work, reviewing libuv PRs and responding to issues
* Colin Ihrig: Rename from io.js to Node.js, reviewing issues and PRs
* Ben Noordhuis: Running native addons as part of CI, libuv bugs, reviewing PRs
* Mikeal Rogers: Website ready for release, working on CloudFlare CDN stuff
* Alexis Campailla: CI for release, parallelising test runs for ARM, looking at managing dependencies with git
* Trevor Norris: reviewing PRs and issues
* Shigeki Ohtsu: reviewing convergence tests for SSLv2/3, working on TLS ALPN features before freeze

### Update README to reflect move to nodejs/node [#25897](https://github.com/joyent/node/pull/25897)

* Alexis: made changes in CI to prepare for this, we’ll keep PRs in original repo, node-accept-pull-request will land changes in new repo as well, mirroring changes in 0.10 and 0.12 across both old and new repos. Still using the old Jenkins for releases for 0.10 and 0.12 right now and that doesn’t depend on repo name & location.
Target ETA for transition: Monday.


### doc: merge CHANGELOG.md with joyent/node ChangeLog [#2536](https://github.com/nodejs/node/pull/2536)

* Rod seeking confirmation from this group that this was _not a bad idea_.
* Discussion about documentation for people upgrading from older versions of Node and having a linear history. Jeremiah has been working on 0.10 -> v4 documentation.

### (guidance on) rename of "language groups" from iojs-\* to nodejs-\*? [#2525](https://github.com/nodejs/node/issues/2525)

* Steven discussed renaming the language groups
* Mikeal: some groups are not in a position to make decisions because they are not active but the ones that are should be given the opportunity to agree or disagree to the move rather than us imposing a move on them. We should post an issue in their repos.
* Steven: we should give them a timeline in issues in their repos
* Discussed naming, could be “lang” or “community” to make it more clear what they are about.
* ACTION: Steven to add a proposal to #2525, let TSC/collaborators add comments, later in the week will reach out to each of the groups.

### Node.js v4 Release Timeline [#2522](https://github.com/nodejs/node/issues/2522)

* Rod gave a summary of the proposed release timeline https://github.com/nodejs/node/issues/2522 (and appologised for documenting it as “the” release proposal just for the sake of getting it done). 
  - “feature freeze” Friday, 28th of August, cut v4.x branch
  - nodejs.org DNS changeover to new website Monday, 31st of August
  - release Thursday, 3rd of September
  - RC builds between website and release
  - backup release date of Monday, 7th of September if absolutely necessary to punt
* Discussed the outstanding items in the 4.0.0 milestone: https://github.com/nodejs/node/milestones/4.0.0, some concerning items:
  - mdb support is late and may not get done, might have to be a semver-minor prior to LTS
  - vcbuilt.bat needs to use the new build_release target and we have to verify that all builds have Intl enabled - Steven to work with Rod on this
  - `process.send()` async/sync, Ben said that this is async on all platforms now (was just Windows previously but now it’s cross-platform) but it’s missing a callback so there’s no way of doing back-pressure. No time to add this prior to v4 but could be done as semiver-minor later. Ben agreed to document current behaviour properly in the docs.
  - `_unrefActive` is in Jeremiah’s hands, he will land the 0.12 changes as the io.js version is terrible. Discussed further perf improvements but agreed to leave those changes till later, ideally till v5 because of the potential for subtle edge-case bugs being introduced.

### How to onboard into WG? [nodejs/collaboration#4](https://github.com/nodejs/collaboration/issues/4)

* Discussed GitHub onboarding mechanics

### V8 embedders unified debugger proposal

* Trevor raised https://github.com/nodejs/node/issues/2546 which is a proposal for a unified debugger for V8 embedders using Chromium DevTools.
* Discussion ensued, agreed to leave it for GitHub discussion unless/until there is something the TSC actually needs to make a decision about.

### Next Meeting

September 2nd
