# Copyright (C) 2018 MongoDB, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

module Mongo
  module Operation

    # Custom behavior for operations that support the causally consistency.
    #
    # @since 2.5.2
    module CausalConsistencySupported

      private

      def apply_causal_consistency!(selector, server)
        if !server.standalone?
          full_read_concern_doc = session.send(:causal_consistency_doc, selector[:readConcern] || read_concern)
          selector[:readConcern] = full_read_concern_doc if full_read_concern_doc
        end
      end
    end
  end
end
