# Copyright (C) 2014-2018 MongoDB, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

module Mongo
  module Operation
    class UsersInfo

      # Defines custom behaviour of results when using the
      # usersInfo command.
      #
      # @since 2.1.0
      class Result < Operation::Result

        # The field name for the users document in a usersInfo result.
        #
        # @since 2.1.0
        USERS = 'users'.freeze

        def documents
          reply.documents.first[USERS]
        end

        private

        def first_document
          @first_document ||= reply.documents[0]
        end
      end
    end
  end
end
