/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.util.Enumeration;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public final class DomParser
implements XMLReader {
    private DefaultHandler2 defaultHandler = new DefaultHandler2();
    private ContentHandler contentHandler = this.defaultHandler;
    private DTDHandler dtdHandler = this.defaultHandler;
    private DeclHandler declHandler = this.defaultHandler;
    private LexicalHandler lexicalHandler = this.defaultHandler;
    private ErrorHandler errHandler = this.defaultHandler;
    private EntityResolver resolver = this.defaultHandler;
    private Locale locale = Locale.getDefault();
    private Node start;
    private Node current;
    private boolean isL2;
    private boolean showNamespaces = true;
    private boolean showXML1_0 = false;
    private NamespaceSupport prefixStack = new NamespaceSupport();
    private boolean isDocument;
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String HANDLERS = "http://xml.org/sax/properties/";

    public DomParser() {
    }

    public DomParser(Node node) {
        this.setStart(node);
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            entityResolver = this.defaultHandler;
        }
        this.resolver = entityResolver;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = this.defaultHandler;
        }
        this.errHandler = errorHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            contentHandler = this.defaultHandler;
        }
        this.contentHandler = contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            dTDHandler = this.defaultHandler;
        }
        this.dtdHandler = dTDHandler;
    }

    public void parse(String string) throws SAXException {
        this.parse();
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse() throws SAXException {
        block3: {
            try {
                this.walk();
                Object var2_1 = null;
                if (!this.isDocument) break block3;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.isDocument) {
                    this.contentHandler.endDocument();
                }
                this.current = null;
                this.prefixStack.reset();
                throw throwable;
            }
            this.contentHandler.endDocument();
        }
        this.current = null;
        this.prefixStack.reset();
    }

    private boolean getIsL2(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        if (document == null) {
            throw new RuntimeException("? unowned node - L2 DTD ?");
        }
        DOMImplementation dOMImplementation = document.getImplementation();
        return dOMImplementation.hasFeature("XML", "2.0");
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string) || "http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string) || "http://xml.org/sax/features/string-interning".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return this.showNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return this.showXML1_0;
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            return this.declHandler == this.defaultHandler ? null : this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.lexicalHandler == this.defaultHandler ? null : this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            return this.current;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.current != null) {
            throw new IllegalStateException("feature change midparse");
        }
        boolean bl2 = this.getFeature(string);
        if (bl2 == bl) {
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            if (!this.showXML1_0 && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showNamespaces = bl;
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            if (!this.showNamespaces && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showXML1_0 = bl;
            return;
        }
        throw new SAXNotSupportedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            if (!(object instanceof DeclHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.declHandler = (DeclHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            if (!(object instanceof LexicalHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.lexicalHandler = (LexicalHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            if (object == null || object instanceof Node) {
                if (this.current != null) {
                    throw new SAXNotSupportedException("property is readonly during parse:  " + string);
                }
                this.setStart((Node)object);
                return;
            }
            throw new SAXNotSupportedException("not a DOM Node");
        }
        throw new SAXNotRecognizedException(string);
    }

    private void setStart(Node node) {
        this.start = node;
        if (this.start != null) {
            this.isL2 = this.getIsL2(this.start);
            this.isDocument = this.start instanceof Document;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void walk() throws SAXException {
        var4_1 = new AttributesImpl();
        var8_2 = this;
        synchronized (var8_2) {
            if (this.current != null) {
                throw new IllegalStateException("already walking tree");
            }
            this.current = this.start;
        }
        block17: while (true) {
            var1_5 = this.current.getNodeType();
            switch (var1_5) {
                case 9: {
                    this.contentHandler.startDocument();
                    break;
                }
                case 1: {
                    var2_6 = this.current.getAttributes();
                    var3_7 = var2_6.getLength();
                    this.prefixStack.pushContext();
                    var9_4 = 0;
                    while (var9_4 < var3_7) {
                        var10_11 = (Attr)var2_6.item(var9_4);
                        var11_12 = var10_11.getNodeName();
                        if (!this.showNamespaces || !var11_12.startsWith("xmlns")) ** GOTO lbl32
                        var12_14 = "xmlns".equals(var11_12) != false ? "" : var11_12.substring(6);
                        var13_17 = var10_11.getNodeValue();
                        this.prefixStack.declarePrefix(var12_14, (String)var13_17);
                        this.contentHandler.startPrefixMapping(var12_14, (String)var13_17);
                        if (!this.showXML1_0) ** GOTO lbl44
lbl32:
                        // 2 sources

                        if (!this.showNamespaces) ** GOTO lbl41
                        if (this.isL2) {
                            var6_9 = var10_11.getNamespaceURI();
                            if (var6_9 == null) {
                                var6_9 = "";
                            }
                            if ((var7_10 = var10_11.getLocalName()) == null) {
                                var7_10 = var11_12;
                            }
                        } else {
                            throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
lbl41:
                            // 1 sources

                            var7_10 = "";
                            var6_9 = "";
                        }
                        var4_1.addAttribute(var6_9, var7_10, var11_12, "CDATA", var10_11.getNodeValue());
lbl44:
                        // 2 sources

                        ++var9_4;
                    }
                    if (!this.showNamespaces) ** GOTO lbl55
                    if (this.isL2) {
                        var6_9 = this.current.getNamespaceURI();
                        if (var6_9 == null) {
                            var6_9 = "";
                        }
                        if ((var7_10 = this.current.getLocalName()) == null) {
                            var7_10 = this.current.getNodeName();
                        }
                    } else {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
lbl55:
                        // 1 sources

                        var7_10 = "";
                        var6_9 = "";
                    }
                    this.contentHandler.startElement(var6_9, var7_10, this.current.getNodeName(), var4_1);
                    if (var3_7 == 0) break;
                    var4_1.clear();
                    break;
                }
                case 4: {
                    this.lexicalHandler.startCDATA();
                    var5_8 = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(var5_8, 0, var5_8.length);
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 8: {
                    var5_8 = this.current.getNodeValue().toCharArray();
                    this.lexicalHandler.comment(var5_8, 0, var5_8.length);
                    break;
                }
                case 10: {
                    var10_11 = (DocumentType)this.current;
                    if (this.isL2) {
                        this.lexicalHandler.startDTD(var10_11.getName(), var10_11.getPublicId(), var10_11.getSystemId());
                    } else {
                        this.lexicalHandler.startDTD(var10_11.getName(), null, null);
                    }
                    var11_12 = this.isL2 != false && var10_11.getInternalSubset() != null ? " Full DTD known; can't be shown using SAX2. " : " This DTD was was recreated using incomplete DOM L2 records. ";
                    var12_15 = var11_12.toCharArray();
                    this.lexicalHandler.comment((char[])var12_15, 0, ((char[])var12_15).length);
                    var2_6 = var10_11.getNotations();
                    var3_7 = var2_6.getLength();
                    var11_13 = 0;
                    while (var11_13 < var3_7) {
                        var12_15 = (Notation)var2_6.item(var11_13);
                        this.dtdHandler.notationDecl(var12_15.getNodeName(), var12_15.getPublicId(), var12_15.getSystemId());
                        ++var11_13;
                    }
                    var2_6 = var10_11.getEntities();
                    var3_7 = var2_6.getLength();
                    var12_16 = 0;
                    while (var12_16 < var3_7) {
                        var13_17 = (Entity)var2_6.item(var12_16);
                        var14_18 = var13_17.getNotationName();
                        if (var14_18 != null) {
                            this.dtdHandler.unparsedEntityDecl(var13_17.getNodeName(), var13_17.getPublicId(), var13_17.getSystemId(), var14_18);
                        } else if (var13_17.getSystemId() != null) {
                            this.declHandler.externalEntityDecl(var13_17.getNodeName(), var13_17.getPublicId(), var13_17.getSystemId());
                        }
                        ++var12_16;
                    }
                    this.lexicalHandler.endDTD();
                    break;
                }
                case 5: {
                    this.lexicalHandler.startEntity(this.current.getNodeName());
                    break;
                }
                case 7: {
                    this.contentHandler.processingInstruction(this.current.getNodeName(), this.current.getNodeValue());
                    break;
                }
                case 3: {
                    var5_8 = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(var5_8, 0, var5_8.length);
                    break;
                }
                default: {
                    throw new SAXException("Illegal DOM Node type in Document:  " + this.current.getNodeType());
                }
            }
            switch (var1_5) {
                case 1: 
                case 5: 
                case 9: {
                    var10_11 = this.current.getFirstChild();
                    if (var10_11 != null) {
                        this.current = var10_11;
                        continue block17;
                    }
                    this.callEnd(this.current);
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    while ((var10_11 = this.current.getNextSibling()) == null) {
                        this.current = this.current.getParentNode();
                        if (this.current == null || this.current == this.start) {
                            return;
                        }
                        this.callEnd(this.current);
                    }
                    this.current = var10_11;
                    continue block17;
                }
            }
            break;
        }
        throw new SAXException("Illegal DOM Node type found:  " + this.current.getNodeType());
    }

    private void callEnd(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                return;
            }
            case 1: {
                if (this.showNamespaces) {
                    if (!this.isL2) {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                    }
                    this.contentHandler.endElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
                    Enumeration enumeration = this.prefixStack.getDeclaredPrefixes();
                    while (enumeration.hasMoreElements()) {
                        this.contentHandler.endPrefixMapping((String)enumeration.nextElement());
                    }
                } else {
                    this.contentHandler.endElement("", "", node.getNodeName());
                }
                this.prefixStack.popContext();
                return;
            }
            case 5: {
                this.lexicalHandler.endEntity(node.getNodeName());
                return;
            }
            case 2: 
            case 11: {
                return;
            }
        }
        throw new SAXException("Illegal DOM container type found:  " + this.current.getNodeType());
    }
}

