/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator.helper;

public class Abbreviator {
    static final String FILLER = "...";
    final char folderSeparator;
    final int invariantPrefixLength;
    final int desiredLength;

    public Abbreviator(int invariantPrefixLength, int desiredLength, char folderSeparator) {
        this.invariantPrefixLength = invariantPrefixLength;
        this.desiredLength = desiredLength;
        this.folderSeparator = folderSeparator;
    }

    public String abbreviate(String filename) {
        if (filename.length() <= this.desiredLength) {
            return filename;
        }
        int firstIndex = filename.indexOf(this.folderSeparator, this.invariantPrefixLength);
        if (firstIndex == -1) {
            return filename;
        }
        StringBuffer buf = new StringBuffer(this.desiredLength);
        buf.append(filename.substring(0, firstIndex + 1));
        buf.append(FILLER);
        int nextIndex = this.computeNextIndex(filename, firstIndex);
        if (nextIndex == -1) {
            return filename;
        }
        buf.append(filename.substring(nextIndex));
        if (buf.length() < filename.length()) {
            return buf.toString();
        }
        return filename;
    }

    int computeNextIndex(String filename, int firstIndex) {
        int nextIndex = firstIndex + 1;
        int hitCount = 0;
        int minToRemove = filename.length() - this.desiredLength + FILLER.length();
        while (nextIndex < firstIndex + minToRemove) {
            int tmpIndex = filename.indexOf(this.folderSeparator, nextIndex + 1);
            if (tmpIndex == -1) {
                if (hitCount == 0) {
                    return -1;
                }
                return nextIndex;
            }
            ++hitCount;
            nextIndex = tmpIndex;
        }
        return nextIndex;
    }
}

