/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.IOException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SyslogWriter
extends Writer {
    final int SYSLOG_PORT = 514;
    String syslogHost;
    private InetAddress address;
    private DatagramSocket ds;
    private Logger logger = LogManager.getLogger(class$org$apache$log4j$helpers$SyslogWriter == null ? (class$org$apache$log4j$helpers$SyslogWriter = SyslogWriter.class$("org.apache.log4j.helpers.SyslogWriter")) : class$org$apache$log4j$helpers$SyslogWriter);
    StringBuffer buf = new StringBuffer();
    static /* synthetic */ Class class$org$apache$log4j$helpers$SyslogWriter;

    public SyslogWriter(String syslogHost) {
        this.syslogHost = syslogHost;
        try {
            this.address = InetAddress.getByName(syslogHost);
        }
        catch (UnknownHostException e) {
            this.logger.error((Object)("Could not find " + syslogHost + ". All logging will FAIL."), e);
        }
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("Could not instantiate DatagramSocket to " + syslogHost + ". All logging will FAIL."), e);
        }
    }

    public void write(char[] charArray, int offset, int len) throws IOException {
        this.buf.append(charArray, offset, len);
    }

    public void write(String str) throws IOException {
        this.buf.append(str);
    }

    public void flush() throws IOException {
        this.logger.debug((Object)"Writing out [{}]", this.buf);
        byte[] bytes = this.buf.toString().getBytes();
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.address, 514);
        if (this.ds != null) {
            this.ds.send(packet);
        }
        this.buf.setLength(0);
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

