/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.status.ErrorStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterAppender<E>
extends AppenderBase<E> {
    protected boolean immediateFlush = true;
    protected String encoding;
    protected Writer writer;
    protected Layout<E> layout;

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    @Override
    public void start() {
        int errors = 0;
        if (this.layout == null) {
            this.addStatus(new ErrorStatus("No layout set for the appender named \"" + this.name + "\".", this));
            ++errors;
        }
        if (this.writer == null) {
            this.addStatus(new ErrorStatus("No writer set for the appender named \"" + this.name + "\".", this));
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    @Override
    protected void append(E eventObject) {
        if (!this.isStarted()) {
            return;
        }
        this.subAppend(eventObject);
    }

    @Override
    public synchronized void stop() {
        this.closeWriter();
        super.stop();
    }

    protected void closeWriter() {
        if (this.writer != null) {
            try {
                this.writeFooter();
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                this.addStatus(new ErrorStatus("Could not close writer for WriterAppener.", this, e));
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream os) {
        OutputStreamWriter retval;
        block2: {
            retval = null;
            String enc = this.getEncoding();
            try {
                retval = enc != null ? new OutputStreamWriter(os, enc) : new OutputStreamWriter(os);
            }
            catch (IOException e) {
                this.addStatus(new ErrorStatus("Error initializing output writer.", this, e));
                if (enc == null) break block2;
                this.addStatus(new ErrorStatus("Unsupported encoding?", this));
            }
        }
        return retval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    @Override
    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    @Override
    public Layout<E> getLayout() {
        return this.layout;
    }

    void writeHeader() {
        String h;
        if (this.layout != null && (h = this.layout.getFileHeader()) != null && this.writer != null) {
            try {
                this.writer.write(h);
                String ph = this.layout.getPresentationHeader();
                if (ph != null) {
                    this.writer.write(ph);
                }
                this.writer.write(Layout.LINE_SEP);
                this.writer.flush();
            }
            catch (IOException ioe) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write header for appender named [" + this.name + "].", this, ioe));
            }
        }
    }

    void writeFooter() {
        String h;
        if (this.layout != null && (h = this.layout.getFileFooter()) != null && this.writer != null) {
            try {
                this.writer.write(h);
                String pf = this.layout.getPresentationFooter();
                if (pf != null) {
                    this.writer.write(pf);
                }
                this.writer.flush();
            }
            catch (IOException ioe) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write footer for appender named [" + this.name + "].", this, ioe));
            }
        }
    }

    public synchronized void setWriter(Writer writer) {
        this.closeWriter();
        this.writer = writer;
        this.writeHeader();
    }

    protected void subAppend(E event) {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.writer.write(this.layout.doLayout(event));
            if (this.immediateFlush) {
                this.writer.flush();
            }
        }
        catch (IOException ioe) {
            this.started = false;
            this.addStatus(new ErrorStatus("IO failure in appender", this, ioe));
        }
    }
}

