/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.Option;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.action.ActionConst;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.xml.sax.Attributes;

public class LoggerAction
extends Action {
    boolean inError = false;

    public void begin(ExecutionContext ec, String name, Attributes attributes) {
        Logger l;
        this.inError = false;
        LoggerRepository repository = (LoggerRepository)ec.getObject(0);
        String loggerName = attributes.getValue("name");
        if (Option.isEmpty(loggerName)) {
            this.inError = true;
            String line = ", around line " + this.getLineNumber(ec) + " column " + this.getColumnNumber(ec);
            String errorMsg = "No 'name' attribute in element " + name + line;
            this.getLogger().warn(errorMsg);
            ec.addError(new ErrorItem(errorMsg));
            return;
        }
        this.getLogger().debug("Logger name is [" + loggerName + "].");
        String className = attributes.getValue("class");
        if (Option.isEmpty(className)) {
            this.getLogger().debug("Retreiving an instance of org.apache.log4j.getLogger().");
            l = repository.getLogger(loggerName);
        } else {
            this.getLogger().debug("Desired logger sub-class: [" + className + ']');
            try {
                Class clazz = Loader.loadClass(className);
                Method getInstanceMethod = clazz.getMethod("getLogger", ActionConst.ONE_STRING_PARAM);
                l = (Logger)getInstanceMethod.invoke(null, loggerName);
            }
            catch (Exception oops) {
                this.getLogger().error((Object)("Could not retrieve category [" + loggerName + "]. Reported error follows."), oops);
                return;
            }
        }
        boolean additivity = OptionConverter.toBoolean(attributes.getValue("additivity"), true);
        this.getLogger().debug("Setting [" + l.getName() + "] additivity to [" + additivity + "].");
        l.setAdditivity(additivity);
        this.getLogger().debug("Pushing logger named [" + loggerName + "].");
        ec.pushObject(l);
    }

    public void end(ExecutionContext ec, String e) {
        this.getLogger().debug("end() called.");
        if (!this.inError) {
            this.getLogger().debug("Removing logger from stack.");
            ec.popObject();
        }
    }

    public void finish(ExecutionContext ec) {
    }
}

