/*
    Authors:
        Stef Walter <stefw@redhat.com>

    Copyright (C) 2014 Red Hat

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _SSSD_DBUS_META_H_
#define _SSSD_DBUS_META_H_

/*
 * Interface metadata
 *
 * For arrays, the last item in each array will have a
 * NULL .name field
 *
 * Typically these structs will be generated by sbus_codegen
 * from canonical XML interface data:
 *
 * http://dbus.freedesktop.org/doc/dbus-specification.html#introspection-format
 */

/* Looks up a vtable func, in a struct derived from struct sbus_vtable */
#define VTABLE_FUNC(vtable, offset) \
    (*(DISCARD_ALIGN((char *)(vtable) + (offset), void **)))

struct sbus_arg_meta {
    const char *name;
    const char *type;
};

struct sbus_request;
struct sbus_interface;

typedef int (* sbus_method_invoker_fn)(struct sbus_request *dbus_req, void *handler_fn);

struct sbus_method_meta {
    const char *name;
    const struct sbus_arg_meta *in_args;
    const struct sbus_arg_meta *out_args;
    size_t vtable_offset;
    sbus_method_invoker_fn invoker;
};

enum {
    SBUS_PROPERTY_READABLE = 1 << 0,
    SBUS_PROPERTY_WRITABLE = 1 << 1
};

struct sbus_property_meta {
    const char *name;
    const char *type;
    int flags;
    size_t vtable_offset_get;
    sbus_method_invoker_fn invoker_get;
    size_t vtable_offset_set;
    sbus_method_invoker_fn invoker_set;
};

struct sbus_signal_meta {
    const char *name;
    const struct sbus_arg_meta *args;
};

struct sbus_interface_meta {
    const char *name;
    const struct sbus_method_meta *methods;
    const struct sbus_signal_meta *signals;
    const struct sbus_property_meta *properties;
    sbus_method_invoker_fn invoker_get_all;
};

const struct sbus_method_meta *
sbus_meta_find_method (const struct sbus_interface_meta *interface,
                       const char *method_name);

const struct sbus_signal_meta *
sbus_meta_find_signal (const struct sbus_interface_meta *interface,
                       const char *signal_name);

const struct sbus_property_meta *
sbus_meta_find_property (const struct sbus_interface_meta *interface,
                         const char *property_name);

#endif /* _SSSD_DBUS_META_H_ */
