/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0xA4, 0x33, 0x7B, 0xBA, 0x7E, 0x26, 0xBF, 0xA5, 0x0F, 0xE2,
        0x94, 0xAE, 0xFD, 0x6F, 0x87, 0xA3, 0x04, 0xDD, 0xA0, 0x77,
        0x33, 0x9A, 0xD7, 0x4C, 0x82, 0x02, 0x66, 0x08, 0x3F, 0x1F,
        0x90, 0xB2, 0xF1, 0x91, 0x78, 0xB1, 0xF0, 0x73, 0xFB, 0x58,
        0xDF, 0x2B, 0x19, 0xA2, 0xB2, 0x84, 0xD7, 0x99, 0x0D, 0xB5,
        0x87, 0x01, 0xBE, 0xEA, 0x14, 0xB5, 0xB0, 0xFD, 0x8D, 0xEF,
        0xBE, 0xFC, 0x64, 0x88, 0x6F, 0xBF, 0xF5, 0xB5, 0x21, 0x5F,
        0xE3, 0x94, 0xAA, 0x31, 0xC8, 0xA9, 0xAE, 0x00, 0x21, 0x2D,
        0x99, 0xF5, 0xE7, 0x73, 0xF3, 0x72, 0x4A, 0x34, 0x60, 0x3B,
        0x93, 0xE2, 0x1E, 0x66, 0x99, 0x7C, 0x82, 0xC3, 0x44, 0xCC,
        0x64, 0x2C, 0xB1, 0xC3, 0xFB, 0x23, 0xD9, 0x88, 0xEA, 0xFB,
        0xB4, 0x22, 0xB3, 0x96, 0x93, 0x19, 0x8A, 0x06, 0x28, 0x68,
        0xE9, 0xE0, 0x73, 0xDC, 0x19, 0xBB, 0x27, 0x3D, 0x03, 0x28,
        0x0A, 0xC9, 0x48, 0x6D, 0xAA, 0x03, 0xAC, 0xCF, 0xC9, 0x68,
        0x55, 0x36, 0x71, 0x11, 0x80, 0x65, 0x33, 0xAC, 0xFA, 0x53,
        0xCF, 0xFD, 0x14, 0x86, 0x1A, 0xFD, 0x2A, 0x80, 0x43, 0x11,
        0x61, 0xE4, 0x0E, 0x52, 0x72, 0x5D, 0x55, 0x31, 0x5F, 0xC4,
        0x8B, 0xA8, 0xF2, 0x36, 0x4E, 0x1C, 0x07, 0x01, 0x8E, 0xCD,
        0x54, 0x57, 0x20, 0x39, 0x3F, 0xCE, 0x6A, 0xEA, 0x7C, 0x56,
        0x13, 0x5F, 0x51, 0xF3, 0x96, 0xE0, 0x1A, 0x9A, 0x31, 0xC7,
        0xC7, 0x37, 0x7C, 0xFB, 0xC9, 0x09, 0xFC, 0xCE, 0x6B, 0xC5,
        0xA7, 0x45, 0xE6, 0xCA, 0x98, 0x1B, 0xC1, 0x7D, 0x69, 0x3D,
        0x2B, 0x86, 0x65, 0xDB, 0xF1, 0xFF, 0x85, 0x0B, 0xCB, 0x84,
        0xEA, 0x16, 0x66, 0xF0, 0x7B, 0x95, 0xA6, 0x2F, 0x1F, 0x58,
        0x21, 0x6A, 0x4D, 0x1D, 0xAE, 0x7C, 0x2A, 0xE5, 0xB9, 0xF2,
        0xFE, 0xF7, 0xA2, 0xE7, 0xA4, 0x1B
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.58 */
