from __future__ import print_function, division, absolute_import

# Copyright (c) 2017 Red Hat, Inc.
#
# This software is licensed to you under the GNU General Public License,
# version 2 (GPLv2). There is NO WARRANTY for this software, express or
# implied, including the implied warranties of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. You should have received a copy of GPLv2
# along with this software; if not, see
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
#
# Red Hat trademarks are not licensed under GPLv2. No permission is
# granted to use or replicate Red Hat trademarks that are incorporated
# in this software or its documentation.

"""
This module provides service for consumer identity.
"""


from subscription_manager import injection as inj


class Consumer(object):
    def __init__(self):
        """
        Initialization of Consumer instance.
        """
        pass

    def get_consumer_uuid(self):
        """
        Method for getting UUID of consumer
        :return: string representing UUID
        """

        identity = inj.require(inj.IDENTITY)

        if identity.uuid is None:
            return ""
        else:
            return identity.uuid
