/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LiveBoxesDrawer {
    private double y1;
    private SymbolContext symbolContext;
    private final Component cross;
    private final Context2D context;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Component compForWidth;
    private final Collection<Segment> delays;

    public LiveBoxesDrawer(Context2D context, Rose skin, ISkinParam skinParam, Map<Double, Double> delays) {
        this.cross = skin.createComponent(new Style[]{ComponentType.DESTROY.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder())}, ComponentType.DESTROY, null, skinParam, null);
        this.compForWidth = skin.createComponent(new Style[]{ComponentType.ALIVE_BOX_CLOSE_CLOSE.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder())}, ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, skinParam, null);
        this.context = context;
        this.skin = skin;
        this.skinParam = skinParam;
        this.delays = new HashSet<Segment>();
        for (Map.Entry<Double, Double> ent : delays.entrySet()) {
            this.delays.add(new Segment(ent.getKey(), ent.getKey() + ent.getValue()));
        }
    }

    public double getWidth(StringBounder stringBounder) {
        return this.compForWidth.getPreferredWidth(stringBounder);
    }

    public void addStart(double y1, SymbolContext symbolContext) {
        this.y1 = y1;
        this.symbolContext = symbolContext;
    }

    public void doDrawing(UGraphic ug, StairsPosition yposition) {
        Segment full = new Segment(this.y1, yposition.getValue());
        Collection<Segment> segments = full.cutSegmentIfNeed(this.delays);
        ComponentType type = ComponentType.ALIVE_BOX_CLOSE_CLOSE;
        if (segments.size() > 1) {
            type = ComponentType.ALIVE_BOX_CLOSE_OPEN;
        }
        Iterator<Segment> it = segments.iterator();
        while (it.hasNext()) {
            Segment seg = it.next();
            if (!it.hasNext() && type != ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
                type = ComponentType.ALIVE_BOX_OPEN_CLOSE;
            }
            this.drawInternal(ug, yposition, seg.getPos1(), seg.getPos2(), type);
            type = ComponentType.ALIVE_BOX_OPEN_OPEN;
        }
        this.y1 = Double.MAX_VALUE;
    }

    public void drawDestroyIfNeeded(UGraphic ug, StairsPosition yposition) {
        if (yposition.isDestroy()) {
            Dimension2D dimCross = this.cross.getPreferredDimension(ug.getStringBounder());
            this.cross.drawU(ug.apply(new UTranslate(-dimCross.getWidth() / 2.0, yposition.getValue() - dimCross.getHeight() / 2.0)), null, this.context);
        }
    }

    private void drawInternal(UGraphic ug, StairsPosition yposition, double ya, double yb, ComponentType type) {
        double width = this.getWidth(ug.getStringBounder());
        Area area = new Area(width, yb - ya);
        SkinParamBackcolored skinParam2 = new SkinParamBackcolored(this.skinParam, this.symbolContext == null ? null : this.symbolContext.getBackColor());
        Style style = type.getDefaultStyleDefinition().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        if (style != null) {
            style = style.eventuallyOverride(this.symbolContext);
        }
        Component comp = this.skin.createComponent(new Style[]{style}, type, null, skinParam2, null);
        comp.drawU(ug.apply(new UTranslate(-width / 2.0, ya)), area, this.context);
    }
}

