/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;

public class TextBlockLineBefore
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final TextBlock textBlock;
    private final char separator;
    private final TextBlock title;

    public TextBlockLineBefore(TextBlock textBlock, char separator, TextBlock title) {
        this.textBlock = textBlock;
        this.separator = separator;
        this.title = title;
    }

    public TextBlockLineBefore(TextBlock textBlock, char separator) {
        this(textBlock, separator, null);
    }

    public TextBlockLineBefore(TextBlock textBlock) {
        this(textBlock, '\u0000');
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        if (this.title != null) {
            Dimension2D dimTitle = this.title.calculateDimension(stringBounder);
            return Dimension2DDouble.atLeast(dim, dimTitle.getWidth() + 8.0, dimTitle.getHeight());
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        HtmlColor color = ug.getParam().getColor();
        if (this.title == null) {
            UHorizontalLine.infinite(1.0, 1.0, this.separator).drawMe(ug);
        }
        this.textBlock.drawU(ug);
        ug = ug.apply(new UChangeColor(color));
        if (this.title != null) {
            UHorizontalLine.infinite(1.0, 1.0, this.title, this.separator).drawMe(ug);
        }
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.textBlock.getInnerPosition(member, stringBounder, strategy);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return ((WithPorts)((Object)this.textBlock)).getPorts(stringBounder);
    }
}

