/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileNoteTop
extends AbstractTile
implements TileWithUpdateStairs,
TileWithCallbackY {
    private final TileWithUpdateStairs tile;
    private final AbstractMessage message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Note noteOnMessage;
    private final double spacey = 10.0;

    @Override
    public Event getEvent() {
        return this.message;
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        return this.tile.getYPoint(stringBounder);
    }

    public CommunicationTileNoteTop(TileWithUpdateStairs tile, AbstractMessage message, Rose skin, ISkinParam skinParam, Note noteOnMessage) {
        this.tile = tile;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        this.noteOnMessage = noteOnMessage;
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        this.tile.updateStairs(stringBounder, y);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(this.noteOnMessage.getUsedStyles(), ComponentType.NOTE, null, this.noteOnMessage.getSkinParamBackcolored(this.skinParam), this.noteOnMessage.getStrings());
        return comp;
    }

    private Real getNotePosition(StringBounder stringBounder) {
        Real minX = this.tile.getMinX(stringBounder);
        return minX;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = new Area(dim.getWidth(), dim.getHeight());
        this.tile.drawU(ug.apply(new UTranslate(0.0, dim.getHeight() + 10.0)));
        double middleMsg = (this.tile.getMinX(stringBounder).getCurrentValue() + this.tile.getMaxX(stringBounder).getCurrentValue()) / 2.0;
        double xNote = this.getNotePosition(stringBounder).getCurrentValue();
        comp.drawU(ug.apply(new UTranslate(xNote, 0.0)), area, (Context2D)((Object)ug));
        this.drawLine(ug, middleMsg, this.tile.getYPoint(stringBounder) + dim.getHeight() + 10.0, xNote + dim.getWidth() / 2.0, dim.getHeight() - 10.0);
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        HtmlColor color = new Rose().getHtmlColor(this.skinParam, ColorParam.arrow);
        double dx = x2 - x1;
        double dy = y2 - y1;
        ug.apply(new UTranslate(x1, y1)).apply(new UChangeColor(color)).apply(new UStroke(2.0, 2.0, 1.0)).draw(new ULine(dx, dy));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return this.tile.getPreferredHeight(stringBounder) + dim.getHeight() + 10.0;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        this.tile.addConstraints(stringBounder);
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.tile.getMinX(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.tile.getMaxX(stringBounder);
    }

    @Override
    public void callbackY(double y) {
        if (this.tile instanceof TileWithCallbackY) {
            ((TileWithCallbackY)((Object)this.tile)).callbackY(y);
        }
    }
}

