/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;

public class CommandCreoleImg
implements Command {
    private final Pattern2 pattern;

    private CommandCreoleImg(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    public static Command create() {
        return new CommandCreoleImg("^(?i)(\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String src = m.group(2);
        double scale = CommandCreoleImg.getScale(m.group(3), 1.0);
        if (src.toLowerCase().startsWith("src=")) {
            src = src.substring(4);
        }
        src = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(src, "\"");
        stripe.addImage(src, scale);
        return line.substring(m.group(1).length());
    }

    public static double getScale(String s, double def) {
        if (s == null) {
            return def;
        }
        Pattern p = Pattern.compile("(?:scale=|\\*)([0-9.]+)");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return Double.parseDouble(m.group(1));
        }
        return def;
    }

    public static String getColor(String s) {
        if (s == null) {
            return null;
        }
        Pattern p = Pattern.compile("color[= :](#[0-9a-fA-F]{6}|\\w+)");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

