/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2;

import java.util.Collection;

public class MinMax {
    private final int min;
    private final int max;

    private MinMax(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException();
        }
        this.min = min;
        this.max = max;
    }

    private MinMax(int value) {
        this(value, value);
    }

    public MinMax add(int value) {
        int newMin = Math.min(this.min, value);
        int newMax = Math.max(this.max, value);
        if (this.min == newMin && this.max == newMax) {
            return this;
        }
        return new MinMax(newMin, newMax);
    }

    public MinMax add(MinMax other) {
        int newMin = Math.min(this.min, other.min);
        int newMax = Math.max(this.max, other.max);
        if (this.min == newMin && this.max == newMax) {
            return this;
        }
        return new MinMax(newMin, newMax);
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public static MinMax from(Collection<Integer> values) {
        MinMax result = null;
        for (Integer i : values) {
            if (result == null) {
                result = new MinMax(i);
                continue;
            }
            result = result.add(i);
        }
        return result;
    }

    public int getDiff() {
        return this.max - this.min;
    }
}

