/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CircledCharacter
extends AbstractTextBlock
implements TextBlock {
    private final String c;
    private final UFont font;
    private final HtmlColor innerCircle;
    private final HtmlColor circle;
    private final HtmlColor fontColor;
    private final double radius;

    public CircledCharacter(char c, double radius, UFont font, HtmlColor innerCircle, HtmlColor circle, HtmlColor fontColor) {
        this.c = "" + c;
        this.radius = radius;
        this.font = font;
        this.innerCircle = innerCircle;
        this.circle = circle;
        this.fontColor = fontColor;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.circle != null) {
            ug = ug.apply(new UChangeColor(this.circle));
        }
        ug = ug.apply(new UChangeBackColor(this.innerCircle));
        ug.draw(new UEllipse(this.radius * 2.0, this.radius * 2.0));
        ug = ug.apply(new UChangeColor(this.fontColor));
        ug = ug.apply(new UTranslate(this.radius, this.radius));
        ug.draw(new UCenteredCharacter(this.c.charAt(0), this.font));
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder));
    }
}

