/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorMiddle;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileCircleStop
extends AbstractFtile {
    private static final int SIZE = 22;
    private final HtmlColor backColor;
    private final Swimlane swimlane;
    private double shadowing;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileCircleStop(ISkinParam skinParam, HtmlColor backColor, Swimlane swimlane, Style style) {
        super(skinParam);
        this.backColor = backColor;
        this.swimlane = swimlane;
        if (SkinParam.USE_STYLES()) {
            this.shadowing = style.value(PName.Shadowing).asDouble();
        } else if (this.skinParam().shadowing(null)) {
            this.shadowing = 3.0;
        }
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(22.0, 22.0);
        circle.setDeltaShadow(this.shadowing);
        ug.apply(new UChangeColor(this.backColor)).apply(new UChangeBackColor(HtmlColorUtils.WHITE)).draw(circle);
        double delta = 5.0;
        UEllipse circleSmall = new UEllipse(12.0, 12.0);
        ug.apply(new UChangeColor(new HtmlColorMiddle(this.backColor, HtmlColorUtils.WHITE))).apply(new UChangeBackColor(this.backColor)).apply(new UTranslate(5.0, 5.0)).draw(circleSmall);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(22.0, 22.0, 11.0, 0.0);
    }
}

