/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;

public class CommandPage
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPage() {
        super(CommandPage.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPage.class.getName(), RegexLeaf.start(), new RegexLeaf("page"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NB1", "(\\d+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("x*"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NB2", "(\\d+)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram classDiagram, LineLocation location, RegexResult arg) {
        int horizontal = Integer.parseInt(arg.get("NB1", 0));
        int vertical = Integer.parseInt(arg.get("NB2", 0));
        if (horizontal <= 0 || vertical <= 0) {
            return CommandExecutionResult.error("Argument must be positive");
        }
        classDiagram.setHorizontalPages(horizontal);
        classDiagram.setVerticalPages(vertical);
        return CommandExecutionResult.ok();
    }
}

