/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.CommandChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandChangeStateByPlayerCode
extends CommandChangeState {
    public CommandChangeStateByPlayerCode() {
        super(CommandChangeStateByPlayerCode.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChangeStateByPlayerCode.class.getName(), RegexLeaf.start(), new RegexLeaf("CODE", "([\\p{L}_][\\p{L}0-9_.]*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("is"), RegexLeaf.spaceZeroOrMore(), CommandChangeStateByPlayerCode.getStateOrHidden(), RegexLeaf.spaceZeroOrMore(), CommandChangeStateByPlayerCode.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COMMENT", "(.*?)"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        String code = arg.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        TimeTick now = diagram.getNow();
        return this.addState(diagram, arg, player, now);
    }
}

