/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;

public class UPolygon
extends AbstractShadowable {
    private final List<Point2D.Double> all = new ArrayList<Point2D.Double>();
    private final String name;
    private MinMax minmax = MinMax.getEmpty(false);
    private CompressionMode ignoreForCompression;

    public UPolygon() {
        this((String)null);
    }

    public UPolygon(List<Point2D.Double> points) {
        this((String)null);
        this.all.addAll(points);
        for (Point2D.Double pt : this.all) {
            this.manageMinMax(pt.getX(), pt.getY());
        }
    }

    public UPolygon(String name) {
        this.name = name;
    }

    public Point2D checkMiddleContactForSpecificTriangle(Point2D center) {
        for (int i = 0; i < this.all.size() - 1; ++i) {
            Point2D.Double pt1 = this.all.get(i);
            Point2D.Double pt2 = this.all.get(i + 1);
            Point2D.Double middle = new Point2D.Double((pt1.getX() + pt2.getX()) / 2.0, (pt1.getY() + pt2.getY()) / 2.0);
            double delta = middle.distance(center);
            if (!(delta < 1.0)) continue;
            return this.all.get((i - 1) % this.all.size());
        }
        return null;
    }

    public void addPoint(double x, double y) {
        this.all.add(new Point2D.Double(x, y));
        this.manageMinMax(x, y);
    }

    public void addPoint(Point2D point) {
        this.addPoint(point.getX(), point.getY());
    }

    private void manageMinMax(double x, double y) {
        this.minmax = this.minmax.addPoint(x, y);
    }

    public List<Point2D.Double> getPoints() {
        return this.all;
    }

    public UPolygon translate(double dx, double dy) {
        UPolygon result = new UPolygon();
        for (Point2D.Double pt : this.all) {
            result.addPoint(pt.x + dx, pt.y + dy);
        }
        return result;
    }

    public void rotate(double theta) {
        AffineTransform rotate = AffineTransform.getRotateInstance(theta);
        for (Point2D.Double pt : this.all) {
            rotate.transform(pt, pt);
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString() + " " + this.all;
    }

    public double getHeight() {
        return this.minmax.getHeight();
    }

    public double getWidth() {
        return this.minmax.getWidth();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public MinMax getMinMax() {
        return this.minmax;
    }

    public double[] getPointArray(double x, double y) {
        double[] points = new double[this.getPoints().size() * 2];
        int i = 0;
        for (Point2D point2D : this.getPoints()) {
            points[i++] = point2D.getX() + x;
            points[i++] = point2D.getY() + y;
        }
        return points;
    }

    public final CompressionMode isIgnoreForCompression() {
        return this.ignoreForCompression;
    }

    public final void setIgnoreForCompression(CompressionMode ignoreForCompression) {
        this.ignoreForCompression = ignoreForCompression;
    }
}

