/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.DotxMaker;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.svek.YDelta;

public class GraphvizSolverB {
    public Dimension2D solve(Cluster root, Collection<Path> paths) throws IOException {
        List<Point2D.Double> pointsList;
        int p1;
        String start;
        String dotString = new DotxMaker(root, paths).createDotString("nodesep=0.2;", "ranksep=0.2;");
        MinFinder minMax = new MinFinder();
        Graphviz graphviz = GraphvizUtils.create(null, dotString, "svg");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProcessState state = graphviz.createFile3(baos);
        baos.close();
        if (state.differs(ProcessState.TERMINATED_OK())) {
            throw new IllegalStateException("Timeout2 " + state);
        }
        byte[] result = baos.toByteArray();
        String s = new String(result, "UTF-8");
        Pattern pGraph = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"");
        Matcher mGraph = pGraph.matcher(s);
        if (!mGraph.find()) {
            throw new IllegalStateException();
        }
        int width = Integer.parseInt(mGraph.group(1));
        int height = Integer.parseInt(mGraph.group(2));
        YDelta yDelta = new YDelta(height);
        for (Block b : root.getRecursiveContents()) {
            start = "b" + b.getUid();
            p1 = s.indexOf("<title>" + start + "</title>");
            if (p1 == -1) {
                throw new IllegalStateException();
            }
            pointsList = GraphvizSolverB.extractPointsList(s, p1, yDelta);
            b.setX(GraphvizSolverB.getMinX(pointsList));
            b.setY(GraphvizSolverB.getMinY(pointsList));
            minMax.manage(b.getPosition());
        }
        for (Cluster cl : root.getSubClusters()) {
            start = "cluster" + cl.getUid();
            p1 = s.indexOf("<title>" + start + "</title>");
            if (p1 == -1) {
                throw new IllegalStateException();
            }
            pointsList = GraphvizSolverB.extractPointsList(s, p1, yDelta);
            cl.setX(GraphvizSolverB.getMinX(pointsList));
            cl.setY(GraphvizSolverB.getMinY(pointsList));
            double w = GraphvizSolverB.getMaxX(pointsList) - GraphvizSolverB.getMinX(pointsList);
            double h = GraphvizSolverB.getMaxY(pointsList) - GraphvizSolverB.getMinY(pointsList);
            cl.setHeight(h);
            cl.setWidth(w);
            minMax.manage(cl.getPosition());
        }
        for (Path p : paths) {
            start = "b" + p.getStart().getUid();
            String end = "b" + p.getEnd().getUid();
            String searched = "<title>" + start + "&#45;&gt;" + end + "</title>";
            int p12 = s.indexOf(searched);
            if (p12 == -1) {
                throw new IllegalStateException(searched);
            }
            int p2 = s.indexOf(" d=\"", p12);
            int p3 = s.indexOf("\"", p2 + " d=\"".length());
            String points = s.substring(p2 + " d=\"".length(), p3);
            DotPath dotPath = new DotPath(new SvgResult(points, yDelta));
            p.setDotPath(dotPath);
            minMax.manage(dotPath.getMinFinder());
            if (p.getLabel() == null) continue;
            List<Point2D.Double> pointsList2 = GraphvizSolverB.extractPointsList(s, p12, yDelta);
            double x = GraphvizSolverB.getMinX(pointsList2);
            double y = GraphvizSolverB.getMinY(pointsList2);
            p.setLabelPosition(x, y);
            minMax.manage(x, y);
        }
        return new Dimension2DDouble(width, height);
    }

    private static List<Point2D.Double> extractPointsList(String svg, int starting, YDelta yDelta) {
        return new SvgResult(svg, yDelta).substring(starting).extractList("points=\"");
    }

    private static double getMaxX(List<Point2D.Double> points) {
        double result = points.get((int)0).x;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).x > result)) continue;
            result = points.get((int)i).x;
        }
        return result;
    }

    private static double getMinX(List<Point2D.Double> points) {
        double result = points.get((int)0).x;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).x < result)) continue;
            result = points.get((int)i).x;
        }
        return result;
    }

    private static double getMaxY(List<Point2D.Double> points) {
        double result = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).y > result)) continue;
            result = points.get((int)i).y;
        }
        return result;
    }

    private static double getMinY(List<Point2D.Double> points) {
        double result = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).y < result)) continue;
            result = points.get((int)i).y;
        }
        return result;
    }

    private void exportPng(String dotString, File f) throws IOException {
        Graphviz graphviz = GraphvizUtils.create(null, dotString, "png");
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        ProcessState state = graphviz.createFile3(os);
        ((OutputStream)os).close();
        if (state.differs(ProcessState.TERMINATED_OK())) {
            throw new IllegalStateException("Timeout3 " + state);
        }
    }

    private Path getPath(Collection<Path> paths, int start, int end) {
        for (Path p : paths) {
            if (p.getStart().getUid() != start || p.getEnd().getUid() != end) continue;
            return p;
        }
        throw new IllegalArgumentException();
    }
}

