/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.impl;

import com.google.common.base.Preconditions;
import com.google.streamhtmlparser.ExternalState;
import com.google.streamhtmlparser.ParseException;
import com.google.streamhtmlparser.Parser;
import com.google.streamhtmlparser.impl.InternalState;
import com.google.streamhtmlparser.impl.ParserStateTable;
import com.google.streamhtmlparser.util.HtmlUtils;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericParser
implements Parser {
    protected final ParserStateTable parserStateTable;
    protected final Map<InternalState, ExternalState> intToExtStateTable;
    protected final InternalState initialState;
    protected InternalState currentState;
    protected int lineNumber;
    protected int columnNumber;

    protected GenericParser(ParserStateTable parserStateTable, Map<InternalState, ExternalState> intToExtStateTable, InternalState initialState) {
        this.parserStateTable = parserStateTable;
        this.intToExtStateTable = intToExtStateTable;
        this.initialState = initialState;
        this.currentState = initialState;
        this.lineNumber = 1;
        this.columnNumber = 1;
    }

    protected GenericParser(GenericParser aGenericParser) {
        this.parserStateTable = aGenericParser.parserStateTable;
        this.intToExtStateTable = aGenericParser.intToExtStateTable;
        this.initialState = aGenericParser.initialState;
        this.currentState = aGenericParser.currentState;
        this.lineNumber = aGenericParser.lineNumber;
        this.columnNumber = aGenericParser.columnNumber;
    }

    @Override
    public void parse(String input) throws ParseException {
        for (int i = 0; i < input.length(); ++i) {
            this.parse(input.charAt(i));
        }
    }

    @Override
    public void parse(char input) throws ParseException {
        InternalState nextState = this.parserStateTable.getNextState(this.currentState, input);
        if (nextState == InternalState.INTERNAL_ERROR_STATE) {
            String errorMsg = String.format("Unexpected character '%s' in int_state '%s' (ext_state '%s')", HtmlUtils.encodeCharForAscii(input), this.currentState.getName(), this.getState().getName());
            this.currentState = InternalState.INTERNAL_ERROR_STATE;
            throw new ParseException(this, errorMsg);
        }
        if (this.currentState != nextState) {
            nextState = this.handleExitState(this.currentState, nextState, input);
        }
        if (this.currentState != nextState) {
            nextState = this.handleEnterState(nextState, nextState, input);
        }
        this.currentState = nextState = this.handleInState(nextState, input);
        this.record(input);
        ++this.columnNumber;
        if (input == '\n') {
            ++this.lineNumber;
            this.columnNumber = 1;
        }
    }

    @Override
    public ExternalState getState() {
        if (!this.intToExtStateTable.containsKey(this.currentState)) {
            throw new NullPointerException("Did not find external state mapping For internal state: " + this.currentState);
        }
        return this.intToExtStateTable.get(this.currentState);
    }

    @Override
    public void reset() {
        this.currentState = this.initialState;
        this.lineNumber = 1;
        this.columnNumber = 1;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    InternalState getCurrentInternalState() {
        return this.currentState;
    }

    protected void setNextState(InternalState nextState) throws ParseException {
        Preconditions.checkNotNull(nextState);
        boolean nullChar = false;
        if (this.currentState != nextState) {
            nextState = this.handleExitState(this.currentState, nextState, '\u0000');
        }
        if (this.currentState != nextState) {
            this.handleEnterState(nextState, nextState, '\u0000');
        }
        this.currentState = nextState;
    }

    protected InternalState handleEnterState(InternalState currentState, InternalState expectedNextState, char input) throws ParseException {
        return expectedNextState;
    }

    protected InternalState handleExitState(InternalState currentState, InternalState expectedNextState, char input) throws ParseException {
        return expectedNextState;
    }

    protected InternalState handleInState(InternalState currentState, char input) throws ParseException {
        return currentState;
    }

    protected void record(char input) {
    }
}

