/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lease;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;

public abstract class AbstractLeaseMap
implements LeaseMap {
    protected final Map map;

    protected AbstractLeaseMap(Lease lease, long duration) {
        this(new HashMap(13), lease, duration);
    }

    protected AbstractLeaseMap(Map map, Lease lease, long duration) {
        this.map = map;
        map.put(lease, new Long(duration));
    }

    protected void checkKey(Object key) {
        if (!this.canContainKey(key)) {
            throw new IllegalArgumentException("key is not valid for this LeaseMap");
        }
    }

    protected static void checkValue(Object value) {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("value is not a Long");
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        AbstractLeaseMap.checkValue(value);
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        this.checkKey(key);
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        this.checkKey(key);
        AbstractLeaseMap.checkValue(value);
        return this.map.put(key, value);
    }

    public Object remove(Object key) {
        this.checkKey(key);
        return this.map.remove(key);
    }

    public void putAll(Map m) {
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return new EntrySet(this.map.entrySet());
    }

    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    private static final class Entry
    implements Map.Entry {
        private final Map.Entry e;

        public Entry(Map.Entry e) {
            this.e = e;
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Object getValue() {
            return this.e.getValue();
        }

        public Object setValue(Object value) {
            AbstractLeaseMap.checkValue(value);
            return this.e.setValue(value);
        }

        public boolean equals(Object o) {
            return ((Object)this.e).equals(o);
        }

        public int hashCode() {
            return ((Object)this.e).hashCode();
        }
    }

    private static final class EntryIterator
    implements Iterator {
        private final Iterator iter;

        public EntryIterator(Iterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return new Entry((Map.Entry)this.iter.next());
        }

        public void remove() {
            this.iter.remove();
        }
    }

    private static final class EntrySet
    extends AbstractSet {
        private final Set set;

        public EntrySet(Set set) {
            this.set = set;
        }

        public Iterator iterator() {
            return new EntryIterator(this.set.iterator());
        }

        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        public int size() {
            return this.set.size();
        }

        public void clear() {
            this.set.clear();
        }
    }
}

