/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.config.Config;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.MultiIPDiscovery;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class LookupLocatorDiscovery
implements DiscoveryManagement,
DiscoveryLocatorManagement {
    private static final String COMPONENT_NAME = "net.jini.discovery.LookupLocatorDiscovery";
    private static final Logger logger;
    private static final int MAX_N_TASKS = 15;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final Method getRegistrarMethod;
    private TaskManager discoveryTaskMgr;
    private WakeupManager discoveryWakeupMgr;
    private final HashSet undiscoveredLocators = new HashSet(11);
    private final ArrayList discoveredLocators = new ArrayList(11);
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private final ArrayList listeners = new ArrayList(1);
    private boolean terminated = false;
    private ProxyPreparer registrarPreparer;
    private Discovery protocol2 = Discovery.getProtocol2(null);
    private long initialUnicastDelayRange = 0L;
    private boolean discoverLocatorsCalled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LookupLocatorDiscovery(LookupLocator[] locators) {
        try {
            this.beginDiscovery(locators, (Configuration)EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public LookupLocatorDiscovery(LookupLocator[] locators, Configuration config) throws ConfigurationException {
        this.beginDiscovery(locators, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener l) {
        if (l == null) {
            throw new NullPointerException("can't add null listener");
        }
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.listeners.contains(l)) {
                return;
            }
            this.listeners.add(l);
            if (!this.discoveredLocators.isEmpty()) {
                HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(this.discoveredLocators.size());
                Iterator iter = this.discoveredLocators.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    LocatorReg reg = (LocatorReg)iter.next();
                    groupsMap.put(reg.proxy, reg.memberGroups);
                    ++i;
                }
                ArrayList<DiscoveryListener> list = new ArrayList<DiscoveryListener>(1);
                list.add(l);
                this.addNotify(list, groupsMap, false);
            }
        }
    }

    public synchronized void removeDiscoveryListener(DiscoveryListener l) {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int index = this.listeners.indexOf(l);
        if (index != -1) {
            this.listeners.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.discoveredLocators == null || this.discoveredLocators.isEmpty()) {
                return new ServiceRegistrar[0];
            }
            return this.buildServiceRegistrar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(ServiceRegistrar proxy) {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (proxy == null) {
                return;
            }
            LookupLocator lct = this.findRegFromProxy(proxy);
            if (lct == null) {
                return;
            }
            LocatorReg reg = this.removeDiscoveredLocator(lct);
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
            groupsMap.put(reg.proxy, reg.memberGroups);
            reg.proxy = null;
            reg.memberGroups = null;
            reg.fixupNextTryTime();
            this.addToMap(reg);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), groupsMap, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.terminateTaskMgr();
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.clear();
        }
    }

    public synchronized LookupLocator[] getLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int size = this.discoveredLocators.size() + this.undiscoveredLocators.size();
        LookupLocator[] ret = new LookupLocator[size];
        int k = 0;
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            ret[k++] = ((LocatorReg)iter.next()).l;
        }
        iter = this.undiscoveredLocators.iterator();
        while (iter.hasNext()) {
            ret[k++] = ((LocatorReg)iter.next()).l;
        }
        return ret;
    }

    public synchronized void addLocators(LookupLocator[] locators) {
        this.testSetForNull(locators);
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        this.discoverLocators(locators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocators(LookupLocator[] locators) {
        this.testSetForNull(locators);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            LocatorReg reg;
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
            Iterator iter = this.discoveredLocators.iterator();
            while (iter.hasNext()) {
                reg = (LocatorReg)iter.next();
                if (this.isArrayContains(locators, reg.l)) continue;
                iter.remove();
                groupsMap.put(reg.proxy, reg.memberGroups);
            }
            iter = this.undiscoveredLocators.iterator();
            while (iter.hasNext()) {
                reg = (LocatorReg)iter.next();
                if (this.isArrayContains(locators, reg.l)) continue;
                iter.remove();
            }
            this.discoverLocators(locators);
            if (!groupsMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), groupsMap, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocators(LookupLocator[] locators) {
        this.testSetForNull(locators);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
            for (int i = 0; i < locators.length; ++i) {
                LocatorReg reg = this.removeDiscoveredLocator(locators[i]);
                if (reg != null) {
                    groupsMap.put(reg.proxy, reg.memberGroups);
                    continue;
                }
                reg = this.findReg(locators[i]);
                if (reg == null) continue;
                this.undiscoveredLocators.remove(reg);
            }
            if (!groupsMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), groupsMap, true);
            }
        }
    }

    public synchronized LookupLocator[] getDiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int size = this.discoveredLocators.size();
        LookupLocator[] ret = new LookupLocator[size];
        int k = 0;
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            ret[k++] = ((LocatorReg)iter.next()).l;
        }
        return ret;
    }

    public synchronized LookupLocator[] getUndiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        LookupLocator[] locs = new LookupLocator[this.undiscoveredLocators.size()];
        Iterator iter = this.undiscoveredLocators.iterator();
        int i = 0;
        while (iter.hasNext()) {
            locs[i] = ((LocatorReg)iter.next()).l;
            ++i;
        }
        return locs;
    }

    private void discoverLocators(LookupLocator[] lcts) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.discoverLocatorsCalled = true;
        if (lcts == null) {
            return;
        }
        for (int i = 0; i < lcts.length; ++i) {
            LocatorReg reg;
            if (this.isDiscovered(lcts[i]) || (reg = this.findReg(lcts[i])) != null) continue;
            reg = new LocatorReg(lcts[i]);
            this.addToMap(reg);
        }
    }

    private LocatorReg findReg(LookupLocator lct) {
        Iterator iter = this.undiscoveredLocators.iterator();
        while (iter.hasNext()) {
            LocatorReg reg = (LocatorReg)iter.next();
            if (!reg.l.equals((Object)lct)) continue;
            return reg;
        }
        return null;
    }

    private LookupLocator findRegFromProxy(ServiceRegistrar proxy) {
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            LocatorReg reg = (LocatorReg)iter.next();
            if (!reg.proxy.equals(proxy)) continue;
            return reg.l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean regTryGetProxy(LocatorReg reg) {
        boolean b = reg.tryGetProxy();
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (!this.undiscoveredLocators.contains(reg)) {
                return true;
            }
            if (!b) {
                return false;
            }
            this.undiscoveredLocators.remove(reg);
            this.discoveredLocators.add(reg);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(reg.proxy, reg.memberGroups), false);
            }
            return true;
        }
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int k = 0;
        ServiceRegistrar[] proxys = new ServiceRegistrar[this.discoveredLocators.size()];
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            LocatorReg reg = (LocatorReg)iter.next();
            proxys[k++] = reg.proxy;
        }
        return proxys;
    }

    private void addToMap(LocatorReg reg) {
        this.undiscoveredLocators.add(reg);
        this.queueDiscoveryTask(reg);
    }

    private void queueDiscoveryTask(LocatorReg reg) {
        this.discoveryTaskMgr.add(new DiscoveryTask(reg, this.discoveryTaskMgr, this.discoveryWakeupMgr));
    }

    private boolean isDiscovered(LookupLocator lct) {
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            LocatorReg reg = (LocatorReg)iter.next();
            if (!reg.l.equals((Object)lct)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotify(ArrayList notifies, Map groupsMap, boolean discard) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(notifies, groupsMap, discard));
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier();
                this.notifierThread.start();
            }
        }
    }

    private LocatorReg removeDiscoveredLocator(LookupLocator lct) {
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            LocatorReg reg = (LocatorReg)iter.next();
            if (!reg.l.equals((Object)lct)) continue;
            iter.remove();
            return reg;
        }
        return null;
    }

    private void terminateTaskMgr() {
        if (this.discoveryWakeupMgr != null) {
            this.discoveryWakeupMgr.stop();
            this.discoveryWakeupMgr.cancelAll();
        }
        if (this.discoveryTaskMgr != null) {
            ArrayList pendingTasks = this.discoveryTaskMgr.getPending();
            for (int i = 0; i < pendingTasks.size(); ++i) {
                RetryTask pendingTask = (RetryTask)pendingTasks.get(i);
                pendingTask.cancel();
                this.discoveryTaskMgr.remove(pendingTask);
            }
            this.discoveryTaskMgr.terminate();
            this.discoveryTaskMgr = null;
            this.discoveryWakeupMgr = null;
        }
    }

    private boolean isArrayContains(Object[] a, Object obj) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    private void printMap() {
        Iterator iter = this.undiscoveredLocators.iterator();
        while (iter.hasNext()) {
            LocatorReg reg = (LocatorReg)iter.next();
            System.out.println("printMap reg:" + reg.id);
        }
    }

    private void testSetForNull(LookupLocator[] locatorSet) {
        if (locatorSet == null) {
            throw new NullPointerException("null locator array");
        }
        for (int i = 0; i < locatorSet.length; ++i) {
            if (locatorSet[i] != null) continue;
            throw new NullPointerException("null element in locator array");
        }
    }

    private Map deepCopy(HashMap groupsMap) {
        HashMap newMap = (HashMap)groupsMap.clone();
        Set eSet = newMap.entrySet();
        Iterator itr = eSet.iterator();
        while (itr.hasNext()) {
            Map.Entry pair = itr.next();
            pair.setValue(((String[])pair.getValue()).clone());
        }
        return newMap;
    }

    private Map mapRegToGroups(ServiceRegistrar reg, String[] curGroups) {
        HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
        groupsMap.put(reg, curGroups);
        return groupsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginDiscovery(final LookupLocator[] locators, Configuration config) throws ConfigurationException {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            this.init(config);
            if (locators == null) {
                return;
            }
            this.testSetForNull(locators);
            if (this.initialUnicastDelayRange > 0L) {
                this.discoveryWakeupMgr.schedule(System.currentTimeMillis() + (long)(Math.random() * (double)this.initialUnicastDelayRange), new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LookupLocatorDiscovery lookupLocatorDiscovery = LookupLocatorDiscovery.this;
                        synchronized (lookupLocatorDiscovery) {
                            if (LookupLocatorDiscovery.this.terminated || LookupLocatorDiscovery.this.discoverLocatorsCalled) {
                                return;
                            }
                            LookupLocatorDiscovery.this.discoverLocators(locators);
                        }
                    }
                });
            } else {
                this.discoverLocators(locators);
            }
        }
    }

    private void init(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.registrarPreparer = (ProxyPreparer)config.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        try {
            this.discoveryTaskMgr = (TaskManager)config.getEntry(COMPONENT_NAME, "taskManager", TaskManager.class);
        }
        catch (NoSuchEntryException e) {
            this.discoveryTaskMgr = new TaskManager(15, 15000L, 1.0f);
        }
        try {
            this.discoveryWakeupMgr = (WakeupManager)config.getEntry(COMPONENT_NAME, "wakeupManager", WakeupManager.class);
        }
        catch (NoSuchEntryException e) {
            this.discoveryWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        }
        this.initialUnicastDelayRange = Config.getLongEntry(config, COMPONENT_NAME, "initialUnicastDelayRange", 0L, 0L, Long.MAX_VALUE);
    }

    static {
        $assertionsDisabled = !LookupLocatorDiscovery.class.desiredAssertionStatus();
        logger = Logger.getLogger(COMPONENT_NAME);
        try {
            getRegistrarMethod = LookupLocator.class.getDeclaredMethod("getRegistrar", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private class DiscoveryTask
    extends RetryTask {
        private LocatorReg reg;

        public DiscoveryTask(LocatorReg reg, TaskManager taskMgr, WakeupManager wakeupMgr) {
            super(taskMgr, wakeupMgr);
            this.reg = reg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryOnce() {
            logger.finest("LookupLocatorDiscovery - DiscoveryTask started");
            LookupLocatorDiscovery lookupLocatorDiscovery = LookupLocatorDiscovery.this;
            synchronized (lookupLocatorDiscovery) {
                if (LookupLocatorDiscovery.this.terminated) {
                    return true;
                }
                if (LookupLocatorDiscovery.this.undiscoveredLocators.isEmpty()) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
                    return true;
                }
                if (!LookupLocatorDiscovery.this.undiscoveredLocators.contains(this.reg)) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
                    return true;
                }
            }
            boolean noRetry = LookupLocatorDiscovery.this.regTryGetProxy(this.reg);
            LookupLocatorDiscovery lookupLocatorDiscovery2 = LookupLocatorDiscovery.this;
            synchronized (lookupLocatorDiscovery2) {
                if (LookupLocatorDiscovery.this.terminated) {
                    return true;
                }
                if (noRetry) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
                } else {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask failed, will retry later");
                }
                return noRetry;
            }
        }

        public long retryTime() {
            return this.reg.getNextTryTime();
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event notifier");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupLocatorDiscovery - Notifier thread started");
            block5: while (true) {
                NotifyTask task;
                LinkedList linkedList = LookupLocatorDiscovery.this.pendingNotifies;
                synchronized (linkedList) {
                    if (LookupLocatorDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupLocatorDiscovery.this.notifierThread = null;
                        return;
                    }
                    task = (NotifyTask)LookupLocatorDiscovery.this.pendingNotifies.removeFirst();
                }
                boolean firstListener = true;
                Iterator iter = task.listeners.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block5;
                    DiscoveryListener l = (DiscoveryListener)iter.next();
                    DiscoveryEvent e = new DiscoveryEvent((Object)LookupLocatorDiscovery.this, LookupLocatorDiscovery.this.deepCopy((HashMap)task.groupsMap));
                    if (firstListener && logger.isLoggable(Level.FINEST)) {
                        String eType = task.discard ? "discarded" : "discovered";
                        ServiceRegistrar[] regs = e.getRegistrars();
                        logger.finest(eType + " event  -- " + regs.length + " lookup(s)");
                        Map groupsMap = e.getGroups();
                        for (int i = 0; i < regs.length; ++i) {
                            LookupLocator loc = null;
                            try {
                                loc = regs[i].getLocator();
                            }
                            catch (Throwable ex) {
                                // empty catch block
                            }
                            String[] groups = (String[])groupsMap.get(regs[i]);
                            logger.finest("    " + eType + " locator  = " + loc);
                            if (groups.length == 0) {
                                logger.finest("    " + eType + " group    = NO_GROUPS");
                                continue;
                            }
                            for (int j = 0; j < groups.length; ++j) {
                                logger.finest("    " + eType + " group[" + j + "] " + "= " + groups[j]);
                            }
                        }
                    }
                    if (task.discard) {
                        l.discarded(e);
                        continue;
                    }
                    l.discovered(e);
                }
                break;
            }
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final boolean discard;

        public NotifyTask(ArrayList listeners, Map groupsMap, boolean discard) {
            this.listeners = listeners;
            this.groupsMap = groupsMap;
            this.discard = discard;
        }
    }

    private class LocatorReg {
        public ServiceRegistrar proxy = null;
        public final LookupLocator l;
        public String[] memberGroups = null;
        private int cnt = 0;
        private static final long MIN_RETRY = 15000L;
        private final long[] sleepTime = new long[]{5000L, 10000L, 20000L, 30000L, 60000L, 120000L, 240000L, 480000L, 900000L};
        private int tryIndx = 0;
        private long nextTryTime;
        private final int id = this.cnt++;
        private long time = 0L;

        public LocatorReg(LookupLocator l) {
            this.l = l;
            this.nextTryTime = System.currentTimeMillis();
        }

        public synchronized long getNextTryTime() {
            return this.nextTryTime;
        }

        public void calcNextTryTime() {
            this.nextTryTime = System.currentTimeMillis() + this.sleepTime[this.tryIndx];
            if (this.tryIndx < this.sleepTime.length - 1) {
                ++this.tryIndx;
            }
        }

        public void fixupNextTryTime() {
            long curTime = System.currentTimeMillis();
            if (curTime - this.time > 15000L) {
                this.tryIndx = 0;
                this.nextTryTime = curTime;
            } else {
                this.calcNextTryTime();
            }
        }

        public boolean tryGetProxy() {
            MethodConstraints mc;
            if (this.proxy != null) {
                throw new IllegalArgumentException("LookupLocator has been discovered already");
            }
            InvocationConstraints ic = InvocationConstraints.EMPTY;
            if (this.l instanceof RemoteMethodControl && (mc = ((RemoteMethodControl)this.l).getConstraints()) != null) {
                ic = mc.getConstraints(getRegistrarMethod);
            }
            try {
                this.doUnicastDiscovery(this.l, ic);
                this.time = System.currentTimeMillis();
                return true;
            }
            catch (Throwable e) {
                if (logger.isLoggable(Level.INFO)) {
                    LogUtil.logThrow(logger, Level.INFO, this.getClass(), "tryGetProxy", "exception occured during unicast discovery to {0}:{1,number,#} with constraints {2}", new Object[]{this.l.getHost(), new Integer(this.l.getPort()), ic}, e);
                }
                this.calcNextTryTime();
                return false;
            }
        }

        private void doUnicastDiscovery(LookupLocator locator, InvocationConstraints ic) throws IOException, ClassNotFoundException {
            UnicastResponse resp = new MultiIPDiscovery(this){
                private final /* synthetic */ LocatorReg this$1;
                {
                    this.this$1 = this$1;
                }

                protected UnicastResponse performDiscovery(Discovery disco, DiscoveryConstraints dc, Socket s) throws IOException, ClassNotFoundException {
                    return disco.doUnicastDiscovery(s, dc.getUnfulfilledConstraints(), null, null, null);
                }

                protected void socketCloseException(IOException e) {
                    LookupLocatorDiscovery.access$100().log(Level.FINEST, "IOException on socket close upon completion of unicast discovery", e);
                }

                protected void singleResponseException(Exception e, InetAddress addr, int port) {
                    LookupLocatorDiscovery.access$100().log(Levels.HANDLED, "Exception occured during unicast discovery " + addr + ":" + port, e);
                }
            }.getResponse(locator.getHost(), locator.getPort(), ic);
            this.proxy = (ServiceRegistrar)LookupLocatorDiscovery.this.registrarPreparer.prepareProxy((Object)resp.getRegistrar());
            logger.log(Level.FINEST, "LookupLocatorDiscovery - prepared lookup service proxy: {0}", this.proxy);
            this.memberGroups = resp.getGroups();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LocatorReg)) {
                return false;
            }
            return this.l.equals((Object)((LocatorReg)obj).l);
        }

        public int hashCode() {
            return this.l.hashCode();
        }
    }
}

