/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataFactory;
import com.google.clearsilver.jsilver.data.DefaultData;
import com.google.clearsilver.jsilver.data.NewHdfParser;
import com.google.clearsilver.jsilver.data.NoOpStringInternStrategy;
import com.google.clearsilver.jsilver.data.Parser;
import com.google.clearsilver.jsilver.data.ParserFactory;
import com.google.clearsilver.jsilver.data.StringInternStrategy;
import com.google.clearsilver.jsilver.exceptions.JSilverBadSyntaxException;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;

public class HDFDataFactory
implements DataFactory {
    private final Parser hdfParser;
    private final boolean ignoreAttributes;

    public HDFDataFactory(boolean ignoreAttributes) {
        this(ignoreAttributes, new NoOpStringInternStrategy());
    }

    public HDFDataFactory(boolean ignoreAttributes, StringInternStrategy stringInternStrategy) {
        this(NewHdfParser.newFactory(stringInternStrategy), ignoreAttributes);
    }

    public HDFDataFactory(ParserFactory hdfParserFactory, boolean ignoreAttributes) {
        this.ignoreAttributes = ignoreAttributes;
        this.hdfParser = hdfParserFactory.newInstance();
    }

    public Data createData() {
        return new DefaultData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(String dataFileName, ResourceLoader resourceLoader, Data output) throws JSilverBadSyntaxException, IOException {
        Reader reader = resourceLoader.open(dataFileName);
        if (reader == null) {
            throw new FileNotFoundException(dataFileName);
        }
        try {
            this.hdfParser.parse(reader, output, new Parser.ErrorHandler(){

                public void error(int line, String lineContent, String fileName, String errorMessage) {
                    throw new JSilverBadSyntaxException("HDF parsing error : '" + errorMessage + "'", lineContent, fileName, line, -1, null);
                }
            }, resourceLoader, dataFileName, this.ignoreAttributes);
        }
        finally {
            resourceLoader.close(reader);
        }
    }

    public Data loadData(String dataFileName, ResourceLoader resourceLoader) throws IOException {
        Data result = this.createData();
        this.loadData(dataFileName, resourceLoader, result);
        return result;
    }

    public Parser getParser() {
        return this.hdfParser;
    }
}

