/*
 * Decompiled with CFR 0.152.
 */
package org.testng.guice;

import java.util.Iterator;
import java.util.List;
import org.testng.guice.Binding;
import org.testng.guice.InjectorImpl;
import org.testng.guice.InjectorShell;
import org.testng.guice.internal.Errors;
import org.testng.guice.spi.Element;
import org.testng.guice.spi.ElementVisitor;
import org.testng.guice.spi.InjectionRequest;
import org.testng.guice.spi.InterceptorBinding;
import org.testng.guice.spi.MembersInjectorLookup;
import org.testng.guice.spi.Message;
import org.testng.guice.spi.PrivateElements;
import org.testng.guice.spi.ProviderLookup;
import org.testng.guice.spi.ScopeBinding;
import org.testng.guice.spi.StaticInjectionRequest;
import org.testng.guice.spi.TypeConverterBinding;
import org.testng.guice.spi.TypeListenerBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractProcessor
implements ElementVisitor<Boolean> {
    protected Errors errors;
    protected InjectorImpl injector;

    protected AbstractProcessor(Errors errors) {
        this.errors = errors;
    }

    public void process(Iterable<InjectorShell> isolatedInjectorBuilders) {
        for (InjectorShell injectorShell : isolatedInjectorBuilders) {
            this.process(injectorShell.getInjector(), injectorShell.getElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InjectorImpl injector, List<Element> elements) {
        Errors errorsAnyElement = this.errors;
        this.injector = injector;
        try {
            Iterator<Element> i = elements.iterator();
            while (i.hasNext()) {
                Element element = i.next();
                this.errors = errorsAnyElement.withSource(element.getSource());
                Boolean allDone = element.acceptVisitor(this);
                if (!allDone.booleanValue()) continue;
                i.remove();
            }
        }
        finally {
            this.errors = errorsAnyElement;
            this.injector = null;
        }
    }

    @Override
    public Boolean visit(Message message) {
        return false;
    }

    @Override
    public Boolean visit(InterceptorBinding interceptorBinding) {
        return false;
    }

    @Override
    public Boolean visit(ScopeBinding scopeBinding) {
        return false;
    }

    @Override
    public Boolean visit(InjectionRequest injectionRequest) {
        return false;
    }

    @Override
    public Boolean visit(StaticInjectionRequest staticInjectionRequest) {
        return false;
    }

    @Override
    public Boolean visit(TypeConverterBinding typeConverterBinding) {
        return false;
    }

    @Override
    public <T> Boolean visit(Binding<T> binding) {
        return false;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> providerLookup) {
        return false;
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        return false;
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        return false;
    }

    @Override
    public Boolean visit(TypeListenerBinding binding) {
        return false;
    }
}

