/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;

public class ApplicationContextAwareProcessor
implements BeanPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ApplicationContext applicationContext;

    public ApplicationContextAwareProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ResourceLoaderAware) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking setResourceLoader on ResourceLoaderAware bean '" + beanName + "'"));
            }
            ((ResourceLoaderAware)bean).setResourceLoader(this.applicationContext);
        }
        if (bean instanceof ApplicationEventPublisherAware) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking setApplicationEventPublisher on ApplicationEventPublisherAware bean '" + beanName + "'"));
            }
            ((ApplicationEventPublisherAware)bean).setApplicationEventPublisher(this.applicationContext);
        }
        if (bean instanceof MessageSourceAware) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking setMessageSource on MessageSourceAware bean '" + beanName + "'"));
            }
            ((MessageSourceAware)bean).setMessageSource(this.applicationContext);
        }
        if (bean instanceof ApplicationContextAware) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking setApplicationContext on ApplicationContextAware bean '" + beanName + "'"));
            }
            ((ApplicationContextAware)bean).setApplicationContext(this.applicationContext);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String name) {
        return bean;
    }
}

